/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess.utils;

import iaik.asn1.CodingException;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.cms.SignerInfo;
import iaik.smime.SignedContent;
import iaik.smime.ess.ESSException;
import iaik.smime.ess.MLData;
import iaik.smime.ess.MLExpansionHistory;
import iaik.smime.ess.MLReceiptPolicy;
import iaik.smime.ess.Receipt;
import iaik.smime.ess.ReceiptContent;
import iaik.smime.ess.ReceiptRequest;
import iaik.smime.ess.ReceiptsFrom;
import iaik.smime.ess.utils.ESSLayerException;
import iaik.smime.ess.utils.ESSLayers;
import iaik.smime.ess.utils.ESSUtil;
import iaik.smime.ess.utils.MLA;
import iaik.smime.ess.utils.SignedESSLayer;
import iaik.smime.ess.utils.SignedReceiptException;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class SignedReceipt {
    private SignerInfo[] FN;
    private ReceiptRequest FP;
    private MLExpansionHistory FQ;
    private GeneralNames[] FU;
    private String e;
    protected PrintWriter debugWriter_;

    public SignedReceipt(SignedContent signedContent, SignedContent signedContent2, GeneralNames generalNames) {
        this.a(signedContent, signedContent2, generalNames, null);
    }

    public SignedReceipt(SignedContent signedContent, SignedContent signedContent2, GeneralNames generalNames, OutputStream outputStream) {
        this.a(signedContent, signedContent2, generalNames, outputStream);
    }

    public SignedReceipt(SignedContent signedContent, SignedContent signedContent2, String string) {
        this.e = string;
        this.a(signedContent, signedContent2, new GeneralNames(new GeneralName(1, (Object)ESSUtil.parseAddress(string))), null);
    }

    public SignedReceipt(SignedContent signedContent, SignedContent signedContent2, String string, OutputStream outputStream) {
        this.e = string;
        this.a(signedContent, signedContent2, new GeneralNames(new GeneralName(1, (Object)ESSUtil.parseAddress(string))), outputStream);
    }

    public SignedReceipt(ESSLayers eSSLayers, GeneralNames generalNames) {
        this.a(eSSLayers, generalNames, null);
    }

    public SignedReceipt(ESSLayers eSSLayers, GeneralNames generalNames, OutputStream outputStream) {
        this.a(eSSLayers, generalNames, outputStream);
    }

    public SignedReceipt(ESSLayers eSSLayers, String string) {
        this.e = string;
        this.a(eSSLayers, new GeneralNames(new GeneralName(1, (Object)ESSUtil.parseAddress(string))), null);
    }

    public SignedReceipt(ESSLayers eSSLayers, String string, OutputStream outputStream) {
        this.e = string;
        this.a(eSSLayers, new GeneralNames(new GeneralName(1, (Object)ESSUtil.parseAddress(string))), outputStream);
    }

    public SignedReceipt(Part part, GeneralNames generalNames) {
        this.a(part, generalNames, null);
    }

    public SignedReceipt(Part part, GeneralNames generalNames, OutputStream outputStream) {
        this.a(part, generalNames, outputStream);
    }

    public SignedReceipt(Part part, String string) {
        this.e = string;
        this.a(part, new GeneralNames(new GeneralName(1, (Object)ESSUtil.parseAddress(string))), null);
    }

    public SignedReceipt(Part part, String string, OutputStream outputStream) {
        this.e = string;
        this.a(part, new GeneralNames(new GeneralName(1, (Object)ESSUtil.parseAddress(string))), outputStream);
    }

    private MimeMessage a(ReceiptContent receiptContent, Session session, String string) {
        if (this.e == null) {
            throw new MessagingException("Cannot create message; missing sender address!");
        }
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom((Address)new InternetAddress(this.e));
        String[] stringArray = ESSUtil.getMailAddresses(this.FU);
        if (stringArray.length == 0) {
            throw new MessagingException("Cannot create message; no recipients!");
        }
        InternetAddress[] internetAddressArray = new InternetAddress[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            internetAddressArray[n2] = new InternetAddress(stringArray[n2]);
            ++n2;
        }
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])internetAddressArray);
        mimeMessage.setSentDate(new Date());
        mimeMessage.setSubject(string);
        mimeMessage.setContent((Object)receiptContent, receiptContent.getContentType());
        receiptContent.setHeaders((Part)mimeMessage);
        mimeMessage.saveChanges();
        return mimeMessage;
    }

    public Receipt createReceipt() {
        if (this.FN == null || this.FN.length == 0) {
            throw new ESSException("Cannot create Receipt. Missing originator SignerInfo!");
        }
        return new Receipt(this.FN[0]);
    }

    public ReceiptContent createReceiptContent() {
        if (this.FN == null || this.FN.length == 0) {
            throw new ESSException("Cannot create ReceiptContent. Missing originator SignerInfo!");
        }
        return new ReceiptContent(this.FN[0]);
    }

    public MimeMessage createReceiptMessage(SignerInfo signerInfo, X509Certificate[] x509CertificateArray, Session session, String string) {
        ReceiptContent receiptContent = this.createReceiptContent();
        receiptContent.setCertificates((Certificate[])x509CertificateArray);
        try {
            receiptContent.setSigner(signerInfo);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ESSException("Error setting SignerInfo: " + noSuchAlgorithmException.toString());
        }
        return this.a(receiptContent, session, string);
    }

    public MimeMessage createReceiptMessage(PrivateKey privateKey, X509Certificate[] x509CertificateArray, X509Certificate x509Certificate, AlgorithmID algorithmID, AlgorithmID algorithmID2, X509Certificate x509Certificate2, boolean bl, Session session, String string) {
        ReceiptContent receiptContent = this.createReceiptContent();
        receiptContent.setCertificates((Certificate[])x509CertificateArray);
        try {
            receiptContent.setSigner(privateKey, x509Certificate, algorithmID, algorithmID2, x509Certificate2, bl);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ESSException("Error setting SignerInfo: " + noSuchAlgorithmException.toString());
        }
        return this.a(receiptContent, session, string);
    }

    private void a(String string) {
        if (this.debugWriter_ != null) {
            this.debugWriter_.println(string);
        }
    }

    public MLExpansionHistory getMLExpansionHistory() {
        return this.FQ;
    }

    public SignerInfo[] getOriginatorSignerInfos() {
        return this.FN;
    }

    public ReceiptRequest getReceiptRequest() {
        return this.FP;
    }

    public GeneralNames[] getReceiptsTo() {
        return this.FU;
    }

    public String getReceiptsToAddressList() {
        String string = null;
        String[] stringArray = ESSUtil.getMailAddresses(this.FU);
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        int n2 = 1;
        while (n2 < stringArray.length) {
            string = string.concat("," + stringArray[n2]);
            ++n2;
        }
        return string;
    }

    public String[] getReceiptsToAddresses() {
        return ESSUtil.getMailAddresses(this.FU);
    }

    private void a(SignedContent signedContent, SignedContent signedContent2, GeneralNames generalNames, OutputStream outputStream) {
        Object object;
        Object object2;
        if (this.debugWriter_ == null) {
            this.a(outputStream);
        }
        if (this.e == null && (object2 = ESSUtil.getMailAddresses(generalNames)) != null) {
            this.e = object2[0];
        }
        if (signedContent2 != null) {
            try {
                object2 = ESSUtil.getAttributeValue(signedContent2, MLExpansionHistory.oid, false);
                if (object2 != null) {
                    this.FQ = object2 instanceof MLExpansionHistory ? (MLExpansionHistory)((Object)object2) : new MLExpansionHistory(object2.toASN1Object());
                }
            }
            catch (CodingException codingException) {
                String string = "Error parsing MLExpansionHistory attribute of outer layer: " + codingException.toString();
                this.a(string);
                throw new SignedReceiptException(5, string);
            }
            catch (ESSException eSSException) {}
        }
        try {
            this.FN = ESSUtil.getSignerInfosWithAttribute(signedContent, ReceiptRequest.oid, true);
            if (this.FN.length == 0) {
                this.a("No receipt requested!");
                throw new SignedReceiptException(0);
            }
            object2 = this.FN[0].getSignedAttribute(ReceiptRequest.oid);
            if (object2 != null && (object = object2.getAttributeValue()) != null) {
                this.FP = object instanceof ReceiptRequest ? (ReceiptRequest)((Object)object) : new ReceiptRequest(object.toASN1Object());
            }
        }
        catch (CodingException codingException) {
            String string = "Error parsing ReceiptRequest attribute : " + codingException.toString();
            this.a(string);
            throw new SignedReceiptException(5, string);
        }
        catch (ESSException eSSException) {
            object2 = new SignedReceiptException(4);
            this.a(((Throwable)object2).getMessage());
            throw object2;
        }
        if (this.FP == null) {
            this.a("Cannot create SignedReceipt. No receipt request found!");
            throw new SignedReceiptException(0);
        }
        object2 = null;
        if (this.FQ != null) {
            this.a("MLExpansionHistory attribute present in outer layer.");
            object = this.FQ.getLastMLData();
            if (object == null) {
                this.a("No MLData in MLExpansionHistory attribute.");
            } else {
                object2 = ((MLData)object).getMLReceiptPolicy();
                if (object2 == null) {
                    this.a("No MLReceiptPolicy in MLData.");
                } else if (((MLReceiptPolicy)object2).getValue() == 0) {
                    this.a("MLReceiptPolicy value is NONE");
                    throw new SignedReceiptException(2);
                }
            }
        } else {
            this.a("No MLExpansionHistory attribute in outer layer.");
        }
        object = this.FP.getReceiptsFrom();
        GeneralNames[] generalNamesArray = ((ReceiptsFrom)object).getReceiptList();
        if (generalNamesArray != null && generalNamesArray.length > 0) {
            this.a("ReceitsFrom is a receipt list.");
            int n2 = 0;
            while (n2 < generalNamesArray.length) {
                if (ESSUtil.compareGeneralNames(generalNamesArray[n2], generalNames)) {
                    this.a("Name of recipient included in receiptList; signed receipt may be created.");
                    break;
                }
                ++n2;
            }
            this.a("Name of recipient not included in receiptList; no signed receipt will be created.");
            throw new SignedReceiptException(1);
        }
        int n3 = ((ReceiptsFrom)object).getAllOrFirstTier();
        if (n3 == 0) {
            this.a("AllOrFirstTier value is allRecipients; signed receipt may be created.");
        } else if (n3 == 1) {
            this.a("AllOrFirstTier value is firstTierRecipients.");
            if (this.FQ != null) {
                this.a("Not a first tier recipient; no signed receipt will be created.");
                throw new SignedReceiptException(3);
            }
        }
        this.FU = this.FP.getReceiptsTo();
        if (this.FU == null) {
            this.FU = new GeneralNames[0];
        }
        if (object2 != null) {
            GeneralNames[] generalNamesArray2 = ((MLReceiptPolicy)object2).getRecipientList();
            if (generalNamesArray2 == null) {
                generalNamesArray2 = new GeneralNames[]{};
            }
            if (((MLReceiptPolicy)object2).getValue() == 2) {
                this.a("MLReceiptPolicy value is IN_ADDITION_TO; expand receiptTo list");
                if (generalNamesArray2.length > 0) {
                    int n4;
                    Vector<GeneralNames> vector = new Vector<GeneralNames>();
                    int n5 = 0;
                    while (n5 < generalNamesArray2.length) {
                        GeneralNames generalNames2 = generalNamesArray2[n5];
                        boolean bl = true;
                        n4 = 0;
                        while (n4 < this.FU.length) {
                            if (generalNames2.equals((Object)this.FU[n4])) {
                                bl = false;
                                break;
                            }
                            ++n4;
                        }
                        if (bl) {
                            vector.addElement(generalNames2);
                        }
                        ++n5;
                    }
                    int n6 = vector.size();
                    if (n6 > 0) {
                        GeneralNames[] generalNamesArray3 = this.FU;
                        this.FU = new GeneralNames[generalNamesArray3.length + n6];
                        System.arraycopy(generalNamesArray3, 0, this.FU, 0, generalNamesArray3.length);
                        n4 = generalNamesArray3.length;
                        Enumeration enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            this.FU[n4++] = (GeneralNames)enumeration.nextElement();
                        }
                    }
                } else {
                    this.a("mlReceiptsTo is empty; nothing to expand");
                }
            } else if (((MLReceiptPolicy)object2).getValue() == 1) {
                this.a("MLReceiptPolicy value is INSTEAD_OF; receiptTo list will be adopted from MLReceiptPolicy");
                this.FU = generalNamesArray2;
            }
        }
        if (this.FU.length == 0) {
            this.a("Warning: Receipt may be created but receiptsTo list is empty!");
        }
    }

    private void a(ESSLayers eSSLayers, GeneralNames generalNames, OutputStream outputStream) {
        if (this.debugWriter_ == null) {
            this.a(outputStream);
        }
        if (eSSLayers == null) {
            String string = "Cannot create SignedReceipt from null message.";
            this.a(string);
            throw new NullPointerException(string);
        }
        int n2 = eSSLayers.getIndexOfInnerSignedLayer();
        if (n2 == -1) {
            String string = "Cannot create SignedReceipt from null signed layer.";
            this.a(string);
            throw new NullPointerException(string);
        }
        SignedESSLayer signedESSLayer = null;
        SignedContent signedContent = null;
        SignedContent signedContent2 = null;
        try {
            signedESSLayer = (SignedESSLayer)eSSLayers.getLayerAtIndex(n2);
            signedContent = (SignedContent)signedESSLayer.getContent();
            int n3 = eSSLayers.getIndexOfOuterSignedLayer();
            if (n3 != -1) {
                signedESSLayer = (SignedESSLayer)eSSLayers.getLayerAtIndex(n3);
                signedContent2 = (SignedContent)signedESSLayer.getContent();
            }
        }
        catch (IOException iOException) {
            String string = null;
            string = signedContent == null ? "Error parsing signed inner layer: " : "Error parsing signed outer layer: ";
            this.a("Cannot create SignedReceipt! " + string + iOException.toString());
            throw new ESSLayerException(0, String.valueOf(string) + iOException.toString(), iOException, signedESSLayer);
        }
        this.a(signedContent, signedContent2, generalNames, outputStream);
    }

    private void a(Part part, GeneralNames generalNames, OutputStream outputStream) {
        this.a(outputStream);
        MLA mLA = new MLA();
        mLA.setDebugStream(null, outputStream);
        this.a("Parsing layers...");
        ESSLayers eSSLayers = mLA.resolve(part, null);
        this.a(eSSLayers, generalNames, outputStream);
    }

    private void a(OutputStream outputStream) {
        this.debugWriter_ = outputStream == null ? null : new PrintWriter(outputStream, true);
    }
}

