/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess.utils;

import iaik.cms.CertificateIdentifier;
import iaik.cms.SignerInfo;
import iaik.smime.SignedContent;
import iaik.smime.ess.ESSSecurityLabel;
import iaik.smime.ess.EquivalentLabels;
import iaik.smime.ess.MLExpansionHistory;
import iaik.smime.ess.ReceiptRequest;
import iaik.smime.ess.utils.ESSLayer;
import iaik.smime.ess.utils.ESSUtil;
import iaik.smime.ess.utils.SignerInfoVerificationResult;

public class SignedESSLayer
extends ESSLayer {
    private SignerInfoVerificationResult[] FD;
    private boolean rH;
    private SignerInfo[] FE;
    private MLExpansionHistory FG;
    private SignerInfo[] FH;
    private ReceiptRequest FL;

    public SignedESSLayer(SignedContent signedContent) {
        super(signedContent, 0);
    }

    public boolean allSignaturesValid() {
        boolean bl = true;
        if (this.FD != null) {
            int n2 = 0;
            while (n2 < this.FD.length) {
                if (this.FD[n2].getVerificationStatus() != 1) {
                    bl = false;
                    break;
                }
                ++n2;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public ESSSecurityLabel getESSSecurityLabel() {
        return ESSUtil.getESSSecurityLabel((SignedContent)this.content_);
    }

    public EquivalentLabels getEquivalentLabels() {
        return ESSUtil.getEquivalentLabels((SignedContent)this.content_);
    }

    public MLExpansionHistory getMLExpansionHistory() {
        return this.FG;
    }

    public ReceiptRequest getReceiptRequest() {
        return this.FL;
    }

    public SignerInfoVerificationResult[] getSignerInfoVerificationResults() {
        if (this.FD == null) {
            return new SignerInfoVerificationResult[0];
        }
        return this.FD;
    }

    public SignerInfoVerificationResult getSignerInfoVerificationResults(CertificateIdentifier certificateIdentifier) {
        SignerInfoVerificationResult signerInfoVerificationResult = null;
        if (this.FD != null) {
            int n2 = 0;
            while (n2 < this.FD.length) {
                SignerInfoVerificationResult signerInfoVerificationResult2 = this.FD[n2];
                if (signerInfoVerificationResult2.getSignerID().equals(certificateIdentifier)) {
                    signerInfoVerificationResult = signerInfoVerificationResult2;
                    break;
                }
                ++n2;
            }
        }
        return signerInfoVerificationResult;
    }

    public SignerInfo[] getSignerInfosWithMLExpansionHistory() {
        if (this.FE == null) {
            this.FE = new SignerInfo[0];
        }
        return this.FE;
    }

    public SignerInfo[] getSignerInfosWithReceiptRequest() {
        if (this.FH == null) {
            this.FH = new SignerInfo[0];
        }
        return this.FH;
    }

    public boolean isOuterLayer() {
        return this.rH;
    }

    public void setIsOuterLayer(boolean bl) {
        this.rH = bl;
    }

    void a(SignerInfo[] signerInfoArray, MLExpansionHistory mLExpansionHistory) {
        this.FE = signerInfoArray;
        this.FG = mLExpansionHistory;
    }

    void a(SignerInfo[] signerInfoArray, ReceiptRequest receiptRequest) {
        this.FH = signerInfoArray;
        this.FL = receiptRequest;
    }

    void a(SignerInfoVerificationResult[] signerInfoVerificationResultArray) {
        this.FD = signerInfoVerificationResultArray;
    }
}

