/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess.utils;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.Attribute;
import iaik.cms.CMSParsingException;
import iaik.cms.DebugCMS;
import iaik.cms.SecurityProvider;
import iaik.cms.SignerInfo;
import iaik.cms.Utils;
import iaik.cms.attributes.CMSMessageDigest;
import iaik.smime.ess.ESSException;
import iaik.smime.ess.MsgSigDigest;
import iaik.smime.ess.Receipt;
import iaik.smime.ess.ReceiptContent;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;

public class SenderAndReceiptContentDigest {
    private static boolean a = false;
    protected static Hashtable digestStore_;
    protected Receipt receipt_;
    protected byte[] senderMessageDigest_;
    protected byte[] receiptContentDigest_;

    static {
        a = DebugCMS.getDebugMode() && a;
        digestStore_ = new Hashtable(10);
    }

    public SenderAndReceiptContentDigest(ASN1Object aSN1Object) {
        this.decode(aSN1Object);
    }

    public SenderAndReceiptContentDigest(SignerInfo signerInfo) {
        this(signerInfo, null, true);
    }

    public SenderAndReceiptContentDigest(SignerInfo signerInfo, SecurityProvider securityProvider, boolean bl) {
        SecurityProvider securityProvider2 = securityProvider;
        if (securityProvider2 == null) {
            securityProvider2 = SecurityProvider.getSecurityProvider();
        }
        this.receipt_ = new Receipt(signerInfo);
        Attribute[] attributeArray = signerInfo.getSignedAttributes();
        if (attributeArray == null) {
            throw new ESSException("Cannot calculate message signature digest value. Missing signed attributes in originator SignerInfo!");
        }
        try {
            byte[] byArray = DerCoder.encode((ASN1Object)ASN.createSetOf((ASN1Type[])attributeArray, (boolean)bl));
            this.senderMessageDigest_ = securityProvider2.getHash(signerInfo.getDigestAlgorithm(), byArray);
        }
        catch (CodingException codingException) {
            throw new ESSException("Cannot calculate sender message signarture digest value; error encoding attributes " + codingException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ESSException("Cannot calculate sender message signarture digest value; hash algorithm not available: " + noSuchAlgorithmException.toString());
        }
        try {
            this.receiptContentDigest_ = securityProvider2.getHash(signerInfo.getDigestAlgorithm(), DerCoder.encode((ASN1Object)this.receipt_.toASN1Object()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ESSException("Cannot calculate receipt content digest value: " + noSuchAlgorithmException.toString());
        }
    }

    public SenderAndReceiptContentDigest(Receipt receipt, byte[] byArray, byte[] byArray2) {
        if (receipt == null) {
            throw new IllegalArgumentException("Cannot create SenderAndReceiptContentDigest. Missing receipt!");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Cannot create SenderAndReceiptContentDigest. Missing sender message digest!");
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("Cannot create SenderAndReceiptContentDigest. Missing sender message digest!");
        }
        this.receipt_ = receipt;
        this.senderMessageDigest_ = byArray;
        this.receiptContentDigest_ = byArray2;
    }

    public SenderAndReceiptContentDigest(InputStream inputStream) {
        this.decode(inputStream);
    }

    public static void clearDigestStore() {
        digestStore_.clear();
    }

    public void decode(ASN1Object aSN1Object) {
        try {
            this.receipt_ = new Receipt(aSN1Object.getComponentAt(0));
            this.senderMessageDigest_ = (byte[])aSN1Object.getComponentAt(1).getValue();
            this.receiptContentDigest_ = (byte[])aSN1Object.getComponentAt(2).getValue();
        }
        catch (CMSParsingException cMSParsingException) {
            throw new CodingException(cMSParsingException.toString());
        }
    }

    public void decode(InputStream inputStream) {
        try {
            ASN1Object aSN1Object = DerCoder.decode((InputStream)inputStream);
            this.decode(aSN1Object);
        }
        catch (CodingException codingException) {
            throw new IOException("Error decoding SenderAndReceiptContentDigest: " + codingException.toString());
        }
    }

    public static Enumeration getAllEntries() {
        return digestStore_.elements();
    }

    public static SenderAndReceiptContentDigest getEntry(Receipt receipt) {
        return (SenderAndReceiptContentDigest)digestStore_.get(receipt);
    }

    public Receipt getReceipt() {
        return this.receipt_;
    }

    public byte[] getReceiptContentDigest() {
        return this.receiptContentDigest_;
    }

    public byte[] getSenderMessageDigest() {
        return this.senderMessageDigest_;
    }

    public static void initDigestStore(InputStream inputStream) {
        digestStore_.clear();
        DerInputStream derInputStream = inputStream instanceof DerInputStream ? (DerInputStream)inputStream : new DerInputStream(inputStream);
        DerInputStream derInputStream2 = derInputStream.readSequence();
        while (derInputStream2.nextTag() > -1) {
            SenderAndReceiptContentDigest.storeEntry(new SenderAndReceiptContentDigest((InputStream)derInputStream2));
        }
        if (Utils.getIaikProviderVersion() >= 3.16) {
            derInputStream2.readEOC();
        }
    }

    public static SenderAndReceiptContentDigest removeEntry(Receipt receipt) {
        return (SenderAndReceiptContentDigest)digestStore_.remove(receipt);
    }

    public static SenderAndReceiptContentDigest removeEntry(SenderAndReceiptContentDigest senderAndReceiptContentDigest) {
        return (SenderAndReceiptContentDigest)digestStore_.remove(senderAndReceiptContentDigest.getReceipt());
    }

    public static SenderAndReceiptContentDigest storeEntry(SenderAndReceiptContentDigest senderAndReceiptContentDigest) {
        return digestStore_.put(senderAndReceiptContentDigest.getReceipt(), senderAndReceiptContentDigest);
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.receipt_.toASN1Object());
        sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(this.senderMessageDigest_));
        sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(this.receiptContentDigest_));
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Receipt: " + this.receipt_ + "\n");
        stringBuffer.append("senderMessageDigest: " + Util.toString((byte[])this.senderMessageDigest_) + "\n");
        stringBuffer.append("receiptContentDigest: " + Util.toString((byte[])this.receiptContentDigest_));
        return stringBuffer.toString();
    }

    public void validate(ReceiptContent receiptContent) {
        if (!this.receipt_.equals(receiptContent.getReceipt())) {
            throw new ESSException("Validation error: Receipts do not match!");
        }
        this.a(receiptContent);
    }

    private void a(SignerInfo signerInfo) {
        MsgSigDigest msgSigDigest = (MsgSigDigest)signerInfo.getSignedAttributeValue(MsgSigDigest.oid);
        if (msgSigDigest == null) {
            throw new ESSException("Validation Error: No MsgSigDigest attribute in Receipt SignerInfo!");
        }
        if (!CryptoUtils.equalsBlock((byte[])this.senderMessageDigest_, (byte[])msgSigDigest.getDigest())) {
            throw new ESSException("Validation Error: MsgSigDigest value does not match to sender signature digest value!");
        }
        CMSMessageDigest cMSMessageDigest = (CMSMessageDigest)signerInfo.getSignedAttributeValue(CMSMessageDigest.oid);
        if (cMSMessageDigest == null) {
            throw new ESSException("Validation Error: No MessageDigest attribute in Receipt SignerInfo!");
        }
        if (!CryptoUtils.equalsBlock((byte[])this.receiptContentDigest_, (byte[])cMSMessageDigest.getDigest())) {
            throw new ESSException("Validation Error: MessageDigest attribute value does not match to receipt content digest value!");
        }
    }

    private void a(ReceiptContent receiptContent) {
        this.a(receiptContent.getSignerInfos()[0]);
    }

    public static SenderAndReceiptContentDigest validateReceiptContent(ReceiptContent receiptContent) {
        SenderAndReceiptContentDigest senderAndReceiptContentDigest = SenderAndReceiptContentDigest.getEntry(receiptContent.getReceipt());
        if (senderAndReceiptContentDigest == null) {
            throw new ESSException("Cannot validate ReceiptContent: No digest values kept for this Signed Receipt!");
        }
        senderAndReceiptContentDigest.a(receiptContent);
        return senderAndReceiptContentDigest;
    }

    public static void writeDigestStore(OutputStream outputStream) {
        outputStream.write(48);
        outputStream.write(-128);
        if (!digestStore_.isEmpty()) {
            Enumeration enumeration = SenderAndReceiptContentDigest.getAllEntries();
            while (enumeration.hasMoreElements()) {
                outputStream.write(DerCoder.encode((ASN1Object)((SenderAndReceiptContentDigest)enumeration.nextElement()).toASN1Object()));
            }
        }
        outputStream.write(0);
        outputStream.write(0);
    }

    public void writeTo(OutputStream outputStream) {
        DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
    }
}

