/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess.utils;

import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.asn1.structures.Attributes;
import iaik.asn1.structures.GeneralNames;
import iaik.cms.CertificateIdentifier;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.OriginatorInfo;
import iaik.cms.RecipientInfo;
import iaik.cms.SignerInfo;
import iaik.cms.attributes.SigningTime;
import iaik.smime.CryptoContent;
import iaik.smime.EncryptedContent;
import iaik.smime.SMimeUtil;
import iaik.smime.SignedContent;
import iaik.smime.attributes.MSOEEncryptionKeyPreference;
import iaik.smime.attributes.SMIMEEncryptionKeyPreference;
import iaik.smime.ess.ESSException;
import iaik.smime.ess.EntityIdentifier;
import iaik.smime.ess.MLData;
import iaik.smime.ess.MLExpansionHistory;
import iaik.smime.ess.MLReceiptPolicy;
import iaik.smime.ess.utils.CertificateDatabase;
import iaik.smime.ess.utils.ESSLayer;
import iaik.smime.ess.utils.ESSLayers;
import iaik.smime.ess.utils.EnvelopedESSLayer;
import iaik.smime.ess.utils.KeyDatabase;
import iaik.smime.ess.utils.SecurityLabelHandler;
import iaik.smime.ess.utils.SignedESSLayer;
import iaik.smime.ess.utils.b;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;

public class MLA {
    private EntityIdentifier EX;
    private KeyDatabase Fx;
    private CertificateDatabase Fy;
    private boolean d = true;
    private SecurityLabelHandler Fz;
    private MLReceiptPolicy FA;
    private b FC;
    protected PrintWriter debugWriter_;
    protected String debugID_;

    public MLA() {
    }

    public MLA(EntityIdentifier entityIdentifier) {
        this();
        this.EX = entityIdentifier;
    }

    private static GeneralNames[] a(GeneralNames[] generalNamesArray, GeneralNames[] generalNamesArray2) {
        Vector<GeneralNames> vector = new Vector<GeneralNames>(generalNamesArray.length + generalNamesArray2.length);
        int n2 = 0;
        while (n2 < generalNamesArray.length) {
            vector.addElement(generalNamesArray[n2]);
            ++n2;
        }
        int n3 = 0;
        while (n3 < generalNamesArray2.length) {
            if (!vector.contains(generalNamesArray2[n3])) {
                vector.addElement(generalNamesArray2[n3]);
            }
            ++n3;
        }
        Object[] objectArray = new GeneralNames[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected Attribute[] createSignedAttributes(SignedESSLayer signedESSLayer, Date date, MLReceiptPolicy mLReceiptPolicy, X509Certificate x509Certificate, boolean bl, String string) {
        Object object;
        Object object2;
        Attributes attributes = new Attributes();
        MLExpansionHistory mLExpansionHistory = null;
        this.a("Create set of attributes to be included in signature.", string, false);
        if (signedESSLayer != null) {
            this.a("Signed outer layer is present. Copying attributes.", string, false);
            object2 = null;
            try {
                object2 = ((SignedContent)signedESSLayer.getContent()).getSignerInfos()[0];
            }
            catch (Exception exception) {
                String string2 = "Error parsing signed outer layer: " + exception.toString();
                this.a(string2, string, false);
                throw new ESSException(string2);
            }
            object = ((SignerInfo)object2).getSignedAttributes();
            if (object != null) {
                int n2 = 0;
                while (n2 < ((Attribute[])object).length) {
                    Attribute attribute = object[n2];
                    ObjectID objectID = attribute.getType();
                    if (objectID.equals((Object)ObjectID.mlExpandHistory)) {
                        AttributeValue attributeValue = attribute.getAttributeValue();
                        if (attributeValue != null) {
                            mLExpansionHistory = attributeValue instanceof MLExpansionHistory ? (MLExpansionHistory)attributeValue : new MLExpansionHistory(attributeValue.toASN1Object());
                        }
                    } else if (!(objectID.equals((Object)ObjectID.messageDigest) || objectID.equals((Object)ObjectID.signingTime) || objectID.equals((Object)ObjectID.smimeCapabilities) || objectID.equals((Object)ObjectID.encrypKeyPref) || objectID.equals((Object)MSOEEncryptionKeyPreference.oid))) {
                        this.a("Copy " + objectID.getName() + " attribute", string, false);
                        attributes.addAttribute(attribute);
                    }
                    ++n2;
                }
            }
        }
        this.a("Add SigningTime attribute.", string, false);
        object2 = date == null ? new SigningTime() : new SigningTime(date);
        attributes.addAttribute(new Attribute((AttributeValue)object2));
        this.a("Add SMimeCapabilities attribute", string, false);
        attributes.addAttribute(new Attribute((AttributeValue)SMimeUtil.makeSMIMECapabilitiesAttribute()));
        if (x509Certificate != null) {
            this.a("Add SMIMEEncryptionKeyPreference attribute", string, false);
            object = new IssuerAndSerialNumber(x509Certificate);
            attributes.addAttribute(new Attribute((AttributeValue)new SMIMEEncryptionKeyPreference((CertificateIdentifier)object)));
            if (bl) {
                this.a("Add MSOEEncryptionKeyPreference attribute", string, false);
                attributes.addAttribute(new Attribute((AttributeValue)new MSOEEncryptionKeyPreference((IssuerAndSerialNumber)object)));
            }
        }
        this.a("Add MLExpansionHistory attribute", string, false);
        if (this.EX == null) {
            this.a("Error: Cannot create MLData; missing mail list identifier!", string, false);
            throw new NullPointerException("Cannot create MLData; missing mail list identifier!");
        }
        object = new MLData(this.EX, date == null ? new Date() : date);
        if (mLExpansionHistory != null) {
            this.a("Update MLExpansionHistory attribute from outer layer", string, false);
            MLData mLData = mLExpansionHistory.getLastMLData();
            ((MLData)object).setMLReceiptPolicy(this.mergeMLReceiptPolicies(mLData.getMLReceiptPolicy(), mLReceiptPolicy, string));
            mLExpansionHistory.addMLData((MLData)object);
        } else {
            this.a("Create new MLExpansionHistory attribute", string, false);
            ((MLData)object).setMLReceiptPolicy(mLReceiptPolicy);
            mLExpansionHistory = new MLExpansionHistory((MLData)object);
        }
        attributes.addAttribute(new Attribute((AttributeValue)mLExpansionHistory));
        return attributes.toArray();
    }

    private SignedContent a(SignerInfo signerInfo, PrivateKey privateKey, Date date, X509Certificate x509Certificate, X509Certificate[] x509CertificateArray, AlgorithmID algorithmID, AlgorithmID algorithmID2, X509Certificate x509Certificate2, boolean bl, boolean bl2, ESSLayers eSSLayers) {
        ESSLayer eSSLayer;
        Object object;
        Object object2 = this.debugID_;
        if (eSSLayers != null && (object = eSSLayers.a()) != null) {
            object2 = object2 != null ? String.valueOf(this.debugID_) + "(" + (String)object + ")" : object;
        }
        if (signerInfo == null) {
            if (privateKey == null) {
                object = "Cannot create signature. Missing private key of signer!";
                this.a((String)object, (String)object2, false);
                throw new NullPointerException((String)object);
            }
            if (x509Certificate == null) {
                object = "Cannot create signature. Missing signer certificate!";
                this.a((String)object, (String)object2, false);
                throw new NullPointerException((String)object);
            }
        }
        if (eSSLayers == null || eSSLayers.getNumberOfLayers() == 0) {
            object = "Nothing to sign. No layers available.";
            this.a((String)object, (String)object2, false);
            throw new NullPointerException((String)object);
        }
        object = new SignedContent(bl2);
        ((SignedContent)object).checkForSMimeParts(false);
        this.a("Prepare for signing...", (String)object2, false);
        this.a("Searching for signed outer layer.", (String)object2, false);
        SignedESSLayer signedESSLayer = null;
        if (eSSLayers.getIndexOfOuterSignedLayer() != -1) {
            this.a("Detected signed outer layer", (String)object2, false);
            signedESSLayer = (SignedESSLayer)eSSLayers.getLayerAtIndex(eSSLayers.getIndexOfOuterSignedLayer());
            this.a("Check signatures of signed outer layer", (String)object2, false);
            if (!signedESSLayer.allSignaturesValid()) {
                String string = "Signature verfication problem: not all signatures in signed outer layer are valid.";
                this.a(String.valueOf(string) + " Check the corresponding SignerInfoVerificationResult.", (String)object2, false);
                throw new SignatureException(string);
            }
        } else {
            this.a("No signed outer layer present.", (String)object2, false);
        }
        this.a("Searching for enveloped layer.", (String)object2, false);
        if (eSSLayers.getIndexOfEnvelopedLayer() != -1) {
            this.a("Detected enveloped layer. Trying to expand.", (String)object2, false);
            if (this.FC == null) {
                throw new NullPointerException("Cannot expand enveloped layer. Missing required encryption info.");
            }
            eSSLayer = (EnvelopedESSLayer)eSSLayers.getLayerAtIndex(eSSLayers.getIndexOfEnvelopedLayer());
            EncryptedContent encryptedContent = ((EnvelopedESSLayer)eSSLayer).expand(this.FC.dj(), this.FC.dk(), this.FC.di(), this.FC.a());
            ((SignedContent)object).setContent(encryptedContent, encryptedContent.getContentType());
        } else {
            this.a("No enveloped layer included.", (String)object2, false);
            if (signedESSLayer != null) {
                this.a("Signing content of original outer layer.", (String)object2, false);
                ((SignedContent)object).setDataHandler(signedESSLayer.getDataHandler());
            } else {
                this.a("No signed outer layer, no enveloped layer. Signing outermost layer.", (String)object2, false);
                eSSLayer = eSSLayers.getOutermostLayer();
                DataHandler dataHandler = eSSLayer.getDataHandler();
                if (dataHandler != null) {
                    ((SignedContent)object).setDataHandler(dataHandler);
                } else {
                    Object object3;
                    try {
                        object3 = eSSLayer.getContent();
                    }
                    catch (IOException iOException) {
                        throw new MessagingException("Error accessing content of outermost layer: " + iOException.getMessage());
                    }
                    if (object3 instanceof Part) {
                        ((SignedContent)object).setContent(object3, ((Part)object3).getContentType());
                    } else if (object3 instanceof CryptoContent) {
                        ((SignedContent)object).setContent(object3, ((CryptoContent)object3).getContentType());
                    } else if (object3 instanceof Multipart) {
                        ((SignedContent)object).setContent((Multipart)object3);
                    } else {
                        throw new ESSException("Cannot set signed content; missing content type information!");
                    }
                }
            }
        }
        ((SignedContent)object).setCertificates((Certificate[])x509CertificateArray);
        this.a("Sign new outer layer.", (String)object2, false);
        if (signerInfo == null) {
            try {
                eSSLayer = this.createSignedAttributes(signedESSLayer, date, this.FA, x509Certificate2, bl, (String)object2);
                ((SignedContent)object).addSigner(privateKey, x509Certificate, algorithmID, algorithmID2, (Attribute[])eSSLayer);
            }
            catch (CodingException codingException) {
                this.a("Attribute encoding error: " + codingException.getMessage(), (String)object2, false);
                throw codingException;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.a("Error creating SignerInfo: Algorithm not supported: " + noSuchAlgorithmException.toString(), (String)object2, false);
                throw noSuchAlgorithmException;
            }
        } else {
            ((SignedContent)object).addSigner(signerInfo);
        }
        this.a("Done. Message signed.", (String)object2, false);
        return object;
    }

    public SignedContent createSignedContent(SignerInfo signerInfo, X509Certificate[] x509CertificateArray, boolean bl, ESSLayers eSSLayers) {
        return this.a(signerInfo, null, null, null, x509CertificateArray, null, null, null, false, bl, eSSLayers);
    }

    public SignedContent createSignedContent(PrivateKey privateKey, Date date, X509Certificate x509Certificate, X509Certificate[] x509CertificateArray, AlgorithmID algorithmID, AlgorithmID algorithmID2, X509Certificate x509Certificate2, boolean bl, boolean bl2, ESSLayers eSSLayers) {
        return this.a(null, privateKey, date, x509Certificate, x509CertificateArray, algorithmID, algorithmID2, x509Certificate2, bl, bl2, eSSLayers);
    }

    private void a(String string, String string2, boolean bl) {
        if (this.debugWriter_ != null) {
            if (bl) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                String string3 = stringTokenizer.nextToken();
                this.debugWriter_.println(String.valueOf(string2 == null ? "" : String.valueOf(string2) + ": ") + string3);
                while (stringTokenizer.hasMoreTokens()) {
                    this.debugWriter_.println(String.valueOf(string2 == null ? "" : String.valueOf(string2) + ": ") + " " + stringTokenizer.nextToken());
                }
            } else {
                this.debugWriter_.println(String.valueOf(string2 == null ? "" : String.valueOf(string2) + ": ") + string);
            }
        }
    }

    public CertificateDatabase getCertificateDatabase() {
        return this.Fy;
    }

    public KeyDatabase getKeyDatabase() {
        return this.Fx;
    }

    public MLReceiptPolicy getMLReceiptPolicy() {
        return this.FA;
    }

    public SecurityLabelHandler getSecurityLabelHandler() {
        return this.Fz;
    }

    public boolean getStopOnInvalidSignature() {
        return this.d;
    }

    protected MLReceiptPolicy mergeMLReceiptPolicies(MLReceiptPolicy mLReceiptPolicy, MLReceiptPolicy mLReceiptPolicy2, String string) {
        this.a("Create new MLReceiptPolicy for B by merging MLReceiptPolicies from A and B.", string, false);
        MLReceiptPolicy mLReceiptPolicy3 = null;
        MLReceiptPolicy mLReceiptPolicy4 = null;
        MLReceiptPolicy mLReceiptPolicy5 = null;
        if (mLReceiptPolicy2 != null) {
            mLReceiptPolicy5 = (MLReceiptPolicy)mLReceiptPolicy2.clone();
        }
        if (mLReceiptPolicy != null) {
            mLReceiptPolicy4 = (MLReceiptPolicy)mLReceiptPolicy.clone();
        }
        if (mLReceiptPolicy4 != null && mLReceiptPolicy5 != null) {
            int n2 = mLReceiptPolicy4.getValue();
            int n3 = mLReceiptPolicy5.getValue();
            if (n2 == 0 || n3 == 0) {
                this.a("MLReceiptPolicy will be NONE.", string, false);
                mLReceiptPolicy3 = new MLReceiptPolicy(0);
            } else if (n3 == 1) {
                this.a("MLReceiptPolicy will be INSTEAD_OF.", string, false);
                mLReceiptPolicy3 = new MLReceiptPolicy(1);
                mLReceiptPolicy3.setRecipientList(mLReceiptPolicy5.getRecipientList());
            } else {
                if (n2 == 1) {
                    this.a("MLReceiptPolicy will be INSTEAD_OF(INSTEAD_OF(A) + IN_ADDITION_TO(B)", string, false);
                    mLReceiptPolicy3 = new MLReceiptPolicy(1);
                } else {
                    this.a("MLReceiptPolicy will be IN_ADDITION_TO(IN_ADDITION_TO(A) + IN_ADDITION_TO(B)", string, false);
                    mLReceiptPolicy3 = new MLReceiptPolicy(2);
                }
                GeneralNames[] generalNamesArray = MLA.a(mLReceiptPolicy4.getRecipientList(), mLReceiptPolicy5.getRecipientList());
                mLReceiptPolicy3.setRecipientList(generalNamesArray);
            }
        } else if (mLReceiptPolicy4 != null) {
            this.a("New MLReceiptPolicy for B adopted from A", string, false);
            mLReceiptPolicy3 = mLReceiptPolicy4;
        } else {
            this.a("MLReceiptPolicy for B not changed", string, false);
            mLReceiptPolicy3 = mLReceiptPolicy5;
        }
        return mLReceiptPolicy3;
    }

    public ESSLayers resolve(Part part) {
        return this.resolve(part, null);
    }

    public ESSLayers resolve(Part part, String string) {
        ESSLayers eSSLayers = new ESSLayers(this.EX);
        eSSLayers.a(this.debugID_, string, this.debugWriter_);
        eSSLayers.a(this.Fx);
        eSSLayers.a(this.Fy);
        eSSLayers.a(this.d);
        eSSLayers.a(part);
        return eSSLayers;
    }

    public void setCertificateDatabase(CertificateDatabase certificateDatabase) {
        this.Fy = certificateDatabase;
    }

    public void setDebugStream(String string, OutputStream outputStream) {
        this.debugID_ = string;
        this.debugWriter_ = outputStream == null ? null : new PrintWriter(outputStream, true);
    }

    public void setEncryptionInfo(OriginatorInfo originatorInfo, RecipientInfo[] recipientInfoArray, AlgorithmID algorithmID, int n2) {
        this.FC = new b(originatorInfo, recipientInfoArray, algorithmID, n2);
    }

    public void setKeyDatabase(KeyDatabase keyDatabase) {
        this.Fx = keyDatabase;
    }

    public void setMLReceiptPolicy(MLReceiptPolicy mLReceiptPolicy) {
        this.FA = mLReceiptPolicy;
    }

    public void setSecurityLabelHandler(SecurityLabelHandler securityLabelHandler) {
        this.Fz = securityLabelHandler;
    }

    public void setStopOnInvalidSignature(boolean bl) {
        this.d = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.EX != null) {
            stringBuffer.append("Owner: " + this.EX + "\n");
        }
        return stringBuffer.toString();
    }
}

