/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess.utils;

import iaik.cms.CertificateIdentifier;
import iaik.cms.DebugCMS;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.KeyIdentifier;
import iaik.cms.Utils;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.KeyBag;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.smime.TrustVerifier;
import iaik.smime.ess.utils.ESSUtil;
import iaik.smime.ess.utils.KeyDatabase;
import iaik.smime.ess.utils.KeyStoreDatabaseException;
import iaik.smime.ess.utils.a;
import iaik.smime.ess.utils.c;
import iaik.utils.ASN1InputStream;
import iaik.utils.KeyAndCertificate;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Hashtable;

public class KeyStoreDatabase
implements KeyDatabase {
    private static boolean a = false;
    protected Hashtable keyBase_ = new Hashtable(20);
    protected Hashtable certBase_ = new Hashtable(20);
    protected TrustVerifier trustVerifier_;

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    public void addCertificate(Certificate certificate, String string) {
        if (certificate != null) {
            try {
                X509Certificate x509Certificate = ESSUtil.convertCertificate(certificate);
                this.certBase_.put(new IssuerAndSerialNumber(x509Certificate), new a(x509Certificate, string));
            }
            catch (Exception exception) {
                throw new KeyStoreDatabaseException("Error adding certificate: " + exception.toString());
            }
        }
    }

    public void addKey(PKCS12 pKCS12, char[] cArray, String string) {
        Object object;
        PrivateKey privateKey = null;
        X509Certificate[] x509CertificateArray = null;
        KeyBag keyBag = null;
        try {
            if (!pKCS12.verify(cArray)) {
                throw new KeyStoreDatabaseException("Error verifying MAC of PKCS#12 object!");
            }
            pKCS12.decrypt(cArray);
            keyBag = pKCS12.getKeyBag();
            privateKey = keyBag.getPrivateKey();
            object = pKCS12.getCertificateBags();
            X509Certificate[] x509CertificateArray2 = CertificateBag.getCertificates((CertificateBag[])object);
            if (x509CertificateArray2 == null || x509CertificateArray2.length < 1) {
                throw new KeyStoreDatabaseException("Missing certificates!");
            }
            x509CertificateArray = ESSUtil.convertCertificateChain((Certificate[])x509CertificateArray2);
            if ((x509CertificateArray = Util.arrangeCertificateChain((X509Certificate[])x509CertificateArray, (boolean)false)) == null) {
                throw new KeyStoreDatabaseException("Unable to sort certificates included in PKCS#12 object!");
            }
        }
        catch (Exception exception) {
            throw new KeyStoreDatabaseException("Cannot adding key entry: " + exception.getMessage());
        }
        object = string;
        if (object == null) {
            object = keyBag.getFriendlyName();
        }
        if (object == null) {
            throw new KeyStoreDatabaseException("Cannot adding key entry: Missing alias!");
        }
        this.addKey(privateKey, (Certificate[])x509CertificateArray, (String)object);
    }

    public void addKey(InputStream inputStream, char[] cArray, String string) {
        try {
            this.addKey(new PKCS12((InputStream)new ASN1InputStream(inputStream)), cArray, string);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new KeyStoreDatabaseException("Cannot add key. Error parsing PKCS#12 file: " + exception.toString());
        }
    }

    public void addKey(Key key, Certificate[] certificateArray, String string) {
        if (!(key instanceof PrivateKey)) {
            throw new KeyStoreDatabaseException("Only private keys are supported as key entries!");
        }
        if (certificateArray == null || certificateArray.length == 0) {
            throw new KeyStoreDatabaseException("Cannot add key entry. Missing corresponding certificate!");
        }
        try {
            X509Certificate[] x509CertificateArray = ESSUtil.convertCertificateChain(certificateArray);
            this.keyBase_.put(new IssuerAndSerialNumber(x509CertificateArray[0]), new c((PrivateKey)key, x509CertificateArray, string));
        }
        catch (Exception exception) {
            throw new KeyStoreDatabaseException("Error adding certificate: " + exception.toString());
        }
    }

    public X509Certificate[] getAllCertificates() {
        int n2 = 0;
        X509Certificate[] x509CertificateArray = new X509Certificate[this.certBase_.size()];
        Enumeration enumeration = this.certBase_.elements();
        while (enumeration.hasMoreElements()) {
            x509CertificateArray[n2++] = ((a)enumeration.nextElement()).dh();
        }
        return x509CertificateArray;
    }

    public KeyAndCertificate[] getAllKeys() {
        KeyAndCertificate[] keyAndCertificateArray = new KeyAndCertificate[this.keyBase_.size()];
        int n2 = 0;
        Enumeration enumeration = this.keyBase_.elements();
        while (enumeration.hasMoreElements()) {
            keyAndCertificateArray[n2++] = ((c)enumeration.nextElement()).dl();
        }
        return keyAndCertificateArray;
    }

    public X509Certificate getCertificate(CertificateIdentifier certificateIdentifier) {
        X509Certificate x509Certificate = null;
        X509Certificate[] x509CertificateArray = this.getCertificateChain(certificateIdentifier);
        if (x509CertificateArray.length > 0) {
            x509Certificate = x509CertificateArray[0];
        }
        return x509Certificate;
    }

    public X509Certificate[] getCertificateChain(CertificateIdentifier certificateIdentifier) {
        if (!(certificateIdentifier instanceof IssuerAndSerialNumber)) {
            throw new KeyStoreDatabaseException("Only KeyIdentifiers of type IssuerAndSerialNumbers are supported!");
        }
        X509Certificate[] x509CertificateArray = null;
        c c2 = (c)this.keyBase_.get((IssuerAndSerialNumber)certificateIdentifier);
        if (c2 != null) {
            x509CertificateArray = c2.b();
        } else {
            a a2 = (a)this.certBase_.get((IssuerAndSerialNumber)certificateIdentifier);
            if (a2 != null) {
                x509CertificateArray = new X509Certificate[]{a2.dh()};
            }
        }
        if (this.trustVerifier_ != null && x509CertificateArray != null && x509CertificateArray.length > 0 && !this.trustVerifier_.verifyChain(x509CertificateArray)) {
            x509CertificateArray = new X509Certificate[]{};
        }
        return x509CertificateArray;
    }

    public Key getKey(KeyIdentifier keyIdentifier) {
        if (!(keyIdentifier instanceof IssuerAndSerialNumber)) {
            throw new KeyStoreDatabaseException("Only KeyIdentifiers of type IssuerAndSerialNumbers are supported!");
        }
        PrivateKey privateKey = null;
        c c2 = (c)this.keyBase_.get((IssuerAndSerialNumber)keyIdentifier);
        if (c2 != null) {
            if (this.trustVerifier_ == null) {
                privateKey = c2.dm();
            } else if (this.trustVerifier_.verifyChain(c2.b())) {
                privateKey = c2.dm();
            }
        }
        return privateKey;
    }

    public int getNumberOfCertificateEntries() {
        return this.certBase_.size();
    }

    public int getNumberOfKeyEntries() {
        return this.keyBase_.size();
    }

    public int getSize() {
        return this.keyBase_.size() + this.certBase_.size();
    }

    public TrustVerifier getTrustVerifier() {
        return this.trustVerifier_;
    }

    public void init(InputStream inputStream, char[] cArray, String string, String string2) {
        KeyStore keyStore = null;
        try {
            keyStore = string2 == null ? KeyStore.getInstance(string) : KeyStore.getInstance(string, string2);
            keyStore.load(inputStream, cArray);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new KeyStoreDatabaseException("Error loading keystore: " + exception.toString());
        }
        this.init(keyStore, cArray);
    }

    public void init(KeyStore keyStore, char[] cArray) {
        this.reset();
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (keyStore.isKeyEntry(string)) {
                    Key key = keyStore.getKey(string, cArray);
                    this.addKey(key, keyStore.getCertificateChain(string), string);
                    continue;
                }
                this.addCertificate(keyStore.getCertificate(string), string);
            }
        }
        catch (Exception exception) {
            throw new KeyStoreDatabaseException("Error in initializing KeyStoreDatabase: " + exception.getMessage());
        }
    }

    public void reset() {
        this.keyBase_.clear();
        this.certBase_.clear();
    }

    public void setTrustVerifier(TrustVerifier trustVerifier) {
        this.trustVerifier_ = trustVerifier;
    }

    public void store(OutputStream outputStream, char[] cArray, String string, String string2) {
        try {
            Serializable serializable;
            Object object;
            KeyStore keyStore = string2 == null ? KeyStore.getInstance(string) : KeyStore.getInstance(string, string2);
            keyStore.load(null, null);
            Enumeration enumeration = this.keyBase_.elements();
            while (enumeration.hasMoreElements()) {
                Object[] objectArray;
                block12: {
                    block11: {
                        object = (c)enumeration.nextElement();
                        serializable = ((c)object).dm();
                        try {
                            serializable = (PrivateKey)ESSUtil.convertKey(serializable, string2);
                        }
                        catch (Exception exception) {
                            if (!a) break block11;
                            System.out.println("Error converting key:");
                            exception.printStackTrace();
                        }
                    }
                    objectArray = ((c)object).b();
                    try {
                        objectArray = ESSUtil.convertCertificateChain((Certificate[])objectArray, string2);
                    }
                    catch (Exception exception) {
                        if (!a) break block12;
                        System.out.println("Error converting certificate chain:");
                        exception.printStackTrace();
                    }
                }
                keyStore.setKeyEntry(((c)object).a(), (Key)serializable, cArray, (Certificate[])objectArray);
            }
            enumeration = this.certBase_.elements();
            while (enumeration.hasMoreElements()) {
                block13: {
                    object = (a)enumeration.nextElement();
                    serializable = ((a)object).dh();
                    try {
                        serializable = ESSUtil.convertCertificate((Certificate)serializable, string2);
                    }
                    catch (Exception exception) {
                        if (!a) break block13;
                        System.out.println("Error converting certificate:");
                        exception.printStackTrace();
                    }
                }
                keyStore.setCertificateEntry(((a)object).a(), (Certificate)serializable);
            }
            keyStore.store(outputStream, cArray);
        }
        catch (KeyStoreException keyStoreException) {
            throw new KeyStoreDatabaseException(keyStoreException.toString());
        }
        catch (CertificateException certificateException) {
            throw new KeyStoreDatabaseException(certificateException.toString());
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("This KeyStoreDatabase contains " + this.keyBase_.size() + " key and " + this.certBase_.size() + " certificate entries.");
        if (bl) {
            Enumeration enumeration;
            stringBuffer.append("\nKey Entries: ");
            if (this.keyBase_.size() == 0) {
                stringBuffer.append("0");
            } else {
                enumeration = this.keyBase_.keys();
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append("\n " + Utils.printIndented(enumeration.nextElement().toString(), false));
                }
            }
            stringBuffer.append("\nCertificate Entries:\n");
            if (this.certBase_.size() == 0) {
                stringBuffer.append("0");
            } else {
                enumeration = this.certBase_.keys();
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append("\n " + Utils.printIndented(enumeration.nextElement().toString(), false));
                }
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

