/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess.utils;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.cms.DebugCMS;
import iaik.cms.SignerInfo;
import iaik.smime.SignedContent;
import iaik.smime.ess.ESSException;
import iaik.smime.ess.ESSSecurityLabel;
import iaik.smime.ess.EquivalentLabels;
import iaik.smime.ess.MLExpansionHistory;
import iaik.smime.ess.ReceiptRequest;
import iaik.utils.CryptoUtils;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Enumeration;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;

public class ESSUtil {
    private static boolean a = false;

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    private ESSUtil() {
    }

    public static boolean compareGeneralName(GeneralName generalName, GeneralName generalName2) {
        if (generalName == null || generalName2 == null) {
            throw new NullPointerException("Cannot compare null names!");
        }
        int n2 = generalName.getType();
        if (n2 != generalName2.getType()) {
            return false;
        }
        boolean bl = false;
        Object object = generalName.getName();
        Object object2 = generalName.getName();
        switch (n2) {
            case 0: 
            case 3: 
            case 5: {
                bl = CryptoUtils.equalsBlock((byte[])DerCoder.encode((ASN1Object)((ASN1Object)object)), (byte[])DerCoder.encode((ASN1Object)((ASN1Object)object2)));
                break;
            }
            case 1: {
                bl = ESSUtil.parseAddress((String)object).equals(ESSUtil.parseAddress((String)object2));
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                bl = object.equals(object2);
                break;
            }
            default: {
                throw new IllegalArgumentException("GeneralName: type " + n2 + " not implemented yet!");
            }
        }
        return bl;
    }

    public static boolean compareGeneralNames(GeneralNames generalNames, GeneralNames generalNames2) {
        if (generalNames == null || generalNames2 == null) {
            throw new NullPointerException("Cannot compare null names!");
        }
        Enumeration enumeration = generalNames.getNames();
        Enumeration enumeration2 = generalNames2.getNames();
        while (enumeration.hasMoreElements()) {
            if (enumeration2.hasMoreElements()) {
                if (enumeration.nextElement().equals(enumeration2.nextElement())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static X509Certificate convertCertificate(Certificate certificate) {
        X509Certificate x509Certificate = null;
        if (certificate != null) {
            x509Certificate = certificate instanceof X509Certificate ? (X509Certificate)certificate : new X509Certificate(certificate.getEncoded());
        }
        return x509Certificate;
    }

    public static java.security.cert.X509Certificate convertCertificate(Certificate certificate, String string) {
        java.security.cert.X509Certificate x509Certificate = null;
        if (certificate != null) {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", string);
            x509Certificate = (java.security.cert.X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certificate.getEncoded()));
        }
        return x509Certificate;
    }

    public static X509Certificate[] convertCertificateChain(Certificate[] certificateArray) {
        X509Certificate[] x509CertificateArray = null;
        if (certificateArray != null && certificateArray.length > 0) {
            x509CertificateArray = new X509Certificate[certificateArray.length];
            int n2 = 0;
            while (n2 < certificateArray.length) {
                x509CertificateArray[n2] = ESSUtil.convertCertificate(certificateArray[n2]);
                ++n2;
            }
        }
        return x509CertificateArray;
    }

    public static java.security.cert.X509Certificate[] convertCertificateChain(Certificate[] certificateArray, String string) {
        java.security.cert.X509Certificate[] x509CertificateArray = null;
        if (certificateArray != null) {
            x509CertificateArray = new java.security.cert.X509Certificate[certificateArray.length];
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", string);
            int n2 = 0;
            while (n2 < certificateArray.length) {
                x509CertificateArray[n2] = (java.security.cert.X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certificateArray[n2].getEncoded()));
                ++n2;
            }
        }
        return x509CertificateArray;
    }

    public static Key convertKey(Key key, String string) {
        if (key instanceof SecretKey) {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(key.getAlgorithm(), string);
            return secretKeyFactory.translateKey((SecretKey)key);
        }
        KeyFactory keyFactory = KeyFactory.getInstance(key.getAlgorithm(), string);
        return keyFactory.translateKey(key);
    }

    public static GeneralName createGeneralName(String string) {
        return new GeneralName(1, (Object)ESSUtil.parseAddress(string));
    }

    public static GeneralNames createGeneralNames(String string) {
        return new GeneralNames(ESSUtil.createGeneralName(string));
    }

    public static AttributeValue getAttributeValue(SignedContent signedContent, ObjectID objectID, boolean bl) {
        return ESSUtil.getAttributeValue(signedContent.getSignerInfos(), objectID, bl, false);
    }

    public static AttributeValue getAttributeValue(SignedContent signedContent, ObjectID objectID, boolean bl, boolean bl2) {
        return ESSUtil.getAttributeValue(signedContent.getSignerInfos(), objectID, bl, bl2);
    }

    public static AttributeValue getAttributeValue(SignerInfo[] signerInfoArray, ObjectID objectID, boolean bl) {
        return ESSUtil.getAttributeValue(signerInfoArray, objectID, bl, false);
    }

    public static AttributeValue getAttributeValue(SignerInfo[] signerInfoArray, ObjectID objectID, boolean bl, boolean bl2) {
        AttributeValue attributeValue = null;
        boolean bl3 = false;
        int n2 = 0;
        while (n2 < signerInfoArray.length) {
            Attribute attribute = signerInfoArray[n2].getSignedAttribute(objectID);
            if (attribute != null) {
                attributeValue = attribute.getAttributeValue();
                if (attributeValue != null) break;
                bl3 = true;
            }
            ++n2;
        }
        if (attributeValue != null && bl) {
            if (bl3) {
                throw new ESSException("SignerInfos contain different " + objectID.getName() + " attributes!");
            }
            if (bl2 && n2 > 0) {
                throw new ESSException(String.valueOf(objectID.getName()) + " attribute not included in all SignerInfos as required!");
            }
            int n3 = ++n2;
            while (n3 < signerInfoArray.length) {
                Attribute attribute = signerInfoArray[n3].getSignedAttribute(objectID);
                if (attribute == null && bl2) {
                    throw new ESSException(String.valueOf(objectID.getName()) + " attribute not included in all SignerInfos as required!");
                }
                if (attribute != null && !attributeValue.equals(attribute.getAttributeValue())) {
                    throw new ESSException("SignerInfos contain different " + objectID.getName() + " attributes!");
                }
                ++n3;
            }
        }
        return attributeValue;
    }

    public static ESSSecurityLabel getESSSecurityLabel(SignedContent signedContent) {
        return ESSUtil.getESSSecurityLabel(signedContent.getSignerInfos());
    }

    public static ESSSecurityLabel getESSSecurityLabel(SignerInfo[] signerInfoArray) {
        AttributeValue attributeValue = ESSUtil.getAttributeValue(signerInfoArray, ESSSecurityLabel.oid, true, true);
        ESSSecurityLabel eSSSecurityLabel = null;
        if (attributeValue != null) {
            eSSSecurityLabel = attributeValue instanceof ESSSecurityLabel ? (ESSSecurityLabel)attributeValue : new ESSSecurityLabel(attributeValue.toASN1Object());
        }
        return eSSSecurityLabel;
    }

    public static EquivalentLabels getEquivalentLabels(SignedContent signedContent) {
        return ESSUtil.getEquivalentLabels(signedContent.getSignerInfos());
    }

    public static EquivalentLabels getEquivalentLabels(SignerInfo[] signerInfoArray) {
        AttributeValue attributeValue = ESSUtil.getAttributeValue(signerInfoArray, EquivalentLabels.oid, true, true);
        EquivalentLabels equivalentLabels = null;
        if (attributeValue != null) {
            equivalentLabels = attributeValue instanceof EquivalentLabels ? (EquivalentLabels)attributeValue : new EquivalentLabels(attributeValue.toASN1Object());
        }
        return equivalentLabels;
    }

    public static SignerInfo getFirstSignerInfoWithAttribute(SignedContent signedContent, ObjectID objectID) {
        return ESSUtil.getFirstSignerInfoWithAttribute(signedContent.getSignerInfos(), objectID);
    }

    public static SignerInfo getFirstSignerInfoWithAttribute(SignerInfo[] signerInfoArray, ObjectID objectID) {
        SignerInfo signerInfo = null;
        int n2 = 0;
        while (n2 < signerInfoArray.length) {
            Attribute attribute = signerInfoArray[n2].getSignedAttribute(objectID);
            if (attribute != null) {
                signerInfo = signerInfoArray[n2];
                break;
            }
            ++n2;
        }
        return signerInfo;
    }

    public static MLExpansionHistory getMLExpansionHistory(SignedContent signedContent) {
        return ESSUtil.getMLExpansionHistory(signedContent.getSignerInfos());
    }

    public static MLExpansionHistory getMLExpansionHistory(SignerInfo[] signerInfoArray) {
        AttributeValue attributeValue = ESSUtil.getAttributeValue(signerInfoArray, MLExpansionHistory.oid, true, false);
        MLExpansionHistory mLExpansionHistory = null;
        if (attributeValue != null) {
            mLExpansionHistory = attributeValue instanceof MLExpansionHistory ? (MLExpansionHistory)attributeValue : new MLExpansionHistory(attributeValue.toASN1Object());
        }
        return mLExpansionHistory;
    }

    public static String[] getMailAddresses(GeneralNames generalNames) {
        Object[] objectArray;
        Vector<Object> vector = new Vector<Object>();
        if (generalNames != null) {
            objectArray = generalNames.getNames();
            while (objectArray.hasMoreElements()) {
                GeneralName generalName = (GeneralName)objectArray.nextElement();
                if (generalName.getType() != 1) continue;
                vector.addElement(generalName.getName());
            }
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String[] getMailAddresses(GeneralNames[] generalNamesArray) {
        Vector<Object> vector = new Vector<Object>();
        if (generalNamesArray != null) {
            int n2 = 0;
            while (n2 < generalNamesArray.length) {
                Enumeration enumeration = generalNamesArray[n2].getNames();
                while (enumeration.hasMoreElements()) {
                    GeneralName generalName = (GeneralName)enumeration.nextElement();
                    if (generalName.getType() != 1) continue;
                    vector.addElement(generalName.getName());
                }
                ++n2;
            }
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static ReceiptRequest getReceiptRequest(SignedContent signedContent) {
        return ESSUtil.getReceiptRequest(signedContent.getSignerInfos());
    }

    public static ReceiptRequest getReceiptRequest(SignerInfo[] signerInfoArray) {
        AttributeValue attributeValue = ESSUtil.getAttributeValue(signerInfoArray, ReceiptRequest.oid, true, false);
        ReceiptRequest receiptRequest = null;
        if (attributeValue != null) {
            receiptRequest = attributeValue instanceof ReceiptRequest ? (ReceiptRequest)attributeValue : new ReceiptRequest(attributeValue.toASN1Object());
        }
        return receiptRequest;
    }

    public static SignerInfo[] getSignerInfosWithAttribute(SignedContent signedContent, ObjectID objectID, boolean bl) {
        return ESSUtil.getSignerInfosWithAttribute(signedContent.getSignerInfos(), objectID, bl);
    }

    public static SignerInfo[] getSignerInfosWithAttribute(SignedContent signedContent, ObjectID objectID, boolean bl, boolean bl2) {
        return ESSUtil.getSignerInfosWithAttribute(signedContent.getSignerInfos(), objectID, bl, bl2);
    }

    public static SignerInfo[] getSignerInfosWithAttribute(SignerInfo[] signerInfoArray, ObjectID objectID, boolean bl) {
        return ESSUtil.getSignerInfosWithAttribute(signerInfoArray, objectID, bl, false);
    }

    public static SignerInfo[] getSignerInfosWithAttribute(SignerInfo[] signerInfoArray, ObjectID objectID, boolean bl, boolean bl2) {
        Attribute attribute;
        Vector<SignerInfo> vector = new Vector<SignerInfo>();
        AttributeValue attributeValue = null;
        int n2 = 0;
        boolean bl3 = false;
        while (n2 < signerInfoArray.length) {
            Attribute attribute2 = signerInfoArray[n2].getSignedAttribute(objectID);
            if (attribute2 != null) {
                attributeValue = attribute2.getAttributeValue();
                vector.addElement(signerInfoArray[n2]);
                if (attributeValue != null) break;
                bl3 = true;
            }
            ++n2;
        }
        if (bl && bl2 && n2 > 0) {
            throw new ESSException(String.valueOf(objectID.getName()) + " attribute not included in all SignerInfos as required!");
        }
        int n3 = ++n2;
        while (n3 < signerInfoArray.length) {
            attribute = signerInfoArray[n3].getSignedAttribute(objectID);
            if (attribute != null) {
                if (attributeValue != null) {
                    if (bl && !attributeValue.equals(attribute.getAttributeValue())) {
                        throw new ESSException("SignerInfos contain different " + objectID.getName() + " attributes!");
                    }
                    if (bl3) {
                        throw new ESSException("SignerInfos contain different " + objectID.getName() + " attributes!");
                    }
                }
                vector.addElement(signerInfoArray[n3]);
            } else if (bl && bl2) {
                throw new ESSException(String.valueOf(objectID.getName()) + " attribute not included in all SignerInfos as required!");
            }
            ++n3;
        }
        attribute = new SignerInfo[vector.size()];
        vector.copyInto((Object[])attribute);
        return attribute;
    }

    public static String parseAddress(String string) {
        if (string == null) {
            throw new NullPointerException("Cannot parse null address!");
        }
        int n2 = string.indexOf(60);
        int n3 = string.indexOf(62);
        if (n3 == -1) {
            n3 = string.length();
        }
        return string.substring(n2 + 1, n3);
    }
}

