/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess.utils;

import iaik.asn1.CodingException;
import iaik.cms.CMSException;
import iaik.cms.CMSSignatureException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.CertificateNotFoundException;
import iaik.cms.KeyIdentifier;
import iaik.cms.RecipientInfo;
import iaik.cms.SignerInfo;
import iaik.smime.EncryptedContent;
import iaik.smime.SMimeContent;
import iaik.smime.SMimeParameters;
import iaik.smime.SignedContent;
import iaik.smime.ess.ESSAttributeValue;
import iaik.smime.ess.ESSException;
import iaik.smime.ess.EntityIdentifier;
import iaik.smime.ess.MLData;
import iaik.smime.ess.MLExpansionHistory;
import iaik.smime.ess.MLExpansionLoopException;
import iaik.smime.ess.ReceiptRequest;
import iaik.smime.ess.SecurityLabelException;
import iaik.smime.ess.utils.CertificateDatabase;
import iaik.smime.ess.utils.CertificateDatabaseException;
import iaik.smime.ess.utils.ESSLayer;
import iaik.smime.ess.utils.ESSLayerException;
import iaik.smime.ess.utils.ESSUtil;
import iaik.smime.ess.utils.EnvelopedESSLayer;
import iaik.smime.ess.utils.KeyDatabase;
import iaik.smime.ess.utils.KeyDatabaseException;
import iaik.smime.ess.utils.SecurityLabelHandler;
import iaik.smime.ess.utils.SignedESSLayer;
import iaik.smime.ess.utils.SignerInfoVerificationResult;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;

public class ESSLayers {
    private int a;
    private int b;
    private int c;
    private int d;
    private KeyDatabase Ft;
    private CertificateDatabase Fu;
    private SecurityLabelHandler En;
    private EntityIdentifier Fv;
    private Vector Ej;
    private boolean j;
    private PrintWriter Fw;
    private String l;
    private String m;

    ESSLayers() {
        this.b();
    }

    ESSLayers(EntityIdentifier entityIdentifier) {
        this();
        this.Fv = entityIdentifier;
    }

    private void a(String string) {
        this.a(string, false);
    }

    private void a(String string, boolean bl) {
        if (this.Fw != null) {
            if (bl) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                String string2 = stringTokenizer.nextToken();
                this.Fw.println(String.valueOf(this.l == null ? "" : String.valueOf(this.l) + ": ") + string2);
                while (stringTokenizer.hasMoreTokens()) {
                    this.Fw.println(String.valueOf(this.l == null ? "" : String.valueOf(this.l) + ": ") + " " + stringTokenizer.nextToken());
                }
            } else {
                this.Fw.println(String.valueOf(this.l == null ? "" : String.valueOf(this.l) + ": ") + string);
            }
        }
    }

    private void c(DataHandler dataHandler) {
        if (dataHandler != null) {
            Object object;
            ++this.a;
            this.a("Processing layer at level " + this.a);
            Object object2 = null;
            try {
                object2 = dataHandler.getContent();
            }
            catch (IOException iOException) {
                this.a("Error parsing part content: " + iOException.toString());
                ESSLayer eSSLayer = new ESSLayer();
                eSSLayer.setDataHandler(dataHandler);
                ESSLayerException eSSLayerException = new ESSLayerException(0, iOException, eSSLayer);
                eSSLayer.a(eSSLayerException);
                this.Ej.addElement(eSSLayer);
                throw eSSLayerException;
            }
            if (object2 instanceof Part) {
                object = (Part)object2;
                try {
                    this.a("Layer is part with content type " + ((Part)object2).getContentType(), true);
                }
                catch (MessagingException messagingException) {
                    this.a("Layer is part; error getting content type: " + messagingException.getMessage());
                }
                try {
                    dataHandler = object.getDataHandler();
                    SMimeParameters.setDataHandlerCommandMap(dataHandler);
                    object2 = object.getContent();
                }
                catch (Exception exception) {
                    this.a("Error parsing part content: " + exception.toString());
                    ESSLayer eSSLayer = new ESSLayer();
                    eSSLayer.setDataHandler(dataHandler);
                    ESSLayerException eSSLayerException = new ESSLayerException(0, exception, eSSLayer);
                    eSSLayer.a(eSSLayerException);
                    this.Ej.addElement(eSSLayer);
                    throw eSSLayerException;
                }
            }
            if (object2 instanceof EncryptedContent) {
                Object object3;
                object = (EncryptedContent)object2;
                EnvelopedESSLayer envelopedESSLayer = new EnvelopedESSLayer((EncryptedContent)object);
                envelopedESSLayer.setDataHandler(dataHandler);
                this.Ej.addElement(envelopedESSLayer);
                EnvelopedESSLayer envelopedESSLayer2 = envelopedESSLayer;
                if (this.d == -1) {
                    this.d = this.a;
                }
                this.a("Layer is enveloped (content type " + ((SMimeContent)object).getContentType() + "). Searching for decryption key");
                Key key = null;
                KeyIdentifier keyIdentifier = null;
                if (this.Ft != null) {
                    object3 = ((EncryptedContent)object).getRecipientInfos();
                    int n2 = 0;
                    while (n2 < ((RecipientInfo[])object3).length) {
                        KeyIdentifier[] keyIdentifierArray = object3[n2].getRecipientIdentifiers();
                        if (keyIdentifierArray != null) {
                            int n3 = 0;
                            while (n3 < keyIdentifierArray.length) {
                                keyIdentifier = keyIdentifierArray[n3];
                                try {
                                    key = this.Ft.getKey(keyIdentifier);
                                }
                                catch (KeyDatabaseException keyDatabaseException) {
                                    this.a("Problem to fetch key from database: " + keyDatabaseException.getMessage() + ". Trying next one.");
                                }
                                if (key != null) break;
                                ++n3;
                            }
                        }
                        if (key != null) break;
                        ++n2;
                    }
                }
                if (key == null) {
                    this.a("Cannot decrypt layer; no key available.");
                    object3 = new ESSLayerException(1, envelopedESSLayer2);
                    envelopedESSLayer.a((ESSLayerException)object3);
                    throw object3;
                }
                this.a("Found decryption key for recipient " + keyIdentifier);
                this.a("Decrypting content encryption key...");
                try {
                    ((EncryptedContent)object).decryptSymmetricKey(key, keyIdentifier);
                    envelopedESSLayer2.a(true);
                }
                catch (Exception exception) {
                    this.a("Error decrypting content encryption key: " + exception.toString());
                    ESSLayerException eSSLayerException = new ESSLayerException(2, exception, (ESSLayer)envelopedESSLayer2);
                    envelopedESSLayer.a(eSSLayerException);
                    throw eSSLayerException;
                }
                try {
                    this.c(((EncryptedContent)object).getDataHandler());
                }
                catch (Exception exception) {
                    this.a("Error parsing content: " + exception.toString());
                    ESSLayerException eSSLayerException = new ESSLayerException(0, exception, (ESSLayer)envelopedESSLayer);
                    envelopedESSLayer.a(eSSLayerException);
                    throw eSSLayerException;
                }
            }
            if (object2 instanceof SignedContent) {
                object = (SignedContent)object2;
                ((SignedContent)object).setSecurityLabelHandler(this.En);
                SignedESSLayer signedESSLayer = new SignedESSLayer((SignedContent)object);
                signedESSLayer.setDataHandler(dataHandler);
                SignedESSLayer signedESSLayer2 = signedESSLayer;
                this.Ej.addElement(signedESSLayer2);
                Object object4 = null;
                this.a("Layer is signed (content type " + object.getContentType() + ").", true);
                this.a("Getting layer content");
                try {
                    dataHandler = ((SignedContent)object).getDataHandler();
                    SMimeParameters.setDataHandlerCommandMap(dataHandler);
                    object4 = dataHandler.getContent();
                }
                catch (SecurityLabelException securityLabelException) {
                    this.a("Detected content access restriction by SecurityLabel attribute.");
                    ESSLayerException eSSLayerException = new ESSLayerException(6, securityLabelException, (ESSLayer)signedESSLayer2);
                    signedESSLayer.a(eSSLayerException);
                    throw eSSLayerException;
                }
                catch (Exception exception) {
                    this.a("Error parsing content of signed layer: " + exception.toString());
                    ESSLayerException eSSLayerException = new ESSLayerException(0, exception, (ESSLayer)signedESSLayer2);
                    signedESSLayer.a(eSSLayerException);
                    throw eSSLayerException;
                }
                this.a("Verifying signatures...");
                SignerInfoVerificationResult[] signerInfoVerificationResultArray = null;
                try {
                    signerInfoVerificationResultArray = this.a((SignedContent)object, this.j);
                }
                catch (CMSSignatureException cMSSignatureException) {
                    signedESSLayer2.a(signerInfoVerificationResultArray);
                    ESSLayerException eSSLayerException = new ESSLayerException(8, cMSSignatureException, (ESSLayer)signedESSLayer2);
                    signedESSLayer2.a(eSSLayerException);
                    throw eSSLayerException;
                }
                signedESSLayer2.a(signerInfoVerificationResultArray);
                if (signerInfoVerificationResultArray.length > 0) {
                    Object object5;
                    SignerInfo[] signerInfoArray;
                    ESSAttributeValue eSSAttributeValue;
                    if (this.b == -1) {
                        this.a("No signed outer layer so far. Search for MLExpansionHistory attribute");
                        eSSAttributeValue = null;
                        try {
                            signerInfoArray = ESSUtil.getSignerInfosWithAttribute((SignedContent)object, MLExpansionHistory.oid, true);
                        }
                        catch (CodingException codingException) {
                            this.a("Error parsing MLExpansionHistory attribute: " + codingException.toString());
                            ESSLayerException eSSLayerException = new ESSLayerException(3, "Error parsing MLExpansionHistory attribute: " + codingException.toString(), (Exception)((Object)codingException), signedESSLayer2);
                            signedESSLayer.a(eSSLayerException);
                            throw eSSLayerException;
                        }
                        catch (ESSException eSSException) {
                            this.a("Error: There are MLExpansionHistory attributes in the SignedData layer that are not identical.");
                            ESSLayerException eSSLayerException = new ESSLayerException(4, "There are MLExpansionHistory attributes in the SignedData layer that are not identical.", (ESSLayer)signedESSLayer2);
                            signedESSLayer.a(eSSLayerException);
                            throw eSSLayerException;
                        }
                        if (signerInfoArray.length > 0) {
                            this.a("Detected MLExpansionHistory attriute.");
                            try {
                                eSSAttributeValue = (MLExpansionHistory)signerInfoArray[0].getSignedAttributeValue(MLExpansionHistory.oid);
                            }
                            catch (CMSException cMSException) {
                                this.a("Error getting MLExpansionHistory attribute: " + cMSException.toString());
                            }
                            signedESSLayer2.a(signerInfoArray, (MLExpansionHistory)eSSAttributeValue);
                            signedESSLayer2.setIsOuterLayer(true);
                            this.b = this.a;
                            if (this.Fv != null) {
                                this.a("Check for mail list expansion loop...");
                                object5 = ((MLExpansionHistory)eSSAttributeValue).getMLDataList();
                                int n4 = 0;
                                while (n4 < ((MLData[])object5).length) {
                                    if (object5[n4].getMailListIdentifier().equals(this.Fv)) {
                                        this.a("Error: Detected mail list expandion loop for " + this.Fv);
                                        ESSLayerException eSSLayerException = new ESSLayerException(5, new MLExpansionLoopException(this.Fv), (ESSLayer)signedESSLayer2);
                                        signedESSLayer.a(eSSLayerException);
                                        throw eSSLayerException;
                                    }
                                    ++n4;
                                }
                            }
                        } else {
                            this.a("No MLExpansionHistory found.");
                        }
                    }
                    if (this.b == -1 && !signedESSLayer2.isOuterLayer() && object4 instanceof EncryptedContent) {
                        signedESSLayer2.setIsOuterLayer(true);
                    }
                    this.a("Search for ReceiptRequest attribute");
                    eSSAttributeValue = null;
                    try {
                        signerInfoArray = ESSUtil.getSignerInfosWithAttribute((SignedContent)object, ReceiptRequest.oid, true);
                    }
                    catch (CodingException codingException) {
                        this.a("Error parsing ReceiptRequest attribute: " + codingException.toString());
                        ESSLayerException eSSLayerException = new ESSLayerException(3, "Error parsing ReceiptRequest attribute: " + codingException.toString(), (Exception)((Object)codingException), signedESSLayer2);
                        signedESSLayer.a(eSSLayerException);
                        throw eSSLayerException;
                    }
                    catch (ESSException eSSException) {
                        this.a("Error: There are ReceiptRequest attributes in the SignedData layer that are not identical.");
                        object5 = new ESSLayerException(4, "There are ReceiptRequest attributes in the SignedData layer that are not identical.", (ESSLayer)signedESSLayer2);
                        signedESSLayer.a((ESSLayerException)object5);
                        throw object5;
                    }
                    if (signerInfoArray.length > 0) {
                        this.a("Detected ReceiptRequest attribute.");
                        try {
                            eSSAttributeValue = (ReceiptRequest)signerInfoArray[0].getSignedAttributeValue(ReceiptRequest.oid);
                        }
                        catch (CMSException cMSException) {
                            this.a("Error getting ReceiptRequest attribute: " + cMSException.toString());
                        }
                        signedESSLayer2.a(signerInfoArray, (ReceiptRequest)eSSAttributeValue);
                        this.c = this.a;
                        if (signedESSLayer2.isOuterLayer()) {
                            this.a("Error: ReceiptRequest attribute not allowed in outer signed layer.");
                            object5 = new ESSLayerException(7, "ReceiptRequest attribute not allowed in outer signed layer", (ESSLayer)signedESSLayer2);
                            signedESSLayer.a((ESSLayerException)object5);
                            throw object5;
                        }
                    } else {
                        this.a("No ReceiptRequest attribute found.");
                    }
                }
                this.c(dataHandler);
            } else {
                this.a("Layer is neither signed nor encrypted.");
                ESSLayer eSSLayer = new ESSLayer(object2);
                eSSLayer.setDataHandler(dataHandler);
                this.Ej.addElement(eSSLayer);
                if (object2 instanceof Message) {
                    this.a("Content is a Nested Message");
                    this.c(dataHandler);
                }
            }
        }
    }

    public ESSLayer[] getAllLayers() {
        Object[] objectArray = new ESSLayer[this.Ej.size()];
        this.Ej.copyInto(objectArray);
        return objectArray;
    }

    String a() {
        return this.m;
    }

    public int getIndexOfEnvelopedLayer() {
        return this.d;
    }

    public int getIndexOfInnerSignedLayer() {
        return this.c;
    }

    public int getIndexOfOuterSignedLayer() {
        return this.b;
    }

    public ESSLayer getInnermostLayer() {
        return (ESSLayer)this.Ej.lastElement();
    }

    public ESSLayer getLayerAtIndex(int n2) {
        return (ESSLayer)this.Ej.elementAt(n2);
    }

    public int getNumberOfLayers() {
        if (this.a == -1) {
            return 0;
        }
        return this.a;
    }

    private int a(int n2) {
        int n3 = 0;
        ESSLayer[] eSSLayerArray = this.getAllLayers();
        int n4 = 0;
        while (n4 < eSSLayerArray.length) {
            if (eSSLayerArray[n4].getType() == n2) {
                ++n3;
            }
            ++n4;
        }
        return n3;
    }

    public ESSLayer getOutermostLayer() {
        return (ESSLayer)this.Ej.firstElement();
    }

    private void b() {
        this.a = -1;
        this.b = -1;
        this.c = -1;
        this.d = -1;
        this.Ej = new Vector();
    }

    void a(Part part) {
        this.b();
        this.a("Searching layers.");
        try {
            DataHandler dataHandler = part.getDataHandler();
            SMimeParameters.setDataHandlerCommandMap(dataHandler);
            this.c(dataHandler);
        }
        catch (MessagingException messagingException) {
            this.a("Error parsing part content: " + messagingException.toString());
            ESSLayer eSSLayer = new ESSLayer(part);
            ESSLayerException eSSLayerException = new ESSLayerException(0, (Exception)((Object)messagingException), eSSLayer);
            eSSLayer.a(eSSLayerException);
            this.Ej.addElement(eSSLayer);
            throw eSSLayerException;
        }
        int n2 = this.Ej.size();
        Object[] objectArray = new ESSLayer[n2];
        this.Ej.copyInto(objectArray);
        this.a("Finished. Detected " + n2 + " layers.");
    }

    void a(CertificateDatabase certificateDatabase) {
        this.Fu = certificateDatabase;
    }

    void a(String string, String string2, PrintWriter printWriter) {
        this.m = string2;
        if (string == null) {
            this.l = string2;
        } else if (string2 != null) {
            this.l = String.valueOf(string) + "(" + string2 + ")";
        }
        this.Fw = printWriter;
    }

    void a(KeyDatabase keyDatabase) {
        this.Ft = keyDatabase;
    }

    void a(boolean bl) {
        this.j = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.Fv != null) {
            stringBuffer.append("Owner: " + this.Fv + "\n");
        }
        int n2 = this.getNumberOfLayers();
        stringBuffer.append("Contains " + n2 + " layer");
        if (n2 != 1) {
            stringBuffer.append("s");
        }
        int n3 = this.a(0);
        int n4 = this.a(1);
        stringBuffer.append("( " + n3 + " signed, " + n4 + " encrypted)");
        return stringBuffer.toString();
    }

    private SignerInfoVerificationResult[] a(SignedContent signedContent, boolean bl) {
        SignerInfoVerificationResult[] signerInfoVerificationResultArray = new SignerInfoVerificationResult[]{};
        SignerInfo[] signerInfoArray = signedContent.getSignerInfos();
        int n2 = signerInfoArray.length;
        if (n2 == 0) {
            this.a("No SignerInfos included.");
        } else {
            signerInfoVerificationResultArray = new SignerInfoVerificationResult[n2];
            int n3 = 0;
            while (n3 < signerInfoArray.length) {
                SignerInfoVerificationResult signerInfoVerificationResult;
                block12: {
                    X509Certificate x509Certificate;
                    CertificateIdentifier certificateIdentifier;
                    block11: {
                        certificateIdentifier = signerInfoArray[n3].getSignerIdentifier();
                        this.a("Verifying signature of signer:\n" + certificateIdentifier, true);
                        signerInfoVerificationResult = new SignerInfoVerificationResult(certificateIdentifier);
                        x509Certificate = null;
                        try {
                            x509Certificate = signedContent.getCertificate(certificateIdentifier);
                        }
                        catch (CMSException cMSException) {
                            if (this.Fu == null) break block11;
                            this.a("Certificate not included in SignedData object; trying to fetch it from certificate database");
                            try {
                                x509Certificate = this.Fu.getCertificate(certificateIdentifier);
                            }
                            catch (CertificateDatabaseException certificateDatabaseException) {
                                this.a("Problem to fetch certificate from database: " + certificateDatabaseException.getMessage());
                            }
                        }
                    }
                    if (x509Certificate == null) {
                        this.a("Cannot verify signature. Certificate not available for signer\n:" + certificateIdentifier);
                        signerInfoVerificationResult.a(new CertificateNotFoundException("Certificate not available!", certificateIdentifier));
                    }
                    try {
                        signedContent.verify(x509Certificate);
                        this.a("Signature successfully verified.");
                        signerInfoVerificationResult.a(1);
                    }
                    catch (CMSSignatureException cMSSignatureException) {
                        this.a("Signature verification failed: " + cMSSignatureException.toString());
                        signerInfoVerificationResult.a(cMSSignatureException);
                        Exception exception = cMSSignatureException.getWrappedException();
                        if (!(exception instanceof NoSuchAlgorithmException) && !(exception instanceof CodingException)) {
                            signerInfoVerificationResult.a(2);
                        }
                        if (!bl) break block12;
                        throw cMSSignatureException;
                    }
                }
                signerInfoVerificationResultArray[n3] = signerInfoVerificationResult;
                ++n3;
            }
        }
        return signerInfoVerificationResultArray;
    }
}

