/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess.utils;

import iaik.smime.ess.ESSException;
import iaik.smime.ess.utils.ESSLayer;

public class ESSLayerException
extends ESSException {
    public static final int CONTENT_PARSING_PROBLEM = 0;
    public static final int NO_DECRYPTION_KEY = 1;
    public static final int CEK_DECRYPTION_ERROR = 2;
    public static final int ATTRIBUTE_PARSING_ERROR = 3;
    public static final int ATTRIBUTE_MISMATCH = 4;
    public static final int MAIL_LIST_EXPANSION_LOOP = 5;
    public static final int SECURITY_LABEL = 6;
    public static final int RECEIPT_REQUEST_IN_OUTER_LAYER = 7;
    public static final int SIGNATURE_VERIFICATION_ERROR = 8;
    private int a;
    private Exception Fr;
    private ESSLayer Fs;

    public ESSLayerException(int n2, ESSLayer eSSLayer) {
        super(ESSLayerException.getReasonMsg(n2));
        this.a = n2;
        this.Fs = eSSLayer;
    }

    public ESSLayerException(int n2, Exception exception, ESSLayer eSSLayer) {
        super(String.valueOf(ESSLayerException.getReasonMsg(n2)) + " " + exception.getMessage());
        this.a = n2;
        this.Fr = exception;
        this.Fs = eSSLayer;
    }

    public ESSLayerException(int n2, String string, ESSLayer eSSLayer) {
        super(String.valueOf(ESSLayerException.getReasonMsg(n2)) + " " + string);
        this.a = n2;
        this.Fs = eSSLayer;
    }

    public ESSLayerException(int n2, String string, Exception exception, ESSLayer eSSLayer) {
        super(string);
        this.a = n2;
        this.Fr = exception;
        this.Fs = eSSLayer;
    }

    public ESSLayer getLayer() {
        return this.Fs;
    }

    public int getReason() {
        return this.a;
    }

    public static String getReasonMsg(int n2) {
        String string = "";
        switch (n2) {
            case 0: {
                string = "Error parsing content.";
                break;
            }
            case 1: {
                string = "No decryption key.";
                break;
            }
            case 2: {
                string = "Error decrypting content encryption key.";
                break;
            }
            case 3: {
                string = "Error parsing attribute.";
                break;
            }
            case 5: {
                string = "Mail list expansion loop deteceted!";
                break;
            }
            case 4: {
                string = "Attributes not identical as required.";
                break;
            }
            case 6: {
                string = "Access denied by SecurityLabel attribute.";
                break;
            }
            case 7: {
                string = "ReceipRequest attribute not allowed in outer layer.";
                break;
            }
            case 8: {
                string = "Signature verification error.";
                break;
            }
        }
        return string;
    }

    public Exception getWrappedException() {
        return this.Fr;
    }
}

