/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.PolicyInformation;
import iaik.cms.CertificateSet;
import iaik.cms.DebugCMS;
import iaik.cms.SecurityProvider;
import iaik.smime.ess.ESSAttributeValue;
import iaik.smime.ess.ESSCertID;
import iaik.utils.CryptoUtils;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.attr.AttributeCertificate;
import iaik.x509.extensions.CertificatePolicies;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Vector;

public class SigningCertificate
extends ESSAttributeValue {
    private static boolean c = false;
    public static final ObjectID oid;
    private ESSCertID[] Fk;
    private PolicyInformation[] Fm;
    private SecurityProvider Fn;
    ASN1Object Fp;
    static Class sl;

    static {
        c = DebugCMS.getDebugMode() && c;
        Attribute.register((ObjectID)ObjectID.signingCertificate, (Class)(sl != null ? sl : (sl = SigningCertificate.class$("iaik.smime.ess.SigningCertificate"))));
        oid = ObjectID.signingCertificate;
    }

    public SigningCertificate() {
    }

    public SigningCertificate(ASN1Object aSN1Object) {
        this();
        this.decode(aSN1Object);
    }

    public SigningCertificate(CertificateSet certificateSet, boolean bl) {
        this(certificateSet.getCertificates(), bl);
    }

    public SigningCertificate(ESSCertID[] eSSCertIDArray) {
        this();
        this.a(eSSCertIDArray);
        this.Fk = eSSCertIDArray;
    }

    public SigningCertificate(Certificate[] certificateArray) {
        this(certificateArray, true, null);
    }

    SigningCertificate(Certificate[] certificateArray, AlgorithmID algorithmID, boolean bl, SecurityProvider securityProvider) {
        this();
        if (certificateArray == null) {
            throw new NullPointerException("Cannot create SigningCertificate from null certificates!");
        }
        if (!(certificateArray[0] instanceof X509Certificate)) {
            throw new CertificateException("Cannot create SigningCertificate attribute. First cert has to be an X.509 public key certificate!");
        }
        this.Fn = securityProvider;
        Vector<ESSCertID> vector = new Vector<ESSCertID>();
        vector.addElement(this.a((Certificate)((X509Certificate)certificateArray[0]), algorithmID, bl, this.Fn));
        if (certificateArray.length > 1) {
            int n2 = 1;
            while (n2 < certificateArray.length) {
                vector.addElement(this.a(certificateArray[n2], algorithmID, bl, this.Fn));
                ++n2;
            }
        }
        this.Fk = new ESSCertID[vector.size()];
        vector.copyInto(this.Fk);
    }

    public SigningCertificate(Certificate[] certificateArray, boolean bl) {
        this(certificateArray, bl, null);
    }

    public SigningCertificate(Certificate[] certificateArray, boolean bl, SecurityProvider securityProvider) {
        this(certificateArray, null, bl, securityProvider);
    }

    void a(ESSCertID[] eSSCertIDArray) {
        if (eSSCertIDArray != null) {
            int n2 = 0;
            while (n2 < eSSCertIDArray.length) {
                if (eSSCertIDArray[n2].a() != 1) {
                    throw new IllegalArgumentException("Only V1 ESSCertIDs allowed for SigningCertificate attribute");
                }
                ++n2;
            }
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    void a() {
        this.Fp = null;
    }

    public int countPolicies() {
        return this.Fm == null ? 0 : this.Fm.length;
    }

    ESSCertID a(Certificate certificate, AlgorithmID algorithmID, boolean bl, SecurityProvider securityProvider) {
        ESSCertID eSSCertID;
        if (certificate instanceof X509Certificate) {
            eSSCertID = new ESSCertID((Certificate)((X509Certificate)certificate), bl, securityProvider);
        } else if (certificate instanceof AttributeCertificate) {
            eSSCertID = new ESSCertID((Certificate)((AttributeCertificate)certificate), bl, securityProvider);
        } else {
            throw new IllegalArgumentException("Cannot create CertID. Certificate has to be X509Certificte or AttributeCertificate!");
        }
        return eSSCertID;
    }

    public void decode(ASN1Object aSN1Object) {
        ASN1Object aSN1Object2 = aSN1Object.getComponentAt(0);
        int n2 = aSN1Object2.countComponents();
        this.Fk = new ESSCertID[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.Fk[n3] = this.g(aSN1Object2.getComponentAt(n3));
            ++n3;
        }
        if (aSN1Object.countComponents() == 2) {
            ASN1Object aSN1Object3 = aSN1Object.getComponentAt(1);
            n2 = aSN1Object3.countComponents();
            this.Fm = new PolicyInformation[n2];
            int n4 = 0;
            while (n4 < n2) {
                this.Fm[n4] = new PolicyInformation(aSN1Object3.getComponentAt(n4));
                ++n4;
            }
        }
        this.Fp = aSN1Object;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SigningCertificate)) {
            return false;
        }
        return CryptoUtils.equalsBlock((byte[])DerCoder.encode((ASN1Object)this.toASN1Object()), (byte[])DerCoder.encode((ASN1Object)((SigningCertificate)((Object)object)).toASN1Object()));
    }

    public ObjectID getAttributeType() {
        return oid;
    }

    public Certificate[] getAuthorizedCertificates(Certificate[] certificateArray) {
        return this.a(certificateArray, true);
    }

    private Certificate[] a(Certificate[] certificateArray, boolean bl) {
        if (this.Fk == null || this.Fk.length <= 1) {
            return certificateArray;
        }
        Vector<Certificate> vector = new Vector<Certificate>();
        int n2 = 0;
        while (n2 < certificateArray.length) {
            if (this.a(certificateArray[n2], bl) != null) {
                vector.addElement(certificateArray[n2]);
            }
            ++n2;
        }
        if (vector.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Certificate[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public ESSCertID getESSCertID(Certificate certificate) {
        if (certificate == null) {
            throw new NullPointerException("Certificate must not be null!");
        }
        return this.a(certificate, false);
    }

    private ESSCertID a(Certificate certificate, boolean bl) {
        try {
            if (this.Fk != null) {
                int n2;
                int n3 = n2 = bl ? 1 : 0;
                while (n3 < this.Fk.length) {
                    ESSCertID eSSCertID = this.Fk[n3];
                    if (eSSCertID.identifiesCert(certificate)) {
                        return eSSCertID;
                    }
                    ++n3;
                }
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        return null;
    }

    public ESSCertID[] getESSCertIDs() {
        return this.Fk;
    }

    public PolicyInformation[] getPolicies() {
        return this.Fm;
    }

    public Certificate[] getPolicyInformationCerts(Certificate[] certificateArray) {
        if (this.Fm == null || certificateArray == null) {
            return certificateArray;
        }
        Certificate[] certificateArray2 = this.a(certificateArray, false);
        if (certificateArray2 == null) {
            return null;
        }
        Vector<Certificate> vector = new Vector<Certificate>();
        int n2 = 0;
        while (n2 < certificateArray2.length) {
            if (this.getPolicyInformations(certificateArray2[n2]) != null) {
                vector.addElement(certificateArray2[n2]);
            }
            ++n2;
        }
        if (vector.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Certificate[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public PolicyInformation[] getPolicyInformations(Certificate certificate) {
        Object[] objectArray;
        CertificatePolicies certificatePolicies;
        Vector<Object> vector;
        block11: {
            vector = new Vector<Object>();
            certificatePolicies = null;
            try {
                if (certificate instanceof X509Certificate) {
                    certificatePolicies = (CertificatePolicies)((X509Certificate)certificate).getExtension(CertificatePolicies.oid);
                    break block11;
                }
                if (certificate instanceof AttributeCertificate) {
                    certificatePolicies = (CertificatePolicies)((AttributeCertificate)certificate).getExtension(CertificatePolicies.oid);
                    break block11;
                }
                throw new IllegalArgumentException("Only iaik.x509.X509Certificate and iaik.x509.attr.AttributeCertificate objects are allowed!");
            }
            catch (X509ExtensionInitException x509ExtensionInitException) {
                return null;
            }
        }
        if (certificatePolicies != null) {
            objectArray = certificatePolicies.getPolicyInformation();
            if (this.Fm == null) {
                return objectArray;
            }
            if (objectArray != null) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    int n3 = 0;
                    while (n3 < this.Fm.length) {
                        if (objectArray[n2].getPolicyIdentifier().equals((Object)this.Fm[n3].getPolicyIdentifier())) {
                            vector.addElement(objectArray[n2]);
                        }
                        ++n3;
                    }
                    ++n2;
                }
            }
        }
        if (vector.isEmpty()) {
            return null;
        }
        objectArray = new PolicyInformation[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public SecurityProvider getSecurityProvider() {
        return this.Fn;
    }

    public int hashCode() {
        if (this.Fk != null && this.Fk.length > 0) {
            return this.Fk[0].hashCode();
        }
        return super.hashCode();
    }

    public boolean isSignerCertificate(X509Certificate x509Certificate) {
        if (this.Fk != null && this.Fk.length > 0) {
            return this.Fk[0].identifiesCert((Certificate)x509Certificate);
        }
        return true;
    }

    ESSCertID g(ASN1Object aSN1Object) {
        return new ESSCertID(aSN1Object);
    }

    public void setPolicies(PolicyInformation[] policyInformationArray) {
        this.Fm = policyInformationArray;
        this.a();
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.Fn = securityProvider;
        if (this.Fk != null && securityProvider != null) {
            int n2 = 0;
            while (n2 < this.Fk.length) {
                this.Fk[n2].setSecurityProvider(this.Fn);
                ++n2;
            }
        }
    }

    public ASN1Object toASN1Object() {
        if (this.Fp != null) {
            return this.Fp;
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        SEQUENCE sEQUENCE2 = new SEQUENCE();
        if (this.Fk != null) {
            int n2 = 0;
            while (n2 < this.Fk.length) {
                sEQUENCE2.addComponent(this.Fk[n2].toASN1Object());
                ++n2;
            }
        }
        sEQUENCE.addComponent((ASN1Object)sEQUENCE2);
        if (this.Fm != null) {
            SEQUENCE sEQUENCE3 = new SEQUENCE();
            int n3 = 0;
            while (n3 < this.Fm.length) {
                sEQUENCE3.addComponent(this.Fm[n3].toASN1Object());
                ++n3;
            }
            sEQUENCE.addComponent((ASN1Object)sEQUENCE3);
        }
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Signing Certificate:\n");
        int n2 = 0;
        while (n2 < this.Fk.length) {
            stringBuffer.append("certID[" + n2 + "]: \n" + this.Fk[n2]);
            ++n2;
        }
        if (this.Fm != null) {
            int n3 = 0;
            while (n3 < this.Fm.length) {
                stringBuffer.append("policy[" + n3 + "]: \n" + this.Fm[n3] + "\n");
                ++n3;
            }
        }
        return stringBuffer.toString();
    }
}

