/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.smime.ess.utils.ESSUtil;
import iaik.utils.CryptoUtils;
import iaik.utils.InternalErrorException;
import java.math.BigInteger;

public class ReceiptsFrom {
    public static final int ALL_RECIPIENTS = 0;
    public static final int FIRST_TIER_RECIPIENTS = 1;
    private int b = -1;
    private GeneralNames[] Fb;
    static Class a;

    ReceiptsFrom() {
    }

    public ReceiptsFrom(int n2) {
        this();
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("Cannot create ReceiptsFrom. Illegal AllOrFirstTier value: " + n2);
        }
        this.b = n2;
    }

    public ReceiptsFrom(ASN1Object aSN1Object) {
        this();
        this.decode(aSN1Object);
    }

    public ReceiptsFrom(GeneralNames[] generalNamesArray) {
        this();
        if (generalNamesArray == null) {
            throw new IllegalArgumentException("Cannot create ReceiptsFrom. Missing receiptList.");
        }
        this.Fb = generalNamesArray;
    }

    public ReceiptsFrom(String[] stringArray) {
        this();
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Cannot create ReceiptsFrom. Missing receiptList.");
        }
        this.Fb = new GeneralNames[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].indexOf("@") == -1) {
                throw new IllegalArgumentException("Invalid rfc822 email address: " + stringArray[n2]);
            }
            this.Fb[n2] = new GeneralNames(new GeneralName(1, (Object)stringArray[n2]));
            ++n2;
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void decode(ASN1Object aSN1Object) {
        if (!aSN1Object.isA(ASN.CON_SPEC)) {
            throw new CodingException("Invalid ASN.1 type. Expected CON SPEC!");
        }
        CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object;
        int n2 = aSN1Object.getAsnType().getTag();
        if (n2 == 0) {
            cON_SPEC.forceImplicitlyTagged(ASN.INTEGER);
            INTEGER iNTEGER = (INTEGER)aSN1Object.getValue();
            this.b = ((BigInteger)iNTEGER.getValue()).intValue();
            if (this.b != 0 && this.b != 1) {
                throw new CodingException("Illegal AllOrFirstTier value: " + this.b);
            }
        } else if (n2 == 1) {
            cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
            ASN1Object aSN1Object2 = (ASN1Object)aSN1Object.getValue();
            this.Fb = (GeneralNames[])ASN.parseSequenceOf((ASN1Object)aSN1Object2, (Class)(a != null ? a : (a = ReceiptsFrom.class$("iaik.asn1.structures.GeneralNames"))));
        } else {
            throw new CodingException("Invalid tag for ReceiptsFrom encoding: " + n2);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ReceiptsFrom)) {
            return false;
        }
        ReceiptsFrom receiptsFrom = (ReceiptsFrom)object;
        if (this.b != -1) {
            return this.b == receiptsFrom.b;
        }
        if (this.Fb != null && receiptsFrom.Fb != null) {
            try {
                return CryptoUtils.equalsBlock((byte[])DerCoder.encode((ASN1Object)ASN.createSequenceOf((ASN1Type[])this.Fb)), (byte[])DerCoder.encode((ASN1Object)ASN.createSequenceOf((ASN1Type[])receiptsFrom.Fb)));
            }
            catch (CodingException codingException) {
                return false;
            }
        }
        return this.Fb == null && receiptsFrom.Fb == null;
    }

    public int getAllOrFirstTier() {
        return this.b;
    }

    public GeneralNames[] getReceiptList() {
        return this.Fb;
    }

    public String[] getRecipientAddresses() {
        if (this.Fb == null || this.Fb.length == 0) {
            return null;
        }
        return ESSUtil.getMailAddresses(this.Fb);
    }

    public int hashCode() {
        return this.b;
    }

    public ASN1Object toASN1Object() {
        if (this.b != -1) {
            return new CON_SPEC(0, (ASN1Object)new INTEGER(this.b), true);
        }
        try {
            return new CON_SPEC(1, ASN.createSequenceOf((ASN1Type[])this.Fb), true);
        }
        catch (CodingException codingException) {
            throw new InternalErrorException("Error building ASN.1 receiptList: " + codingException.toString(), (Exception)((Object)codingException));
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.b != -1) {
            stringBuffer.append("allOrFirstTier: " + this.b + (this.b == 0 ? " (all receipts)" : " (first tier recipients)"));
        } else if (this.Fb != null && this.Fb.length > 0) {
            int n2 = this.Fb.length;
            stringBuffer.append("Request receipts from " + n2 + (n2 == 1 ? " recipient" : " recipients"));
            if (bl) {
                stringBuffer.append(":");
                int n3 = 0;
                while (n3 < n2) {
                    stringBuffer.append("\nRecipient No " + (n3 + 1) + ": " + this.Fb[n3]);
                    ++n3;
                }
            }
        } else {
            stringBuffer.append("Empty receiptList");
        }
        return stringBuffer.toString();
    }
}

