/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.cms.DebugCMS;
import iaik.smime.ess.ContentIdentifier;
import iaik.smime.ess.ESSAttributeValue;
import iaik.smime.ess.ReceiptsFrom;
import iaik.smime.ess.utils.ESSUtil;
import iaik.utils.CryptoUtils;

public class ReceiptRequest
extends ESSAttributeValue {
    private static boolean c = false;
    public static final ObjectID oid;
    public static final int UP_RECEIPTS_TO = 16;
    private ContentIdentifier EJ;
    private ReceiptsFrom Fi;
    private GeneralNames[] Fj;
    static Class a;
    static Class sl;

    static {
        c = DebugCMS.getDebugMode() && c;
        Attribute.register((ObjectID)ObjectID.receiptRequest, (Class)(a != null ? a : (a = ReceiptRequest.class$("iaik.smime.ess.ReceiptRequest"))));
        oid = ObjectID.receiptRequest;
    }

    public ReceiptRequest() {
    }

    public ReceiptRequest(ASN1Object aSN1Object) {
        this();
        this.decode(aSN1Object);
    }

    public ReceiptRequest(ContentIdentifier contentIdentifier, ReceiptsFrom receiptsFrom, GeneralNames[] generalNamesArray) {
        this();
        if (contentIdentifier == null) {
            throw new IllegalArgumentException("Cannot create ReceiptRequest. Missing signed content identifier!");
        }
        if (receiptsFrom == null) {
            throw new IllegalArgumentException("Cannot create ReceiptRequest. Missing reciptsFrom!");
        }
        if (generalNamesArray == null || generalNamesArray.length == 0) {
            throw new IllegalArgumentException("Cannot create ReceiptRequest. Empty reciptsTo list!");
        }
        if (generalNamesArray.length > 16) {
            throw new IllegalArgumentException("Cannot create ReceiptRequest. Too many entries in reciptsTo list!");
        }
        this.EJ = contentIdentifier;
        this.Fi = receiptsFrom;
        this.Fj = generalNamesArray;
    }

    public ReceiptRequest(ContentIdentifier contentIdentifier, ReceiptsFrom receiptsFrom, String[] stringArray) {
        this();
        if (contentIdentifier == null) {
            throw new IllegalArgumentException("Cannot create ReceiptRequest. Missing signed content identifier!");
        }
        if (receiptsFrom == null) {
            throw new IllegalArgumentException("Cannot create ReceiptRequest. Missing reciptsFrom!");
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Cannot create ReceiptRequest. Empty reciptsTo list!");
        }
        if (stringArray.length > 16) {
            throw new IllegalArgumentException("Cannot create ReceiptRequest. Too many entries in reciptsTo list!");
        }
        this.EJ = contentIdentifier;
        this.Fi = receiptsFrom;
        this.Fj = new GeneralNames[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].indexOf("@") == -1) {
                throw new IllegalArgumentException("Invalid rfc822 email address: " + stringArray[n2]);
            }
            this.Fj[n2] = new GeneralNames(new GeneralName(1, (Object)ESSUtil.parseAddress(stringArray[n2])));
            ++n2;
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void decode(ASN1Object aSN1Object) {
        ASN aSN = aSN1Object.getAsnType();
        if (!aSN.equals((Object)ASN.SEQUENCE)) {
            throw new CodingException("Invalid ReceiptRequest encoding: " + aSN + ". Expected SEQUENCE!");
        }
        if (aSN1Object.countComponents() != 3) {
            throw new CodingException("Invalid ReceiptRequest encoding. Invalid number of components: " + aSN1Object.countComponents());
        }
        this.EJ = new ContentIdentifier(aSN1Object.getComponentAt(0));
        if (this.EJ == null) {
            throw new CodingException("Missing signed content identifier!");
        }
        this.Fi = new ReceiptsFrom(aSN1Object.getComponentAt(1));
        if (this.Fi == null) {
            throw new CodingException("Missing receiptsFrom!");
        }
        this.Fj = (GeneralNames[])ASN.parseSequenceOf((ASN1Object)aSN1Object.getComponentAt(2), (Class)(sl != null ? sl : (sl = ReceiptRequest.class$("iaik.asn1.structures.GeneralNames"))));
        if (this.Fj == null || this.Fj.length == 0) {
            throw new CodingException("Empty reciptsTo list!");
        }
        if (this.Fj.length > 16) {
            throw new CodingException("Too many entries in reciptsTo list!");
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ReceiptRequest)) {
            return false;
        }
        ReceiptRequest receiptRequest = (ReceiptRequest)((Object)object);
        try {
            return CryptoUtils.equalsBlock((byte[])DerCoder.encode((ASN1Object)this.toASN1Object()), (byte[])DerCoder.encode((ASN1Object)receiptRequest.toASN1Object()));
        }
        catch (CodingException codingException) {
            return false;
        }
    }

    public ObjectID getAttributeType() {
        return oid;
    }

    public ReceiptsFrom getReceiptsFrom() {
        return this.Fi;
    }

    public GeneralNames[] getReceiptsTo() {
        return this.Fj;
    }

    public String[] getReceiptsToAddresses() {
        return ESSUtil.getMailAddresses(this.Fj);
    }

    public ContentIdentifier getSignedContentIdentifier() {
        return this.EJ;
    }

    public int hashCode() {
        return this.EJ.hashCode();
    }

    public ASN1Object toASN1Object() {
        if (this.EJ == null) {
            throw new CodingException("Missing signed content identifier!");
        }
        if (this.Fi == null) {
            throw new CodingException("Missing receiptsFrom!");
        }
        if (this.Fj == null || this.Fj.length == 0) {
            throw new CodingException("Empty reciptsTo list!");
        }
        if (this.Fj.length > 16) {
            throw new CodingException("Too many entries in reciptsTo list!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.EJ.toASN1Object());
        sEQUENCE.addComponent(this.Fi.toASN1Object());
        sEQUENCE.addComponent(ASN.createSequenceOf((ASN1Type[])this.Fj));
        return sEQUENCE;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("signedContentIdentifier: " + (Object)((Object)this.EJ) + "\n");
        stringBuffer.append(String.valueOf(this.Fi.toString(bl)) + "\n");
        if (this.Fj != null && this.Fj.length > 0) {
            int n2 = this.Fj.length;
            stringBuffer.append("Receipts should be sent to " + n2 + (n2 == 1 ? " user" : " users"));
            if (bl) {
                stringBuffer.append(":");
                int n3 = 0;
                while (n3 < n2) {
                    stringBuffer.append("\nUser No " + (n3 + 1) + ": " + this.Fj[n3]);
                    ++n3;
                }
            }
        } else {
            stringBuffer.append("Empty receiptsTo list");
        }
        return stringBuffer.toString();
    }
}

