/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.asn1.structures.Attributes;
import iaik.cms.CMSException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.ContentInfo;
import iaik.cms.DebugCMS;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.SecurityProvider;
import iaik.cms.SignedData;
import iaik.cms.SignerInfo;
import iaik.cms.Utils;
import iaik.smime.CryptoContent;
import iaik.smime.SMimeParameters;
import iaik.smime.SMimeUtil;
import iaik.smime.ess.ESSException;
import iaik.smime.ess.MsgSigDigest;
import iaik.smime.ess.Receipt;
import iaik.utils.InternalErrorException;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;

public class ReceiptContent
implements CryptoContent {
    private static boolean a = false;
    private DataSource Fc;
    private SignedData Fd;
    private boolean d;
    private ContentType Fe;
    private MsgSigDigest Fg;
    private Receipt Fh;
    private SecurityProvider tY;

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    ReceiptContent() {
        this.d = true;
        this.Fe = new ContentType("application", SMimeParameters.getNewContentTypes() ? "pkcs7-mime" : "x-pkcs7-mime", null);
        this.Fe.setParameter("smime-type", "signed-receipt");
    }

    public ReceiptContent(SignerInfo signerInfo) {
        this(signerInfo, null);
    }

    public ReceiptContent(SignerInfo signerInfo, SecurityProvider securityProvider) {
        this();
        this.tY = securityProvider;
        this.Fh = new Receipt(signerInfo);
        byte[] byArray = DerCoder.encode((ASN1Object)this.Fh.toASN1Object());
        this.Fd = new SignedData(byArray, Receipt.oid, 1);
        try {
            Attribute[] attributeArray;
            SecurityProvider securityProvider2 = this.tY;
            if (securityProvider2 == null) {
                securityProvider2 = SecurityProvider.getSecurityProvider();
            }
            if ((attributeArray = signerInfo.getSignedAttributes()) == null || attributeArray.length == 0) {
                throw new ESSException("Cannot create signed receipt. Missing signed attributes in original SignerInfo!");
            }
            byte[] byArray2 = DerCoder.encode((ASN1Object)ASN.createSetOf((ASN1Type[])attributeArray));
            byte[] byArray3 = securityProvider2.getHash(signerInfo.getDigestAlgorithm(), byArray2);
            this.Fg = new MsgSigDigest(byArray3);
        }
        catch (Exception exception) {
            throw new ESSException("Error processing receipt: " + exception.toString());
        }
    }

    public ReceiptContent(Receipt receipt) {
        this.d = true;
        this.Fh = receipt;
        byte[] byArray = DerCoder.encode((ASN1Object)this.Fh.toASN1Object());
        this.Fd = new SignedData(byArray, Receipt.oid, 1);
    }

    public ReceiptContent(DataSource dataSource) {
        block6: {
            this();
            try {
                this.Fc = dataSource;
                this.Fe = new ContentType(dataSource.getContentType());
                String string = this.Fe.getParameter("smime-type");
                if (string == null || !string.equalsIgnoreCase("signed-receipt")) {
                    throw new IOException("Invalid smime type for signed receipt: " + string);
                }
                if (this.Fe.match("application/x-pkcs7-mime") || this.Fe.match("application/pkcs7-mime")) {
                    this.Fd = new SignedData(dataSource.getInputStream());
                    InputStream inputStream = this.Fd.getInputStream();
                    this.Fh = new Receipt(inputStream);
                    while (inputStream.read() != -1) {
                    }
                    break block6;
                }
                throw new IOException("Unknown mime type: " + this.Fe.toString());
            }
            catch (MessagingException messagingException) {
                throw new IOException("Error reading message content: " + messagingException.getMessage());
            }
            catch (CMSException cMSException) {
                throw new IOException("Error parsing content: " + cMSException.getMessage());
            }
        }
    }

    public X509CRL[] getCRLs() {
        return this.Fd == null ? new X509CRL[]{} : this.Fd.getCRLs();
    }

    public Certificate[] getCertificates() {
        return this.Fd == null ? new Certificate[]{} : this.Fd.getCertificates();
    }

    public Object getContent() {
        return this.Fh;
    }

    public String getContentType() {
        return this.Fe.toString();
    }

    public Receipt getReceipt() {
        return this.Fh;
    }

    public String getSMimeType() {
        return "signed-receipt";
    }

    public SignerInfo[] getSignerInfos() {
        return this.Fd.getSignerInfos();
    }

    private Attribute[] a(X509Certificate x509Certificate, boolean bl) {
        if (this.Fg == null) {
            throw new ESSException("Cannot create attributes for signed receipt. MsgSigDigest attribute required!");
        }
        try {
            Attributes attributes = SMimeUtil.makeStandardAttributes(x509Certificate == null ? null : new IssuerAndSerialNumber(x509Certificate), bl, ObjectID.receipt);
            attributes.addAttribute(new Attribute((AttributeValue)this.Fg));
            return attributes.toArray();
        }
        catch (Exception exception) {
            throw new ESSException("Error adding attributes: " + exception.getMessage());
        }
    }

    public void setCRLs(X509CRL[] x509CRLArray) {
        this.Fd.setCRLs(x509CRLArray);
        this.Fc = null;
    }

    public void setCertificates(Certificate[] certificateArray) {
        this.Fd.setCertificates(certificateArray);
        this.Fc = null;
    }

    public void setHeaders(Part part) {
        try {
            part.setDisposition("attachment");
            part.setFileName("smime.p7m");
            part.addHeader("Content-Transfer-Encoding", "base64");
        }
        catch (MessagingException messagingException) {
            throw new InternalErrorException((Exception)((Object)messagingException));
        }
    }

    private Attribute[] b(Attribute[] attributeArray) {
        Attributes attributes = new Attributes();
        if (attributeArray != null) {
            attributes.addAttributes(attributeArray);
        }
        if (attributes.getAttribute(MsgSigDigest.oid) == null) {
            if (this.Fg == null) {
                throw new ESSException("Cannot create attributes for signed receipt. MsgSigDigest attribute required!");
            }
            try {
                attributes.addAttribute(new Attribute((AttributeValue)this.Fg), true);
            }
            catch (CodingException codingException) {
                throw new ESSException("Cannot encode MsgSigDigest attribute: " + codingException.getMessage());
            }
        }
        return attributes.toArray();
    }

    public void setSigner(SignerInfo signerInfo) {
        if (signerInfo == null) {
            throw new NullPointerException("Cannot set null signer!");
        }
        Attribute[] attributeArray = signerInfo.getSignedAttributes();
        attributeArray = attributeArray == null || attributeArray.length == 0 ? this.a(null, false) : this.b(attributeArray);
        signerInfo.setSignedAttributes(attributeArray);
        this.Fd.addSignerInfo(signerInfo);
        this.Fc = null;
    }

    public void setSigner(PrivateKey privateKey, X509Certificate x509Certificate, AlgorithmID algorithmID, AlgorithmID algorithmID2, X509Certificate x509Certificate2, boolean bl) {
        Attribute[] attributeArray = this.a(x509Certificate2, bl);
        this.setSigner(privateKey, x509Certificate, algorithmID, algorithmID2, attributeArray);
    }

    public void setSigner(PrivateKey privateKey, X509Certificate x509Certificate, AlgorithmID algorithmID, AlgorithmID algorithmID2, Attribute[] attributeArray) {
        if (privateKey == null) {
            throw new NullPointerException("Cannot sign receipt with null private key!");
        }
        Attribute[] attributeArray2 = null;
        attributeArray2 = attributeArray == null || attributeArray.length == 0 ? this.a(null, false) : this.b(attributeArray);
        SignerInfo signerInfo = new SignerInfo((CertificateIdentifier)new IssuerAndSerialNumber(x509Certificate), algorithmID == null ? (AlgorithmID)AlgorithmID.sha1.clone() : algorithmID, algorithmID2 == null ? (AlgorithmID)AlgorithmID.rsaEncryption.clone() : algorithmID2, privateKey);
        signerInfo.setSignedAttributes(attributeArray2);
        this.Fd.addSignerInfo(signerInfo);
        this.Fc = null;
    }

    public X509Certificate verify() {
        return this.verify(0);
    }

    public X509Certificate verify(int n2) {
        return this.Fd.verify(n2);
    }

    public SignerInfo verify(X509Certificate x509Certificate) {
        return this.Fd.verify(x509Certificate);
    }

    public void verify(PublicKey publicKey) {
        this.verify(publicKey, 0);
    }

    public void verify(PublicKey publicKey, int n2) {
        this.Fd.verify(publicKey, n2);
    }

    public void writeTo(OutputStream outputStream) {
        block11: {
            block10: {
                if (this.Fc == null) break block10;
                InputStream inputStream = this.Fc.getInputStream();
                if (inputStream == null) break block11;
                try {
                    Utils.copyStream(inputStream, outputStream, null);
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                Object var4_4 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                break block11;
            }
            try {
                if (this.Fd == null) {
                    throw new NullPointerException("Cannot write null SignedData!");
                }
                new ContentInfo(this.Fd).writeTo(outputStream);
            }
            catch (Exception exception) {
                throw new IOException("Error writing SignedData: " + exception.toString());
            }
        }
    }
}

