/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.asn1.structures.UnknownAttributeValue;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.Content;
import iaik.cms.DebugCMS;
import iaik.cms.SecurityProvider;
import iaik.cms.SignerInfo;
import iaik.smime.ess.ContentIdentifier;
import iaik.smime.ess.ESSException;
import iaik.smime.ess.ReceiptRequest;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class Receipt
implements Content {
    private static boolean a = false;
    public static final ObjectID oid;
    private int b;
    private ObjectID ui;
    private ContentIdentifier EJ;
    private byte[] uu;

    static {
        a = DebugCMS.getDebugMode() && a;
        oid = ObjectID.receipt;
    }

    public Receipt() {
        this.b = 1;
    }

    public Receipt(ASN1Object aSN1Object) {
        this();
        this.decode(aSN1Object);
    }

    public Receipt(ObjectID objectID, ContentIdentifier contentIdentifier, byte[] byArray) {
        this();
        if (objectID == null) {
            throw new IllegalArgumentException("Cannot create Receipt. Missing content type!");
        }
        if (contentIdentifier == null) {
            throw new IllegalArgumentException("Cannot create Receipt. Missing signed content identifier!");
        }
        if (contentIdentifier == null) {
            throw new IllegalArgumentException("Cannot create Receipt. Missing originator signature value!");
        }
        this.ui = objectID;
        this.EJ = contentIdentifier;
        this.uu = byArray;
    }

    public Receipt(SignerInfo signerInfo) {
        this();
        Attribute attribute = signerInfo.getSignedAttribute(ObjectID.contentType);
        if (attribute == null) {
            throw new ESSException("Cannot create Receipt. SignerInfo does not contain contentType attribute!");
        }
        this.ui = (ObjectID)attribute.getValue()[0];
        try {
            AttributeValue attributeValue = signerInfo.getSignedAttributeValue(ReceiptRequest.oid);
            if (attributeValue == null) {
                throw new ESSException("Cannot create Receipt. SignerInfo does not contain ReceiptRequest attribute!");
            }
            if (attributeValue instanceof UnknownAttributeValue) {
                attributeValue = new ReceiptRequest(attributeValue.toASN1Object());
            }
            this.EJ = ((ReceiptRequest)attributeValue).getSignedContentIdentifier();
        }
        catch (CMSException cMSException) {
            throw new ESSException("Cannot create Receipt. Error reading ReceiptRequest attribute from SignerInfo: " + cMSException.toString());
        }
        catch (CodingException codingException) {
            throw new ESSException("Cannot create Receipt. Error reading ReceiptRequest attribute from SignerInfo: " + codingException.toString());
        }
        if (signerInfo.getSignatureValue() == null) {
            throw new ESSException("Cannot create Receipt. No signature value in SignerInfo!");
        }
        this.uu = (byte[])signerInfo.getSignatureValue().clone();
    }

    public Receipt(InputStream inputStream) {
        this.decode(inputStream);
    }

    public void decode(ASN1Object aSN1Object) {
        try {
            this.b = ((BigInteger)aSN1Object.getComponentAt(0).getValue()).intValue();
            this.ui = (ObjectID)aSN1Object.getComponentAt(1);
            this.EJ = new ContentIdentifier(aSN1Object.getComponentAt(2));
            this.uu = (byte[])aSN1Object.getComponentAt(3).getValue();
        }
        catch (CodingException codingException) {
            throw new CMSParsingException("Error parsing ASN.1 Receipt: " + codingException.toString());
        }
    }

    public void decode(InputStream inputStream) {
        try {
            ASN1Object aSN1Object = DerCoder.decode((InputStream)inputStream);
            this.decode(aSN1Object);
        }
        catch (CodingException codingException) {
            throw new CMSParsingException("Error decoding Receipt: " + codingException.toString());
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            return true;
        }
        if (object instanceof Receipt) {
            Receipt receipt = (Receipt)object;
            if (this.b == receipt.b && (this.ui == null && receipt.ui == null || this.ui != null && receipt.ui != null && this.ui.equals((Object)receipt.ui)) && (this.EJ == null && receipt.EJ == null || this.EJ != null && receipt.EJ != null && this.EJ.equals((Object)receipt.EJ))) {
                bl = this.uu != null && receipt.uu != null ? CryptoUtils.equalsBlock((byte[])this.uu, (byte[])receipt.uu) : this.uu == null && receipt.uu == null;
            }
        }
        return bl;
    }

    public int getBlockSize() {
        return -1;
    }

    public ObjectID getContentType() {
        return oid;
    }

    public byte[] getEncoded() {
        return DerCoder.encode((ASN1Object)this.toASN1Object());
    }

    public byte[] getOriginatorSignatureValue() {
        return this.uu;
    }

    public ObjectID getReceiptContentType() {
        return this.ui;
    }

    public SecurityProvider getSecurityProvider() {
        return null;
    }

    public ContentIdentifier getSignedContentIdentifier() {
        return this.EJ;
    }

    public int getVersion() {
        return this.b;
    }

    public int hashCode() {
        return this.EJ.hashCode();
    }

    public void setBlockSize(int n2) {
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent((ASN1Object)new INTEGER(this.b));
        sEQUENCE.addComponent((ASN1Object)this.ui);
        sEQUENCE.addComponent(this.EJ.toASN1Object());
        sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(this.uu));
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("version: " + this.b + "\n");
        stringBuffer.append("contentType: " + this.ui.getName() + "\n");
        stringBuffer.append("signedContentIdentifier: " + (Object)((Object)this.EJ) + "\n");
        stringBuffer.append("originatorSignatureValue: " + Util.toString((byte[])this.uu));
        return stringBuffer.toString();
    }

    public String toString(boolean bl) {
        return this.toString();
    }

    public void writeTo(OutputStream outputStream) {
        DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
    }
}

