/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.cms.DebugCMS;
import iaik.cms.SecurityProvider;
import iaik.cms.SignerInfo;
import iaik.smime.ess.ESSAttributeValue;
import iaik.smime.ess.ESSException;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.security.NoSuchAlgorithmException;

public class MsgSigDigest
extends ESSAttributeValue {
    private static boolean rH = false;
    public static final ObjectID oid;
    private byte[] rE;
    static Class a;

    static {
        rH = DebugCMS.getDebugMode() && rH;
        Attribute.register((ObjectID)ObjectID.msgSigDigest, (Class)(a != null ? a : (a = MsgSigDigest.class$("iaik.smime.ess.MsgSigDigest"))));
        oid = ObjectID.msgSigDigest;
    }

    public MsgSigDigest() {
    }

    public MsgSigDigest(ASN1Object aSN1Object) {
        this();
        this.decode(aSN1Object);
    }

    public MsgSigDigest(SignerInfo signerInfo) {
        this(signerInfo, null);
    }

    public MsgSigDigest(SignerInfo signerInfo, SecurityProvider securityProvider) {
        this();
        Attribute[] attributeArray;
        SecurityProvider securityProvider2 = securityProvider;
        if (securityProvider2 == null) {
            securityProvider2 = SecurityProvider.getSecurityProvider();
        }
        if ((attributeArray = signerInfo.getSignedAttributes()) == null || attributeArray.length == 0) {
            throw new ESSException("Cannot create MsgSigDigest from SignerInfo. No signed attributes included!");
        }
        AlgorithmID algorithmID = signerInfo.getDigestAlgorithm();
        try {
            this.rE = securityProvider2.getHash(algorithmID, DerCoder.encode((ASN1Object)ASN.createSetOf((ASN1Type[])attributeArray)));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ESSException("Cannot calculate hash over signed attributes. Digest algorithm " + algorithmID.getAlgorithm().getName() + "not supported!");
        }
        catch (CodingException codingException) {
            throw new ESSException("Error encoding signed attributes: " + codingException.getMessage());
        }
    }

    public MsgSigDigest(byte[] byArray) {
        this();
        this.rE = byArray;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void decode(ASN1Object aSN1Object) {
        this.rE = (byte[])aSN1Object.getValue();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MsgSigDigest)) {
            return false;
        }
        MsgSigDigest msgSigDigest = (MsgSigDigest)((Object)object);
        if (this.rE != null && msgSigDigest.rE != null) {
            return CryptoUtils.equalsBlock((byte[])this.rE, (byte[])msgSigDigest.rE);
        }
        return this.rE == null && msgSigDigest.rE == null;
    }

    public ObjectID getAttributeType() {
        return oid;
    }

    public byte[] getDigest() {
        return this.rE;
    }

    public int hashCode() {
        return Util.calculateHashCode((byte[])this.rE);
    }

    public ASN1Object toASN1Object() {
        return new OCTET_STRING(this.rE);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Util.toString((byte[])this.rE));
        return stringBuffer.toString();
    }
}

