/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.NULL;
import iaik.asn1.structures.GeneralNames;
import iaik.smime.ess.ESSRuntimeException;
import iaik.smime.ess.utils.ESSUtil;
import java.util.Arrays;

public class MLReceiptPolicy
implements Cloneable {
    public static final int NONE = 0;
    public static final int INSTEAD_OF = 1;
    public static final int IN_ADDITION_TO = 2;
    private int b;
    private GeneralNames[] Fb;
    static Class a;

    public MLReceiptPolicy(int n2) {
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("Invalid value: " + n2 + ". Must be 0, 1, or 2");
        }
        this.b = n2;
    }

    public MLReceiptPolicy(ASN1Object aSN1Object) {
        this.a(aSN1Object);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Object clone() {
        MLReceiptPolicy mLReceiptPolicy = null;
        try {
            mLReceiptPolicy = (MLReceiptPolicy)super.clone();
            mLReceiptPolicy.b = this.b;
            if (this.b > 0 && this.Fb != null && this.Fb.length > 0) {
                mLReceiptPolicy.Fb = new GeneralNames[this.Fb.length];
                int n2 = 0;
                while (n2 < this.Fb.length) {
                    mLReceiptPolicy.Fb[n2] = new GeneralNames(DerCoder.decode((byte[])DerCoder.encode((ASN1Object)this.Fb[n2].toASN1Object())));
                    ++n2;
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
        }
        catch (CodingException codingException) {
            throw new ESSRuntimeException("Error cloning recipientList: " + codingException.toString());
        }
        return mLReceiptPolicy;
    }

    private void a(ASN1Object aSN1Object) {
        if (!aSN1Object.isA(ASN.CON_SPEC)) {
            throw new CodingException("Invalid MLReceiptPolicy encoding. Expected a context specific!");
        }
        CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object;
        this.b = cON_SPEC.getAsnType().getTag();
        if (this.b < 0 || this.b > 2) {
            throw new CodingException("Invalid tag: " + this.b + ". Must be 0, 1, or 2");
        }
        if (this.b > 0) {
            cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
            this.Fb = (GeneralNames[])ASN.parseSequenceOf((ASN1Object)((ASN1Object)cON_SPEC.getValue()), (Class)(a != null ? a : (a = MLReceiptPolicy.class$("iaik.asn1.structures.GeneralNames"))));
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MLReceiptPolicy)) {
            return false;
        }
        MLReceiptPolicy mLReceiptPolicy = (MLReceiptPolicy)object;
        if (this.b != mLReceiptPolicy.b) {
            return false;
        }
        if (this.b != 0) {
            return Arrays.equals(this.Fb, mLReceiptPolicy.Fb);
        }
        return true;
    }

    public GeneralNames[] getRecipientList() {
        return this.Fb;
    }

    public int getValue() {
        return this.b;
    }

    public int hashCode() {
        return this.b;
    }

    public void setRecipientList(GeneralNames[] generalNamesArray) {
        if (this.b == 0) {
            throw new IllegalArgumentException("Recipient list not required; no receipt should be sent (value = NONE).");
        }
        this.Fb = generalNamesArray;
    }

    public void setRecipientList(String[] stringArray) {
        if (this.b == 0) {
            throw new IllegalArgumentException("Recipient list not required; no receipt should be sent (value = NONE).");
        }
        this.Fb = new GeneralNames[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.Fb[n2] = ESSUtil.createGeneralNames(stringArray[n2]);
            ++n2;
        }
    }

    public ASN1Object toASN1Object() {
        NULL nULL;
        if (this.b == 0) {
            nULL = new NULL();
        } else {
            if (this.Fb == null || this.Fb.length == 0) {
                throw new CodingException("Missing recipient list to return to a receipt " + (this.b == 1 ? "instead of" : "in addition to") + " the originator!");
            }
            nULL = ASN.createSequenceOf((ASN1Type[])this.Fb);
        }
        return new CON_SPEC(this.b, (ASN1Object)nULL, true);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Receipts " + (this.b == 0 ? "must not" : "should") + " be returned");
        if (this.b > 0 && this.Fb != null && this.Fb.length > 0) {
            stringBuffer.append(" to the following list of recipients " + (this.b == 1 ? "instead of" : "in addition to") + " the originator:");
            int n2 = 0;
            while (n2 < this.Fb.length) {
                stringBuffer.append("\nrecipient " + (n2 + 1) + ": " + this.Fb[n2]);
                ++n2;
            }
        }
        return stringBuffer.toString();
    }
}

