/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.cms.Utils;
import iaik.smime.ess.EntityIdentifier;
import iaik.smime.ess.MLReceiptPolicy;
import java.util.Date;

public class MLData
implements ASN1Type {
    private EntityIdentifier EX;
    private ChoiceOfTime EY;
    private MLReceiptPolicy EZ;

    public MLData() {
    }

    public MLData(ASN1Object aSN1Object) {
        this.decode(aSN1Object);
    }

    public MLData(EntityIdentifier entityIdentifier, Date date) {
        if (entityIdentifier == null) {
            throw new IllegalArgumentException("Cannot create MLData. Missing mailListIdentifier!");
        }
        if (date == null) {
            throw new IllegalArgumentException("Cannot create MLData. Missing expansionTime!");
        }
        this.EX = entityIdentifier;
        this.EY = new ChoiceOfTime(date);
        this.EY.setEncodingType(ASN.GeneralizedTime);
    }

    public boolean belongsTo(EntityIdentifier entityIdentifier) {
        return this.EX.equals(entityIdentifier);
    }

    public void decode(ASN1Object aSN1Object) {
        this.EX = new EntityIdentifier(aSN1Object.getComponentAt(0));
        this.EY = new ChoiceOfTime(aSN1Object.getComponentAt(1));
        if (aSN1Object.countComponents() == 3) {
            this.EZ = new MLReceiptPolicy(aSN1Object.getComponentAt(2));
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (!(object instanceof MLData)) {
            bl = false;
        } else {
            MLData mLData = (MLData)object;
            if (this.EX.equals(mLData.EX) && this.EY.getDate().equals(mLData.EY.getDate())) {
                bl = this.EZ != null && mLData.EZ != null ? this.EZ.equals(mLData.EZ) : this.EZ == null && mLData.EZ == null;
            }
        }
        return bl;
    }

    public Date getExpansionTime() {
        return this.EY == null ? null : this.EY.getDate();
    }

    public MLReceiptPolicy getMLReceiptPolicy() {
        return this.EZ;
    }

    public EntityIdentifier getMailListIdentifier() {
        return this.EX;
    }

    public int hashCode() {
        return this.EX.hashCode();
    }

    public void setMLReceiptPolicy(MLReceiptPolicy mLReceiptPolicy) {
        this.EZ = mLReceiptPolicy;
    }

    public ASN1Object toASN1Object() {
        if (this.EX == null) {
            throw new CodingException("Invalid MLData. Missing mailListIdentifier!");
        }
        if (this.EY == null) {
            throw new CodingException("Invalid MLData. Missing expansionTime!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.EX.toASN1Object());
        sEQUENCE.addComponent(this.EY.toASN1Object());
        if (this.EZ != null) {
            sEQUENCE.addComponent(this.EZ.toASN1Object());
        }
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("mailListIdentifier:\n");
        Utils.printIndented(this.EX.toString(), true, "  ", stringBuffer);
        stringBuffer.append("\nexpansionTime: " + this.EY);
        if (this.EZ != null) {
            stringBuffer.append("\nmlReceiptPolicy: " + this.EZ);
        }
        return stringBuffer.toString();
    }
}

