/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.DebugCMS;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.SubjectKeyID;
import iaik.smime.ess.MLData;
import iaik.utils.InternalErrorException;
import iaik.x509.X509Certificate;

public class EntityIdentifier
implements CertificateIdentifier {
    private static boolean a = false;
    private CertificateIdentifier EV;

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    public EntityIdentifier(ASN1Object aSN1Object) {
        this.decode(aSN1Object);
    }

    public EntityIdentifier(CertificateIdentifier certificateIdentifier) {
        if (certificateIdentifier.getKeyIdType() != 0 && certificateIdentifier.getKeyIdType() != 1) {
            throw new IllegalArgumentException("Only IssuerAndSerialNumber or SubjectKeyIdentifier are allowed!");
        }
        this.EV = certificateIdentifier;
    }

    public void decode(ASN1Object aSN1Object) {
        if (aSN1Object.isA(ASN.SEQUENCE)) {
            this.EV = new IssuerAndSerialNumber(aSN1Object);
            if (this.EV == null) {
                throw new CodingException("Missing IssuerAndSerialNumber!");
            }
        } else {
            this.EV = new SubjectKeyID(aSN1Object);
            if (this.EV == null) {
                throw new CodingException("Missing SubjectKeyIdentifier!");
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EntityIdentifier)) {
            return false;
        }
        EntityIdentifier entityIdentifier = (EntityIdentifier)object;
        if (this.getKeyIdType() != entityIdentifier.getKeyIdType()) {
            return false;
        }
        return this.EV.equals(entityIdentifier.getCertificateIdentifier());
    }

    public CertificateIdentifier getCertificateIdentifier() {
        return this.EV;
    }

    public int getKeyIdType() {
        return this.EV.getKeyIdType();
    }

    public String getKeyIdTypeName() {
        return this.EV.getKeyIdTypeName();
    }

    public int hashCode() {
        return this.EV.hashCode();
    }

    public boolean identifiesCert(X509Certificate x509Certificate) {
        return this.EV.identifiesCert(x509Certificate);
    }

    public boolean isMailListIdentifierFor(MLData mLData) {
        return this.equals(mLData.getMailListIdentifier());
    }

    public ASN1Object toASN1Object() {
        try {
            return this.EV.toASN1Object();
        }
        catch (CodingException codingException) {
            throw new InternalErrorException("Error encoding certificate identifier: " + codingException.getMessage(), (Exception)((Object)codingException));
        }
    }

    public String toString() {
        return this.EV.toString();
    }
}

