/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.SET;
import iaik.asn1.UTF8String;
import iaik.asn1.structures.Attribute;
import iaik.cms.DebugCMS;
import iaik.smime.ess.ESSAttributeValue;
import iaik.smime.ess.SecurityCategory;
import iaik.smime.ess.UnknownSecurityCategory;
import iaik.utils.CryptoUtils;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Hashtable;

public class ESSSecurityLabel
extends ESSAttributeValue {
    private static boolean c = false;
    public static final ObjectID oid;
    private static HashMap uW;
    public static final int UNMARKED = 0;
    public static final int UNCLASSIFIED = 1;
    public static final int RESTRICTED = 2;
    public static final int CONFIDENTIAL = 3;
    public static final int SECRET = 4;
    public static final int TOP_SECRET = 5;
    public static final int UB_INTEGER_OPTIONS = 256;
    public static final int UB_PRIVACY_MARK_LENGTH = 128;
    public static final int UB_SECURITY_CATEGORIES = 64;
    private static Hashtable Bc;
    private ObjectID sv;
    private int g = -1;
    private ASN1Object EO;
    private SecurityCategory[] EP;
    static Class a;
    static Class sl;

    static {
        c = DebugCMS.getDebugMode() && c;
        Attribute.register((ObjectID)ObjectID.securityLabel, (Class)(a != null ? a : (a = ESSSecurityLabel.class$("iaik.smime.ess.ESSSecurityLabel"))));
        oid = ObjectID.securityLabel;
        uW = new HashMap(5);
        Bc = new Hashtable();
        Bc.put(new Integer(0), "unmarked");
        Bc.put(new Integer(1), "unclassified");
        Bc.put(new Integer(2), "restricted");
        Bc.put(new Integer(3), "confidential");
        Bc.put(new Integer(4), "secret");
        Bc.put(new Integer(5), "top-secret");
    }

    public ESSSecurityLabel() {
    }

    public ESSSecurityLabel(ASN1Object aSN1Object) {
        this();
        this.decode(aSN1Object);
    }

    public ESSSecurityLabel(ObjectID objectID) {
        this();
        if (objectID == null) {
            throw new NullPointerException("securityPolicyIdentifier must not be null!");
        }
        this.sv = objectID;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static synchronized SecurityCategory create(ObjectID objectID) {
        Class clazz = (Class)uW.get(objectID);
        if (clazz == null) {
            throw new InstantiationException("No known implementation for " + objectID.getName());
        }
        try {
            return (SecurityCategory)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InstantiationException("Error when trying to create a " + clazz + "instance for " + objectID + ": " + illegalAccessException.getMessage());
        }
    }

    public void decode(ASN1Object aSN1Object) {
        int n2 = aSN1Object.countComponents();
        if (n2 < 1 || n2 > 4) {
            throw new CodingException("Invalid number of components: " + n2);
        }
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2) {
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(n3);
            ASN aSN = aSN1Object2.getAsnType();
            if (aSN.equals((Object)ASN.ObjectID)) {
                this.sv = (ObjectID)aSN1Object2;
                bl = true;
            } else if (aSN.equals((Object)ASN.INTEGER)) {
                this.g = ((BigInteger)aSN1Object2.getValue()).intValue();
            } else if (aSN.equals((Object)ASN.PrintableString) || aSN.equals((Object)ASN.UTF8String)) {
                this.EO = aSN1Object2;
            } else if (aSN.equals((Object)ASN.SET)) {
                int n4 = aSN1Object2.countComponents();
                this.EP = new SecurityCategory[n4];
                int n5 = 0;
                while (n5 < n4) {
                    SecurityCategory securityCategory;
                    ASN1Object aSN1Object3 = aSN1Object2.getComponentAt(n5);
                    CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object3.getComponentAt(0);
                    cON_SPEC.forceImplicitlyTagged(ASN.ObjectID);
                    ObjectID objectID = (ObjectID)cON_SPEC.getValue();
                    try {
                        securityCategory = ESSSecurityLabel.create(objectID);
                    }
                    catch (InstantiationException instantiationException) {
                        securityCategory = new UnknownSecurityCategory(objectID);
                    }
                    securityCategory.decode(aSN1Object3.getComponentAt(1));
                    this.EP[n5] = securityCategory;
                    ++n5;
                }
            } else {
                throw new CodingException("Invalid component type: " + aSN);
            }
            ++n3;
        }
        if (!bl) {
            throw new CodingException("Invalid ESSSecurityLabel encoding! Missing Security policy identifier!");
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ESSSecurityLabel)) {
            return false;
        }
        ESSSecurityLabel eSSSecurityLabel = (ESSSecurityLabel)((Object)object);
        try {
            return CryptoUtils.equalsBlock((byte[])DerCoder.encode((ASN1Object)this.toASN1Object()), (byte[])DerCoder.encode((ASN1Object)eSSSecurityLabel.toASN1Object()));
        }
        catch (CodingException codingException) {
            return false;
        }
    }

    public ObjectID getAttributeType() {
        return oid;
    }

    public ASN1Object getPrivacyMark() {
        return this.EO;
    }

    public String getPrivacyMarkString() {
        String string = null;
        if (this.EO != null) {
            string = (String)this.EO.getValue();
        }
        return string;
    }

    public SecurityCategory[] getSecurityCategories() {
        return this.EP;
    }

    public int getSecurityClassification() {
        return this.g;
    }

    public String getSecurityClassificationName() {
        return ESSSecurityLabel.getSecurityClassificationName(this.g);
    }

    public static String getSecurityClassificationName(int n2) {
        Object v2;
        if (Bc != null && (v2 = Bc.get(new Integer(n2))) instanceof String) {
            return (String)v2;
        }
        return null;
    }

    public ObjectID getSecurityPolicyIdentifier() {
        return this.sv;
    }

    public int hashCode() {
        return this.sv.hashCode();
    }

    public static synchronized void register(ObjectID objectID, Class clazz) {
        if (!(sl != null ? sl : (sl = ESSSecurityLabel.class$("iaik.smime.ess.SecurityCategory"))).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Only classes extended from SecurityCategory can be registered!");
        }
        uW.put(objectID, clazz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPrivacyMark(ASN1Object aSN1Object) {
        if (aSN1Object != null) {
            ASN aSN = aSN1Object.getAsnType();
            if (aSN.equals((Object)ASN.PrintableString)) {
                int n2 = ((String)aSN1Object.getValue()).length();
                if (n2 < 1 || n2 > 128) {
                    throw new IllegalArgumentException("ESSPrivacyMark has invalid length: " + n2);
                }
                this.EO = aSN1Object;
                return;
            } else {
                if (!aSN.equals((Object)ASN.UTF8String)) throw new IllegalArgumentException("Invalid essPrivacyMark type: " + aSN);
                this.EO = aSN1Object;
            }
            return;
        } else {
            this.EO = null;
        }
    }

    public void setPrivacyMarkString(String string) {
        this.EO = string != null ? new UTF8String(string) : null;
    }

    public void setSecurityCategories(SecurityCategory[] securityCategoryArray) {
        if (securityCategoryArray != null) {
            if (securityCategoryArray.length > 64) {
                throw new IllegalArgumentException("Only up to 64 security categories allowed!");
            }
            this.EP = securityCategoryArray;
        } else {
            this.EP = null;
        }
    }

    public void setSecurityClassification(int n2) {
        if (n2 > 256) {
            throw new IllegalArgumentException("Classification (" + n2 + ") out of range!");
        }
        this.g = n2;
    }

    public static void setSecurityClassificationNames(Hashtable hashtable) {
        Bc = hashtable;
    }

    public ASN1Object toASN1Object() {
        if (this.sv == null) {
            throw new CodingException("Cannot encode ESSSecurityLabel. Missing security policy identifier!");
        }
        boolean bl = true;
        SET sET = new SET(bl);
        sET.addComponent((ASN1Object)this.sv);
        if (this.g > -1) {
            sET.addComponent((ASN1Object)new INTEGER(this.g));
        }
        if (this.EO != null) {
            sET.addComponent(this.EO);
        }
        if (this.EP != null && this.EP.length > 0) {
            SET sET2 = new SET(bl);
            int n2 = 0;
            while (n2 < this.EP.length) {
                SEQUENCE sEQUENCE = new SEQUENCE();
                sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)this.EP[n2].getType(), true));
                sEQUENCE.addComponent(this.EP[n2].toASN1Object());
                sET2.addComponent((ASN1Object)sEQUENCE);
                ++n2;
            }
            sET.addComponent((ASN1Object)sET2);
        }
        return sET;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("security-policy-identifier: " + this.sv.getName() + "\n");
        if (this.g > -1) {
            Object v2;
            stringBuffer.append("security-classification: " + this.g);
            if (Bc != null && (v2 = Bc.get(new Integer(this.g))) != null) {
                stringBuffer.append(" (" + v2 + ")");
            }
            stringBuffer.append("\n");
        }
        if (this.EO != null) {
            stringBuffer.append("privacy-mark: " + this.EO.getValue() + "\n");
        }
        if (this.EP != null && this.EP.length > 0) {
            int n2 = this.EP.length;
            stringBuffer.append("This ESSSecurityLabel contains " + n2 + " security categor" + (n2 == 1 ? "y:\n" : "ies:\n"));
            int n3 = 0;
            while (n3 < n2) {
                if (bl) {
                    stringBuffer.append("SecurityCategory No " + (n3 + 1) + " (type: " + this.EP[n3].getType().getName() + "):\n");
                    stringBuffer.append(String.valueOf(String.valueOf(this.EP[n3])) + "\n");
                } else {
                    if (n3 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.EP[n3].getType().getName());
                }
                ++n3;
            }
        }
        return stringBuffer.toString();
    }
}

