/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.cms.DebugCMS;
import iaik.cms.IssuerAndSerialNumber;
import iaik.utils.InternalErrorException;
import iaik.x509.X509Certificate;
import iaik.x509.attr.AttCertIssuer;
import iaik.x509.attr.AttributeCertificate;
import iaik.x509.attr.V1Form;
import iaik.x509.attr.V2Form;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;

public class ESSIssuerSerial {
    private static boolean a = false;
    private GeneralNames EL;
    private BigInteger rS;

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    public ESSIssuerSerial(ASN1Object aSN1Object) {
        if (aSN1Object == null) {
            throw new NullPointerException("ASN.1 object must not be null!");
        }
        this.decode(aSN1Object);
    }

    public ESSIssuerSerial(GeneralNames generalNames, BigInteger bigInteger) {
        if (generalNames == null) {
            throw new NullPointerException("Issuer must not be null!");
        }
        if (bigInteger == null) {
            throw new NullPointerException("SerialNumber must not be null!");
        }
        this.EL = generalNames;
        this.rS = bigInteger;
    }

    public ESSIssuerSerial(Name name, BigInteger bigInteger) {
        if (name == null) {
            throw new NullPointerException("Issuer must not be null!");
        }
        if (bigInteger == null) {
            throw new NullPointerException("SerialNumber must not be null!");
        }
        GeneralName generalName = new GeneralName(4, (Object)name);
        this.EL = new GeneralNames(generalName);
        this.rS = bigInteger;
    }

    public ESSIssuerSerial(IssuerAndSerialNumber issuerAndSerialNumber) {
        this(issuerAndSerialNumber.getIssuer(), issuerAndSerialNumber.getSerialNumber());
    }

    public ESSIssuerSerial(Certificate certificate) {
        if (certificate instanceof X509Certificate) {
            this.a((X509Certificate)certificate);
        } else if (certificate instanceof AttributeCertificate) {
            this.a((AttributeCertificate)certificate);
        } else {
            throw new IllegalArgumentException("Only iaik.x509.X509Certificate and iaik.x509.attr.AttributeCertificate objects are allowed!");
        }
    }

    public void decode(ASN1Object aSN1Object) {
        this.EL = new GeneralNames(aSN1Object.getComponentAt(0));
        this.rS = (BigInteger)aSN1Object.getComponentAt(1).getValue();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof ESSIssuerSerial) {
            ESSIssuerSerial eSSIssuerSerial = (ESSIssuerSerial)object;
            bl = this.EL.equals((Object)eSSIssuerSerial.EL) && this.rS.compareTo(eSSIssuerSerial.rS) == 0;
        }
        return bl;
    }

    public GeneralNames getIssuer() {
        return this.EL;
    }

    public BigInteger getSerialNumber() {
        return this.rS;
    }

    public int hashCode() {
        return this.EL.hashCode() + this.rS.hashCode();
    }

    public boolean identifiesCert(Certificate certificate) {
        try {
            return this.equals(new ESSIssuerSerial(certificate));
        }
        catch (CertificateException certificateException) {
            return false;
        }
    }

    private void a(AttributeCertificate attributeCertificate) {
        AttCertIssuer attCertIssuer = attributeCertificate.getIssuer();
        if (attCertIssuer.getVForm() == 1) {
            this.EL = ((V1Form)attCertIssuer).getGeneralNames();
        } else {
            V2Form v2Form = (V2Form)attCertIssuer;
            GeneralNames generalNames = v2Form.getIssuerName();
            if (generalNames != null) {
                this.EL = generalNames;
            } else {
                throw new CertificateException("Cannot create IssuerSerial from given attribute certificate: insufficient issuer information!");
            }
        }
        this.rS = attributeCertificate.getSerialNumber();
    }

    private void a(X509Certificate x509Certificate) {
        GeneralName generalName = new GeneralName(4, (Object)((Name)x509Certificate.getIssuerDN()));
        this.EL = new GeneralNames(generalName);
        this.rS = x509Certificate.getSerialNumber();
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        try {
            sEQUENCE.addComponent(this.EL.toASN1Object());
            sEQUENCE.addComponent((ASN1Object)new INTEGER(this.rS));
        }
        catch (CodingException codingException) {
            throw new InternalErrorException((Exception)((Object)codingException));
        }
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SerialNumber: " + this.rS + "\n");
        stringBuffer.append("Issuer: " + this.EL + "\n");
        return stringBuffer.toString();
    }
}

