/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess;

import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.DebugCMS;
import iaik.cms.SecurityProvider;
import iaik.smime.ess.ESSIssuerSerial;
import iaik.smime.ess.ESSRuntimeException;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;

public class ESSCertID
implements ASN1Type {
    private static boolean rM = false;
    private static final AlgorithmID wp;
    AlgorithmID sM;
    byte[] b;
    ESSIssuerSerial EK;
    SecurityProvider d;

    static {
        rM = DebugCMS.getDebugMode() && rM;
        wp = (AlgorithmID)AlgorithmID.sha1.clone();
    }

    public ESSCertID() {
        this((AlgorithmID)wp.clone());
    }

    public ESSCertID(ASN1Object aSN1Object) {
        if (aSN1Object == null) {
            throw new NullPointerException("ASN.1 object must mot be null!");
        }
        this.decode(aSN1Object);
    }

    ESSCertID(AlgorithmID algorithmID) {
        if (algorithmID == null) {
            throw new NullPointerException("Hash algorithm must not be null!");
        }
        this.sM = algorithmID;
    }

    ESSCertID(AlgorithmID algorithmID, Certificate certificate, boolean bl, SecurityProvider securityProvider) {
        this(algorithmID);
        this.d = securityProvider;
        if (certificate == null) {
            throw new NullPointerException("Certificate must mot be null!");
        }
        this.calculateCertHash(certificate.getEncoded());
        if (bl) {
            this.EK = new ESSIssuerSerial(certificate);
        }
    }

    public ESSCertID(Certificate certificate, boolean bl) {
        this(certificate, bl, null);
    }

    public ESSCertID(Certificate certificate, boolean bl, SecurityProvider securityProvider) {
        this((AlgorithmID)wp.clone(), certificate, bl, securityProvider);
    }

    ASN1Object e(ASN1Object aSN1Object) {
        return aSN1Object;
    }

    public void calculateCertHash(byte[] byArray) {
        SecurityProvider securityProvider = this.d;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        this.b = securityProvider.getHash(this.sM, byArray);
    }

    public void decode(ASN1Object aSN1Object) {
        int n2 = aSN1Object.countComponents();
        if (n2 < 1) {
            throw new CodingException("Invalid number (" + n2 + ") of components in ESSCertID!");
        }
        int n3 = this.f(aSN1Object);
        this.b = (byte[])aSN1Object.getComponentAt(n3++).getValue();
        if (this.b == null) {
            throw new CodingException("Invalid ESSCertID encoding: Missing cert hash!");
        }
        if (n2 == n3 + 1) {
            this.EK = new ESSIssuerSerial(aSN1Object.getComponentAt(n3));
        } else if (n2 != n3) {
            throw new CodingException("Invalid number (" + n2 + ") of components in ESSCertID!");
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof ESSCertID) {
            ESSCertID eSSCertID = (ESSCertID)object;
            if (this.sM.equals((Object)eSSCertID.sM) && (this.b == null && eSSCertID.b == null || this.b != null && eSSCertID.b != null && CryptoUtils.equalsBlock((byte[])this.b, (byte[])eSSCertID.b))) {
                bl = this.EK != null && eSSCertID.EK != null ? this.EK.equals(eSSCertID.EK) : this.EK == null && eSSCertID.EK == null;
            }
        }
        return bl;
    }

    public byte[] getCertHash() {
        return this.b;
    }

    public AlgorithmID getHashAlgorithm() {
        return this.sM;
    }

    public ESSIssuerSerial getIssuerSerial() {
        return this.EK;
    }

    public SecurityProvider getSecurityProvider() {
        return this.d;
    }

    int a() {
        return 1;
    }

    public int hashCode() {
        return Util.calculateHashCode((byte[])this.b);
    }

    public boolean identifiesCert(Certificate certificate) {
        try {
            return this.equals(new ESSCertID(certificate, this.EK != null, this.d));
        }
        catch (CertificateException certificateException) {
            return false;
        }
    }

    int f(ASN1Object aSN1Object) {
        this.sM = (AlgorithmID)wp.clone();
        return 0;
    }

    public void setCertHash(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Cert hash is not allowed to be null!");
        }
        this.b = byArray;
    }

    public void setIssuerSerial(ESSIssuerSerial eSSIssuerSerial) {
        this.EK = eSSIssuerSerial;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.d = securityProvider;
    }

    public ASN1Object toASN1Object() {
        if (this.b == null) {
            throw new RuntimeException("Cannot encode this ESSCertID: Missing cert hash!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        try {
            this.e((ASN1Object)sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new ESSRuntimeException("Error encoding hash algorithm: " + codingException.toString());
        }
        sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(this.b));
        if (this.EK != null) {
            sEQUENCE.addComponent(this.EK.toASN1Object());
        }
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Hash algorithm: " + this.sM);
        stringBuffer.append("\nCertHash: " + Util.toString((byte[])this.b) + "\n");
        if (this.EK != null) {
            stringBuffer.append("IssuerSerial: " + this.EK);
        }
        return stringBuffer.toString();
    }
}

