/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess;

import iaik.asn1.ASN1Object;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.Attribute;
import iaik.cms.DebugCMS;
import iaik.smime.ess.ContentIdentifier;
import iaik.smime.ess.ESSAttributeValue;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;

public class ContentReference
extends ESSAttributeValue {
    private static boolean rH = false;
    public static final ObjectID oid;
    private ObjectID ui;
    private ContentIdentifier EJ;
    private byte[] uu;
    static Class a;

    static {
        rH = DebugCMS.getDebugMode() && rH;
        Attribute.register((ObjectID)ObjectID.contentReference, (Class)(a != null ? a : (a = ContentReference.class$("iaik.smime.ess.ContentReference"))));
        oid = ObjectID.contentReference;
    }

    public ContentReference() {
    }

    public ContentReference(ASN1Object aSN1Object) {
        this();
        this.decode(aSN1Object);
    }

    public ContentReference(ObjectID objectID, ContentIdentifier contentIdentifier, byte[] byArray) {
        this();
        if (objectID == null) {
            throw new IllegalArgumentException("Cannot create ContentReference. Missing content type!");
        }
        if (contentIdentifier == null) {
            throw new IllegalArgumentException("Cannot create ContentReference. Missing signed content identifier!");
        }
        if (contentIdentifier == null) {
            throw new IllegalArgumentException("Cannot create ContentReference. Missing originator signature value!");
        }
        this.ui = objectID;
        this.EJ = contentIdentifier;
        this.uu = byArray;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void decode(ASN1Object aSN1Object) {
        this.ui = (ObjectID)aSN1Object.getComponentAt(0);
        this.EJ = new ContentIdentifier(aSN1Object.getComponentAt(1));
        this.uu = (byte[])aSN1Object.getComponentAt(2).getValue();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ContentReference)) {
            return false;
        }
        ContentReference contentReference = (ContentReference)((Object)object);
        if (this.ui != null && contentReference.ui != null ? !this.ui.equals((Object)contentReference.ui) : !(this.ui == null && contentReference.ui == null)) {
            return false;
        }
        if (this.EJ != null && contentReference.EJ != null ? !this.EJ.equals((Object)contentReference.EJ) : !(this.EJ == null && contentReference.EJ == null)) {
            return false;
        }
        if (this.uu != null && contentReference.uu != null) {
            return CryptoUtils.equalsBlock((byte[])this.uu, (byte[])contentReference.uu);
        }
        return this.uu == null && contentReference.uu == null;
    }

    public ObjectID getAttributeType() {
        return oid;
    }

    public ObjectID getContentType() {
        return this.ui;
    }

    public byte[] getOriginatorSignatureValue() {
        return this.uu;
    }

    public ContentIdentifier getSignedContentIdentifier() {
        return this.EJ;
    }

    public int hashCode() {
        return this.EJ.hashCode();
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent((ASN1Object)this.ui);
        sEQUENCE.addComponent(this.EJ.toASN1Object());
        sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(this.uu));
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("contentType: " + this.ui.getName() + "\n");
        stringBuffer.append("signedContentIdentifier: " + (Object)((Object)this.EJ) + "\n");
        stringBuffer.append("originatorSignatureValue: " + Util.toString((byte[])this.uu));
        return stringBuffer.toString();
    }
}

