/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.cms.DebugCMS;
import iaik.cms.SecurityProvider;
import iaik.smime.ess.ESSAttributeValue;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Date;

public class ContentIdentifier
extends ESSAttributeValue {
    private static boolean rH = false;
    public static final ObjectID oid;
    private byte[] rE;
    static Class a;

    static {
        rH = DebugCMS.getDebugMode() && rH;
        Attribute.register((ObjectID)ObjectID.contentIdentifier, (Class)(a != null ? a : (a = ContentIdentifier.class$("iaik.smime.ess.ContentIdentifier"))));
        oid = ObjectID.contentIdentifier;
    }

    public ContentIdentifier() {
    }

    public ContentIdentifier(ASN1Object aSN1Object) {
        this();
        this.decode(aSN1Object);
    }

    public ContentIdentifier(GeneralNames generalNames) {
        this(generalNames, null);
    }

    public ContentIdentifier(GeneralNames generalNames, SecurityProvider securityProvider) {
        this();
        byte[] byArray = DerCoder.encode((ASN1Object)generalNames.toASN1Object());
        this.rE = ContentIdentifier.a(byArray, null, null, securityProvider);
    }

    public ContentIdentifier(GeneralNames generalNames, Date date, byte[] byArray) {
        this();
        byte[] byArray2 = DerCoder.encode((ASN1Object)generalNames.toASN1Object());
        this.rE = ContentIdentifier.a(byArray2, date, byArray, null);
    }

    public ContentIdentifier(Name name) {
        this(name, null, null);
    }

    public ContentIdentifier(Name name, SecurityProvider securityProvider) {
        this();
        byte[] byArray = DerCoder.encode((ASN1Object)name.toASN1Object());
        this.rE = ContentIdentifier.a(byArray, null, null, securityProvider);
    }

    public ContentIdentifier(Name name, Date date, byte[] byArray) {
        this();
        byte[] byArray2 = DerCoder.encode((ASN1Object)name.toASN1Object());
        this.rE = ContentIdentifier.a(byArray2, date, byArray, null);
    }

    public ContentIdentifier(PublicKey publicKey) {
        this(publicKey, null, null);
    }

    public ContentIdentifier(PublicKey publicKey, SecurityProvider securityProvider) {
        this();
        byte[] byArray = publicKey.getEncoded();
        this.rE = ContentIdentifier.a(byArray, null, null, securityProvider);
    }

    public ContentIdentifier(PublicKey publicKey, Date date, byte[] byArray) {
        this();
        byte[] byArray2 = publicKey.getEncoded();
        this.rE = ContentIdentifier.a(byArray2, date, byArray, null);
    }

    public ContentIdentifier(byte[] byArray) {
        this();
        if (byArray == null) {
            throw new IllegalArgumentException("Cannot create ContentIdentifier. Missing identifier value!");
        }
        this.rE = byArray;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void decode(ASN1Object aSN1Object) {
        this.rE = (byte[])aSN1Object.getValue();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ContentIdentifier)) {
            return false;
        }
        ContentIdentifier contentIdentifier = (ContentIdentifier)((Object)object);
        if (this.rE != null && contentIdentifier.rE != null) {
            return CryptoUtils.equalsBlock((byte[])this.rE, (byte[])contentIdentifier.rE);
        }
        return this.rE == null && contentIdentifier.rE == null;
    }

    public byte[] get() {
        return this.rE;
    }

    public ObjectID getAttributeType() {
        return oid;
    }

    public int hashCode() {
        return Util.calculateHashCode((byte[])this.rE);
    }

    private static byte[] a(byte[] byArray, Date date, byte[] byArray2, SecurityProvider securityProvider) {
        Object object;
        SecurityProvider securityProvider2;
        if (date == null) {
            date = new Date();
        }
        if (byArray2 == null) {
            securityProvider2 = securityProvider;
            if (securityProvider2 == null) {
                securityProvider2 = SecurityProvider.getSecurityProvider();
            }
            byArray2 = new byte[16];
            object = securityProvider2.getSecureRandom();
            ((SecureRandom)object).nextBytes(byArray2);
        }
        securityProvider2 = new ChoiceOfTime(date);
        securityProvider2.setEncodingType(ASN.GeneralizedTime);
        object = DerCoder.encode((ASN1Object)securityProvider2.toASN1Object());
        byte[] byArray3 = new byte[byArray.length + ((Object)object).length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(object, 0, byArray3, byArray.length, ((Object)object).length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length + ((Object)object).length, byArray2.length);
        return byArray3;
    }

    public ASN1Object toASN1Object() {
        if (this.rE == null) {
            throw new NullPointerException("Identifier must not be null!");
        }
        return new OCTET_STRING(this.rE);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Util.toString((byte[])this.rE));
        return stringBuffer.toString();
    }
}

