/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.UTF8String;
import iaik.asn1.structures.Attribute;
import iaik.cms.DebugCMS;
import iaik.smime.ess.ESSAttributeValue;

public class ContentHints
extends ESSAttributeValue {
    public static final ObjectID oid = ObjectID.contentHint;
    private static boolean rH = false;
    private static int c;
    private UTF8String[] EI;
    private ObjectID tV;
    static Class a;

    static {
        rH = DebugCMS.getDebugMode() && rH;
        Attribute.register((ObjectID)oid, (Class)(a != null ? a : (a = ContentHints.class$("iaik.smime.ess.ContentHints"))));
        c = 1;
    }

    public ContentHints() {
    }

    public ContentHints(ASN1Object aSN1Object) {
        this();
        this.decode(aSN1Object);
    }

    public ContentHints(ObjectID objectID) {
        this();
        if (objectID == null) {
            throw new IllegalArgumentException("Cannot create ContentHints. Missing content type!");
        }
        this.tV = objectID;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void decode(ASN1Object aSN1Object) {
        ASN1Object aSN1Object2;
        int n2 = 0;
        int n3 = aSN1Object.countComponents();
        if (n3 == 0) {
            throw new CodingException("Invalid number of components (" + n3 + "). Min 1 required!");
        }
        if (n3 > c + 1) {
            throw new CodingException("Invalid number of components (" + n3 + "). Max " + c + " allowed!");
        }
        if (n3 > 1) {
            int n4 = n3 - 1;
            this.EI = new UTF8String[n3 - 1];
            n2 = 0;
            while (n2 < n4) {
                aSN1Object2 = aSN1Object.getComponentAt(n2);
                if (!aSN1Object2.isA(ASN.UTF8String)) {
                    throw new CodingException("Invalid ASN.1 type (" + aSN1Object2.getAsnType() + ") of content description field! Expected UTF8String!");
                }
                this.EI[n2] = (UTF8String)aSN1Object2;
                ++n2;
            }
        }
        if (!(aSN1Object2 = aSN1Object.getComponentAt(n2)).isA(ASN.ObjectID)) {
            throw new CodingException("Invalid ASN.1 type (" + aSN1Object2.getAsnType() + ") of content type field! Expected ObjectID!");
        }
        this.tV = (ObjectID)aSN1Object.getComponentAt(n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ContentHints)) {
            return false;
        }
        ContentHints contentHints = (ContentHints)((Object)object);
        if (this.EI != null && contentHints.EI != null) {
            if (this.EI.length != contentHints.EI.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < this.EI.length) {
                if (!this.EI[n2].equals((Object)contentHints.EI[n2])) {
                    return false;
                }
                ++n2;
            }
        } else if (!(this.EI == null && contentHints.EI == null)) {
            return false;
        }
        return this.tV.equals((Object)contentHints.tV);
    }

    public ObjectID getAttributeType() {
        return oid;
    }

    public String getContentDescription() {
        return this.EI == null ? null : (String)this.EI[0].getValue();
    }

    public String[] getContentDescriptions() {
        String[] stringArray = null;
        if (this.EI != null) {
            stringArray = new String[this.EI.length];
            int n2 = 0;
            while (n2 < this.EI.length) {
                stringArray[n2] = (String)this.EI[n2].getValue();
                ++n2;
            }
        }
        return stringArray;
    }

    public ObjectID getContentType() {
        return this.tV;
    }

    public int hashCode() {
        return this.tV.hashCode();
    }

    public void setContentDescription(String string) {
        this.EI = string != null ? new UTF8String[]{new UTF8String(string)} : null;
    }

    public void setContentDescriptions(String[] stringArray) {
        if (stringArray != null) {
            int n2 = stringArray.length;
            if (n2 > c) {
                throw new IllegalArgumentException("Too many contentDescription terms! Max " + c + " allowed!");
            }
            this.EI = new UTF8String[n2];
            int n3 = 0;
            while (n3 < n2) {
                String string = stringArray[n3];
                if (string == null) {
                    throw new IllegalArgumentException("contentDescription element must not be null!");
                }
                this.EI[n3] = new UTF8String(string);
                ++n3;
            }
        } else {
            this.EI = null;
        }
    }

    public static void setMaxNumOfContentDescriptions(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("max must be >= 0");
        }
        c = n2;
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.EI != null) {
            int n2 = 0;
            while (n2 < this.EI.length) {
                sEQUENCE.addComponent((ASN1Object)this.EI[n2]);
                ++n2;
            }
        }
        sEQUENCE.addComponent((ASN1Object)this.tV);
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.EI != null) {
            int n2 = 0;
            while (n2 < this.EI.length) {
                stringBuffer.append("contentDescription: " + this.EI[n2].getValue() + "\n");
                ++n2;
            }
        }
        stringBuffer.append("contentType: " + this.tV.getName());
        return stringBuffer.toString();
    }
}

