/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.attributes;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.cms.CertificateIdentifier;
import iaik.cms.DebugCMS;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.RecipientKeyIdentifier;
import iaik.cms.SubjectKeyID;

public class SMIMEEncryptionKeyPreference
extends AttributeValue {
    private static boolean rH = false;
    public static final ObjectID oid;
    private CertificateIdentifier Ew;
    static Class a;

    static {
        rH = DebugCMS.getDebugMode() && rH;
        Attribute.register((ObjectID)ObjectID.encrypKeyPref, (Class)(a != null ? a : (a = SMIMEEncryptionKeyPreference.class$("iaik.smime.attributes.SMIMEEncryptionKeyPreference"))));
        oid = ObjectID.encrypKeyPref;
    }

    public SMIMEEncryptionKeyPreference() {
    }

    public SMIMEEncryptionKeyPreference(ASN1Object aSN1Object) {
        this();
        this.decode(aSN1Object);
    }

    public SMIMEEncryptionKeyPreference(CertificateIdentifier certificateIdentifier) {
        this();
        if (certificateIdentifier == null) {
            throw new IllegalArgumentException("Cannot create SMIMEEncryptionKeyPreference. Missing certificate identifier!");
        }
        this.Ew = certificateIdentifier;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void decode(ASN1Object aSN1Object) {
        if (!aSN1Object.isA(ASN.CON_SPEC)) {
            throw new CodingException("Invalid ASN.1 SMIMEEncryptionKeyPreference. Expected context specific.");
        }
        CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object;
        int n2 = cON_SPEC.getAsnType().getTag();
        switch (n2) {
            case 0: {
                cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                this.Ew = new IssuerAndSerialNumber((ASN1Object)cON_SPEC.getValue());
                break;
            }
            case 1: {
                cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                this.Ew = new RecipientKeyIdentifier((ASN1Object)cON_SPEC.getValue());
                break;
            }
            case 2: {
                cON_SPEC.forceImplicitlyTagged(ASN.OCTET_STRING);
                this.Ew = new SubjectKeyID((ASN1Object)cON_SPEC.getValue());
                break;
            }
            default: {
                throw new CodingException("Invalid recipient id for SMIMEEncryptionKeyPreference attribute: " + this.Ew.getKeyIdType());
            }
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof SMIMEEncryptionKeyPreference) {
            SMIMEEncryptionKeyPreference sMIMEEncryptionKeyPreference = (SMIMEEncryptionKeyPreference)((Object)object);
            bl = this.Ew.equals(sMIMEEncryptionKeyPreference.Ew);
        }
        return bl;
    }

    public ObjectID getAttributeType() {
        return oid;
    }

    public CertificateIdentifier getEncryptionCertID() {
        return this.Ew;
    }

    public int hashCode() {
        return oid.hashCode() + this.Ew.hashCode();
    }

    public ASN1Object toASN1Object() {
        if (this.Ew == null) {
            throw new CodingException("Cannot encode SMIMEEncryptionKeyPreference with missing encryption cert id!");
        }
        int n2 = 0;
        switch (this.Ew.getKeyIdType()) {
            case 2: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            default: {
                throw new CodingException("Invalid recipient id for SMIMEEncryptionKeyPreference attribute: " + this.Ew.getKeyIdType());
            }
            case 0: 
        }
        boolean bl = true;
        return new CON_SPEC(n2, this.Ew.toASN1Object(), bl);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.Ew);
        return stringBuffer.toString();
    }
}

