/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.attributes;

import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.utils.CryptoUtils;

public class SMIMECapability
implements ASN1Type {
    private ObjectID sd;
    private ASN1Object rD;

    public SMIMECapability() {
    }

    public SMIMECapability(ASN1Object aSN1Object) {
        this.decode(aSN1Object);
    }

    public SMIMECapability(ObjectID objectID) {
        this.sd = objectID;
    }

    public void decode(ASN1Object aSN1Object) {
        this.sd = (ObjectID)aSN1Object.getComponentAt(0);
        if (aSN1Object.countComponents() == 2) {
            this.rD = aSN1Object.getComponentAt(1);
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof SMIMECapability) {
            SMIMECapability sMIMECapability = (SMIMECapability)object;
            if (this.sd.equals((Object)sMIMECapability.sd)) {
                bl = this.rD != null && sMIMECapability.rD != null ? CryptoUtils.equalsBlock((byte[])DerCoder.encode((ASN1Object)this.rD), (byte[])DerCoder.encode((ASN1Object)sMIMECapability.rD)) : this.rD == null && sMIMECapability.rD == null;
            }
        }
        return bl;
    }

    public ObjectID getCapabilityID() {
        return this.sd;
    }

    public ASN1Object getParameters() {
        return this.rD;
    }

    public int hashCode() {
        return this.sd.hashCode();
    }

    public void setParameters(ASN1Object aSN1Object) {
        this.rD = aSN1Object;
    }

    public ASN1Object toASN1Object() {
        if (this.sd == null) {
            throw new CodingException("Missing capabilityID!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent((ASN1Object)this.sd);
        if (this.rD != null) {
            sEQUENCE.addComponent(this.rD);
        }
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CapabilityID: " + this.sd.getName());
        if (this.rD != null) {
            stringBuffer.append("\nParameters: " + this.rD);
        }
        return stringBuffer.toString();
    }
}

