/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime;

import iaik.asn1.ObjectID;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.cms.DebugCMS;
import iaik.cms.IssuerAndSerialNumber;
import iaik.smime.ess.utils.ESSUtil;
import iaik.utils.CryptoUtils;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.SubjectAltName;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TrustVerifier {
    private static boolean a = false;
    protected Hashtable trustedCerts_ = new Hashtable(20);
    private Hashtable xW = new Hashtable(20);
    private Hashtable Et = new Hashtable(20);
    protected PrintWriter debugWriter_;

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    public TrustVerifier() {
        if (a) {
            this.setDebugStream(System.out);
        }
    }

    private static void a(X509Certificate x509Certificate, Object object, Hashtable hashtable) {
        if (object != null) {
            Object[] objectArray = (X509Certificate[])hashtable.get(object);
            if (objectArray != null && objectArray.length > 0) {
                if (TrustVerifier.a((X509Certificate[])objectArray, x509Certificate)) {
                    return;
                }
                objectArray = (X509Certificate[])TrustVerifier.a(objectArray, objectArray.length + 1);
                objectArray[objectArray.length - 1] = x509Certificate;
            } else {
                objectArray = new X509Certificate[]{x509Certificate};
            }
            hashtable.put(object, objectArray);
        }
    }

    public void addTrustedCertificate(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new NullPointerException("Cannot add a null certificate!");
        }
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(x509Certificate);
        this.trustedCerts_.put(issuerAndSerialNumber, x509Certificate);
        TrustVerifier.a(x509Certificate, x509Certificate.getSubjectDN(), this.xW);
        Enumeration enumeration = TrustVerifier.getEmailAddresses(x509Certificate);
        while (enumeration.hasMoreElements()) {
            TrustVerifier.a(x509Certificate, ESSUtil.parseAddress((String)enumeration.nextElement()), this.Et);
        }
    }

    private static boolean a(X509Certificate[] x509CertificateArray, X509Certificate x509Certificate) {
        int n2 = 0;
        while (n2 < x509CertificateArray.length) {
            if (x509CertificateArray[n2].equals(x509Certificate)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean checkEMail(String string, X509Certificate x509Certificate) {
        GeneralNames generalNames;
        String string2 = ESSUtil.parseAddress(string);
        Name name = (Name)x509Certificate.getSubjectDN();
        String string3 = name.getRDN(ObjectID.emailAddress);
        if (string3 != null) {
            if (string2.equalsIgnoreCase(string3)) {
                this.a("Email addresses correct!");
                return true;
            }
            this.a("Email addresses do not match!");
            return false;
        }
        SubjectAltName subjectAltName = null;
        try {
            subjectAltName = (SubjectAltName)x509Certificate.getExtension(SubjectAltName.oid);
        }
        catch (Exception exception) {
            subjectAltName = null;
        }
        if (subjectAltName != null && (generalNames = subjectAltName.getGeneralNames()) != null) {
            Enumeration enumeration = generalNames.getNames();
            while (enumeration.hasMoreElements()) {
                GeneralName generalName = (GeneralName)enumeration.nextElement();
                if (generalName.getType() != 1 || !string2.equalsIgnoreCase(string3 = (String)generalName.getName())) continue;
                this.a("Email addresses correct!");
                return true;
            }
        }
        if (string3 == null) {
            if (TrustVerifier.e(x509Certificate)) {
                this.a("Ca cert must not contain an email!");
                return true;
            }
            this.a("Missing email in certificate!");
            return false;
        }
        this.a("Email addresses do not match!");
        return false;
    }

    private void a(String string) {
        if (this.debugWriter_ != null) {
            this.debugWriter_.println("TrustVerifier: " + string);
        }
    }

    public X509Certificate[] getCertificates(String string) {
        X509Certificate[] x509CertificateArray = null;
        if (string != null) {
            x509CertificateArray = (X509Certificate[])this.Et.get(ESSUtil.parseAddress(string).toLowerCase());
        }
        if (x509CertificateArray == null) {
            x509CertificateArray = new X509Certificate[]{};
        }
        return x509CertificateArray;
    }

    public X509Certificate[] getCertificates(Principal principal) {
        X509Certificate[] x509CertificateArray = null;
        if (principal != null) {
            x509CertificateArray = (X509Certificate[])this.xW.get(principal);
        }
        if (x509CertificateArray == null) {
            x509CertificateArray = new X509Certificate[]{};
        }
        return x509CertificateArray;
    }

    public static Enumeration getEmailAddresses(X509Certificate x509Certificate) {
        Vector<String> vector = new Vector<String>();
        Name name = (Name)x509Certificate.getSubjectDN();
        String[] stringArray = name.getRDNs(ObjectID.emailAddress);
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                vector.addElement(stringArray[n2].toLowerCase());
                ++n2;
            }
        }
        try {
            SubjectAltName subjectAltName = (SubjectAltName)x509Certificate.getExtension(SubjectAltName.oid);
            if (subjectAltName != null) {
                Enumeration enumeration = subjectAltName.getGeneralNames().getNames();
                while (enumeration.hasMoreElements()) {
                    GeneralName generalName = (GeneralName)enumeration.nextElement();
                    if (generalName.getType() != 1) continue;
                    vector.addElement(((String)generalName.getName()).toLowerCase());
                }
            }
        }
        catch (Exception exception) {}
        return vector.elements();
    }

    public Enumeration getTrustedCertificates() {
        return this.trustedCerts_.elements();
    }

    public X509Certificate getTrustedIssuerCert(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return null;
        }
        X509Certificate[] x509CertificateArray = (X509Certificate[])this.xW.get(x509Certificate.getIssuerDN());
        int n2 = 0;
        if (x509CertificateArray != null && (n2 = x509CertificateArray.length) > 0) {
            if (n2 == 1) {
                return x509CertificateArray[0];
            }
            int n3 = 0;
            while (n3 < n2) {
                try {
                    X509Certificate x509Certificate2 = x509CertificateArray[n3];
                    x509Certificate2.checkValidity();
                    x509Certificate.verify(x509Certificate2.getPublicKey());
                    return x509Certificate2;
                }
                catch (Exception exception) {
                    ++n3;
                }
            }
        }
        return null;
    }

    public X509Certificate[] getTrustedIssuerCerts(X509Certificate x509Certificate) {
        X509Certificate[] x509CertificateArray = null;
        if (x509Certificate != null) {
            x509CertificateArray = (X509Certificate[])this.xW.get(x509Certificate.getIssuerDN());
        }
        if (x509CertificateArray == null) {
            x509CertificateArray = new X509Certificate[]{};
        }
        return x509CertificateArray;
    }

    private static boolean e(X509Certificate x509Certificate) {
        try {
            BasicConstraints basicConstraints = (BasicConstraints)x509Certificate.getExtension(BasicConstraints.oid);
            if (basicConstraints != null && basicConstraints.ca()) {
                return true;
            }
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {}
        if (x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN())) {
            try {
                x509Certificate.verify();
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public boolean isTrustedCertificate(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new NullPointerException("Cannot check null certificate!");
        }
        X509Certificate x509Certificate2 = (X509Certificate)this.trustedCerts_.get(new IssuerAndSerialNumber(x509Certificate));
        boolean bl = false;
        if (x509Certificate2 != null && x509Certificate2.equals(x509Certificate)) {
            bl = true;
        }
        return bl;
    }

    private static void b(X509Certificate x509Certificate, Object object, Hashtable hashtable) {
        X509Certificate[] x509CertificateArray = (X509Certificate[])hashtable.get(object);
        if (x509CertificateArray != null && x509CertificateArray.length > 0) {
            int n2 = x509CertificateArray.length;
            if (n2 == 1) {
                if (x509CertificateArray[0].equals(x509Certificate)) {
                    hashtable.remove(object);
                }
            } else {
                int n3 = 0;
                while (n3 < n2) {
                    if (x509CertificateArray[n3].equals(x509Certificate)) {
                        x509CertificateArray[n3] = null;
                        X509Certificate[] x509CertificateArray2 = new X509Certificate[n2 - 1];
                        int n4 = 0;
                        int n5 = 0;
                        while (n5 < n2) {
                            if (x509CertificateArray[n5] != null) {
                                x509CertificateArray2[n4++] = x509CertificateArray[n5];
                            }
                            ++n5;
                        }
                        hashtable.put(object, x509CertificateArray2);
                        break;
                    }
                    ++n3;
                }
            }
        }
    }

    public boolean removeTrustedCertificate(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return false;
        }
        try {
            boolean bl;
            IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(x509Certificate);
            boolean bl2 = bl = this.trustedCerts_.remove(issuerAndSerialNumber) != null;
            if (bl) {
                TrustVerifier.b(x509Certificate, x509Certificate.getSubjectDN(), this.xW);
                Enumeration enumeration = TrustVerifier.getEmailAddresses(x509Certificate);
                while (enumeration.hasMoreElements()) {
                    TrustVerifier.b(x509Certificate, ESSUtil.parseAddress((String)enumeration.nextElement()), this.Et);
                }
            }
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static Object[] a(Object[] objectArray, int n2) {
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2);
        System.arraycopy(objectArray, 0, objectArray2, 0, Math.min(n2, objectArray.length));
        return objectArray2;
    }

    public void setDebugStream(OutputStream outputStream) {
        this.debugWriter_ = outputStream == null ? null : new PrintWriter(outputStream, true);
    }

    public int size() {
        return this.trustedCerts_.size();
    }

    private boolean a(X509Certificate x509Certificate, X509Certificate x509Certificate2, String string) {
        String string2 = string == null ? "" : "(" + string + ") ";
        this.a(String.valueOf(string2) + "Verifying " + x509Certificate.getSubjectDN());
        x509Certificate.checkValidity();
        if (this.isTrustedCertificate(x509Certificate)) {
            this.a(String.valueOf(string2) + " Cert is trusted, done.");
            return true;
        }
        if (x509Certificate2 != null) {
            x509Certificate.verify(x509Certificate2.getPublicKey());
            if (CryptoUtils.equalsBlock((byte[])x509Certificate.getSignature(), (byte[])x509Certificate2.getSignature()) && !x509Certificate.equals(x509Certificate2)) {
                throw new CertificateException("Cert " + x509Certificate.getSubjectDN() + " and " + x509Certificate2.getSubjectDN() + " have same signature value!");
            }
        }
        return false;
    }

    public void verifyCertificateChain(X509Certificate[] x509CertificateArray) {
        this.verifyCertificateChain(x509CertificateArray, null);
    }

    public void verifyCertificateChain(X509Certificate[] x509CertificateArray, String string) {
        String string2;
        block14: {
            if (x509CertificateArray == null) {
                throw new NullPointerException("Cannot verify null cert chain!");
            }
            string2 = string == null ? "" : "(" + string + ") ";
            try {
                int n2 = x509CertificateArray.length;
                int n3 = 0;
                while (n3 < n2 - 1) {
                    if (this.a(x509CertificateArray[n3], x509CertificateArray[n3 + 1], string)) {
                        String string3 = "Found a trusted certificate, ok!";
                        this.a(String.valueOf(string2) + string3);
                        return;
                    }
                    ++n3;
                }
                X509Certificate x509Certificate = x509CertificateArray[n2 - 1];
                if (x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN())) {
                    if (this.a(x509Certificate, x509Certificate, string)) {
                        String string4 = "Found a trusted certificate, ok!";
                        this.a(String.valueOf(string2) + string4);
                        return;
                    }
                    break block14;
                }
                X509Certificate[] x509CertificateArray2 = this.getTrustedIssuerCerts(x509Certificate);
                if (x509CertificateArray2.length > 0) {
                    this.a(String.valueOf(string2) + "Found issuers.");
                }
                int n4 = 0;
                while (n4 < x509CertificateArray2.length) {
                    block15: {
                        this.a(String.valueOf(string2) + "Checking against issuer cert " + x509CertificateArray2[0].getSubjectDN() + "...");
                        try {
                            if (this.a(x509Certificate, x509CertificateArray2[n4], string)) {
                                String string5 = "Found a trusted certificate, ok!";
                                this.a(String.valueOf(string2) + string5);
                                return;
                            }
                            if (x509CertificateArray2[n4] != null && this.isTrustedCertificate(x509CertificateArray2[n4])) {
                                String string6 = "Found a trusted certificate, ok!";
                                this.a(String.valueOf(string2) + string6);
                                return;
                            }
                        }
                        catch (Exception exception) {
                            this.a(String.valueOf(string2) + "Verification failed for issuer cert " + x509CertificateArray2[0].getSubjectDN() + exception.toString());
                            if (n4 != x509CertificateArray2.length - 1) break block15;
                            throw exception;
                        }
                    }
                    ++n4;
                }
            }
            catch (Exception exception) {
                String string7 = "Error verifying certificate chain: " + exception;
                this.a(String.valueOf(string2) + string7);
                throw new CertificateException(string7);
            }
        }
        if (this.size() != 0) {
            String string8 = "No trusted certificate found, rejected.";
            this.a(String.valueOf(string2) + string8);
            throw new CertificateException(string8);
        }
        this.a(String.valueOf(string2) + "No trusted certificate found, OK anyway.");
    }

    public boolean verifyChain(X509Certificate[] x509CertificateArray) {
        return this.verifyChain(x509CertificateArray, null);
    }

    public boolean verifyChain(X509Certificate[] x509CertificateArray, String string) {
        try {
            this.verifyCertificateChain(x509CertificateArray, string);
            return true;
        }
        catch (CertificateException certificateException) {
            return false;
        }
    }
}

