/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime;

import iaik.asn1.ASN1Object;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.asn1.structures.Attributes;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.Name;
import iaik.cms.CertificateIdentifier;
import iaik.cms.DebugCMS;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.attributes.CMSContentType;
import iaik.cms.attributes.SigningTime;
import iaik.smime.SMimeException;
import iaik.smime.SMimeParameters;
import iaik.smime.SharedByteArrayInputStream;
import iaik.smime.SharedFileInputStream;
import iaik.smime.attributes.MSOEEncryptionKeyPreference;
import iaik.smime.attributes.SMIMECapabilities;
import iaik.smime.attributes.SMIMECapability;
import iaik.smime.attributes.SMIMEEncryptionKeyPreference;
import iaik.smime.ess.SigningCertificate;
import iaik.smime.ess.SigningCertificateV2;
import iaik.utils.LineInputStream;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import iaik.x509.extensions.SubjectAltName;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Vector;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;

public class SMimeUtil {
    private static boolean a = false;

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    private SMimeUtil() {
    }

    public static Attribute[] createStandardAttributes() {
        return SMimeUtil.createStandardAttributes(null, false, ObjectID.cms_data);
    }

    public static Attribute[] createStandardAttributes(CertificateIdentifier certificateIdentifier, boolean bl) {
        return SMimeUtil.createStandardAttributes(certificateIdentifier, bl, ObjectID.cms_data);
    }

    public static Attribute[] createStandardAttributes(CertificateIdentifier certificateIdentifier, boolean bl, ObjectID objectID) {
        return SMimeUtil.makeStandardAttributes(certificateIdentifier, bl, objectID).toArray();
    }

    public static Attribute[] createStandardAttributes(X509Certificate[] x509CertificateArray, AlgorithmID algorithmID, CertificateIdentifier certificateIdentifier, boolean bl, ObjectID objectID) {
        return SMimeUtil.makeStandardAttributes(x509CertificateArray, algorithmID, certificateIdentifier, bl, objectID).toArray();
    }

    public static String[] getEmailAddresses(X509Certificate x509Certificate) {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        Name name = (Name)x509Certificate.getSubjectDN();
        if (name != null && (objectArray = name.getRDNs(ObjectID.emailAddress)) != null) {
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (objectArray[n2] != null && ((String)objectArray[n2]).length() > 0) {
                    vector.addElement(((String)objectArray[n2]).toLowerCase());
                }
                ++n2;
            }
        }
        try {
            objectArray = (Object[])x509Certificate.getExtension(SubjectAltName.oid);
            if (objectArray != null) {
                Enumeration enumeration = objectArray.getGeneralNames().getNames();
                while (enumeration.hasMoreElements()) {
                    String string;
                    GeneralName generalName = (GeneralName)enumeration.nextElement();
                    if (generalName.getType() != 1 || (string = (String)generalName.getName()) == null || string.length() <= 0) continue;
                    vector.addElement(string.toLowerCase());
                }
            }
        }
        catch (Exception exception) {}
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static InputStream l(InputStream inputStream) {
        void var1_4;
        Object var1_1 = null;
        byte[] byArray = new byte[SMimeParameters.getMaxBufSize() + 1];
        int n2 = 0;
        int n3 = 0;
        while (n3 != -1 && n2 < byArray.length) {
            n3 = inputStream.read(byArray, n2, byArray.length - n2);
            if (n3 <= 0) continue;
            n2 += n3;
        }
        if (n3 != -1) {
            File file = SMimeParameters.a();
            if (a) {
                System.out.println("Write signed content to temp file: " + file.getPath());
            }
            BufferedOutputStream bufferedOutputStream = null;
            try {
                try {
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                    ((OutputStream)bufferedOutputStream).write(byArray);
                    Util.copyStream((InputStream)inputStream, (OutputStream)bufferedOutputStream, (byte[])byArray);
                    ((OutputStream)bufferedOutputStream).flush();
                    SharedFileInputStream sharedFileInputStream = new SharedFileInputStream(file);
                    sharedFileInputStream.a(true);
                }
                catch (IOException iOException) {
                    throw new IOException("Error writing to tmp file " + file.getName() + ": " + iOException.getMessage());
                }
                Object var8_11 = null;
                if (bufferedOutputStream == null) return var1_4;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                if (bufferedOutputStream == null) throw throwable;
                try {
                    ((OutputStream)bufferedOutputStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((OutputStream)bufferedOutputStream).close();
                return var1_4;
            }
            catch (IOException iOException) {}
            return var1_4;
        }
        SharedByteArrayInputStream sharedByteArrayInputStream = new SharedByteArrayInputStream(byArray, 0, n2);
        return var1_4;
    }

    public static SMIMECapabilities makeSMIMECapabilitiesAttribute() {
        SMIMECapability[] sMIMECapabilityArray = new SMIMECapability[7];
        int n2 = 0;
        sMIMECapabilityArray[n2++] = new SMIMECapability(AlgorithmID.aes256_CBC.getAlgorithm());
        sMIMECapabilityArray[n2++] = new SMIMECapability(AlgorithmID.aes128_CBC.getAlgorithm());
        sMIMECapabilityArray[n2++] = new SMIMECapability(AlgorithmID.des_EDE3_CBC.getAlgorithm());
        sMIMECapabilityArray[n2] = new SMIMECapability(AlgorithmID.rc2_CBC.getAlgorithm());
        sMIMECapabilityArray[n2++].setParameters((ASN1Object)new INTEGER(128));
        sMIMECapabilityArray[n2] = new SMIMECapability(AlgorithmID.rc2_CBC.getAlgorithm());
        sMIMECapabilityArray[n2++].setParameters((ASN1Object)new INTEGER(64));
        sMIMECapabilityArray[n2++] = new SMIMECapability(AlgorithmID.des_CBC.getAlgorithm());
        sMIMECapabilityArray[n2] = new SMIMECapability(AlgorithmID.rc2_CBC.getAlgorithm());
        sMIMECapabilityArray[n2++].setParameters((ASN1Object)new INTEGER(40));
        return new SMIMECapabilities(sMIMECapabilityArray);
    }

    public static Attributes makeStandardAttributes() {
        return SMimeUtil.makeStandardAttributes(null, false, ObjectID.cms_data);
    }

    public static Attributes makeStandardAttributes(CertificateIdentifier certificateIdentifier, boolean bl) {
        return SMimeUtil.makeStandardAttributes(certificateIdentifier, bl, ObjectID.cms_data);
    }

    public static Attributes makeStandardAttributes(CertificateIdentifier certificateIdentifier, boolean bl, ObjectID objectID) {
        return SMimeUtil.makeStandardAttributes(null, null, certificateIdentifier, bl, objectID);
    }

    public static Attributes makeStandardAttributes(X509Certificate[] x509CertificateArray, AlgorithmID algorithmID, CertificateIdentifier certificateIdentifier, boolean bl, ObjectID objectID) {
        Attributes attributes = new Attributes();
        try {
            attributes.addAttribute(new Attribute((AttributeValue)new CMSContentType(objectID)));
            attributes.addAttribute(new Attribute((AttributeValue)new SigningTime()));
            attributes.addAttribute(new Attribute((AttributeValue)SMimeUtil.makeSMIMECapabilitiesAttribute()));
            if (x509CertificateArray != null && x509CertificateArray.length > 0) {
                if (algorithmID == null || AlgorithmID.sha1.equals((Object)algorithmID)) {
                    attributes.addAttribute(new Attribute((AttributeValue)new SigningCertificate((Certificate[])x509CertificateArray, true)));
                } else {
                    attributes.addAttribute(new Attribute((AttributeValue)new SigningCertificateV2((Certificate[])x509CertificateArray, true)));
                }
            }
            if (certificateIdentifier != null) {
                attributes.addAttribute(new Attribute((AttributeValue)new SMIMEEncryptionKeyPreference(certificateIdentifier)));
                if (bl && certificateIdentifier.getKeyIdType() == 0) {
                    attributes.addAttribute(new Attribute((AttributeValue)new MSOEEncryptionKeyPreference((IssuerAndSerialNumber)certificateIdentifier)));
                }
            }
        }
        catch (Exception exception) {
            throw new SMimeException("Error adding attribute: " + exception.toString());
        }
        return attributes;
    }

    static String a(String string) {
        String string2 = string;
        if (string != null) {
            int n2 = string.length();
            while (n2 > 0) {
                char c2;
                if ((c2 = string.charAt(--n2)) == ' ' || c2 == '\t') continue;
                ++n2;
                break;
            }
            string2 = n2 == string.length() ? string : string.substring(0, n2);
        }
        return string2;
    }

    static void a(MimePart mimePart, InternetHeaders internetHeaders, boolean bl) {
        Enumeration enumeration;
        if (mimePart != null && internetHeaders != null && (enumeration = internetHeaders.getAllHeaders()).hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                mimePart.removeHeader(((Header)enumeration.nextElement()).getName());
            }
            enumeration = internetHeaders.getAllHeaders();
            while (enumeration.hasMoreElements()) {
                Header header = (Header)enumeration.nextElement();
                mimePart.addHeader(header.getName(), header.getValue());
            }
            if (bl && mimePart instanceof MimeMessage) {
                ((MimeMessage)mimePart).saveChanges();
            }
        }
    }

    static void a(LineInputStream lineInputStream, String string) {
        string = "--" + SMimeUtil.a(string);
        try {
            String string2;
            while (!(string2 = SMimeUtil.a(lineInputStream.readLine())).equals(string)) {
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException("Invalid boundary?");
        }
    }

    static MimeMessage m(InputStream inputStream) {
        try {
            return new MimeMessage(null, inputStream);
        }
        catch (MessagingException messagingException) {
            throw new IOException(messagingException.toString());
        }
    }
}

