/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.cms.CMSException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.DebugCMS;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.SignedDataStream;
import iaik.cms.SignerInfo;
import iaik.smime.SMimeUtil;
import iaik.utils.InternalErrorException;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.PublicKey;

public class SMimeSigned
extends SignedDataStream {
    private static boolean a = false;
    private int b = 0;

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    private SMimeSigned() {
    }

    public SMimeSigned(InputStream inputStream) {
        this();
        try {
            this.decode(inputStream);
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.toString());
        }
    }

    public SMimeSigned(InputStream inputStream, int n2) {
        super(inputStream, n2);
    }

    public SMimeSigned(InputStream inputStream, ObjectID objectID, int n2) {
        super(inputStream, objectID, n2);
    }

    public SMimeSigned(InputStream inputStream, AlgorithmID[] algorithmIDArray) {
        super(inputStream, algorithmIDArray);
    }

    public void addSigner(PrivateKey privateKey, IssuerAndSerialNumber issuerAndSerialNumber) {
        this.addSigner(privateKey, issuerAndSerialNumber, null, false);
    }

    public void addSigner(PrivateKey privateKey, IssuerAndSerialNumber issuerAndSerialNumber, AlgorithmID algorithmID, AlgorithmID algorithmID2) {
        this.addSigner(privateKey, issuerAndSerialNumber, algorithmID, algorithmID2, null, false);
    }

    public void addSigner(PrivateKey privateKey, IssuerAndSerialNumber issuerAndSerialNumber, AlgorithmID algorithmID, AlgorithmID algorithmID2, CertificateIdentifier certificateIdentifier, boolean bl) {
        SignerInfo signerInfo = new SignerInfo((CertificateIdentifier)issuerAndSerialNumber, algorithmID, algorithmID2, privateKey);
        SMimeSigned.a(signerInfo, null, certificateIdentifier, bl);
        this.addSignerInfo(signerInfo);
    }

    public void addSigner(PrivateKey privateKey, IssuerAndSerialNumber issuerAndSerialNumber, AlgorithmID algorithmID, AlgorithmID algorithmID2, Attribute[] attributeArray) {
        SignerInfo signerInfo = new SignerInfo((CertificateIdentifier)issuerAndSerialNumber, algorithmID, algorithmID2, privateKey);
        signerInfo.setSignedAttributes(attributeArray);
        this.addSignerInfo(signerInfo);
    }

    public void addSigner(PrivateKey privateKey, IssuerAndSerialNumber issuerAndSerialNumber, CertificateIdentifier certificateIdentifier, boolean bl) {
        SignerInfo signerInfo = new SignerInfo(issuerAndSerialNumber, null, privateKey);
        SMimeSigned.a(signerInfo, null, certificateIdentifier, bl);
        this.addSignerInfo(signerInfo);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, AlgorithmID algorithmID, AlgorithmID algorithmID2, CertificateIdentifier certificateIdentifier, boolean bl) {
        SignerInfo signerInfo = new SignerInfo(x509Certificate, algorithmID, algorithmID2, privateKey);
        SMimeSigned.a(signerInfo, x509Certificate, certificateIdentifier, bl);
        this.addSignerInfo(signerInfo);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, AlgorithmID algorithmID, AlgorithmID algorithmID2, X509Certificate x509Certificate2, boolean bl) {
        SignerInfo signerInfo = new SignerInfo(x509Certificate, algorithmID, algorithmID2, privateKey);
        SMimeSigned.a(signerInfo, x509Certificate, x509Certificate2 == null ? null : new IssuerAndSerialNumber(x509Certificate2), bl);
        this.addSignerInfo(signerInfo);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, AlgorithmID algorithmID, AlgorithmID algorithmID2, Attribute[] attributeArray) {
        SignerInfo signerInfo = new SignerInfo(x509Certificate, algorithmID, algorithmID2, privateKey);
        signerInfo.setSignedAttributes(attributeArray);
        this.addSignerInfo(signerInfo);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, X509Certificate x509Certificate2, boolean bl) {
        SignerInfo signerInfo = new SignerInfo(x509Certificate, null, privateKey);
        SMimeSigned.a(signerInfo, x509Certificate, x509Certificate2 == null ? null : new IssuerAndSerialNumber(x509Certificate2), x509Certificate2 != null && bl);
        this.addSignerInfo(signerInfo);
    }

    public int getMode() {
        return this.mode_;
    }

    private static void a(SignerInfo signerInfo, X509Certificate x509Certificate, CertificateIdentifier certificateIdentifier, boolean bl) {
        try {
            X509Certificate[] x509CertificateArray;
            if (x509Certificate == null) {
                x509CertificateArray = null;
            } else {
                X509Certificate[] x509CertificateArray2 = new X509Certificate[1];
                x509CertificateArray = x509CertificateArray2;
                x509CertificateArray2[0] = x509Certificate;
            }
            signerInfo.setSignedAttributes(SMimeUtil.createStandardAttributes(x509CertificateArray, signerInfo.getDigestAlgorithm(), certificateIdentifier, bl, ObjectID.cms_data));
        }
        catch (Exception exception) {
            throw new InternalErrorException("Error adding attribute: " + exception.getMessage(), exception);
        }
    }

    public ASN1Object toASN1Object(int n2) {
        this.blockSize_ = n2;
        boolean bl = n2 > 0;
        SEQUENCE sEQUENCE = new SEQUENCE(bl);
        sEQUENCE.addComponent((ASN1Object)this.getContentType());
        CON_SPEC cON_SPEC = new CON_SPEC(0, super.toASN1Object(this.blockSize_));
        cON_SPEC.setIndefiniteLength(bl);
        sEQUENCE.addComponent((ASN1Object)cON_SPEC);
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("mode: ");
        if (this.mode_ == 1) {
            stringBuffer.append("implicit\n");
        } else {
            stringBuffer.append("explicit\n");
        }
        stringBuffer.append(String.valueOf(super.toString()) + "\n\n");
        return stringBuffer.toString();
    }

    public X509Certificate verify() {
        return this.verify(0);
    }

    public void verify(PublicKey publicKey) {
        this.verify(publicKey, 0);
    }

    public void writeTo(OutputStream outputStream) {
        this.writeTo(outputStream, this.blockSize_);
    }

    public void writeTo(OutputStream outputStream, int n2) {
        this.blockSize_ = n2;
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }
}

