/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime;

import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.cms.CertificateIdentifier;
import iaik.cms.DebugCMS;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.KeyTransRecipientInfo;
import iaik.cms.RecipientInfo;
import iaik.cms.SecurityProvider;
import iaik.cms.SignerInfo;
import iaik.smime.SMimeEncrypted;
import iaik.smime.SMimeSigned;
import iaik.smime.SMimeUtil;
import iaik.utils.SmtpException;
import iaik.utils.SmtpMailer;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class SMimeMailer
extends SmtpMailer {
    private static boolean a = false;
    public static final int ENCRYPTED = 1;
    public static final int SIGNED = 2;
    public static final int SIGNED_AND_ENCRYPTED = 3;
    private Vector tR = new Vector();
    private Vector sV;
    private AlgorithmID vM;
    private int e;
    private int f = 0;
    private SecureRandom wf;
    private SignerInfo Ed;
    private X509Certificate[] Ee;

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    public SMimeMailer(String string, int n2) {
        super(string);
        this.f = n2;
        this.sV = new Vector();
    }

    public void addAdditionalField(String string) {
        this.tR.addElement(string);
    }

    public void addBcc(String string, String string2, X509Certificate x509Certificate, AlgorithmID algorithmID) {
        this.addBcc(string, string2);
        this.sV.addElement(new KeyTransRecipientInfo(x509Certificate, algorithmID));
    }

    public void addCc(String string, String string2, X509Certificate x509Certificate, AlgorithmID algorithmID) {
        this.addCc(string, string2);
        this.sV.addElement(new KeyTransRecipientInfo(x509Certificate, algorithmID));
    }

    public void addDate() {
        this.addDate(new Date());
    }

    public void addDate(Date date) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Date: ");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
        stringBuffer.append(simpleDateFormat.format(date));
        stringBuffer.append(" +");
        TimeZone timeZone = simpleDateFormat.getTimeZone();
        String string = String.valueOf(timeZone.getRawOffset() / 36000);
        int n2 = string.length();
        while (n2++ < 4) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        this.addAdditionalField(stringBuffer.toString());
    }

    public void addTo(String string, String string2, X509Certificate x509Certificate, AlgorithmID algorithmID) {
        this.addTo(string, string2);
        this.sV.addElement(new KeyTransRecipientInfo(x509Certificate, algorithmID));
    }

    private byte[] a() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
        printWriter.println("Content-Type: text/plain");
        printWriter.println("charset=\"iso-8859-1\"");
        printWriter.println("Content-Transfer-Encoding: 7bit");
        this.writeBody(printWriter);
        return byteArrayOutputStream.toByteArray();
    }

    public boolean sendMail() {
        try {
            if (this.f == 1) {
                SMimeEncrypted sMimeEncrypted = new SMimeEncrypted(new ByteArrayInputStream(this.a()), this.vM, this.e);
                Object[] objectArray = new RecipientInfo[this.sV.size()];
                this.sV.copyInto(objectArray);
                sMimeEncrypted.setRecipientInfos((RecipientInfo[])objectArray);
                if (this.wf == null) {
                    this.wf = SecurityProvider.getSecurityProvider().getSecureRandom();
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                sMimeEncrypted.writeTo(byteArrayOutputStream);
                byte[] byArray = Util.Base64Encode((byte[])byteArrayOutputStream.toByteArray());
                this.setText(new String(byArray));
                byte[] byArray2 = new byte[10];
                this.wf.nextBytes(byArray2);
                String string = Util.toString((byte[])byArray2);
                super.addAdditionalField("Message-ID: <" + string + ">");
                super.addAdditionalField("MIME-Version: 1.0");
                super.addAdditionalField("Content-Type: application/x-pkcs7-mime; smime-type=enveloped-data;");
                super.addAdditionalField("\tname=\"smime.p7m\"");
                super.addAdditionalField("Content-Transfer-Encoding: base64");
                super.addAdditionalField("Content-Disposition: attachment;");
                super.addAdditionalField("\tfilename=\"smime.p7m\"");
                return super.sendMail();
            }
            if (this.f == 2) {
                SMimeSigned sMimeSigned = new SMimeSigned((InputStream)new ByteArrayInputStream(this.a()), 1);
                sMimeSigned.setCertificates((Certificate[])this.Ee);
                sMimeSigned.addSignerInfo(this.Ed);
                if (this.wf == null) {
                    this.wf = SecurityProvider.getSecurityProvider().getSecureRandom();
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                sMimeSigned.writeTo(byteArrayOutputStream);
                byte[] byArray = Util.Base64Encode((byte[])byteArrayOutputStream.toByteArray());
                this.setText(new String(byArray));
                byte[] byArray3 = new byte[10];
                this.wf.nextBytes(byArray3);
                String string = Util.toString((byte[])byArray3);
                super.addAdditionalField("Message-ID: <" + string + ">");
                super.addAdditionalField("MIME-Version: 1.0");
                super.addAdditionalField("Content-Type: application/pkcs7-mime; smime-type=signed-data;");
                super.addAdditionalField("\tname=\"smime.p7m\"");
                super.addAdditionalField("Content-Transfer-Encoding: base64");
                super.addAdditionalField("Content-Disposition: attachment;");
                super.addAdditionalField("\tfilename=\"smime.p7m\"");
                return super.sendMail();
            }
            if (this.f == 3) {
                SMimeSigned sMimeSigned = new SMimeSigned((InputStream)new ByteArrayInputStream(this.a()), 1);
                sMimeSigned.setCertificates((Certificate[])this.Ee);
                sMimeSigned.addSignerInfo(this.Ed);
                if (this.wf == null) {
                    this.wf = SecurityProvider.getSecurityProvider().getSecureRandom();
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                sMimeSigned.writeTo(byteArrayOutputStream);
                byte[] byArray = Util.Base64Encode((byte[])byteArrayOutputStream.toByteArray());
                byteArrayOutputStream.reset();
                PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
                printWriter.println("Content-Type: application/pkcs7-mime; smime-type=signed-data;");
                printWriter.println("\tname=\"smime.p7m\"");
                printWriter.println("Content-Transfer-Encoding: base64");
                printWriter.println("Content-Disposition: attachment;");
                printWriter.println("\tfilename=\"smime.p7m\"");
                printWriter.println();
                printWriter.println(String.valueOf(new String(byArray)) + "\n");
                SMimeEncrypted sMimeEncrypted = new SMimeEncrypted(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), this.vM, this.e);
                Object[] objectArray = new RecipientInfo[this.sV.size()];
                this.sV.copyInto(objectArray);
                sMimeEncrypted.setRecipientInfos((RecipientInfo[])objectArray);
                if (this.wf == null) {
                    this.wf = SecurityProvider.getSecurityProvider().getSecureRandom();
                }
                byteArrayOutputStream.reset();
                sMimeEncrypted.writeTo(byteArrayOutputStream);
                byte[] byArray4 = Util.Base64Encode((byte[])byteArrayOutputStream.toByteArray());
                this.setText(new String(byArray4));
                byte[] byArray5 = new byte[10];
                this.wf.nextBytes(byArray5);
                String string = Util.toString((byte[])byArray5);
                super.addAdditionalField("Message-ID: <" + string + ">");
                super.addAdditionalField("MIME-Version: 1.0");
                super.addAdditionalField("Content-Type: application/pkcs7-mime; smime-type=enveloped-data;");
                super.addAdditionalField("\tname=\"smime.p7m\"");
                super.addAdditionalField("Content-Transfer-Encoding: base64");
                super.addAdditionalField("Content-Disposition: attachment;");
                super.addAdditionalField("\tfilename=\"smime.p7m\"");
                return super.sendMail();
            }
            throw new SmtpException("Unsupported mode: " + this.f);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SmtpException("Encryption Error: " + noSuchAlgorithmException.getMessage());
        }
        catch (Exception exception) {
            throw new SmtpException("Encryption Error: " + exception.getMessage());
        }
    }

    public void setEncryption(AlgorithmID algorithmID, int n2) {
        this.vM = algorithmID;
        this.e = n2;
    }

    public void setFrom(String string, String string2, X509Certificate x509Certificate, AlgorithmID algorithmID) {
        this.setFrom(string, string2);
        this.sV.addElement(new KeyTransRecipientInfo(x509Certificate, algorithmID));
    }

    public void setFrom(String string, String string2, X509Certificate[] x509CertificateArray, X509Certificate x509Certificate, X509Certificate x509Certificate2, AlgorithmID algorithmID, PrivateKey privateKey, AlgorithmID algorithmID2, AlgorithmID algorithmID3) {
        if (this.f != 2 && this.f != 3) {
            throw new IllegalArgumentException("Mode has to be SMimeMailer.SIGNED or SMimeMailer.SIGNED_AND_ENCRYPTED!");
        }
        this.Ee = x509CertificateArray;
        this.setFrom(string, string2);
        Attribute[] attributeArray = SMimeUtil.createStandardAttributes(x509Certificate2 == null ? null : new IssuerAndSerialNumber(x509Certificate2), true);
        this.Ed = new SignerInfo((CertificateIdentifier)new IssuerAndSerialNumber(x509Certificate), algorithmID2, algorithmID3, privateKey);
        this.Ed.setSignedAttributes(attributeArray);
        if (this.f == 3 && x509Certificate2 != null && algorithmID != null) {
            this.sV.addElement(new KeyTransRecipientInfo(x509Certificate2, algorithmID));
        }
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.wf = secureRandom;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("S/MIME EMail type: ");
        switch (this.f) {
            case 1: {
                stringBuffer.append("ENCRYPTED\n");
                break;
            }
            case 2: {
                stringBuffer.append("SIGNED\n");
                break;
            }
            case 3: {
                stringBuffer.append("SIGNED_AND_ENCRYPTED\n");
                break;
            }
            default: {
                stringBuffer.append("undefined\n");
            }
        }
        stringBuffer.append("Content encryption algorithm: ");
        stringBuffer.append(String.valueOf(this.vM.getName()) + "\n");
        stringBuffer.append("Key length [bits]: " + this.e + "\n\n");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }
}

