/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.EnvelopedDataStream;
import iaik.cms.KeyAgreeRecipientInfo;
import iaik.cms.KeyIdentifier;
import iaik.cms.KeyTransRecipientInfo;
import iaik.cms.RecipientInfo;
import iaik.cms.SecurityProvider;
import iaik.smime.SMimeException;
import iaik.smime.f;
import iaik.utils.InternalErrorException;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import javax.crypto.SecretKey;

public class SMimeEncrypted
extends EnvelopedDataStream {
    private AlgorithmID tO;
    private AlgorithmParameters Ec;

    SMimeEncrypted() {
    }

    public SMimeEncrypted(InputStream inputStream) {
        this();
        try {
            this.decode(inputStream);
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.toString());
        }
    }

    public SMimeEncrypted(InputStream inputStream, AlgorithmID algorithmID, int n2) {
        super(inputStream, algorithmID, n2);
    }

    public void addRecipient(X509Certificate x509Certificate, AlgorithmID algorithmID) {
        KeyTransRecipientInfo keyTransRecipientInfo = new KeyTransRecipientInfo(x509Certificate, algorithmID);
        this.addRecipientInfo(keyTransRecipientInfo);
    }

    public KeyPair addRecipient(X509Certificate x509Certificate, AlgorithmID algorithmID, AlgorithmID algorithmID2, int n2) {
        KeyAgreeRecipientInfo keyAgreeRecipientInfo = null;
        KeyPair keyPair = null;
        Enumeration enumeration = this.recipientInfos_.elements();
        while (enumeration.hasMoreElements()) {
            RecipientInfo recipientInfo = (RecipientInfo)enumeration.nextElement();
            if (recipientInfo.getRecipientInfoType() != 1) continue;
            try {
                keyAgreeRecipientInfo = (KeyAgreeRecipientInfo)recipientInfo;
                if (!keyAgreeRecipientInfo.getKeyEncryptionAlgorithm().equals((Object)algorithmID) || !keyAgreeRecipientInfo.getKeyWrapAlgorithm().equals((Object)algorithmID2)) continue;
                keyPair = keyAgreeRecipientInfo.addRecipient(x509Certificate, 0);
            }
            catch (Exception exception) {}
        }
        if (keyPair == null) {
            keyAgreeRecipientInfo = new KeyAgreeRecipientInfo(algorithmID, algorithmID2, n2);
            try {
                keyPair = keyAgreeRecipientInfo.addRecipient(x509Certificate, 0);
            }
            catch (X509ExtensionException x509ExtensionException) {
                throw new InternalErrorException("Error creating KeyAgreeRecipientInfo: " + x509ExtensionException.toString(), (Exception)((Object)x509ExtensionException));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new SMimeException("Cannot add recipient: " + invalidKeyException.toString());
            }
        }
        this.addRecipientInfo(keyAgreeRecipientInfo);
        return keyPair;
    }

    public SecretKey decryptSymmetricKey(Key key, int n2) {
        try {
            return super.setupCipher(key, n2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (Exception exception) {
            throw new SMimeException("Key/content decryption error: " + exception.toString());
        }
    }

    public SecretKey decryptSymmetricKey(Key key, KeyIdentifier keyIdentifier) {
        try {
            return super.setupCipher(key, keyIdentifier);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (Exception exception) {
            throw new SMimeException("Key/content decryption error: " + exception.toString());
        }
    }

    public SecretKey decryptSymmetricKey(Key key, X509Certificate x509Certificate) {
        try {
            return super.setupCipher(key, x509Certificate);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (Exception exception) {
            throw new SMimeException("Key/content decryption error: " + exception.toString());
        }
    }

    public AlgorithmID getEncryptionAlgorithm() {
        return this.encryptedContentInfo_.getContentEncryptionAlgorithm();
    }

    public int getRecipientInfoIndex(X509Certificate x509Certificate) {
        int n2 = -1;
        Enumeration enumeration = this.recipientInfos_.elements();
        while (enumeration.hasMoreElements()) {
            ++n2;
            RecipientInfo recipientInfo = (RecipientInfo)enumeration.nextElement();
            if (recipientInfo.isRecipientInfoFor(x509Certificate) == null) continue;
            return n2;
        }
        return -1;
    }

    void a() {
        if (!this.keyChanged_) {
            if (this.symmetricKey_ == null) {
                throw new NullPointerException("Cannot init cipher: Missing content encryption key!");
            }
            if (this.tO == null) {
                throw new NullPointerException("Cannot init cipher: Missing content encryption algorithm id!");
            }
            if (this.encryptedContentInfo_ == null) {
                throw new NullPointerException("Cannot init cipher: Missing encrypted content info!");
            }
            try {
                this.encryptedContentInfo_.setupCipher(this.tO, (Key)this.symmetricKey_, this.Ec);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new NoSuchAlgorithmException("Cannot init cipher with generated cek: " + invalidKeyException.toString());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new NoSuchAlgorithmException("Cannot init cipher with no parameters: " + invalidAlgorithmParameterException.toString());
            }
        }
    }

    void a(AlgorithmID algorithmID, int n2, SecurityProvider securityProvider) {
        this.securityProvider_ = securityProvider;
        SecurityProvider securityProvider2 = this.securityProvider_;
        if (securityProvider2 == null) {
            securityProvider2 = SecurityProvider.getSecurityProvider();
        }
        this.tO = algorithmID;
        this.symmetricKey_ = securityProvider2.generateKey(algorithmID, n2);
        this.a(algorithmID, this.symmetricKey_, securityProvider);
    }

    void a(AlgorithmID algorithmID, SecretKey secretKey, SecurityProvider securityProvider) {
        this.securityProvider_ = securityProvider;
        this.tO = algorithmID;
        this.symmetricKey_ = secretKey;
        this.keyChanged_ = true;
        this.encryptedContentInfo_ = new f(ObjectID.cms_data, null);
        this.encryptedContentInfo_.setSecurityProvider(this.securityProvider_);
        try {
            this.encryptedContentInfo_.setupCipher(algorithmID, (Key)this.symmetricKey_, (AlgorithmParameterSpec)null);
            this.Ec = ((f)this.encryptedContentInfo_).dn().getParameters();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new NoSuchAlgorithmException("Cannot init cipher with generated cek: " + invalidKeyException.toString());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new NoSuchAlgorithmException("Cannot init cipher with no parameters: " + invalidAlgorithmParameterException.toString());
        }
    }

    public ASN1Object toASN1Object(int n2) {
        this.blockSize_ = n2;
        boolean bl = n2 > 0;
        SEQUENCE sEQUENCE = new SEQUENCE(bl);
        sEQUENCE.addComponent((ASN1Object)this.getContentType());
        CON_SPEC cON_SPEC = new CON_SPEC(0, super.toASN1Object(this.blockSize_));
        cON_SPEC.setIndefiniteLength(bl);
        sEQUENCE.addComponent((ASN1Object)cON_SPEC);
        return sEQUENCE;
    }

    public void writeTo(OutputStream outputStream) {
        this.writeTo(outputStream, 2048);
    }

    public void writeTo(OutputStream outputStream, int n2) {
        this.blockSize_ = n2;
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.toString());
        }
    }
}

