/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime;

import iaik.asn1.structures.AlgorithmID;
import iaik.cms.EncryptedContentInfoStream;
import iaik.cms.KeyIdentifier;
import iaik.cms.OriginatorInfo;
import iaik.cms.RecipientInfo;
import iaik.cms.Utils;
import iaik.smime.CryptoContent;
import iaik.smime.SMimeContent;
import iaik.smime.SMimeEncrypted;
import iaik.smime.SMimeException;
import iaik.smime.SMimeParameters;
import iaik.smime.SMimeUtil;
import iaik.smime.c;
import iaik.utils.InternalErrorException;
import iaik.x509.X509Certificate;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.crypto.SecretKey;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;

public class EncryptedContent
extends SMimeContent {
    private SMimeEncrypted Dx;

    public EncryptedContent() {
        this.DD = new ContentType("application", SMimeParameters.a, null);
        this.DD.setParameter("name", "smime.p7m");
        this.setSMimeType();
    }

    public EncryptedContent(CryptoContent cryptoContent) {
        this();
        this.setContent(cryptoContent, cryptoContent.getContentType());
        this.setSMimeType();
    }

    public EncryptedContent(InputStream inputStream) {
        this((DataSource)new MimePartDataSource((MimePart)SMimeUtil.m(inputStream)));
    }

    public EncryptedContent(DataSource dataSource) {
        this();
        this.Dx = new SMimeEncrypted(dataSource.getInputStream());
        this.DT = dataSource;
        try {
            this.DD = new ContentType(dataSource.getContentType());
        }
        catch (Exception exception) {}
    }

    public void addRecipient(RecipientInfo recipientInfo) {
        if (this.Dx == null) {
            this.Dx = new SMimeEncrypted();
        }
        this.Dx.addRecipientInfo(recipientInfo);
        this.DT = null;
    }

    public void addRecipient(X509Certificate x509Certificate, AlgorithmID algorithmID) {
        if (this.Dx == null) {
            this.Dx = new SMimeEncrypted();
        }
        this.Dx.addRecipient(x509Certificate, algorithmID);
        this.DT = null;
    }

    public KeyPair addRecipient(X509Certificate x509Certificate, AlgorithmID algorithmID, AlgorithmID algorithmID2, int n2) {
        if (this.Dx == null) {
            this.Dx = new SMimeEncrypted();
        }
        this.DT = null;
        return this.Dx.addRecipient(x509Certificate, algorithmID, algorithmID2, n2);
    }

    public SecretKey decryptSymmetricKey(Key key, int n2) {
        if (this.Dx == null) {
            throw new SMimeException("Cannot decrypt key; no EnvelopedData included");
        }
        return this.Dx.decryptSymmetricKey(key, n2);
    }

    public SecretKey decryptSymmetricKey(Key key, KeyIdentifier keyIdentifier) {
        if (this.Dx == null) {
            throw new SMimeException("Cannot decrypt key; no EnvelopedData included");
        }
        return this.Dx.decryptSymmetricKey(key, keyIdentifier);
    }

    public SecretKey decryptSymmetricKey(Key key, X509Certificate x509Certificate) {
        if (this.Dx == null) {
            throw new SMimeException("Cannot decrypt key; no EnvelopedData included");
        }
        return this.Dx.decryptSymmetricKey(key, x509Certificate);
    }

    public InputStream getContentInputStream() {
        InputStream inputStream = null;
        if (this.DQ == null) {
            inputStream = this.Dx.getInputStream();
        } else {
            Object object;
            if (this.DU == null) {
                throw new NullPointerException("No message to read!");
            }
            c c2 = null;
            try {
                object = new PipedOutputStream();
                PipedInputStream pipedInputStream = new PipedInputStream((PipedOutputStream)object);
                c2 = new c((Part)this.DU, (OutputStream)object);
                c2.start();
                inputStream = pipedInputStream;
            }
            finally {
                Object var4_6 = null;
                if (c2 != null && (object = c2.a()) != null) {
                    throw new IOException("Error reading content: " + ((Throwable)object).toString());
                }
            }
        }
        return inputStream;
    }

    public DataHandler getDataHandler() {
        InputStream inputStream;
        if (this.DQ == null && this.Dx != null && (inputStream = this.Dx.getInputStream()) != null) {
            inputStream = new BufferedInputStream(inputStream);
            if (SMimeParameters.b()) {
                try {
                    inputStream = SMimeUtil.l(inputStream);
                }
                catch (IOException iOException) {
                    throw new MessagingException(iOException.toString());
                }
            }
            this.DU = new MimeMessage(null, inputStream);
            this.DQ = this.DU.getDataHandler();
            SMimeParameters.setDataHandlerCommandMap(this.DQ);
        }
        return this.DQ;
    }

    public AlgorithmID getEncryptionAlgorithm() {
        EncryptedContentInfoStream encryptedContentInfoStream;
        AlgorithmID algorithmID = null;
        if (this.Dx != null && (encryptedContentInfoStream = this.Dx.getEncryptedContentInfo()) != null) {
            algorithmID = encryptedContentInfoStream.getContentEncryptionAlgorithm();
        }
        return algorithmID;
    }

    public OriginatorInfo getOriginatorInfo() {
        OriginatorInfo originatorInfo = null;
        if (this.Dx != null) {
            originatorInfo = this.Dx.getOriginatorInfo();
        }
        return originatorInfo;
    }

    public int getRecipientInfoIndex(X509Certificate x509Certificate) {
        int n2 = -1;
        if (this.Dx != null) {
            n2 = this.Dx.getRecipientInfoIndex(x509Certificate);
        }
        return n2;
    }

    public RecipientInfo[] getRecipientInfos() {
        RecipientInfo[] recipientInfoArray = null;
        recipientInfoArray = this.Dx != null ? this.Dx.getRecipientInfos() : new RecipientInfo[]{};
        return recipientInfoArray;
    }

    public String getSMimeType() {
        return "enveloped-data";
    }

    public void setEncryptionAlgorithm(AlgorithmID algorithmID, int n2) {
        if (this.Dx == null) {
            this.Dx = new SMimeEncrypted();
        }
        this.Dx.a(algorithmID, n2, null);
        this.DT = null;
    }

    public void setEncryptionAlgorithm(AlgorithmID algorithmID, SecretKey secretKey) {
        if (this.Dx == null) {
            this.Dx = new SMimeEncrypted();
        }
        this.Dx.a(algorithmID, secretKey, null);
        this.DT = null;
    }

    public void setHeaders(Part part) {
        try {
            part.setDisposition("attachment");
            part.setFileName("smime.p7m");
            part.setHeader("Content-Transfer-Encoding", "base64");
        }
        catch (MessagingException messagingException) {
            throw new InternalErrorException((Exception)((Object)messagingException));
        }
    }

    public void setOriginatorInfo(OriginatorInfo originatorInfo) {
        if (this.Dx == null) {
            this.Dx = new SMimeEncrypted();
        }
        this.Dx.setOriginatorInfo(originatorInfo);
    }

    public void setRecipients(RecipientInfo[] recipientInfoArray) {
        if (this.Dx == null) {
            this.Dx = new SMimeEncrypted();
        }
        this.Dx.setRecipientInfos(recipientInfoArray);
        this.DT = null;
    }

    public void setSMimeType() {
        this.DD.setParameter("smime-type", "enveloped-data");
    }

    public void setupCipher(Key key) {
        if (this.Dx == null) {
            throw new SMimeException("Cannot setup cipher; no EnvelopedData included");
        }
        try {
            this.Dx.setupCipher(key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (Exception exception) {
            throw new SMimeException("Cipher setup error: " + exception.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeTo(OutputStream outputStream) {
        Exception exception;
        c c2;
        block18: {
            Closeable closeable;
            PipedInputStream pipedInputStream = null;
            c2 = null;
            if (this.DT != null && (closeable = this.DT.getInputStream()) != null) {
                try {
                    Utils.copyStream((InputStream)closeable, outputStream, new byte[8192]);
                    Object var6_6 = null;
                    if (closeable == null) return;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (closeable == null) throw throwable;
                    try {
                        ((InputStream)closeable).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    ((InputStream)closeable).close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            if (this.DQ == null || this.DU == null) {
                throw new NullPointerException("Cannot send message! No content data available!");
            }
            if (this.Dx == null) {
                throw new NullPointerException("Cannot encrypt message! Missing encryption information (algorithm, recipientInfo...)");
            }
            try {
                this.Dx.a();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new MessagingException("Cannot encrypt message; cipher setup error: " + noSuchAlgorithmException.toString());
            }
            closeable = new PipedOutputStream();
            pipedInputStream = new PipedInputStream((PipedOutputStream)closeable);
            c2 = new c((Part)this.DU, (OutputStream)closeable);
            c2.start();
            try {
                try {
                    this.Dx.setInputStream(pipedInputStream);
                    this.Dx.writeTo(outputStream, this.h);
                }
                catch (Exception exception2) {
                    throw new MessagingException(exception2.toString());
                }
                Object var6_8 = null;
                if (pipedInputStream == null) break block18;
            }
            catch (Throwable throwable) {
                Exception exception3;
                Object var6_9 = null;
                if (pipedInputStream != null) {
                    try {
                        ((InputStream)pipedInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                if (c2 == null || (exception3 = c2.a()) == null) throw throwable;
                throw new MessagingException(exception3.toString());
            }
            try {
                ((InputStream)pipedInputStream).close();
            }
            catch (IOException iOException) {}
        }
        if (c2 == null || (exception = c2.a()) == null) return;
        throw new MessagingException(exception.toString());
    }
}

