/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.cms.CertificateIdentifier;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.SubjectKeyID;
import iaik.utils.InternalErrorException;
import iaik.x509.X509Certificate;
import java.io.InputStream;

class z
implements CertificateIdentifier {
    private CertificateIdentifier vQ;

    z() {
    }

    public z(ASN1Object aSN1Object) {
        this.decode(aSN1Object);
    }

    public z(CertificateIdentifier certificateIdentifier) {
        if (certificateIdentifier.getKeyIdType() != 0 && certificateIdentifier.getKeyIdType() != 1) {
            throw new IllegalArgumentException("Only IssuerAndSerialNumber or SubjectKeyIdentifier are allowed!");
        }
        this.vQ = certificateIdentifier;
    }

    public z(InputStream inputStream) {
        this.decode(inputStream);
    }

    public void decode(ASN1Object aSN1Object) {
        if (!aSN1Object.isA(ASN.CON_SPEC)) {
            this.vQ = new IssuerAndSerialNumber(aSN1Object);
            if (this.vQ == null) {
                throw new CodingException("Missing IssuerAndSerialNumber!");
            }
        } else {
            CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object;
            cON_SPEC.forceImplicitlyTagged(ASN.OCTET_STRING);
            this.vQ = new SubjectKeyID((ASN1Object)cON_SPEC.getValue());
            if (this.vQ == null) {
                throw new CodingException("Missing SubjectKeyIdentifier!");
            }
        }
    }

    public void decode(InputStream inputStream) {
        DerInputStream derInputStream;
        DerInputStream derInputStream2 = derInputStream = inputStream instanceof DerInputStream ? (DerInputStream)inputStream : new DerInputStream(inputStream);
        if (derInputStream.nextIsContextSpecific()) {
            int n2 = derInputStream.readContextSpecific(4);
            if (n2 != 0) {
                throw new CodingException("Invalid tag (" + n2 + ") for SubjectKeyIdentifier choice. Expected 0!");
            }
            this.vQ = new SubjectKeyID(derInputStream.readOctetStringByteArray());
        } else {
            this.vQ = new IssuerAndSerialNumber(DerCoder.decode((InputStream)derInputStream));
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof z)) {
            return false;
        }
        z z2 = (z)object;
        if (this.getKeyIdType() != z2.getKeyIdType()) {
            return false;
        }
        return this.vQ.equals(z2.getCertificateIdentifier());
    }

    public CertificateIdentifier getCertificateIdentifier() {
        return this.vQ;
    }

    public int getKeyIdType() {
        return this.vQ.getKeyIdType();
    }

    public String getKeyIdTypeName() {
        return this.vQ.getKeyIdTypeName();
    }

    public int hashCode() {
        return this.vQ.hashCode();
    }

    public boolean identifiesCert(X509Certificate x509Certificate) {
        return this.vQ.identifiesCert(x509Certificate);
    }

    public ASN1Object toASN1Object() {
        boolean bl = true;
        ASN1Object aSN1Object = null;
        try {
            aSN1Object = this.vQ.toASN1Object();
        }
        catch (CodingException codingException) {
            throw new InternalErrorException("Error encoding certificate identifier: " + codingException.getMessage(), (Exception)((Object)codingException));
        }
        if (this.vQ.getKeyIdType() == 1) {
            aSN1Object = new CON_SPEC(0, aSN1Object, bl);
        }
        return aSN1Object;
    }

    public String toString() {
        return String.valueOf(this.getKeyIdTypeName()) + ": " + this.vQ.toString();
    }
}

