/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.cms.DebugCMS;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.KeyIdentifier;
import iaik.cms.OriginatorPublicKey;
import iaik.cms.SecurityProvider;
import iaik.cms.SubjectKeyID;

class x
implements KeyIdentifier {
    private static boolean a = false;
    private KeyIdentifier uK;
    private SecurityProvider vc;

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    public x() {
    }

    public x(ASN1Object aSN1Object, SecurityProvider securityProvider) {
        this.vc = securityProvider;
        this.decode(aSN1Object);
    }

    public x(KeyIdentifier keyIdentifier) {
        int n2 = keyIdentifier.getKeyIdType();
        if (n2 != 0 && n2 != 1 && n2 != 4) {
            throw new IllegalArgumentException("Invalid originatorIdentifier! Expected IssuerAndSerialNumber, SubjectKeyID, or OriginatorPublicKey");
        }
        this.uK = keyIdentifier;
    }

    public void decode(ASN1Object aSN1Object) {
        if (!aSN1Object.isA(ASN.CON_SPEC)) {
            this.uK = new IssuerAndSerialNumber(aSN1Object);
        } else {
            CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object;
            cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
            int n2 = cON_SPEC.getAsnType().getTag();
            if (n2 == 0) {
                this.uK = new SubjectKeyID((ASN1Object)cON_SPEC.getValue());
            } else if (n2 == 1) {
                this.uK = new OriginatorPublicKey((ASN1Object)cON_SPEC.getValue(), this.vc);
            } else {
                throw new CodingException("Invalid tag (" + n2 + ") in OriginatorIdentifierOrKey engoding!");
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof x)) {
            return false;
        }
        x x2 = (x)object;
        if (this.getKeyIdType() != x2.getKeyIdType()) {
            return false;
        }
        return this.uK.equals(x2.a());
    }

    public int getKeyIdType() {
        return this.uK.getKeyIdType();
    }

    public String getKeyIdTypeName() {
        return this.uK.getKeyIdTypeName();
    }

    public KeyIdentifier a() {
        return this.uK;
    }

    public int hashCode() {
        return this.uK.hashCode();
    }

    public ASN1Object toASN1Object() {
        if (this.uK.getKeyIdType() == 0) {
            return this.uK.toASN1Object();
        }
        if (this.uK.getKeyIdType() == 1) {
            return new CON_SPEC(0, this.uK.toASN1Object(), true);
        }
        return new CON_SPEC(1, this.uK.toASN1Object(), true);
    }

    public String toString() {
        return String.valueOf(this.getKeyIdTypeName()) + ": " + this.uK.toString();
    }
}

