/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.RecipientKeyIdentifier;
import iaik.utils.InternalErrorException;
import iaik.x509.X509Certificate;

class v
implements CertificateIdentifier {
    private CertificateIdentifier vQ;

    public v() {
    }

    public v(ASN1Object aSN1Object) {
        this.decode(aSN1Object);
    }

    public v(CertificateIdentifier certificateIdentifier) {
        int n2 = certificateIdentifier.getKeyIdType();
        if (n2 != 0 && n2 != 2) {
            throw new IllegalArgumentException("Invalid signerIdentifier! Expected RecipientKeyIdentifier or IssuerAndSerialNumber!");
        }
        this.vQ = certificateIdentifier;
    }

    public void decode(ASN1Object aSN1Object) {
        if (!aSN1Object.isA(ASN.CON_SPEC)) {
            this.vQ = new IssuerAndSerialNumber(aSN1Object);
            if (this.vQ == null) {
                throw new CodingException("Cannot create KeyAgreeRecipientIdentifier. Missing IssuerAndSerialNumber!");
            }
        } else {
            CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object;
            cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
            this.vQ = new RecipientKeyIdentifier((ASN1Object)cON_SPEC.getValue());
            if (this.vQ == null) {
                throw new CodingException("Cannot create KeyAgreeRecipientIdentifier. Missing RecipientKeyIdentifier!");
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof v)) {
            return false;
        }
        v v2 = (v)object;
        if (this.getKeyIdType() != v2.getKeyIdType()) {
            return false;
        }
        return this.vQ.equals(v2.a());
    }

    public CertificateIdentifier a() {
        return this.vQ;
    }

    public int getKeyIdType() {
        return this.vQ.getKeyIdType();
    }

    public String getKeyIdTypeName() {
        return this.vQ.getKeyIdTypeName();
    }

    public int hashCode() {
        return this.vQ.hashCode();
    }

    public boolean identifiesCert(X509Certificate x509Certificate) {
        return this.vQ.identifiesCert(x509Certificate);
    }

    public ASN1Object toASN1Object() {
        ASN1Object aSN1Object = null;
        try {
            aSN1Object = this.vQ.toASN1Object();
        }
        catch (CodingException codingException) {
            throw new InternalErrorException("Error encoding certificate identifier: " + codingException.getMessage(), (Exception)((Object)codingException));
        }
        if (this.vQ.getKeyIdType() == 0) {
            return aSN1Object;
        }
        return new CON_SPEC(0, aSN1Object, true);
    }

    public String toString() {
        return String.valueOf(this.getKeyIdTypeName()) + ": " + this.vQ.toString();
    }
}

