/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms.ecc;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.DerCoder;
import iaik.asn1.NULL;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSAlgorithmID;
import iaik.cms.IaikProvider;
import iaik.cms.ecc.ECCPublicKey;
import iaik.security.ecc.ECCException;
import iaik.security.ecc.ecdsa.ECDSAKeyPairGeneratorImpl;
import iaik.security.ecc.ecdsa.ECDSAParameter;
import iaik.security.ecc.ecdsa.ECPrivateKey;
import iaik.security.ecc.ecdsa.ECPublicKey;
import iaik.security.ecc.interfaces.ECDSAParams;
import iaik.security.ecc.math.ecgroup.ECPoint;
import iaik.security.ecc.provider.ECCProvider;
import iaik.utils.CriticalObject;
import iaik.utils.CryptoUtils;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;

public class IaikEccProvider
extends IaikProvider {
    public static final AlgorithmID ecka_eg_X963KDF_SHA256 = new CMSAlgorithmID("0.4.0.127.0.7.1.1.5.1.1.3", "ECKA-EG", "ECDH");
    public static final AlgorithmID ecka_eg_X963KDF_SHA384 = new CMSAlgorithmID("0.4.0.127.0.7.1.1.5.1.1.4", "ECKA-EG", "ECDH");
    public static final AlgorithmID ecka_eg_X963KDF_SHA512 = new CMSAlgorithmID("0.4.0.127.0.7.1.1.5.1.1.5", "ECKA-EG", "ECDH");

    public IaikEccProvider() {
        Provider provider;
        if (Security.getProvider("IAIK_ECC") == null) {
            Security.insertProviderAt((Provider)new ECCProvider(), 1);
        }
        if ((provider = Security.getProvider("IAIK_ECC")) == null) {
            String string = "Could not add ECC provider! IAIK-ECC crypto provider not installed!";
            System.err.println(string);
            throw new RuntimeException(string);
        }
    }

    private byte[] a(byte[] byArray, int n2, byte[] byArray2, String string, int n3) {
        if (byArray == null) {
            throw new NullPointerException("Shared secret (Z) must not be null.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Keydatalen must not be negative.");
        }
        int n4 = byArray.length;
        int n5 = 0;
        if (byArray2 != null) {
            n5 = byArray2.length;
        }
        int n6 = (n2 + n3 - 1) / n3;
        byte[] byArray3 = new byte[n6 * n3];
        byte[] byArray4 = new byte[n4 + 4 + n5];
        System.arraycopy(byArray, 0, byArray4, 0, n4);
        byArray4[n4 + 3] = 1;
        if (byArray2 != null) {
            System.arraycopy(byArray2, 0, byArray4, n4 + 4, byArray2.length);
        }
        MessageDigest messageDigest = this.getMessageDigest(string);
        int n7 = 0;
        while (n7 < n6) {
            System.arraycopy(messageDigest.digest(byArray4), 0, byArray3, n7 * n3, n3);
            IaikEccProvider.a(byArray4, n4, 4);
            ++n7;
        }
        CriticalObject.destroy((byte[])byArray4);
        byte[] byArray5 = new byte[n2];
        System.arraycopy(byArray3, 0, byArray5, 0, n2);
        CriticalObject.destroy((byte[])byArray3);
        return byArray5;
    }

    public byte[] calculateSharedSecret(AlgorithmID algorithmID, Key key, Key key2, AlgorithmParameterSpec algorithmParameterSpec) {
        byte[] byArray;
        if (key2 instanceof ECCPublicKey) {
            ECPublicKey eCPublicKey;
            Object object;
            if (!(key instanceof ECPrivateKey)) {
                throw new InvalidKeyException("Private key not an ECPrivateKey!");
            }
            try {
                object = ((ECPrivateKey)key).getParameter();
                if (object == null) {
                    throw new InvalidKeyException("Missing parameters in Private!");
                }
                ECPoint eCPoint = new ECPoint(((ECCPublicKey)((Object)key2)).a(), object.getG().getCurve());
                eCPublicKey = new ECPublicKey((ECDSAParams)object, eCPoint);
            }
            catch (ECCException eCCException) {
                throw new InvalidKeyException(eCCException.toString());
            }
            object = algorithmID.getKeyAgreementInstance("IAIK_ECC");
            if (object == null) {
                object = algorithmID.getKeyAgreementInstance();
            }
            if (algorithmParameterSpec != null) {
                ((KeyAgreement)object).init(key, algorithmParameterSpec, this.getSecureRandom());
            } else {
                ((KeyAgreement)object).init(key, this.getSecureRandom());
            }
            ((KeyAgreement)object).doPhase((Key)eCPublicKey, true);
            byArray = ((KeyAgreement)object).generateSecret();
        } else {
            byArray = super.calculateSharedSecret(algorithmID, key, key2, algorithmParameterSpec);
        }
        return byArray;
    }

    public void checkDomainParameters(PrivateKey privateKey, PublicKey publicKey) {
        if (privateKey instanceof ECPrivateKey && publicKey instanceof ECPublicKey) {
            ECDSAParameter eCDSAParameter = (ECDSAParameter)((ECPrivateKey)privateKey).getParameter();
            ECDSAParameter eCDSAParameter2 = (ECDSAParameter)((ECPublicKey)publicKey).getParameter();
            if (eCDSAParameter != null && eCDSAParameter2 != null && !eCDSAParameter.equals((Object)eCDSAParameter2)) {
                throw new InvalidParameterException("Different domain parameters for ECDH!");
            }
        } else {
            super.checkDomainParameters(privateKey, publicKey);
        }
    }

    private static byte[] a(AlgorithmID algorithmID, byte[] byArray, int n2) {
        if (algorithmID == null) {
            throw new NullPointerException("Cannot create SharedInfo. Key encryption algorithm must not be null.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Cannot create SharedInfo. Kek length must not be negative.");
        }
        byte[] byArray2 = null;
        SEQUENCE sEQUENCE = new SEQUENCE();
        AlgorithmID algorithmID2 = (AlgorithmID)algorithmID.clone();
        ASN1Object aSN1Object = algorithmID.getParameter();
        if (aSN1Object == null || !aSN1Object.isA(ASN.NULL)) {
            algorithmID2 = (AlgorithmID)algorithmID.clone();
            algorithmID2.setParameter((ASN1Object)new NULL());
        } else {
            algorithmID2 = algorithmID;
        }
        sEQUENCE.addComponent(algorithmID2.toASN1Object());
        if (byArray != null) {
            sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)new OCTET_STRING(byArray)));
        }
        byte[] byArray3 = new byte[4];
        CryptoUtils.spreadIntsToBytes((int[])new int[]{n2}, (int)0, (byte[])byArray3, (int)0, (int)1);
        sEQUENCE.addComponent((ASN1Object)new CON_SPEC(2, (ASN1Object)new OCTET_STRING(byArray3)));
        byArray2 = DerCoder.encode((ASN1Object)sEQUENCE);
        return byArray2;
    }

    public SecretKey createSharedKeyEncryptionKey(AlgorithmID algorithmID, PrivateKey privateKey, PublicKey publicKey, AlgorithmID algorithmID2, int n2, byte[] byArray, String string) {
        SecretKey secretKey = null;
        String string2 = "SHA-1";
        int n3 = 20;
        if (algorithmID.equals((Object)CMSAlgorithmID.dhSinglePass_stdDH_sha1kdf_scheme) || algorithmID.equals((Object)CMSAlgorithmID.dhSinglePass_cofactorDH_sha1kdf_scheme) || algorithmID.equals((Object)CMSAlgorithmID.dhSinglePass_stdDH_sha256kdf_scheme) || algorithmID.equals((Object)CMSAlgorithmID.dhSinglePass_stdDH_sha384kdf_scheme) || algorithmID.equals((Object)ecka_eg_X963KDF_SHA256) || algorithmID.equals((Object)ecka_eg_X963KDF_SHA384) || algorithmID.equals((Object)ecka_eg_X963KDF_SHA512)) {
            if (algorithmID.equals((Object)CMSAlgorithmID.dhSinglePass_stdDH_sha256kdf_scheme)) {
                string2 = "SHA-256";
                n3 = 32;
            } else if (algorithmID.equals((Object)ecka_eg_X963KDF_SHA256)) {
                string2 = "SHA-256";
                n3 = 32;
            } else if (algorithmID.equals((Object)CMSAlgorithmID.dhSinglePass_stdDH_sha384kdf_scheme)) {
                string2 = "SHA-384";
                n3 = 48;
            } else if (algorithmID.equals((Object)ecka_eg_X963KDF_SHA256)) {
                string2 = "SHA-256";
                n3 = 32;
            } else if (algorithmID.equals((Object)ecka_eg_X963KDF_SHA384)) {
                string2 = "SHA-384";
                n3 = 48;
            } else if (algorithmID.equals((Object)ecka_eg_X963KDF_SHA512)) {
                string2 = "SHA-512";
                n3 = 64;
            }
            byte[] byArray2 = this.calculateSharedSecret(algorithmID, privateKey, publicKey, null);
            byte[] byArray3 = null;
            if (!(algorithmID.equals((Object)ecka_eg_X963KDF_SHA256) || algorithmID.equals((Object)ecka_eg_X963KDF_SHA384) || algorithmID.equals((Object)ecka_eg_X963KDF_SHA512))) {
                byArray3 = IaikEccProvider.a(algorithmID2, byArray, n2);
            }
            byArray2 = this.a(byArray2, n2 / 8, byArray3, string2, n3);
            SecretKeySpec secretKeySpec = null;
            try {
                secretKeySpec = new SecretKeySpec(byArray2, string);
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string);
                secretKey = secretKeyFactory.generateSecret(secretKeySpec);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                secretKey = secretKeySpec;
            }
        } else {
            secretKey = super.createSharedKeyEncryptionKey(algorithmID, privateKey, publicKey, algorithmID2, n2, byArray, string);
        }
        return secretKey;
    }

    public KeyPair generateKeyAgreementKeyPair(AlgorithmID algorithmID, PublicKey publicKey) {
        if (publicKey instanceof ECPublicKey) {
            ECDSAKeyPairGeneratorImpl eCDSAKeyPairGeneratorImpl = null;
            try {
                eCDSAKeyPairGeneratorImpl = (ECDSAKeyPairGeneratorImpl)KeyPairGenerator.getInstance("ECDSA", "IAIK_ECC");
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new NoSuchAlgorithmException("Cannot get ECDH KeyPairGenerator: No such provider: IAIK_ECC");
            }
            eCDSAKeyPairGeneratorImpl.initialize(((ECPublicKey)publicKey).getParameter(), this.getSecureRandom());
            return eCDSAKeyPairGeneratorImpl.generateKeyPair();
        }
        return super.generateKeyAgreementKeyPair(algorithmID, publicKey);
    }

    public ASN1Object getASN1OriginatorPublicKey(PublicKey publicKey) {
        ASN1Object aSN1Object = null;
        if (publicKey instanceof ECPublicKey) {
            ECCPublicKey eCCPublicKey = new ECCPublicKey(((ECPublicKey)publicKey).getW());
            return eCCPublicKey.toASN1Object();
        }
        aSN1Object = super.getASN1OriginatorPublicKey(publicKey);
        return aSN1Object;
    }

    public int getKeyLength(PrivateKey privateKey) {
        int n2 = privateKey instanceof ECPrivateKey ? ((ECPrivateKey)privateKey).getParameter().getR().bitLength() : super.getKeyLength(privateKey);
        return n2;
    }

    public int getKeyLength(PublicKey publicKey) {
        int n2 = publicKey instanceof ECPublicKey ? ((ECPublicKey)publicKey).getParameter().getR().bitLength() : super.getKeyLength(publicKey);
        return n2;
    }

    public PublicKey getOriginatorPublicKey(ASN1Object aSN1Object) {
        Object object = null;
        try {
            object = new ECCPublicKey(aSN1Object);
        }
        catch (Throwable throwable) {
            object = super.getOriginatorPublicKey(aSN1Object);
        }
        return object;
    }

    private static void a(byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3 - 1;
        while (n4 >= n2) {
            int n5 = n4--;
            byArray[n5] = (byte)(byArray[n5] + 1);
            if (byArray[n5] == 0) continue;
        }
    }
}

