/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms.ecc;

import iaik.asn1.ASN1Object;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.structures.AlgorithmID;
import iaik.security.ecc.math.ecgroup.ECPoint;
import iaik.x509.PublicKeyInfo;
import java.security.InvalidKeyException;

class ECCPublicKey
extends PublicKeyInfo {
    private OCTET_STRING vE;

    ECCPublicKey(ASN1Object aSN1Object) {
        super(aSN1Object);
    }

    ECCPublicKey(ECPoint eCPoint) {
        if (eCPoint == null) {
            throw new NullPointerException("Public key (ECPoint) must not be null.");
        }
        this.vE = eCPoint.toASN1Object();
        this.public_key_algorithm = (AlgorithmID)AlgorithmID.ecdsa.clone();
        this.public_key_algorithm.setParameter(null);
        this.createPublicKeyInfo();
    }

    public void decode(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Cannot decode null public key!");
        }
        if (!AlgorithmID.ecdsa.equals((Object)this.public_key_algorithm)) {
            throw new InvalidKeyException("No ECDH key!");
        }
        this.vE = new OCTET_STRING(byArray);
    }

    public byte[] encode() {
        return (byte[])this.vE.getValue();
    }

    public String getAlgorithm() {
        return "ECDSA";
    }

    public byte[] a() {
        return (byte[])this.vE.getValue();
    }
}

