/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms.attributes;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.cms.CMSException;
import iaik.cms.CMSSignatureException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.DebugCMS;
import iaik.cms.InvalidContentHashException;
import iaik.cms.InvalidContentTypeException;
import iaik.cms.SecurityProvider;
import iaik.cms.SignerInfo;
import iaik.cms.attributes.CMSContentType;
import iaik.cms.attributes.CMSMessageDigest;
import iaik.smime.ess.SigningCertificate;
import iaik.smime.ess.SigningCertificateV2;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;

public class CounterSignature
extends AttributeValue {
    private static boolean rH = false;
    public static final ObjectID oid;
    private SignerInfo vB;
    private PrivateKey vC;
    private SecurityProvider ux;
    private boolean ua = false;
    static Class a;

    static {
        rH = DebugCMS.getDebugMode() && rH;
        Attribute.register((ObjectID)ObjectID.countersignature, (Class)(a != null ? a : (a = CounterSignature.class$("iaik.cms.attributes.CounterSignature"))));
        oid = ObjectID.countersignature;
    }

    public CounterSignature() {
    }

    public CounterSignature(ASN1Object aSN1Object) {
        this();
        this.decode(aSN1Object);
    }

    public CounterSignature(CertificateIdentifier certificateIdentifier, AlgorithmID algorithmID, AlgorithmID algorithmID2, PrivateKey privateKey) {
        this();
        this.vB = new SignerInfo(certificateIdentifier, algorithmID, algorithmID2, null);
        this.vC = privateKey;
    }

    public CounterSignature(CertificateIdentifier certificateIdentifier, AlgorithmID algorithmID, PrivateKey privateKey) {
        this();
        this.vB = new SignerInfo(certificateIdentifier, algorithmID, null);
        this.vC = privateKey;
    }

    public void addSignedAttribute(Attribute attribute) {
        if (CMSContentType.oid.equals((Object)attribute.getType())) {
            throw new IllegalArgumentException("ContentType attribute not allowed for CounterSignature!");
        }
        this.vB.addSignedAttribute(attribute);
    }

    public void addSignedAttributes(Attribute[] attributeArray) {
        try {
            this.a(attributeArray);
        }
        catch (InvalidContentTypeException invalidContentTypeException) {
            throw new IllegalArgumentException(invalidContentTypeException.getMessage());
        }
        this.vB.addSignedAttributes(attributeArray);
    }

    public void addUnsignedAttribute(Attribute attribute) {
        this.vB.addUnSignedAttribute(attribute);
    }

    public void addUnsignedAttributes(Attribute[] attributeArray) {
        this.vB.addUnsignedAttributes(attributeArray);
    }

    private byte[] r(byte[] byArray) {
        SecurityProvider securityProvider = this.ux;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        return securityProvider.getHash(this.vB.getDigestAlgorithm(), byArray);
    }

    private void a(Attribute[] attributeArray) {
        if (attributeArray != null) {
            int n2 = 0;
            while (n2 < attributeArray.length) {
                if (CMSContentType.oid.equals((Object)attributeArray[n2].getType())) {
                    throw new InvalidContentTypeException("ContentType attribute not allowed for CounterSignature!", this.vB.getSignerIdentifier());
                }
                ++n2;
            }
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void counterSign(SignerInfo signerInfo) {
        this.counterSign(signerInfo.getSignatureValue());
    }

    public void counterSign(CounterSignature counterSignature) {
        this.counterSign(counterSignature.getSignatureValue());
    }

    public void counterSign(byte[] byArray) {
        SecurityProvider securityProvider = this.ux;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        try {
            if (this.vB.getSignatureValue() == null) {
                AlgorithmID algorithmID = this.vB.getDigestAlgorithm();
                AlgorithmID algorithmID2 = this.vB.getSignatureAlgorithm();
                byte[] byArray2 = this.r(byArray);
                this.t(byArray2);
                Attribute[] attributeArray = this.vB.getSignedAttributes();
                if (attributeArray == null || attributeArray.length == 0) {
                    this.vB.setSignatureValue(securityProvider.calculateSignatureFromHash(algorithmID2, algorithmID, this.vC, byArray2));
                } else {
                    byte[] byArray3 = DerCoder.encode((ASN1Object)ASN.createSetOf((ASN1Type[])attributeArray, (boolean)true));
                    this.setSignatureValue(securityProvider.calculateSignatureFromSignedAttributes(algorithmID2, algorithmID, this.vC, byArray3));
                }
            }
        }
        catch (Exception exception) {
            throw new SignatureException("Unable to calculate signature: " + exception.toString());
        }
    }

    public void decode(ASN1Object aSN1Object) {
        this.vB = new SignerInfo(aSN1Object);
    }

    public ObjectID getAttributeType() {
        return oid;
    }

    public AlgorithmID getDigestAlgorithm() {
        return this.vB.getDigestAlgorithm();
    }

    public SecurityProvider getSecurityProvider() {
        return this.ux;
    }

    public AlgorithmID getSignatureAlgorithm() {
        return this.vB.getSignatureAlgorithm();
    }

    public byte[] getSignatureValue() {
        return this.vB.getSignatureValue();
    }

    public Attribute getSignedAttribute(ObjectID objectID) {
        return this.vB.getSignedAttribute(objectID);
    }

    public AttributeValue getSignedAttributeValue(ObjectID objectID) {
        return this.vB.getSignedAttributeValue(objectID);
    }

    public Attribute[] getSignedAttributes() {
        return this.vB.getSignedAttributes();
    }

    public Attribute[] getSignedAttributes(ObjectID objectID) {
        return this.vB.getSignedAttributes(objectID);
    }

    public byte[] getSignedDigest() {
        return this.vB.getSignedDigest();
    }

    public CertificateIdentifier getSignerIdentifier() {
        return this.vB.getSignerIdentifier();
    }

    public SigningCertificate getSigningCertificateAttribute() {
        return this.vB.getSigningCertificateAttribute();
    }

    public SigningCertificateV2 getSigningCertificateV2Attribute() {
        return this.vB.getSigningCertificateV2Attribute();
    }

    public Attribute getUnsignedAttribute(ObjectID objectID) {
        return this.vB.getUnsignedAttribute(objectID);
    }

    public AttributeValue getUnsignedAttributeValue(ObjectID objectID) {
        return this.vB.getUnsignedAttributeValue(objectID);
    }

    public Attribute[] getUnsignedAttributes() {
        return this.vB.getUnsignedAttributes();
    }

    public Attribute[] getUnsignedAttributes(ObjectID objectID) {
        return this.vB.getUnsignedAttributes(objectID);
    }

    public int getVersion() {
        return this.vB.getVersion();
    }

    public boolean isSignerCertificate(X509Certificate x509Certificate) {
        return this.vB.isSignerCertificate(x509Certificate);
    }

    public void removeSignedAttribute(ObjectID objectID) {
        this.vB.removeSignedAttribute(objectID);
    }

    public void removeUnsignedAttribute(ObjectID objectID) {
        this.vB.removeUnSignedAttribute(objectID);
    }

    private void t(byte[] byArray) {
        Object[] objectArray = this.vB.getSignedAttributes();
        if (objectArray != null && objectArray.length > 0) {
            int n2 = objectArray.length;
            boolean bl = false;
            int n3 = 0;
            while (n3 < n2) {
                if (objectArray[n3].getType().equals((Object)ObjectID.messageDigest)) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                try {
                    objectArray = (Attribute[])Util.resizeArray((Object[])objectArray, (int)(n2 + 1));
                    objectArray[n2] = new Attribute((AttributeValue)new CMSMessageDigest(byArray));
                }
                catch (Exception exception) {
                    throw new CMSException("Unable to calculate MessageDigest attribute: " + exception.getMessage());
                }
                this.vB.setSignedAttributes((Attribute[])objectArray);
            }
        }
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.ux = securityProvider;
        if (this.vB != null && this.vB.getSecurityProvider() == null) {
            this.vB.setSecurityProvider(this.ux);
        }
    }

    public void setSignatureValue(byte[] byArray) {
        this.vB.setSignatureValue(byArray);
        this.ua = true;
    }

    public void setSignedAttributes(Attribute[] attributeArray) {
        try {
            this.a(attributeArray);
        }
        catch (InvalidContentTypeException invalidContentTypeException) {
            throw new IllegalArgumentException(invalidContentTypeException.getMessage());
        }
        this.vB.setSignedAttributes(attributeArray);
    }

    public void setUnsignedAttributes(Attribute[] attributeArray) {
        this.vB.setUnsignedAttributes(attributeArray);
    }

    public ASN1Object toASN1Object() {
        return this.vB.toASN1Object();
    }

    public String toString() {
        return this.vB.toString(false);
    }

    public String toString(boolean bl) {
        return this.vB.toString(bl);
    }

    public boolean verify(PublicKey publicKey, SignerInfo signerInfo) {
        return this.verify(publicKey, signerInfo.getSignatureValue());
    }

    public boolean verify(PublicKey publicKey, CounterSignature counterSignature) {
        return this.verify(publicKey, counterSignature.getSignatureValue());
    }

    public boolean verify(PublicKey publicKey, byte[] byArray) {
        SecurityProvider securityProvider = this.ux;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        try {
            AlgorithmID algorithmID = this.vB.getDigestAlgorithm();
            AlgorithmID algorithmID2 = this.vB.getSignatureAlgorithm();
            byte[] byArray2 = this.r(byArray);
            Attribute[] attributeArray = this.vB.getSignedAttributes();
            if (attributeArray != null && attributeArray.length > 0) {
                byte[] byArray3 = this.vB.getSignedDigest();
                if (!CryptoUtils.equalsBlock((byte[])byArray2, (byte[])byArray3)) {
                    throw new InvalidContentHashException("Content hash does not match to MessageDigest attribute value!");
                }
                boolean bl = securityProvider.verifySignatureFromSignedAttributes(algorithmID2, algorithmID, publicKey, DerCoder.encode((ASN1Object)ASN.createSetOf((ASN1Type[])attributeArray, (boolean)this.ua)), this.vB.getSignatureValue());
                this.a(attributeArray);
                return bl;
            }
            return securityProvider.verifySignatureFromHash(algorithmID2, algorithmID, publicKey, byArray2, this.vB.getSignatureValue());
        }
        catch (CMSSignatureException cMSSignatureException) {
            throw cMSSignatureException;
        }
        catch (Exception exception) {
            throw new CMSSignatureException(exception.toString(), this.vB.getSignerIdentifier());
        }
    }
}

