/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerInputStream;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.asn1.structures.Name;
import iaik.asn1.structures.PolicyInformation;
import iaik.cms.CMSException;
import iaik.cms.SecurityProvider;
import iaik.cms.a;
import iaik.cms.attributes.CMSContentType;
import iaik.cms.attributes.CMSMessageDigest;
import iaik.cms.b;
import iaik.security.provider.IAIK;
import iaik.smime.ess.ESSCertID;
import iaik.smime.ess.ESSCertIDv2;
import iaik.smime.ess.SigningCertificate;
import iaik.smime.ess.SigningCertificateV2;
import iaik.utils.CryptoUtils;
import iaik.utils.RFC2253NameParserException;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.AuthorityKeyIdentifier;
import iaik.x509.extensions.SubjectKeyIdentifier;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Utils {
    static double vy = -1.0;

    private Utils() {
    }

    /*
     * Unable to fully structure code
     */
    public static long copy(InputStream var0, OutputStream var1_1, byte[] var2_2) {
        block4: {
            if (var0 == null) {
                throw new NullPointerException("Argument \"source\" must not be null.");
            }
            if (var2_2 == null) {
                var2_2 = new byte[4096];
            }
            var3_3 = 0L;
            var5_4 = 0;
            if (var1_1 == null) ** GOTO lbl14
            while ((var5_4 = var0.read(var2_2)) >= 0) {
                var1_1.write(var2_2, 0, var5_4);
                var3_3 += (long)var5_4;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                var3_3 += (long)var5_4;
lbl14:
                // 2 sources

                ** while ((var5_4 = var0.read((byte[])var2_2)) >= 0)
            }
        }
        return var3_3;
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream, byte[] byArray) {
        if (inputStream == null) {
            throw new NullPointerException("Argument \"source\" must not be null.");
        }
        if (byArray == null) {
            byArray = new byte[4096];
        }
        if (outputStream != null) {
            int n2;
            while ((n2 = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n2);
            }
        } else {
            while (inputStream.read(byArray) >= 0) {
            }
        }
    }

    static X509Certificate[] a(X509Certificate x509Certificate, X509Certificate[] x509CertificateArray) {
        Object[] objectArray;
        if (x509Certificate == null) {
            throw new NullPointerException("Argument \"userCertificate\" must not be null.");
        }
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            return new X509Certificate[]{x509Certificate};
        }
        Vector<Object> vector = new Vector<Object>(4);
        try {
            Object object;
            Name name;
            X509Certificate x509Certificate2;
            objectArray = new Hashtable(x509CertificateArray.length + 2);
            int n2 = 0;
            while (n2 < x509CertificateArray.length) {
                x509Certificate2 = x509CertificateArray[n2];
                name = (Name)x509Certificate2.getSubjectDN();
                object = name.getRFC2253String();
                objectArray.put(object, x509Certificate2);
                ++n2;
            }
            vector.addElement(x509Certificate);
            x509Certificate2 = x509Certificate;
            object = (Name)x509Certificate2.getIssuerDN();
            String string = object.getRFC2253String();
            name = (X509Certificate)objectArray.get(string);
            int n3 = 20;
            while (name != null && !x509Certificate2.equals(name) && n3-- > 0) {
                AuthorityKeyIdentifier authorityKeyIdentifier = (AuthorityKeyIdentifier)x509Certificate2.getExtension(AuthorityKeyIdentifier.oid);
                SubjectKeyIdentifier subjectKeyIdentifier = (SubjectKeyIdentifier)name.getExtension(SubjectKeyIdentifier.oid);
                if (authorityKeyIdentifier == null || subjectKeyIdentifier == null || CryptoUtils.equalsBlock((byte[])authorityKeyIdentifier.getKeyIdentifier(), (byte[])subjectKeyIdentifier.get())) {
                    vector.addElement(name);
                    x509Certificate2 = name;
                    object = (Name)x509Certificate2.getIssuerDN();
                    string = object.getRFC2253String();
                    name = (X509Certificate)objectArray.get(string);
                    continue;
                }
                break;
            }
        }
        catch (RFC2253NameParserException rFC2253NameParserException) {
            throw new CertificateException("Error parsing dn: " + rFC2253NameParserException.toString());
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            throw new CertificateException("Error parsing cert extension: " + x509ExtensionInitException.toString());
        }
        objectArray = new X509Certificate[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static ASN1Object a(byte[] byArray, ASN1Object aSN1Object) {
        if (Utils.getIaikProviderVersion() < 3.13) {
            return aSN1Object;
        }
        return a.s(byArray);
    }

    public static double getIaikProviderVersion() {
        if (vy == -1.0) {
            Provider provider = Security.getProvider("IAIK");
            if (provider == null) {
                provider = new IAIK();
            }
            vy = provider.getVersion();
        }
        return vy;
    }

    public static boolean isClassAvailable(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static SigningCertificate makeSigningCertificate(ESSCertID[] eSSCertIDArray, PolicyInformation[] policyInformationArray) {
        SigningCertificate signingCertificate = new SigningCertificate(eSSCertIDArray);
        signingCertificate.setPolicies(policyInformationArray);
        return signingCertificate;
    }

    public static SigningCertificate makeSigningCertificate(Certificate[] certificateArray, PolicyInformation[] policyInformationArray, boolean bl) {
        return Utils.makeSigningCertificate(certificateArray, policyInformationArray, bl, null);
    }

    public static SigningCertificate makeSigningCertificate(Certificate[] certificateArray, PolicyInformation[] policyInformationArray, boolean bl, SecurityProvider securityProvider) {
        try {
            SigningCertificate signingCertificate = new SigningCertificate(certificateArray, bl, securityProvider);
            signingCertificate.setPolicies(policyInformationArray);
            return signingCertificate;
        }
        catch (Exception exception) {
            throw new CMSException("Cannot create ESS SigningCertificate: " + exception.getMessage());
        }
    }

    public static SigningCertificateV2 makeSigningCertificateV2(ESSCertIDv2[] eSSCertIDv2Array, PolicyInformation[] policyInformationArray) {
        SigningCertificateV2 signingCertificateV2 = new SigningCertificateV2(eSSCertIDv2Array);
        signingCertificateV2.setPolicies(policyInformationArray);
        return signingCertificateV2;
    }

    public static SigningCertificateV2 makeSigningCertificateV2(Certificate[] certificateArray, AlgorithmID algorithmID, PolicyInformation[] policyInformationArray, boolean bl) {
        return Utils.makeSigningCertificateV2(certificateArray, algorithmID, policyInformationArray, bl, null);
    }

    public static SigningCertificateV2 makeSigningCertificateV2(Certificate[] certificateArray, AlgorithmID algorithmID, PolicyInformation[] policyInformationArray, boolean bl, SecurityProvider securityProvider) {
        try {
            SigningCertificateV2 signingCertificateV2 = new SigningCertificateV2(certificateArray, algorithmID, bl, securityProvider);
            signingCertificateV2.setPolicies(policyInformationArray);
            return signingCertificateV2;
        }
        catch (Exception exception) {
            throw new CMSException("Cannot create ESS SigningCertificate: " + exception.getMessage());
        }
    }

    public static String printIndented(String string, boolean bl) {
        return Utils.printIndented(string, bl, " ");
    }

    public static String printIndented(String string, boolean bl, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        Utils.printIndented(string, bl, string2, stringBuffer);
        return stringBuffer.toString();
    }

    public static void printIndented(String string, boolean bl, String string2, StringBuffer stringBuffer) {
        String string3 = string2 == null ? "" : string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string4 = stringTokenizer.nextToken();
        if (!bl) {
            stringBuffer.append(string4);
        } else {
            stringBuffer.append(String.valueOf(string3) + string4);
        }
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("\n" + string3 + stringTokenizer.nextToken());
        }
    }

    public static void printIndented(String string, boolean bl, StringBuffer stringBuffer) {
        Utils.printIndented(string, bl, " ", stringBuffer);
    }

    static byte[] k(InputStream inputStream) {
        if (Utils.getIaikProviderVersion() < 5.3) {
            return new ASN1(inputStream).toByteArray();
        }
        return a.k(inputStream);
    }

    static InputStream c(DerInputStream derInputStream) {
        InputStream inputStream;
        DerInputStream derInputStream2 = derInputStream;
        while ((inputStream = derInputStream2.readOctetString()) instanceof DerInputStream) {
            derInputStream2 = (DerInputStream)inputStream;
        }
        return inputStream;
    }

    static void a(b b2, byte[] byArray, ObjectID objectID) {
        if (b2 != null && b2.size() > 0) {
            Attribute attribute = b2.getAttribute(CMSContentType.oid);
            ObjectID objectID2 = null;
            if (attribute != null) {
                objectID2 = (ObjectID)attribute.getValue()[0];
            }
            if (objectID2 != null) {
                if (!objectID2.equals((Object)objectID)) {
                    throw new CMSException("ContentType attribute does not match to eContentType of EncapsulatedContentInfo!");
                }
            } else {
                if (byArray != null) {
                    throw new CMSException("Missing ContentType attribute!");
                }
                try {
                    b2.addAttribute(new Attribute((AttributeValue)new CMSContentType(objectID)));
                }
                catch (CodingException codingException) {
                    throw new CMSException("Unable to set ContentType attribute: " + codingException.toString());
                }
            }
        }
    }

    static void a(b b2, byte[] byArray) {
        if (b2 != null && b2.size() > 0 && b2.getAttribute(CMSMessageDigest.oid) == null) {
            try {
                b2.addAttribute(new Attribute((AttributeValue)new CMSMessageDigest(byArray)));
            }
            catch (CodingException codingException) {
                throw new CMSException("Unable to set MessageDigest attribute: " + codingException.toString());
            }
        }
    }
}

