/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.SET;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.asn1.structures.UnknownAttributeValue;
import iaik.cms.CMSAlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.CMSObjectID;
import iaik.cms.CMSRuntimeException;
import iaik.cms.CMSSignatureException;
import iaik.cms.CMSVersion;
import iaik.cms.CertificateIdentifier;
import iaik.cms.DebugCMS;
import iaik.cms.InvalidContentHashException;
import iaik.cms.InvalidContentTypeException;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.SecurityProvider;
import iaik.cms.SignatureValue;
import iaik.cms.SignedAttributes;
import iaik.cms.SignedDataStream;
import iaik.cms.SignerIdentifier;
import iaik.cms.Utils;
import iaik.cms.aa;
import iaik.cms.attributes.CMSContentType;
import iaik.cms.attributes.CMSMessageDigest;
import iaik.cms.b;
import iaik.cms.s;
import iaik.cms.z;
import iaik.pkcs.pkcs1.RSAPssParameterSpec;
import iaik.security.rsa.RSAPrivateKey;
import iaik.security.rsa.RSAPssPrivateKey;
import iaik.security.rsa.RSAPssPublicKey;
import iaik.security.rsa.RSAPublicKey;
import iaik.smime.ess.SigningCertificate;
import iaik.smime.ess.SigningCertificateV2;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Locale;

public class SignerInfo
implements ASN1Type {
    private static boolean a = false;
    private s vq;
    private CMSVersion vr;
    private SignerIdentifier vt;
    private AlgorithmID sX;
    private SignedAttributes vu;
    private AlgorithmID uN;
    private SignatureValue vv;
    private b vw;
    private PrivateKey vx;
    private SecurityProvider ta;
    private boolean up;
    private boolean uq;

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    public SignerInfo() {
        this.d();
        this.sX = (AlgorithmID)AlgorithmID.sha256.clone();
        this.uN = (AlgorithmID)AlgorithmID.rsaEncryption.clone();
    }

    public SignerInfo(ASN1Object aSN1Object) {
        this.d();
        this.decode(aSN1Object);
    }

    private SignerInfo(CertificateIdentifier certificateIdentifier, AlgorithmID algorithmID, AlgorithmID algorithmID2, Key key) {
        if (certificateIdentifier == null) {
            throw new IllegalArgumentException("Signer ID must not be null!");
        }
        this.d();
        int n2 = certificateIdentifier.getKeyIdType();
        if (n2 == 1) {
            this.vr = new CMSVersion(3);
        } else if (n2 != 0) {
            throw new IllegalArgumentException("Invalid signerIdentifier! Expected SubjectKeyIdentifier or IssuerAndSerialNumber!");
        }
        this.vt = new SignerIdentifier(certificateIdentifier);
        if (algorithmID == null && algorithmID2 == null) {
            this.d(key);
        } else if (algorithmID == null) {
            this.sX = this.b(key, algorithmID2);
            this.uN = algorithmID2;
        } else if (algorithmID2 == null) {
            this.sX = algorithmID;
            this.uN = this.c(key, algorithmID);
        } else {
            this.sX = algorithmID;
            this.uN = algorithmID2;
        }
    }

    public SignerInfo(CertificateIdentifier certificateIdentifier, AlgorithmID algorithmID, AlgorithmID algorithmID2, PrivateKey privateKey) {
        this(certificateIdentifier, algorithmID, algorithmID2, (Key)privateKey);
        this.vx = privateKey;
    }

    public SignerInfo(CertificateIdentifier certificateIdentifier, AlgorithmID algorithmID, PrivateKey privateKey) {
        this(certificateIdentifier, algorithmID, null, privateKey);
    }

    public SignerInfo(X509Certificate x509Certificate, AlgorithmID algorithmID, AlgorithmID algorithmID2, PrivateKey privateKey) {
        this((CertificateIdentifier)new IssuerAndSerialNumber(x509Certificate), algorithmID, algorithmID2, x509Certificate.getPublicKey());
        this.vx = privateKey;
    }

    public SignerInfo(X509Certificate x509Certificate, AlgorithmID algorithmID, PrivateKey privateKey) {
        this((CertificateIdentifier)new IssuerAndSerialNumber(x509Certificate), algorithmID, null, x509Certificate.getPublicKey());
        this.vx = privateKey;
    }

    public SignerInfo(InputStream inputStream) {
        this(inputStream, false);
    }

    SignerInfo(InputStream inputStream, boolean bl) {
        this.d();
        if (bl) {
            this.b(inputStream, bl);
        } else {
            this.a(inputStream);
        }
    }

    public void addSignedAttribute(Attribute attribute) {
        this.vu.addAttribute(attribute);
        this.a();
        if (!this.uq) {
            this.vv = null;
        }
    }

    public void addSignedAttributes(Attribute[] attributeArray) {
        this.vu.addAttributes(attributeArray);
        if (!this.uq) {
            this.vv = null;
        }
    }

    public void addUnSignedAttribute(Attribute attribute) {
        this.vw.addAttribute(attribute);
    }

    public void addUnsignedAttribute(Attribute attribute) {
        this.vw.addAttribute(attribute);
    }

    public void addUnsignedAttributes(Attribute[] attributeArray) {
        this.vw.addAttributes(attributeArray);
    }

    private void a(b b2) {
    }

    void a() {
        ObjectID objectID;
        this.vr.getEncoded();
        if (this.vt != null) {
            this.vt.clearEncoded();
        }
        if (this.sX != null && this.sX instanceof CMSAlgorithmID) {
            ((CMSAlgorithmID)this.sX).clearEncoded();
        }
        if (this.vu != null) {
            this.vu.clearEncoded();
        }
        if (this.uN != null && this.uN instanceof CMSAlgorithmID) {
            ((CMSAlgorithmID)this.uN).clearEncoded();
        }
        if (this.vv != null) {
            this.vv.a();
        }
        if (this.vw != null) {
            this.vw.clearEncoded();
        }
        if (this.vq != null && this.vq instanceof SignedDataStream && (objectID = ((SignedDataStream)this.vq).getEncapsulatedContentType()) instanceof CMSObjectID) {
            ((CMSObjectID)objectID).clearEncoded();
        }
    }

    void b() {
        if (this.vv == null) {
            this.a();
            try {
                SecurityProvider securityProvider = this.ta;
                if (securityProvider == null) {
                    securityProvider = SecurityProvider.getSecurityProvider();
                }
                byte[] byArray = this.getDigest();
                if (this.vu.size() == 0) {
                    byte[] byArray2 = securityProvider.calculateSignatureFromHash(this.uN, this.sX, this.vx, byArray);
                    this.vv = new SignatureValue(byArray2);
                }
                Utils.a(this.vu, byArray);
                byte[] byArray3 = DerCoder.encode((ASN1Object)this.vu.toAsn1SET(true));
                this.setSignatureValue(securityProvider.calculateSignatureFromSignedAttributes(this.uN, this.sX, this.vx, byArray3));
            }
            catch (Exception exception) {
                throw new CMSException("Unable to calculate signature: " + exception.toString());
            }
        } else if (this.vu.size() > 0 && this.vu.getAttribute(CMSMessageDigest.oid) == null) {
            throw new CMSException("Message digest not included in signed attributes!");
        }
    }

    public void decode(ASN1Object aSN1Object) {
        try {
            ASN1Object aSN1Object2 = null;
            int n2 = 0;
            this.vr = new CMSVersion(aSN1Object.getComponentAt(0));
            this.vt = new SignerIdentifier(aSN1Object.getComponentAt(1));
            this.sX = new CMSAlgorithmID(aSN1Object.getComponentAt(2));
            aSN1Object2 = aSN1Object.getComponentAt(3);
            if (aSN1Object2.isA(ASN.CON_SPEC)) {
                ((CON_SPEC)aSN1Object2).forceImplicitlyTagged(ASN.SET);
                this.vu = new SignedAttributes((ASN1Object)aSN1Object2.getValue());
                ++n2;
            }
            this.uN = new AlgorithmID(aSN1Object.getComponentAt(3 + n2));
            this.vv = new SignatureValue(aSN1Object.getComponentAt(4 + n2));
            if (5 + n2 < aSN1Object.countComponents()) {
                CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(5 + n2);
                cON_SPEC.forceImplicitlyTagged(ASN.SET);
                this.vw = new b((ASN1Object)cON_SPEC.getValue());
            }
        }
        catch (CodingException codingException) {
            throw codingException;
        }
        catch (Exception exception) {
            throw new CodingException(exception.toString());
        }
    }

    void a(InputStream inputStream) {
        DerInputStream derInputStream = inputStream instanceof DerInputStream ? (DerInputStream)inputStream : new DerInputStream(inputStream);
        try {
            int n2;
            block9: {
                Object var3_3 = null;
                boolean bl = false;
                this.vr = new CMSVersion((InputStream)derInputStream);
                this.vt = new SignerIdentifier((InputStream)derInputStream);
                this.sX = CMSAlgorithmID.b(derInputStream);
                if (derInputStream.nextIsContextSpecific()) {
                    this.vu = new SignedAttributes((InputStream)derInputStream, true);
                }
                this.uN = CMSAlgorithmID.b(derInputStream);
                this.vv = new SignatureValue((InputStream)derInputStream);
                n2 = -1;
                try {
                    n2 = derInputStream.nextTag();
                }
                catch (IOException iOException) {
                    if (!a) break block9;
                    System.err.println("Error reading SignerInfo: " + iOException.toString());
                    throw iOException;
                }
            }
            if (n2 != -1) {
                if (!derInputStream.nextIsContextSpecific()) {
                    throw new CodingException("Invalid encoding of unsigned attributes! Expetced context specific!");
                }
                n2 = derInputStream.readContextSpecific(17);
                if (n2 != 1) {
                    throw new CodingException("Invalid tag (" + n2 + ") in unsigned attributes encoding! Expected 1!");
                }
                this.vw = new b((InputStream)derInputStream);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    void b(InputStream inputStream, boolean bl) {
        DerInputStream derInputStream;
        aa aa2 = null;
        if (bl) {
            aa2 = new aa(inputStream, 4096);
            derInputStream = new DerInputStream((InputStream)aa2);
            aa2.a(derInputStream);
        } else {
            derInputStream = inputStream instanceof DerInputStream ? (DerInputStream)inputStream : new DerInputStream(inputStream);
        }
        aa aa3 = aa2 != null ? aa2 : derInputStream;
        try {
            int n2;
            block17: {
                Object var6_6 = null;
                boolean bl2 = false;
                this.vr = new CMSVersion(aa3, bl);
                this.vt = new SignerIdentifier(aa3, bl);
                if (bl) {
                    n2 = aa2.c();
                    this.sX = CMSAlgorithmID.b(derInputStream);
                    ((CMSAlgorithmID)this.sX).a(aa2.a(n2));
                } else {
                    this.sX = new CMSAlgorithmID(derInputStream);
                }
                if (bl) {
                    n2 = 0;
                    if (derInputStream.nextIsContextSpecific()) {
                        this.vu = new SignedAttributes(aa3, bl);
                    } else {
                        --n2;
                    }
                    this.uN = CMSAlgorithmID.b(derInputStream);
                    ((CMSAlgorithmID)this.uN).a(aa2.a(n2 += aa2.c()));
                } else {
                    if (derInputStream.nextIsContextSpecific()) {
                        this.vu = new SignedAttributes(aa3, bl);
                    }
                    this.uN = new CMSAlgorithmID(derInputStream);
                }
                this.vv = new SignatureValue(aa3, bl);
                n2 = -1;
                try {
                    n2 = derInputStream.nextTag();
                }
                catch (IOException iOException) {
                    if (!a) break block17;
                    System.err.println("Error reading SignerInfo: " + iOException.toString());
                    throw iOException;
                }
            }
            if (n2 != -1) {
                if (!derInputStream.nextIsContextSpecific()) {
                    throw new CodingException("Invalid encoding of unsigned attributes! Expetced context specific!");
                }
                n2 = derInputStream.readContextSpecific(17);
                if (n2 != 1) {
                    throw new CodingException("Invalid tag (" + n2 + ") in unsigned attributes encoding! Expected 1!");
                }
                this.vw = new b(aa3, bl);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    private AlgorithmID a(Key key) {
        AlgorithmID algorithmID = null;
        if (key != null) {
            String string;
            SecurityProvider securityProvider = this.ta;
            if (securityProvider == null) {
                securityProvider = SecurityProvider.getSecurityProvider();
            }
            if ((string = key.getAlgorithm()).equalsIgnoreCase("RSA")) {
                algorithmID = this.b(key);
            } else if (string.equalsIgnoreCase("RSASSA-PSS")) {
                algorithmID = this.c(key);
            } else if (string.equalsIgnoreCase("DSA")) {
                int n2 = securityProvider.getKeyLength(key);
                if (n2 <= 1024) {
                    algorithmID = (AlgorithmID)AlgorithmID.sha1.clone();
                } else {
                    try {
                        securityProvider.getSignature("SHA256withDSA", 0, null);
                        algorithmID = (AlgorithmID)AlgorithmID.sha256.clone();
                    }
                    catch (Throwable throwable) {
                        algorithmID = (AlgorithmID)AlgorithmID.sha1.clone();
                    }
                }
            } else if (string.equalsIgnoreCase("SHA224WITHDSA")) {
                algorithmID = (AlgorithmID)AlgorithmID.sha224.clone();
            } else if (string.equalsIgnoreCase("SHA256WITHDSA")) {
                algorithmID = (AlgorithmID)AlgorithmID.sha256.clone();
            } else if (string.equalsIgnoreCase("ECDSA") || string.equalsIgnoreCase("EC")) {
                int n3 = securityProvider.getKeyLength(key);
                algorithmID = n3 < 384 ? (AlgorithmID)AlgorithmID.sha256.clone() : (n3 < 512 ? (AlgorithmID)AlgorithmID.sha384.clone() : (AlgorithmID)AlgorithmID.sha512.clone());
            }
        }
        if (algorithmID == null) {
            algorithmID = (AlgorithmID)AlgorithmID.sha256.clone();
        }
        return algorithmID;
    }

    private AlgorithmID b(Key key, AlgorithmID algorithmID) {
        AlgorithmID algorithmID2 = null;
        if (algorithmID == null) {
            algorithmID2 = this.a(key);
        } else if (algorithmID.equals((Object)AlgorithmID.rsaEncryption)) {
            algorithmID2 = this.b(key);
        } else if (algorithmID.equals((Object)AlgorithmID.rsassaPss)) {
            algorithmID2 = this.c(key);
        } else {
            String string = algorithmID.getName();
            if (string != null) {
                if ((string = string.toUpperCase(Locale.US)).indexOf("SHA256") != -1) {
                    algorithmID2 = (AlgorithmID)AlgorithmID.sha256.clone();
                } else if (string.indexOf("SHA512") != -1) {
                    algorithmID2 = (AlgorithmID)AlgorithmID.sha512.clone();
                } else if (string.indexOf("SHA384") != -1) {
                    algorithmID2 = (AlgorithmID)AlgorithmID.sha384.clone();
                } else if (string.indexOf("SHA224") != -1) {
                    algorithmID2 = (AlgorithmID)AlgorithmID.sha224.clone();
                } else if (string.indexOf("SHA1") != -1 || string.indexOf("SHA") != -1) {
                    algorithmID2 = (AlgorithmID)AlgorithmID.sha1.clone();
                } else if (string.indexOf("RIPEMD160") != -1) {
                    algorithmID2 = (AlgorithmID)AlgorithmID.ripeMd160.clone();
                } else if (string.indexOf("RIPEMD128") != -1) {
                    algorithmID2 = (AlgorithmID)AlgorithmID.ripeMd128.clone();
                } else if (string.indexOf("WHIRLPOOL") != -1) {
                    algorithmID2 = (AlgorithmID)AlgorithmID.whirlpool.clone();
                } else if (string.indexOf("MD5") != -1) {
                    algorithmID2 = (AlgorithmID)AlgorithmID.md5.clone();
                } else if (string.indexOf("MD2") != -1) {
                    algorithmID2 = (AlgorithmID)AlgorithmID.md2.clone();
                } else if (string.indexOf("MD4") != -1) {
                    algorithmID2 = (AlgorithmID)AlgorithmID.md4.clone();
                }
            }
        }
        if (algorithmID2 == null) {
            algorithmID2 = (AlgorithmID)AlgorithmID.sha256.clone();
        }
        return algorithmID2;
    }

    private final AlgorithmID b(Key key) {
        int n2;
        SecurityProvider securityProvider = this.ta;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        AlgorithmID algorithmID = (n2 = securityProvider.getKeyLength(key)) <= 3072 ? (AlgorithmID)AlgorithmID.sha256.clone() : (n2 <= 7680 ? (AlgorithmID)AlgorithmID.sha384.clone() : (AlgorithmID)AlgorithmID.sha512.clone());
        return algorithmID;
    }

    private final AlgorithmID c(Key key) {
        AlgorithmID algorithmID;
        block8: {
            algorithmID = null;
            try {
                RSAPublicKey rSAPublicKey;
                AlgorithmParameterSpec algorithmParameterSpec = null;
                if (key instanceof PrivateKey) {
                    RSAPrivateKey rSAPrivateKey = Util.getRSAPrivateKey((Key)key);
                    if (rSAPrivateKey instanceof RSAPssPrivateKey) {
                        algorithmParameterSpec = ((RSAPssPrivateKey)rSAPrivateKey).getParams();
                    }
                } else if (key instanceof PublicKey && (rSAPublicKey = Util.getRSAPublicKey((Key)key)) instanceof RSAPssPublicKey) {
                    algorithmParameterSpec = ((RSAPssPublicKey)rSAPublicKey).getParams();
                }
                if (algorithmParameterSpec != null) {
                    algorithmID = ((RSAPssParameterSpec)algorithmParameterSpec).getHashAlgorithm();
                }
            }
            catch (Exception exception) {
                if (!a) break block8;
                System.err.println("Error parsing RSA-PSS key: " + exception.toString());
            }
        }
        if (algorithmID == null) {
            algorithmID = this.b(key);
        }
        return algorithmID;
    }

    private void d(Key key) {
        if (key != null) {
            String string;
            SecurityProvider securityProvider = this.ta;
            if (securityProvider == null) {
                securityProvider = SecurityProvider.getSecurityProvider();
            }
            if ((string = key.getAlgorithm()).equalsIgnoreCase("RSA")) {
                this.uN = (AlgorithmID)AlgorithmID.rsaEncryption.clone();
                this.sX = this.b(key);
            } else if (string.equalsIgnoreCase("RSASSA-PSS")) {
                this.uN = (AlgorithmID)AlgorithmID.rsassaPss.clone();
                this.sX = this.c(key);
            } else if (string.equalsIgnoreCase("DSA")) {
                int n2 = securityProvider.getKeyLength(key);
                if (n2 <= 1024) {
                    this.sX = (AlgorithmID)AlgorithmID.sha1.clone();
                    this.uN = (AlgorithmID)AlgorithmID.dsaWithSHA.clone();
                } else {
                    try {
                        securityProvider.getSignature("SHA256withDSA", 0, null);
                        this.sX = (AlgorithmID)AlgorithmID.sha256.clone();
                        this.uN = (AlgorithmID)AlgorithmID.dsaWithSHA256.clone();
                    }
                    catch (Throwable throwable) {
                        this.sX = (AlgorithmID)AlgorithmID.sha1.clone();
                        this.uN = (AlgorithmID)AlgorithmID.dsaWithSHA.clone();
                    }
                }
            } else if (string.equalsIgnoreCase("SHA224WITHDSA")) {
                this.sX = (AlgorithmID)AlgorithmID.sha224.clone();
                this.uN = (AlgorithmID)AlgorithmID.dsaWithSHA224.clone();
            } else if (string.equalsIgnoreCase("SHA256WITHDSA")) {
                this.sX = (AlgorithmID)AlgorithmID.sha256.clone();
                this.uN = (AlgorithmID)AlgorithmID.dsaWithSHA256.clone();
            } else if (string.equalsIgnoreCase("ECDSA") || string.equalsIgnoreCase("EC")) {
                int n3 = securityProvider.getKeyLength(key);
                if (n3 <= 256) {
                    this.sX = (AlgorithmID)AlgorithmID.sha256.clone();
                    this.uN = (AlgorithmID)CMSAlgorithmID.ecdsa_With_SHA256.clone();
                } else if (n3 <= 384) {
                    this.sX = (AlgorithmID)AlgorithmID.sha384.clone();
                    this.uN = (AlgorithmID)CMSAlgorithmID.ecdsa_With_SHA384.clone();
                } else {
                    this.sX = (AlgorithmID)AlgorithmID.sha512.clone();
                    this.uN = (AlgorithmID)CMSAlgorithmID.ecdsa_With_SHA512.clone();
                }
            }
        }
        if (this.sX == null) {
            this.sX = (AlgorithmID)AlgorithmID.sha256.clone();
        }
        if (this.uN == null) {
            this.uN = (AlgorithmID)AlgorithmID.rsaEncryption.clone();
        }
    }

    private AlgorithmID c(Key key, AlgorithmID algorithmID) {
        AlgorithmID algorithmID2 = null;
        if (key == null) {
            algorithmID2 = (AlgorithmID)AlgorithmID.rsaEncryption.clone();
        } else {
            String string = key.getAlgorithm();
            if (string.equalsIgnoreCase("RSA")) {
                algorithmID2 = (AlgorithmID)AlgorithmID.rsaEncryption.clone();
            } else if (string.equalsIgnoreCase("RSASSA-PSS")) {
                algorithmID2 = (AlgorithmID)AlgorithmID.rsassaPss.clone();
            } else if (string.equalsIgnoreCase("DSA")) {
                if (algorithmID.equals((Object)AlgorithmID.sha) || algorithmID.equals((Object)AlgorithmID.sha1)) {
                    algorithmID2 = (AlgorithmID)AlgorithmID.dsaWithSHA.clone();
                } else if (algorithmID.equals((Object)AlgorithmID.sha224)) {
                    algorithmID2 = (AlgorithmID)AlgorithmID.dsaWithSHA224.clone();
                } else if (algorithmID.equals((Object)AlgorithmID.sha256)) {
                    algorithmID2 = (AlgorithmID)AlgorithmID.dsaWithSHA256.clone();
                }
            } else if (string.equalsIgnoreCase("ECDSA") || string.equalsIgnoreCase("EC")) {
                if (algorithmID.equals((Object)AlgorithmID.sha) || algorithmID.equals((Object)AlgorithmID.sha1)) {
                    algorithmID2 = (AlgorithmID)AlgorithmID.ecdsa_With_SHA1.clone();
                } else if (algorithmID.equals((Object)AlgorithmID.sha224)) {
                    algorithmID2 = (AlgorithmID)CMSAlgorithmID.ecdsa_With_SHA224.clone();
                } else if (algorithmID.equals((Object)AlgorithmID.sha256)) {
                    algorithmID2 = (AlgorithmID)CMSAlgorithmID.ecdsa_With_SHA256.clone();
                } else if (algorithmID.equals((Object)AlgorithmID.sha384)) {
                    algorithmID2 = (AlgorithmID)CMSAlgorithmID.ecdsa_With_SHA384.clone();
                } else if (algorithmID.equals((Object)AlgorithmID.sha512)) {
                    algorithmID2 = (AlgorithmID)CMSAlgorithmID.ecdsa_With_SHA512.clone();
                }
            } else {
                algorithmID2 = (AlgorithmID)AlgorithmID.rsaEncryption.clone();
            }
        }
        return algorithmID2;
    }

    public CMSVersion getCMSVersion() {
        return this.vr;
    }

    public byte[] getDigest() {
        try {
            return this.vq.getMessageDigest(this.sX);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Digest algorithm not available: " + noSuchAlgorithmException.getMessage());
        }
        catch (CMSRuntimeException cMSRuntimeException) {
            throw new CMSException("Error calculating digest for algorithm " + this.sX.getAlgorithm().getName() + ": " + cMSRuntimeException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            if (this.sX != null) {
                throw new CMSException("Error calculating digest for algorithm " + this.sX.getAlgorithm().getName() + ": " + ((Throwable)nullPointerException).getMessage());
            }
            throw new CMSException("Cannot calculate digest value!");
        }
    }

    public AlgorithmID getDigestAlgorithm() {
        return this.sX;
    }

    public SecurityProvider getSecurityProvider() {
        return this.ta;
    }

    public SignatureValue getSigValue() {
        return this.vv;
    }

    public AlgorithmID getSignatureAlgorithm() {
        return this.uN;
    }

    public byte[] getSignatureValue() {
        return this.vv == null ? null : this.vv.getValue();
    }

    boolean c() {
        return this.uq;
    }

    public Attribute getSignedAttribute(ObjectID objectID) {
        return this.vu.getAttribute(objectID);
    }

    public AttributeValue getSignedAttributeValue(ObjectID objectID) {
        AttributeValue attributeValue = null;
        Attribute attribute = this.getSignedAttribute(objectID);
        if (attribute != null) {
            try {
                attributeValue = attribute.getAttributeValue();
                if (attributeValue instanceof UnknownAttributeValue) {
                    attributeValue = b.a((UnknownAttributeValue)attributeValue);
                }
            }
            catch (CodingException codingException) {
                throw new CMSException("Cannot decode attribute " + objectID.getName() + ": " + codingException.getMessage());
            }
        }
        return attributeValue;
    }

    public Attribute[] getSignedAttributes() {
        return this.vu.toArray();
    }

    public Attribute[] getSignedAttributes(ObjectID objectID) {
        return this.vu.getAttributes(objectID);
    }

    public SignedAttributes getSignedAttrs() {
        return this.vu;
    }

    public byte[] getSignedDigest() {
        if (this.vu.size() == 0) {
            throw new CMSException("No signed attributes included!");
        }
        try {
            AttributeValue attributeValue = this.getSignedAttributeValue(CMSMessageDigest.oid);
            if (attributeValue == null) {
                throw new CMSException("MessageDigest not included in signed attributes!");
            }
            CMSMessageDigest cMSMessageDigest = attributeValue instanceof CMSMessageDigest ? (CMSMessageDigest)attributeValue : new CMSMessageDigest(attributeValue.toASN1Object());
            return cMSMessageDigest.getDigest();
        }
        catch (CodingException codingException) {
            throw new CMSException("Error parsing MessageDigest attribute: " + codingException.toString());
        }
    }

    public SignerIdentifier getSignerId() {
        return this.vt;
    }

    public CertificateIdentifier getSignerIdentifier() {
        return this.vt.getCertificateIdentifier();
    }

    public SigningCertificate getSigningCertificateAttribute() {
        SigningCertificate signingCertificate = null;
        Attribute[] attributeArray = this.getSignedAttributes(ObjectID.signingCertificate);
        if (attributeArray != null && attributeArray.length > 0) {
            if (attributeArray.length > 1) {
                throw new CMSException("SignerInfo contains more than only one SigningCertificate attributes!");
            }
            try {
                AttributeValue[] attributeValueArray = attributeArray[0].getAttributeValues();
                if (attributeValueArray != null) {
                    int n2 = attributeValueArray.length;
                    if (n2 == 0) {
                        throw new CMSException("SigningCertificate attribute must not be empty!");
                    }
                    if (n2 > 1) {
                        throw new CMSException("SigningCertificate attribute contains more than only one value!");
                    }
                    AttributeValue attributeValue = attributeValueArray[0];
                    signingCertificate = attributeValue instanceof SigningCertificate ? (SigningCertificate)attributeValue : new SigningCertificate(attributeValue.toASN1Object());
                    signingCertificate.setSecurityProvider(this.ta);
                }
            }
            catch (CodingException codingException) {
                throw new CMSException("Error when parsing SigningCertificate attribute: " + codingException.getMessage());
            }
        }
        return signingCertificate;
    }

    public SigningCertificateV2 getSigningCertificateV2Attribute() {
        SigningCertificateV2 signingCertificateV2 = null;
        Attribute[] attributeArray = this.getSignedAttributes(SigningCertificateV2.oid);
        if (attributeArray != null && attributeArray.length > 0) {
            if (attributeArray.length > 1) {
                throw new CMSException("SignerInfo contains more than only one SigningCertificateV2 attributes!");
            }
            try {
                AttributeValue[] attributeValueArray = attributeArray[0].getAttributeValues();
                if (attributeValueArray != null) {
                    int n2 = attributeValueArray.length;
                    if (n2 == 0) {
                        throw new CMSException("SigningCertificateV2 attribute must not be empty!");
                    }
                    if (n2 > 1) {
                        throw new CMSException("SigningCertificateV2 attribute contains more than only one value!");
                    }
                    AttributeValue attributeValue = attributeValueArray[0];
                    signingCertificateV2 = attributeValue instanceof SigningCertificateV2 ? (SigningCertificateV2)attributeValue : new SigningCertificateV2(attributeValue.toASN1Object());
                    signingCertificateV2.setSecurityProvider(this.ta);
                }
            }
            catch (CodingException codingException) {
                throw new CMSException("Error when parsing SigningCertificateV2 attribute: " + codingException.getMessage());
            }
        }
        return signingCertificateV2;
    }

    public Attribute getUnsignedAttribute(ObjectID objectID) {
        return this.vw.getAttribute(objectID);
    }

    public AttributeValue getUnsignedAttributeValue(ObjectID objectID) {
        AttributeValue attributeValue = null;
        Attribute attribute = this.getUnsignedAttribute(objectID);
        if (attribute != null) {
            try {
                attributeValue = attribute.getAttributeValue();
                if (attributeValue instanceof UnknownAttributeValue) {
                    attributeValue = b.a((UnknownAttributeValue)attributeValue);
                }
            }
            catch (CodingException codingException) {
                throw new CMSException("Cannot decode attribute " + objectID.getName() + ": " + codingException.getMessage());
            }
        }
        return attributeValue;
    }

    public Attribute[] getUnsignedAttributes() {
        return this.vw.toArray();
    }

    public Attribute[] getUnsignedAttributes(ObjectID objectID) {
        return this.vw.getAttributes(objectID);
    }

    public int getVersion() {
        return this.vr.getVersion();
    }

    private void d() {
        this.vr = new CMSVersion(1);
        this.up = false;
        boolean bl = false;
        this.vu = new SignedAttributes();
        this.vw = new b();
    }

    public boolean isSignerCertificate(X509Certificate x509Certificate) {
        boolean bl = false;
        if (this.vt.identifiesCert(x509Certificate)) {
            if (this.vu.size() == 0) {
                bl = true;
            } else {
                SigningCertificate signingCertificate = this.getSigningCertificateAttribute();
                SigningCertificateV2 signingCertificateV2 = this.getSigningCertificateV2Attribute();
                if (signingCertificate == null && signingCertificateV2 == null) {
                    bl = true;
                } else {
                    try {
                        boolean bl2 = true;
                        if (signingCertificate != null) {
                            bl2 = signingCertificate.isSignerCertificate(x509Certificate);
                        }
                        if (bl2) {
                            boolean bl3 = true;
                            if (signingCertificateV2 != null) {
                                bl3 = signingCertificateV2.isSignerCertificate(x509Certificate);
                            }
                            bl = bl2 && bl3;
                        }
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new CMSException("Cannot check included SigningCertificate attribute: Algorithm not supported: " + noSuchAlgorithmException.toString());
                    }
                }
            }
        }
        return bl;
    }

    public void removeSignedAttribute(ObjectID objectID) {
        if (objectID != null) {
            this.vu.removeAttribute(objectID);
            this.a();
            if (!this.uq) {
                this.vv = null;
            }
        }
    }

    public void removeUnSignedAttribute(ObjectID objectID) {
        if (objectID != null) {
            this.vw.removeAttribute(objectID);
        }
    }

    public void removeUnsignedAttribute(ObjectID objectID) {
        if (objectID != null) {
            this.vw.removeAttribute(objectID);
        }
    }

    void a(ObjectID objectID) {
        this.a();
        byte[] byArray = this.vv == null ? null : this.vv.getValue();
        Utils.a(this.vu, byArray, objectID);
    }

    void a(s s2) {
        this.vq = s2;
    }

    public void setEncryptedDigest(byte[] byArray) {
        this.setSignatureValue(byArray);
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.ta = securityProvider;
    }

    public void setSignatureValue(byte[] byArray) {
        this.a();
        this.vv = byArray == null ? null : new SignatureValue(byArray);
        this.uq = true;
        this.up = true;
    }

    public void setSignedAttributes(Attribute[] attributeArray) {
        this.vu.clearAll();
        this.vu.addAttributes(attributeArray);
        if (!this.uq) {
            this.vv = null;
        }
    }

    public void setUnsignedAttributes(Attribute[] attributeArray) {
        this.vw.clearAll();
        this.vw.addAttributes(attributeArray);
    }

    private ASN1Object l(AlgorithmID algorithmID) {
        String string;
        ASN1Object aSN1Object = null;
        String string2 = null;
        try {
            string2 = algorithmID.getImplementationName();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        boolean bl = true;
        if (string2 != null && (string = string2.toUpperCase(Locale.US)).indexOf("DSA") != -1 && string.indexOf("ECDSA") == -1) {
            bl = false;
        }
        if (!bl) {
            algorithmID.setParameter(null);
            aSN1Object = algorithmID.toASN1Object(false);
        } else {
            aSN1Object = algorithmID.toASN1Object();
        }
        return aSN1Object;
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        try {
            ASN1Object aSN1Object;
            sEQUENCE.addComponent(this.vr.toASN1Object());
            sEQUENCE.addComponent(new z(this.vt).toASN1Object());
            sEQUENCE.addComponent(this.sX.toASN1Object());
            this.b();
            if (this.vu.size() > 0) {
                aSN1Object = this.vu.m(this.up);
                sEQUENCE.addComponent(aSN1Object);
            }
            aSN1Object = this.l(this.uN);
            sEQUENCE.addComponent(aSN1Object);
            sEQUENCE.addComponent(this.vv.toASN1Object());
            if (this.vw.size() > 0) {
                this.a(this.vw);
                SET sET = this.vw.toAsn1SET(true);
                sEQUENCE.addComponent((ASN1Object)new CON_SPEC(1, (ASN1Object)sET, true));
            }
        }
        catch (Exception exception) {
            throw new CodingException(exception.toString());
        }
        return sEQUENCE;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.vr + "\n");
        stringBuffer.append("SignerID: {\n");
        Utils.printIndented(this.vt.toString(), true, stringBuffer);
        stringBuffer.append("\n}\n");
        stringBuffer.append("DigestAlgorithm: " + this.sX + "\n");
        stringBuffer.append("SignatureAlgorithm: " + this.uN + "\n");
        stringBuffer.append("SignatureValue: ");
        if (this.vv != null) {
            byte[] byArray = this.vv.getValue();
            stringBuffer.append(String.valueOf(byArray.length) + " Bytes [" + Util.toString((byte[])byArray, (int)0, (int)5) + "...]");
        }
        stringBuffer.append("\n");
        stringBuffer.append("Signed Attributes: {\n");
        if (this.vu.size() > 0) {
            Utils.printIndented(this.vu.toString(), true, stringBuffer);
        }
        stringBuffer.append("\n}\n");
        stringBuffer.append("Unsigned Attributes: {\n");
        if (this.vw.size() > 0) {
            Utils.printIndented(this.vw.toString(), true, stringBuffer);
        }
        stringBuffer.append("\n}\n");
        return stringBuffer.toString();
    }

    public boolean verifySignature(PublicKey publicKey) {
        byte[] byArray = null;
        try {
            byArray = this.getDigest();
        }
        catch (CMSException cMSException) {
            throw new CMSSignatureException("Digest algorithm not available: " + cMSException.getMessage(), cMSException, this.vt);
        }
        return this.verifySignature(byArray, publicKey);
    }

    public boolean verifySignature(byte[] byArray, PublicKey publicKey) {
        SecurityProvider securityProvider = this.ta;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        CMSSignatureException cMSSignatureException = null;
        try {
            if (this.vu.size() > 0) {
                Object object;
                byte[] byArray2 = this.getSignedDigest();
                if (!CryptoUtils.equalsBlock((byte[])byArray, (byte[])byArray2)) {
                    throw new InvalidContentHashException("Content hash does not match to MessageDigest attribute value!", (CertificateIdentifier)this.vt);
                }
                boolean bl = false;
                byte[] byArray3 = this.vu.a(false, this.up);
                try {
                    bl = securityProvider.verifySignatureFromSignedAttributes(this.uN, this.sX, publicKey, byArray3, this.vv.getValue());
                }
                catch (CMSSignatureException cMSSignatureException2) {
                    cMSSignatureException = cMSSignatureException2;
                    bl = false;
                }
                if (!(bl || this.up || CryptoUtils.equalsBlock((byte[])byArray3, (byte[])(object = DerCoder.encode((ASN1Object)this.vu.toAsn1SET(true)))))) {
                    bl = securityProvider.verifySignatureFromSignedAttributes(this.uN, this.sX, publicKey, (byte[])object, this.vv.getValue());
                }
                if (bl) {
                    object = null;
                    AttributeValue attributeValue = this.getSignedAttributeValue(CMSContentType.oid);
                    if (attributeValue != null) {
                        object = (Object)(attributeValue instanceof CMSContentType ? (CMSContentType)attributeValue : new CMSContentType(attributeValue.toASN1Object()));
                    }
                    if (object != null) {
                        if (!object.get().equals((Object)((SignedDataStream)this.vq).getEncapsulatedContentType())) {
                            throw new InvalidContentTypeException("ContentType attribute does not match to eContentType of EncapsulatedContentInfo!", (CertificateIdentifier)this.vt);
                        }
                    } else if (this.vq != null) {
                        throw new InvalidContentTypeException("Missing signed ContentType attribute!", (CertificateIdentifier)this.vt);
                    }
                }
                return bl;
            }
            return securityProvider.verifySignatureFromHash(this.uN, this.sX, publicKey, byArray, this.vv.getValue());
        }
        catch (CodingException codingException) {
            if (cMSSignatureException != null) {
                throw cMSSignatureException;
            }
            throw new CMSSignatureException("Error encoding signed attributes: " + codingException.toString(), (Exception)((Object)codingException), this.vt);
        }
        catch (CMSSignatureException cMSSignatureException3) {
            throw cMSSignatureException3;
        }
        catch (Exception exception) {
            if (cMSSignatureException != null) {
                throw cMSSignatureException;
            }
            throw new CMSSignatureException(exception, (CertificateIdentifier)this.vt);
        }
    }
}

