/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.EncodeListener;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.CMSRuntimeException;
import iaik.cms.CMSSignatureException;
import iaik.cms.CertificateChoices;
import iaik.cms.CertificateIdentifier;
import iaik.cms.CertificateNotFoundException;
import iaik.cms.CertificateSet;
import iaik.cms.ContentStream;
import iaik.cms.DebugCMS;
import iaik.cms.EncapsulatedContentInfo;
import iaik.cms.EncapsulatedContentInfoStream;
import iaik.cms.InputStreamHashEngine;
import iaik.cms.InvalidSignatureValueException;
import iaik.cms.RevocationInfoChoices;
import iaik.cms.SDSEncodeListener;
import iaik.cms.SecurityProvider;
import iaik.cms.SignedDataInOutStream;
import iaik.cms.SignerInfo;
import iaik.cms.Utils;
import iaik.cms.e;
import iaik.cms.s;
import iaik.utils.EOFListener;
import iaik.utils.NotifyEOFInputStream;
import iaik.utils.Util;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import iaik.x509.attr.AttributeCertificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

public class SignedDataStream
implements EncodeListener,
ContentStream,
s,
EOFListener {
    private static boolean a = false;
    public static final int IMPLICIT = 1;
    public static final int EXPLICIT = 2;
    protected int version_ = 1;
    DigestVector vl = new DigestVector(this);
    protected ObjectID contentType_;
    protected EncapsulatedContentInfoStream encapContentInfo_;
    protected CertificateSet certSet_;
    protected RevocationInfoChoices crls_;
    protected Vector signerInfos_ = new Vector();
    protected DerInputStream thisObject_;
    protected InputStream inputStream_;
    protected int mode_ = 1;
    protected int blockSize_ = 2048;
    protected SecurityProvider securityProvider_;
    private ArrayList vm;
    OutputStream d;
    private boolean g;
    static Class e;
    static Class f;

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    protected SignedDataStream() {
        this.certSet_ = new CertificateSet();
        this.crls_ = new RevocationInfoChoices();
    }

    public SignedDataStream(ObjectID objectID) {
        this();
        if (objectID == null) {
            throw new NullPointerException("contentType must not be null!");
        }
        this.mode_ = 2;
        this.contentType_ = objectID;
        if (!this.contentType_.equals((Object)ObjectID.cms_data)) {
            this.version_ = 3;
        }
    }

    public SignedDataStream(InputStream inputStream) {
        this(inputStream, (SecurityProvider)null);
    }

    public SignedDataStream(InputStream inputStream, int n2) {
        this();
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Illegal mode specification: " + n2 + "! Expected " + 1 + " (implicit) or " + 2 + " (explicit)");
        }
        this.contentType_ = ObjectID.cms_data;
        this.inputStream_ = inputStream;
        this.mode_ = n2;
    }

    public SignedDataStream(InputStream inputStream, ObjectID objectID, int n2) {
        this();
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Illegal mode specification: " + n2 + "! Expected " + 1 + " (implicit) or " + 2 + " (explicit)");
        }
        if (objectID == null) {
            throw new NullPointerException("contentType must not be null!");
        }
        this.contentType_ = objectID;
        this.inputStream_ = inputStream;
        this.mode_ = n2;
        if (!this.contentType_.equals((Object)ObjectID.cms_data)) {
            this.version_ = 3;
        }
    }

    public SignedDataStream(InputStream inputStream, SecurityProvider securityProvider) {
        this();
        this.securityProvider_ = securityProvider;
        this.decode(inputStream);
    }

    public SignedDataStream(InputStream inputStream, AlgorithmID[] algorithmIDArray) {
        this(inputStream, algorithmIDArray, null);
    }

    public SignedDataStream(InputStream inputStream, AlgorithmID[] algorithmIDArray, SecurityProvider securityProvider) {
        this();
        this.securityProvider_ = securityProvider;
        this.inputStream_ = inputStream;
        this.mode_ = 2;
        this.vl = new DigestVector(this, algorithmIDArray);
        try {
            this.inputStream_ = this.vl.d(this.inputStream_, true);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("No implementation for hash algorithm: " + noSuchAlgorithmException.getMessage());
        }
    }

    public void addCRLs(X509CRL[] x509CRLArray) {
        if (x509CRLArray != null && x509CRLArray.length > 0) {
            this.crls_.addRevocationInfos((CRL[])x509CRLArray);
            this.a();
        }
    }

    public void addCertificates(Certificate[] certificateArray) {
        if (certificateArray != null && certificateArray.length > 0) {
            this.certSet_.addCertificates(certificateArray);
            this.a();
        }
    }

    public void addDigestAlgorithm(AlgorithmID algorithmID) {
        boolean bl = this.vl.a(algorithmID, true);
        if (bl) {
            this.inputStream_ = this.vl.d(this.inputStream_, false);
        }
    }

    public void addSDSEncodeListener(SDSEncodeListener sDSEncodeListener) {
        if (this.vm == null) {
            this.vm = new ArrayList();
        }
        this.vm.add(sDSEncodeListener);
        if (sDSEncodeListener != null) {
            OutputStream outputStream;
            AlgorithmID[] algorithmIDArray = sDSEncodeListener.getDigestAlgorithms();
            if (algorithmIDArray != null) {
                boolean bl = false;
                int n2 = 0;
                while (n2 < algorithmIDArray.length) {
                    if (this.vl.d(algorithmIDArray[n2])) {
                        bl = true;
                    }
                    ++n2;
                }
                if (bl) {
                    this.inputStream_ = this.vl.d(this.inputStream_, false);
                }
            }
            if ((outputStream = sDSEncodeListener.getOutputStream()) != null) {
                this.inputStream_ = new e(this.inputStream_, outputStream);
            }
        }
    }

    public void addSignerInfo(SignerInfo signerInfo) {
        boolean bl;
        try {
            signerInfo.a(this.contentType_);
        }
        catch (CMSException cMSException) {
            throw new NoSuchAlgorithmException(cMSException.getMessage());
        }
        signerInfo.a(this);
        if (signerInfo.getSecurityProvider() == null) {
            signerInfo.setSecurityProvider(this.securityProvider_);
        }
        AlgorithmID algorithmID = signerInfo.getDigestAlgorithm();
        boolean bl2 = signerInfo.getSignatureValue() == null;
        boolean bl3 = bl = this.vl.a(algorithmID, bl2) && bl2;
        if (this.mode_ == 2 && bl) {
            this.inputStream_ = this.vl.d(this.inputStream_, false);
        }
        this.signerInfos_.addElement(signerInfo);
        if (this.version_ < 3 && signerInfo.getVersion() == 3) {
            this.version_ = 3;
        }
    }

    private void a() {
        this.version_ = 1;
        if (this.certSet_.containsOtherCertificates() || this.crls_.containsOtherRevocationInfos()) {
            this.version_ = 5;
        } else {
            int n2 = this.certSet_.getAttributeCertificateType();
            if (n2 == 1) {
                this.version_ = 3;
            } else if (n2 == 2) {
                this.version_ = 4;
            }
            if (this.version_ < 3) {
                Enumeration enumeration = this.signerInfos_.elements();
                while (enumeration.hasMoreElements()) {
                    if (((SignerInfo)enumeration.nextElement()).getVersion() != 3) continue;
                    this.version_ = 3;
                    break;
                }
            }
            if (this.version_ < 3 && !this.contentType_.equals((Object)ObjectID.cms_data)) {
                this.version_ = 3;
            }
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void clearSignatures(boolean bl, boolean bl2) {
        Enumeration enumeration = this.signerInfos_.elements();
        while (enumeration.hasMoreElements()) {
            SignerInfo signerInfo = (SignerInfo)enumeration.nextElement();
            if (!bl && signerInfo.c()) continue;
            signerInfo.setSignatureValue(null);
            if (!bl2) continue;
            signerInfo.removeSignedAttribute(ObjectID.messageDigest);
        }
    }

    public void decode(InputStream inputStream) {
        Object object;
        DerInputStream derInputStream;
        int n2;
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        if ((n2 = (derInputStream = ((DerInputStream)inputStream).readSequence()).nextTag()) == 6) {
            object = derInputStream.readObjectID();
            if (!object.equals((Object)ObjectID.cms_signedData)) {
                throw new CMSParsingException("Content type not SignedData!");
            }
            this.thisObject_ = derInputStream.readContextSpecific().readSequence();
        } else {
            this.thisObject_ = derInputStream;
        }
        this.version_ = this.thisObject_.readInteger().intValue();
        try {
            this.vl.a((AlgorithmID[])ASN.parseSequenceOf((ASN1Object)DerCoder.decode((InputStream)this.thisObject_), (Class)(e != null ? e : (e = SignedDataStream.class$("iaik.asn1.structures.AlgorithmID")))));
        }
        catch (CodingException codingException) {
            throw new IOException("Error parsing digest algorithms: " + codingException.toString());
        }
        object = this.thisObject_;
        if (this.d != null) {
            this.b();
            object = new e((InputStream)this.thisObject_, this.d);
        }
        this.encapContentInfo_ = new EncapsulatedContentInfoStream((InputStream)object, this instanceof SignedDataInOutStream);
        this.contentType_ = this.encapContentInfo_.getContentType();
        boolean bl = this.encapContentInfo_.hasContent();
        if (!bl || this.mode_ == 2) {
            if (bl) {
                this.inputStream_ = this.encapContentInfo_.getContentInputStream();
                this.inputStream_ = new PushbackInputStream(this.inputStream_);
                int n3 = this.inputStream_.read();
                if (n3 != -1) {
                    ((PushbackInputStream)this.inputStream_).unread(n3);
                }
            }
            this.mode_ = 2;
            if (this.d != null) {
                this.b();
            }
            this.notifyEOF();
            return;
        }
        this.inputStream_ = this.encapContentInfo_.getContentInputStream();
        try {
            this.inputStream_ = this.vl.d(this.inputStream_, true);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("No implementation for hash algorithm: " + noSuchAlgorithmException.getMessage());
        }
        InputStream inputStream2 = this.inputStream_;
        this.inputStream_ = new NotifyEOFInputStream(inputStream2);
        ((NotifyEOFInputStream)this.inputStream_).addEOFListener((EOFListener)this);
    }

    public void encodeCalled(ASN1Object aSN1Object, int n2) {
        try {
            Object object;
            Object object2;
            if (this.vm != null) {
                object2 = ((AbstractList)this.vm).iterator();
                while (object2.hasNext()) {
                    ((SDSEncodeListener)object2.next()).beforeComputeSignature(this);
                }
            }
            object2 = this.signerInfos_.elements();
            while (object2.hasMoreElements()) {
                object = (SignerInfo)object2.nextElement();
                ((SignerInfo)object).b();
            }
            if (this.vm != null) {
                object = ((AbstractList)this.vm).iterator();
                while (object.hasNext()) {
                    ((SDSEncodeListener)object.next()).afterComputeSignature(this);
                }
            }
            if (this.certSet_ != null && !this.certSet_.isEmpty()) {
                aSN1Object.addComponent((ASN1Object)new CON_SPEC(0, this.certSet_.toASN1Object(), true));
            }
            if (this.crls_ != null && !this.crls_.isEmpty()) {
                aSN1Object.addComponent((ASN1Object)new CON_SPEC(1, this.crls_.toASN1Object(), true));
            }
            aSN1Object.addComponent(ASN.createSetOf((Vector)this.signerInfos_));
        }
        catch (CMSException cMSException) {
            throw new CodingException("Error encoding SignedData: " + cMSException.getMessage());
        }
    }

    void b() {
        if (!this.g) {
            try {
                this.d.write(new byte[]{48, -128});
                this.d.write(DerCoder.encode((ASN1Object)ObjectID.cms_signedData));
                this.d.write(new byte[]{-96, -128});
                this.d.write(new byte[]{48, -128});
                this.d.write(DerCoder.encode((ASN1Object)new INTEGER(this.version_)));
                this.d.write(DerCoder.encode((ASN1Object)ASN.createSetOf((ASN1Type[])this.vl.cA())));
                this.g = true;
            }
            catch (CodingException codingException) {
                throw new IOException(codingException.toString());
            }
        }
    }

    public AttributeCertificate[] getAttributeCertificates() {
        return this.certSet_.getAttributeCertificates();
    }

    public int getBlockSize() {
        return this.blockSize_;
    }

    public X509CRL[] getCRLs() {
        return this.crls_.getX509CRLs();
    }

    public X509Certificate getCertificate(CertificateIdentifier certificateIdentifier) {
        if (this.certSet_ == null) {
            throw new CMSException("Certificate not found!");
        }
        if (certificateIdentifier == null) {
            throw new NullPointerException("Cannot search certificate for null signerIdentifier!");
        }
        X509Certificate x509Certificate = this.certSet_.getX509Certificate(certificateIdentifier);
        if (x509Certificate == null) {
            throw new CMSException("Certificate not found!");
        }
        return x509Certificate;
    }

    public CertificateSet getCertificateSet() {
        return this.certSet_;
    }

    public Certificate[] getCertificates() {
        return this.certSet_.getCertificates();
    }

    public X509Certificate[] getCertificates(CertificateIdentifier certificateIdentifier) {
        X509Certificate[] x509CertificateArray;
        X509Certificate x509Certificate = this.getCertificate(certificateIdentifier);
        try {
            x509CertificateArray = Utils.a(x509Certificate, this.certSet_.getX509Certificates());
        }
        catch (CertificateException certificateException) {
            x509CertificateArray = new X509Certificate[]{x509Certificate};
        }
        return x509CertificateArray;
    }

    public ObjectID getContentType() {
        return ObjectID.cms_signedData;
    }

    public AlgorithmID[] getDigestAlgorithms() {
        return this.vl.cA();
    }

    public ObjectID getEncapsulatedContentType() {
        return this.contentType_;
    }

    public InputStream getInputStream() {
        return this.inputStream_;
    }

    public byte[] getMessageDigest(AlgorithmID algorithmID) {
        return this.vl.h(algorithmID);
    }

    public int getMode() {
        return this.mode_;
    }

    public RevocationInfoChoices getRevocationInfoChoices() {
        return this.crls_;
    }

    public SecurityProvider getSecurityProvider() {
        return this.securityProvider_;
    }

    public byte[] getSignedDigest(int n2) {
        SignerInfo signerInfo = (SignerInfo)this.signerInfos_.elementAt(n2);
        if (signerInfo == null) {
            throw new ArrayIndexOutOfBoundsException("Wrong signerInfoIndex: " + n2);
        }
        return signerInfo.getSignedDigest();
    }

    public SignerInfo getSignerInfo(CertificateIdentifier certificateIdentifier) {
        Enumeration enumeration = this.signerInfos_.elements();
        SignerInfo signerInfo = null;
        if (certificateIdentifier != null) {
            while (enumeration.hasMoreElements()) {
                SignerInfo signerInfo2 = (SignerInfo)enumeration.nextElement();
                CertificateIdentifier certificateIdentifier2 = signerInfo2.getSignerIdentifier();
                if (!certificateIdentifier2.equals(certificateIdentifier)) continue;
                signerInfo = signerInfo2;
                break;
            }
        }
        return signerInfo;
    }

    public SignerInfo getSignerInfo(X509Certificate x509Certificate) {
        Enumeration enumeration = this.signerInfos_.elements();
        SignerInfo signerInfo = null;
        if (x509Certificate != null) {
            while (enumeration.hasMoreElements()) {
                SignerInfo signerInfo2 = (SignerInfo)enumeration.nextElement();
                CertificateIdentifier certificateIdentifier = signerInfo2.getSignerIdentifier();
                if (!certificateIdentifier.identifiesCert(x509Certificate)) continue;
                signerInfo = signerInfo2;
                break;
            }
        }
        return signerInfo;
    }

    public int getSignerInfoIndex(X509Certificate x509Certificate) {
        Enumeration enumeration = this.signerInfos_.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            SignerInfo signerInfo = (SignerInfo)enumeration.nextElement();
            CertificateIdentifier certificateIdentifier = signerInfo.getSignerIdentifier();
            if (certificateIdentifier.identifiesCert(x509Certificate)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public SignerInfo[] getSignerInfos() {
        Object[] objectArray = new SignerInfo[this.signerInfos_.size()];
        this.signerInfos_.copyInto(objectArray);
        return objectArray;
    }

    public int getVersion() {
        return this.version_;
    }

    public X509Certificate[] getX509Certificates() {
        return this.certSet_.getX509Certificates();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void notifyEOF() {
        var1_1 = false;
        if (this instanceof SignedDataInOutStream) {
            var1_1 = SignedDataInOutStream.a();
        }
        try {
            block19: {
                block17: {
                    block9: while (true) {
                        if (!this.thisObject_.nextIsContextSpecific()) {
                            if (!(Utils.getIaikProviderVersion() < 3.16)) break block17;
                        }
                        var2_2 = this.thisObject_.readContextSpecific(17);
                        switch (var2_2) {
                            case 0: {
                                var3_7 = new CertificateSet((InputStream)this.thisObject_, var1_1);
                                var4_10 = var3_7.getCertificateChoices();
                                var5_12 = 0;
                                while (true) {
                                    if (var5_12 >= ((CertificateChoices[])var4_10).length) continue block9;
                                    this.certSet_.addCertificateChoices(var4_10[var5_12]);
                                    ++var5_12;
                                }
                            }
                            case 1: {
                                var5_13 = new RevocationInfoChoices((InputStream)this.thisObject_, var1_1);
                                var6_14 = var5_13.getRevocationInfoChoices();
                                var7_15 = 0;
                                while (true) {
                                    if (var7_15 < var6_14.length) ** break;
                                    continue block9;
                                    this.crls_.addRevocationInfoChoice(var6_14[var7_15]);
                                    ++var7_15;
                                }
                            }
                        }
                        break;
                    }
                    throw new CMSParsingException("Invalid implicit tag " + var2_2 + "!");
                    this.signerInfos_ = Util.getVector((Object[])ASN.parseSequenceOf((ASN1Object)DerCoder.decode((InputStream)this.thisObject_), (Class)(SignedDataStream.f != null ? SignedDataStream.f : (SignedDataStream.f = SignedDataStream.class$("iaik.cms.SignerInfo")))));
                    break block19;
                }
                var2_3 = this.thisObject_.readSet();
                while (true) {
                    block18: {
                        var3_8 = -1;
                        try {
                            var3_8 = var2_3.nextTag();
                        }
                        catch (IOException var4_11) {
                            if (!SignedDataStream.a) break block18;
                            System.err.println("Error reading SignerInfo: " + var4_11.toString());
                            throw var4_11;
                        }
                    }
                    if (var3_8 == -1) break;
                    this.signerInfos_.add(new SignerInfo((InputStream)var2_3.readSequence(), var1_1));
                }
            }
            var2_4 = Util.toArray((Vector)this.signerInfos_);
            var3_9 = 0;
            while (true) {
                if (var3_9 >= var2_4.length) {
                    if (!(Utils.getIaikProviderVersion() >= 3.16)) return;
                    this.thisObject_.readEOC();
                    return;
                }
                var4_10 = (SignerInfo)var2_4[var3_9];
                var4_10.a(this);
                var4_10.setSecurityProvider(this.securityProvider_);
                ++var3_9;
            }
        }
        catch (CodingException var2_5) {
            throw new IOException("Error parsing Object! " + var2_5.getMessage());
        }
        catch (CMSParsingException var2_6) {
            throw new IOException("Error parsing Object! " + var2_6.getMessage());
        }
    }

    public boolean removeMessageDigest(AlgorithmID algorithmID) {
        return this.vl.k(algorithmID);
    }

    private SignerInfo b(CertificateIdentifier certificateIdentifier) {
        SignerInfo signerInfo = null;
        if (certificateIdentifier != null) {
            Enumeration enumeration = this.signerInfos_.elements();
            while (enumeration.hasMoreElements()) {
                SignerInfo signerInfo2 = (SignerInfo)enumeration.nextElement();
                CertificateIdentifier certificateIdentifier2 = signerInfo2.getSignerIdentifier();
                if (!certificateIdentifier2.equals(certificateIdentifier) || !this.signerInfos_.removeElement(signerInfo2)) continue;
                signerInfo = signerInfo2;
                AlgorithmID algorithmID = signerInfo2.getDigestAlgorithm();
                Enumeration enumeration2 = this.signerInfos_.elements();
                while (enumeration2.hasMoreElements()) {
                    SignerInfo signerInfo3 = (SignerInfo)enumeration2.nextElement();
                    if (!signerInfo3.getDigestAlgorithm().equals((Object)algorithmID)) continue;
                    algorithmID = null;
                }
                if (algorithmID != null) {
                    this.removeMessageDigest(algorithmID);
                }
                this.a();
            }
        }
        return signerInfo;
    }

    public boolean removeSignerInfo(CertificateIdentifier certificateIdentifier) {
        boolean bl = false;
        if (this.b(certificateIdentifier) != null) {
            bl = true;
            while (this.b(certificateIdentifier) != null) {
            }
        }
        return bl;
    }

    public void setBlockSize(int n2) {
        this.blockSize_ = n2;
    }

    public void setCRLs(X509CRL[] x509CRLArray) {
        if (x509CRLArray == null || x509CRLArray.length == 0) {
            this.crls_.removeAllRevocationInfos();
        } else {
            this.crls_.setRevocationInfos((CRL[])x509CRLArray);
        }
        this.a();
    }

    public void setCertificateSet(CertificateSet certificateSet) {
        if (certificateSet == null) {
            this.certSet_.removeAllCertificates();
        } else {
            this.certSet_ = certificateSet;
        }
        this.a();
    }

    public void setCertificates(Certificate[] certificateArray) {
        if (certificateArray == null || certificateArray.length == 0) {
            this.certSet_.removeAllCertificates();
        } else {
            this.certSet_.setCertificates(certificateArray);
        }
        this.a();
    }

    public void setInputStream(InputStream inputStream) {
        try {
            this.inputStream_ = this.vl.d(inputStream, true);
        }
        catch (Exception exception) {
            this.inputStream_ = inputStream;
        }
    }

    public void setMessageDigest(AlgorithmID algorithmID, byte[] byArray) {
        this.vl.b(algorithmID, byArray);
    }

    public void setRevocationInfoChoices(RevocationInfoChoices revocationInfoChoices) {
        if (revocationInfoChoices == null) {
            this.crls_.removeAllRevocationInfos();
        } else {
            this.crls_ = revocationInfoChoices;
        }
        this.a();
    }

    public void setSDSEncodeListener(SDSEncodeListener sDSEncodeListener) {
        if (this.vm == null) {
            this.vm = new ArrayList();
        }
        this.vm.clear();
        this.addSDSEncodeListener(sDSEncodeListener);
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider_ = securityProvider;
        if (this.signerInfos_ != null) {
            Object[] objectArray = Util.toArray((Vector)this.signerInfos_);
            int n2 = 0;
            while (n2 < objectArray.length) {
                SignerInfo signerInfo = (SignerInfo)objectArray[n2];
                if (signerInfo.getSecurityProvider() == null) {
                    signerInfo.setSecurityProvider(this.securityProvider_);
                }
                ++n2;
            }
        }
    }

    public void setSignerInfos(SignerInfo[] signerInfoArray) {
        this.signerInfos_.removeAllElements();
        if (signerInfoArray != null) {
            int n2 = 0;
            while (n2 < signerInfoArray.length) {
                SignerInfo signerInfo = signerInfoArray[n2];
                if (signerInfo != null) {
                    this.addSignerInfo(signerInfoArray[n2]);
                }
                ++n2;
            }
        }
        this.a();
    }

    public ASN1Object toASN1Object() {
        return this.toASN1Object(this.blockSize_);
    }

    protected ASN1Object toASN1Object(int n2) {
        Object object;
        boolean bl;
        if (n2 < 0) {
            n2 = this.blockSize_;
        }
        if (this.mode_ == 1) {
            try {
                this.inputStream_ = this.vl.d(this.inputStream_, false);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new CMSException("No implementation for hash algorithm: " + noSuchAlgorithmException.getMessage());
            }
        }
        boolean bl2 = bl = n2 > 0;
        if (this.mode_ == 1 && this.inputStream_ != null) {
            if (bl) {
                this.encapContentInfo_ = new EncapsulatedContentInfoStream(this.inputStream_, this.contentType_);
            } else {
                try {
                    object = Util.readStream((InputStream)this.inputStream_);
                    this.encapContentInfo_ = new EncapsulatedContentInfo((byte[])object, this.contentType_);
                }
                catch (IOException iOException) {
                    throw new CMSException("Error encoding content data: " + iOException.toString());
                }
            }
        } else {
            this.encapContentInfo_ = new EncapsulatedContentInfoStream(this.contentType_);
        }
        this.encapContentInfo_.setBlockSize(n2);
        object = new SEQUENCE(bl);
        try {
            object.addComponent((ASN1Object)new INTEGER(this.version_));
            object.addComponent(ASN.createSetOf((ASN1Type[])this.vl.cA()));
            object.addComponent(this.encapContentInfo_.toASN1Object());
            if (bl) {
                object.addEncodeListener((EncodeListener)this, 1, 2);
            } else {
                this.encodeCalled((ASN1Object)object, 1);
            }
        }
        catch (CodingException codingException) {
            throw new CMSException(codingException.toString());
        }
        return object;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.version_ + "\n");
        AlgorithmID[] algorithmIDArray = this.vl.cA();
        if (algorithmIDArray.length > 0) {
            stringBuffer.append("DigestAlgorithms: ");
            n2 = 0;
            while (n2 < algorithmIDArray.length) {
                stringBuffer.append(String.valueOf(algorithmIDArray[n2].getName()) + ",");
                ++n2;
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append("\n");
        }
        stringBuffer.append("EncapsulatedContentInfo: {\n");
        if (this.encapContentInfo_ != null) {
            Utils.printIndented(this.encapContentInfo_.toString(bl), true, stringBuffer);
        }
        stringBuffer.append("\n}\n");
        if (this.certSet_ != null && !this.certSet_.isEmpty()) {
            stringBuffer.append(this.certSet_);
        }
        if (this.crls_ != null && !this.crls_.isEmpty()) {
            stringBuffer.append(this.crls_);
        }
        stringBuffer.append("SignerInfos: " + this.signerInfos_.size() + "\n");
        if (bl) {
            n2 = 1;
            Enumeration enumeration = this.signerInfos_.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append("SignerInfo " + n2 + ": {\n");
                Utils.printIndented(((SignerInfo)enumeration.nextElement()).toString(bl), true, stringBuffer);
                stringBuffer.append("\n}\n");
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public X509Certificate verify(int n2) {
        if (n2 < 0 || n2 >= this.signerInfos_.size()) {
            throw new CMSSignatureException("SignerInfo does not exist. Wrong index.");
        }
        SignerInfo signerInfo = (SignerInfo)this.signerInfos_.elementAt(n2);
        CertificateIdentifier certificateIdentifier = signerInfo.getSignerIdentifier();
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = this.getCertificate(certificateIdentifier);
        }
        catch (Exception exception) {
            throw new CertificateNotFoundException("Certificate for verifying the signature not found!", certificateIdentifier);
        }
        this.verify(x509Certificate.getPublicKey(), n2);
        return x509Certificate;
    }

    public SignerInfo verify(X509Certificate x509Certificate) {
        int n2 = this.getSignerInfoIndex(x509Certificate);
        if (n2 == -1) {
            throw new CMSSignatureException("Cannot do verification. No signer for this certificate!");
        }
        this.verify(x509Certificate.getPublicKey(), n2);
        return (SignerInfo)this.signerInfos_.elementAt(n2);
    }

    public void verify(PublicKey publicKey, int n2) {
        if (n2 < 0 || n2 >= this.signerInfos_.size()) {
            throw new CMSSignatureException("SignerInfo does not exist. Wrong index.");
        }
        SignerInfo signerInfo = (SignerInfo)this.signerInfos_.elementAt(n2);
        if (!signerInfo.verifySignature(publicKey)) {
            throw new InvalidSignatureValueException("Signature verification error: wrong signature value!", signerInfo.getSignerIdentifier());
        }
    }

    public void writeTo(OutputStream outputStream) {
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.toString());
        }
    }

    public void writeTo(OutputStream outputStream, int n2) {
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(n2), (OutputStream)outputStream);
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.toString());
        }
    }

    class a {
        private final SignedDataStream vo;
        AlgorithmID sM;
        InputStreamHashEngine vp;
        byte[] rE;
        boolean d;

        a(SignedDataStream signedDataStream) {
            this.vo = signedDataStream;
            this.d = true;
        }

        a(SignedDataStream signedDataStream, AlgorithmID algorithmID) {
            this(signedDataStream);
            this.sM = algorithmID;
        }

        a(SignedDataStream signedDataStream, AlgorithmID algorithmID, byte[] byArray) {
            this(signedDataStream);
            this.sM = algorithmID;
            this.rE = byArray;
            this.d = false;
        }

        public boolean equals(Object object) {
            try {
                if (object instanceof a) {
                    return this.sM.getImplementationName().equals(((a)object).sM.getImplementationName());
                }
                if (object instanceof AlgorithmID) {
                    return this.sM.getImplementationName().equals(((AlgorithmID)object).getImplementationName());
                }
            }
            catch (Exception exception) {}
            return false;
        }

        boolean a() {
            return this.d;
        }

        byte[] b() {
            if (this.rE == null) {
                if (this.vp == null) {
                    throw new CMSRuntimeException("MessageDigest engine not initialized yet!");
                }
                if (this.vp.getInputStream() == null) {
                    throw new CMSRuntimeException("Cannot calculate message digest value. InputStream not set yet!");
                }
                this.rE = this.vp.getHash();
            }
            return this.rE;
        }

        public int hashCode() {
            return this.sM.getAlgorithm().hashCode();
        }

        void a(boolean bl) {
            this.d = bl;
        }

        void a(byte[] byArray) {
            this.rE = byArray;
        }
    }

    class DigestVector
    extends Vector {
        private final SignedDataStream vn;

        DigestVector(SignedDataStream signedDataStream) {
            this.vn = signedDataStream;
        }

        DigestVector(SignedDataStream signedDataStream, AlgorithmID[] algorithmIDArray) {
            this.vn = signedDataStream;
            this.a(algorithmIDArray);
        }

        boolean d(AlgorithmID algorithmID) {
            return this.a(algorithmID, true);
        }

        boolean a(AlgorithmID algorithmID, boolean bl) {
            boolean bl2;
            block4: {
                block3: {
                    bl2 = false;
                    if (this.g(algorithmID)) break block3;
                    a a2 = new a(this.vn, algorithmID);
                    a2.a(bl);
                    this.addElement(a2);
                    bl2 = true;
                    break block4;
                }
                if (!bl) break block4;
                try {
                    a a3 = this.i(algorithmID);
                    if (!a3.a()) {
                        a3.a(bl);
                        bl2 = true;
                    }
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            }
            return bl2;
        }

        void a(AlgorithmID algorithmID, byte[] byArray) {
            a a2 = new a(this.vn, algorithmID, byArray);
            int n2 = this.j(algorithmID);
            if (n2 == -1) {
                this.addElement(a2);
            } else {
                this.insertElementAt(a2, n2);
            }
        }

        boolean g(AlgorithmID algorithmID) {
            try {
                this.i(algorithmID);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }

        byte[] h(AlgorithmID algorithmID) {
            return this.i(algorithmID).b();
        }

        private a i(AlgorithmID algorithmID) {
            int n2 = 0;
            while (n2 < this.elementCount) {
                a a2 = (a)this.elementData[n2];
                if (a2.equals(algorithmID)) {
                    return a2;
                }
                ++n2;
            }
            throw new NoSuchAlgorithmException("No such MessageDigest: " + algorithmID.getName());
        }

        private int j(AlgorithmID algorithmID) {
            int n2 = 0;
            while (n2 < this.elementCount) {
                a a2 = (a)this.elementData[n2];
                if (a2.equals(algorithmID)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        AlgorithmID[] cA() {
            AlgorithmID[] algorithmIDArray = new AlgorithmID[this.elementCount];
            int n2 = 0;
            while (n2 < this.elementCount) {
                algorithmIDArray[n2] = ((a)this.elementData[n2]).sM;
                ++n2;
            }
            return algorithmIDArray;
        }

        boolean k(AlgorithmID algorithmID) {
            boolean bl = false;
            try {
                a a2 = this.i(algorithmID);
                if (a2 != null) {
                    bl = this.removeElement(a2);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            return bl;
        }

        void b(AlgorithmID algorithmID, byte[] byArray) {
            this.i(algorithmID).a(byArray);
        }

        void a(AlgorithmID[] algorithmIDArray) {
            int n2 = 0;
            while (n2 < algorithmIDArray.length) {
                this.d(algorithmIDArray[n2]);
                ++n2;
            }
        }

        InputStream d(InputStream inputStream, boolean bl) {
            if (inputStream != null) {
                SecurityProvider securityProvider = this.vn.securityProvider_;
                if (securityProvider == null) {
                    securityProvider = SecurityProvider.getSecurityProvider();
                }
                int n2 = 0;
                while (n2 < this.elementCount) {
                    a a2 = (a)this.elementData[n2];
                    if (a2.a() && (bl || a2.vp == null)) {
                        try {
                            InputStreamHashEngine inputStreamHashEngine;
                            a2.vp = inputStreamHashEngine = securityProvider.getInputStreamHashEngine(a2.sM, inputStream);
                            inputStream = inputStreamHashEngine.getInputStream();
                        }
                        catch (Exception exception) {
                            throw new NoSuchAlgorithmException(exception.toString());
                        }
                    }
                    ++n2;
                }
            }
            return inputStream;
        }

        void a(byte[] byArray, boolean bl) {
            if (byArray != null) {
                SecurityProvider securityProvider = this.vn.securityProvider_;
                if (securityProvider == null) {
                    securityProvider = SecurityProvider.getSecurityProvider();
                }
                int n2 = 0;
                while (n2 < this.elementCount) {
                    a a2 = (a)this.elementData[n2];
                    if (a2.a() && (bl || a2.vp == null)) {
                        try {
                            a2.rE = securityProvider.getHash(a2.sM, byArray);
                        }
                        catch (Exception exception) {
                            throw new NoSuchAlgorithmException("No MessageDigest implementation for " + a2.sM.getAlgorithm().getName());
                        }
                    }
                    ++n2;
                }
            }
        }
    }
}

