/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.CMSRuntimeException;
import iaik.cms.CertificateSet;
import iaik.cms.DataOutputStream;
import iaik.cms.DebugCMS;
import iaik.cms.OutputStreamHashEngine;
import iaik.cms.RevocationInfoChoices;
import iaik.cms.SecurityProvider;
import iaik.cms.SignerInfo;
import iaik.cms.Utils;
import iaik.cms.s;
import iaik.cms.w;
import iaik.utils.Util;
import iaik.x509.X509CRL;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Vector;

public class SignedDataOutputStream
extends OutputStream
implements s {
    private static boolean a = false;
    public static final int IMPLICIT = 1;
    public static final int EXPLICIT = 2;
    private int b = 1;
    private DigestVector ve = new DigestVector(this);
    private ObjectID rZ;
    private CertificateSet vf;
    private RevocationInfoChoices vg;
    private Vector tf = new Vector();
    private OutputStream vh;
    private OutputStream uC;
    private int j = 1;
    private SecurityProvider ta;
    private boolean up;
    private boolean uq = true;
    private boolean sS;

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    private SignedDataOutputStream() {
        this.vf = new CertificateSet();
        this.vg = new RevocationInfoChoices();
    }

    public SignedDataOutputStream(OutputStream outputStream, int n2) {
        this(outputStream, ObjectID.cms_data, n2, null);
    }

    public SignedDataOutputStream(OutputStream outputStream, ObjectID objectID, int n2) {
        this(outputStream, objectID, n2, null);
    }

    public SignedDataOutputStream(OutputStream outputStream, ObjectID objectID, int n2, SecurityProvider securityProvider) {
        this();
        if (outputStream == null) {
            throw new NullPointerException("Output stream must not be null!");
        }
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Illegal mode specification: " + n2 + "! Expected " + 1 + " (implicit) or " + 2 + " (explicit)");
        }
        this.rZ = objectID;
        this.vh = outputStream;
        this.uC = n2 == 1 ? new DataOutputStream(outputStream, false) : new w();
        this.j = n2;
        if (!this.rZ.equals((Object)ObjectID.cms_data)) {
            this.b = 3;
        }
        this.ta = securityProvider;
    }

    static SecurityProvider a(SignedDataOutputStream signedDataOutputStream) {
        return signedDataOutputStream.ta;
    }

    public void addCRLs(X509CRL[] x509CRLArray) {
        if (x509CRLArray != null && x509CRLArray.length > 0) {
            this.vg.addRevocationInfos((CRL[])x509CRLArray);
            this.a();
        }
    }

    public void addCertificates(Certificate[] certificateArray) {
        if (certificateArray != null && certificateArray.length > 0) {
            this.vf.addCertificates(certificateArray);
            this.a();
        }
    }

    public void addSignerInfo(SignerInfo signerInfo) {
        boolean bl;
        try {
            signerInfo.a(this.rZ);
        }
        catch (CMSException cMSException) {
            throw new NoSuchAlgorithmException(cMSException.getMessage());
        }
        signerInfo.a(this);
        if (signerInfo.getSecurityProvider() == null) {
            signerInfo.setSecurityProvider(this.ta);
        }
        AlgorithmID algorithmID = signerInfo.getDigestAlgorithm();
        boolean bl2 = signerInfo.getSignatureValue() == null;
        boolean bl3 = bl = this.ve.a(algorithmID, bl2) && bl2;
        if (bl) {
            this.uC = this.ve.a(this.uC, false);
        }
        this.tf.addElement(signerInfo);
        if (this.b < 3 && signerInfo.getVersion() == 3) {
            this.b = 3;
        }
    }

    private void a() {
        this.b = 1;
        if (this.vf.containsOtherCertificates() || this.vg.containsOtherRevocationInfos()) {
            this.b = 5;
        } else {
            int n2 = this.vf.getAttributeCertificateType();
            if (n2 == 1) {
                this.b = 3;
            } else if (n2 == 2) {
                this.b = 4;
            }
            if (this.b < 3) {
                Enumeration enumeration = this.tf.elements();
                while (enumeration.hasMoreElements()) {
                    if (((SignerInfo)enumeration.nextElement()).getVersion() != 3) continue;
                    this.b = 3;
                    break;
                }
            }
            if (this.b < 3 && !this.rZ.equals((Object)ObjectID.cms_data)) {
                this.b = 3;
            }
        }
    }

    private void b() {
        if (this.sS) {
            throw new IOException("Stream already closed!");
        }
    }

    public void close() {
        this.b();
        this.sS = true;
        this.c();
        this.uC.close();
        if (this.j == 1) {
            this.vh.write(new byte[2]);
        }
        this.vh.write(new byte[2]);
        try {
            if (this.vf != null && !this.vf.isEmpty()) {
                this.vh.write(DerCoder.encode((ASN1Object)new CON_SPEC(0, this.vf.toASN1Object(), true)));
            }
            if (this.vg != null && !this.vg.isEmpty()) {
                this.vh.write(DerCoder.encode((ASN1Object)new CON_SPEC(1, this.vg.toASN1Object(), true)));
            }
            this.vh.write(DerCoder.encode((ASN1Object)ASN.createSetOf((Vector)this.tf)));
            this.vh.write(new byte[2]);
            if (this.uq) {
                this.vh.close();
            }
        }
        catch (CodingException codingException) {
            throw new IOException(codingException.toString());
        }
    }

    private void c() {
        if (!this.up) {
            try {
                this.vh.write(new byte[]{48, -128});
                this.vh.write(DerCoder.encode((ASN1Object)new INTEGER(this.b)));
                this.vh.write(DerCoder.encode((ASN1Object)ASN.createSetOf((ASN1Type[])this.ve.cA())));
                this.vh.write(new byte[]{48, -128});
                this.vh.write(DerCoder.encode((ASN1Object)this.rZ));
                if (this.j == 1) {
                    this.vh.write(new byte[]{-96, -128});
                }
                this.up = true;
            }
            catch (CodingException codingException) {
                throw new IOException(codingException.toString());
            }
        }
    }

    public void flush() {
        this.b();
        this.c();
        this.uC.flush();
    }

    public byte[] getMessageDigest(AlgorithmID algorithmID) {
        return this.ve.e(algorithmID);
    }

    public SecurityProvider getSecurityProvider() {
        return this.ta;
    }

    public boolean isPassThroughClose() {
        return this.uq;
    }

    public void setCRLs(X509CRL[] x509CRLArray) {
        if (x509CRLArray == null || x509CRLArray.length == 0) {
            this.vg.removeAllRevocationInfos();
        } else {
            this.vg.setRevocationInfos((CRL[])x509CRLArray);
        }
        this.a();
    }

    public void setCertificateSet(CertificateSet certificateSet) {
        if (certificateSet == null) {
            this.vf.removeAllCertificates();
        } else {
            this.vf = certificateSet;
        }
        this.a();
    }

    public void setCertificates(Certificate[] certificateArray) {
        if (certificateArray == null || certificateArray.length == 0) {
            this.vf.removeAllCertificates();
        } else {
            this.vf.setCertificates(certificateArray);
        }
        this.a();
    }

    public void setMessageDigest(AlgorithmID algorithmID, byte[] byArray) {
        this.ve.a(algorithmID, byArray);
    }

    public void setPassThroughClose(boolean bl) {
        this.uq = bl;
    }

    public void setRevocationInfoChoices(RevocationInfoChoices revocationInfoChoices) {
        if (revocationInfoChoices == null) {
            this.vg.removeAllRevocationInfos();
        } else {
            this.vg = revocationInfoChoices;
        }
        this.a();
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.ta = securityProvider;
        if (this.tf != null) {
            Object[] objectArray = Util.toArray((Vector)this.tf);
            int n2 = 0;
            while (n2 < objectArray.length) {
                SignerInfo signerInfo = (SignerInfo)objectArray[n2];
                if (signerInfo.getSecurityProvider() == null) {
                    signerInfo.setSecurityProvider(this.ta);
                }
                ++n2;
            }
        }
    }

    public void setSignerInfos(SignerInfo[] signerInfoArray) {
        this.tf.removeAllElements();
        if (signerInfoArray != null) {
            int n2 = 0;
            while (n2 < signerInfoArray.length) {
                SignerInfo signerInfo = signerInfoArray[n2];
                if (signerInfo != null) {
                    this.addSignerInfo(signerInfoArray[n2]);
                }
                ++n2;
            }
        }
        this.a();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.b + "\n");
        AlgorithmID[] algorithmIDArray = this.ve.cA();
        if (algorithmIDArray.length > 0) {
            stringBuffer.append("DigestAlgorithms: ");
            n2 = 0;
            while (n2 < algorithmIDArray.length) {
                stringBuffer.append(String.valueOf(algorithmIDArray[n2].getName()) + ",");
                ++n2;
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append("\n");
        }
        stringBuffer.append("EncapsulatedContentInfo: {\n");
        Utils.printIndented("ContentType: " + this.rZ.getName() + (this.j == 1 ? ", content included\n" : ", no content\n"), true, stringBuffer);
        if (this.vf != null && !this.vf.isEmpty()) {
            stringBuffer.append(this.vf);
        }
        if (this.vg != null && !this.vg.isEmpty()) {
            stringBuffer.append(this.vg);
        }
        stringBuffer.append("SignerInfos: " + this.tf.size() + "\n");
        if (bl) {
            n2 = 1;
            Enumeration enumeration = this.tf.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append("SignerInfo " + n2 + ": {\n");
                Utils.printIndented(((SignerInfo)enumeration.nextElement()).toString(bl), true, stringBuffer);
                stringBuffer.append("\n}\n");
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public void write(int n2) {
        this.b();
        this.write(new byte[]{(byte)(n2 & 0xFF)}, 0, 1);
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) {
        this.b();
        this.c();
        this.uC.write(byArray, n2, n3);
    }

    class a {
        private final SignedDataOutputStream vj;
        AlgorithmID sM;
        OutputStreamHashEngine vk;
        byte[] rE;
        boolean d;

        a(SignedDataOutputStream signedDataOutputStream) {
            this.vj = signedDataOutputStream;
            this.d = true;
        }

        a(SignedDataOutputStream signedDataOutputStream, AlgorithmID algorithmID) {
            this(signedDataOutputStream);
            this.sM = algorithmID;
        }

        public boolean equals(Object object) {
            try {
                if (object instanceof a) {
                    return this.sM.getImplementationName().equals(((a)object).sM.getImplementationName());
                }
                if (object instanceof AlgorithmID) {
                    return this.sM.getImplementationName().equals(((AlgorithmID)object).getImplementationName());
                }
            }
            catch (Exception exception) {}
            return false;
        }

        boolean a() {
            return this.d;
        }

        byte[] b() {
            if (this.rE == null) {
                if (this.vk == null) {
                    throw new CMSRuntimeException("MessageDigest engine not initialized yet!");
                }
                if (this.vk.getOutputStream() == null) {
                    throw new CMSRuntimeException("Cannot calculate message digest value. OututStream not set yet!");
                }
                this.rE = this.vk.getHash();
            }
            return this.rE;
        }

        public int hashCode() {
            return this.sM.getAlgorithm().hashCode();
        }

        void a(boolean bl) {
            this.d = bl;
        }

        void a(byte[] byArray) {
            this.rE = byArray;
        }
    }

    class DigestVector
    extends Vector {
        private final SignedDataOutputStream vi;

        DigestVector(SignedDataOutputStream signedDataOutputStream) {
            this.vi = signedDataOutputStream;
        }

        boolean a(AlgorithmID algorithmID, boolean bl) {
            boolean bl2;
            block4: {
                block3: {
                    bl2 = false;
                    if (this.d(algorithmID)) break block3;
                    a a2 = new a(this.vi, algorithmID);
                    a2.a(bl);
                    this.addElement(a2);
                    bl2 = true;
                    break block4;
                }
                if (!bl) break block4;
                try {
                    a a3 = this.f(algorithmID);
                    if (!a3.a()) {
                        a3.a(bl);
                        bl2 = true;
                    }
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            }
            return bl2;
        }

        boolean d(AlgorithmID algorithmID) {
            try {
                this.f(algorithmID);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }

        byte[] e(AlgorithmID algorithmID) {
            return this.f(algorithmID).b();
        }

        private a f(AlgorithmID algorithmID) {
            int n2 = 0;
            while (n2 < this.elementCount) {
                a a2 = (a)this.elementData[n2];
                if (a2.equals(algorithmID)) {
                    return a2;
                }
                ++n2;
            }
            throw new NoSuchAlgorithmException("No such MessageDigest: " + algorithmID.getName());
        }

        AlgorithmID[] cA() {
            AlgorithmID[] algorithmIDArray = new AlgorithmID[this.elementCount];
            int n2 = 0;
            while (n2 < this.elementCount) {
                algorithmIDArray[n2] = ((a)this.elementData[n2]).sM;
                ++n2;
            }
            return algorithmIDArray;
        }

        void a(AlgorithmID algorithmID, byte[] byArray) {
            this.f(algorithmID).a(byArray);
        }

        OutputStream a(OutputStream outputStream, boolean bl) {
            if (outputStream != null) {
                SecurityProvider securityProvider = SignedDataOutputStream.a(this.vi);
                if (securityProvider == null) {
                    securityProvider = SecurityProvider.getSecurityProvider();
                }
                int n2 = 0;
                while (n2 < this.elementCount) {
                    a a2 = (a)this.elementData[n2];
                    if (a2.a() && (bl || a2.vk == null)) {
                        try {
                            OutputStreamHashEngine outputStreamHashEngine;
                            a2.vk = outputStreamHashEngine = securityProvider.getOutputStreamHashEngine(a2.sM, outputStream);
                            outputStream = outputStreamHashEngine.getOutputStream();
                        }
                        catch (Exception exception) {
                            throw new NoSuchAlgorithmException(exception.toString());
                        }
                    }
                    ++n2;
                }
            }
            return outputStream;
        }
    }
}

