/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.Content;
import iaik.cms.EncapsulatedContentInfo;
import iaik.cms.SecurityProvider;
import iaik.cms.SignedDataStream;
import iaik.cms.SignerInfo;
import iaik.cms.Utils;
import iaik.utils.InternalErrorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Vector;

public class SignedData
extends SignedDataStream
implements Content {
    byte[] a;
    private EncapsulatedContentInfo vd;
    static Class sl;

    protected SignedData() {
        this.blockSize_ = -1;
    }

    public SignedData(ASN1Object aSN1Object) {
        this(aSN1Object, null);
    }

    public SignedData(ASN1Object aSN1Object, SecurityProvider securityProvider) {
        this();
        this.securityProvider_ = securityProvider;
        this.decode(aSN1Object);
    }

    public SignedData(ObjectID objectID) {
        super(objectID);
        this.blockSize_ = -1;
    }

    public SignedData(InputStream inputStream) {
        this(inputStream, (SecurityProvider)null);
    }

    public SignedData(InputStream inputStream, SecurityProvider securityProvider) {
        this();
        this.securityProvider_ = securityProvider;
        this.decode(inputStream);
    }

    public SignedData(byte[] byArray, int n2) {
        this();
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Illegal mode specification: " + n2 + "! Expected " + 1 + " (implicit) or " + 2 + " (explicit)");
        }
        this.a = byArray;
        this.mode_ = n2;
        this.contentType_ = ObjectID.cms_data;
    }

    public SignedData(byte[] byArray, ObjectID objectID, int n2) {
        this();
        if (objectID == null) {
            throw new NullPointerException("contentType must not be null!");
        }
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Illegal mode specification: " + n2 + "! Expected " + 1 + " (implicit) or " + 2 + " (explicit)");
        }
        this.a = byArray;
        this.mode_ = n2;
        this.contentType_ = objectID;
        if (!this.contentType_.equals((Object)ObjectID.cms_data)) {
            this.version_ = 3;
        }
    }

    public SignedData(byte[] byArray, AlgorithmID[] algorithmIDArray) {
        this(byArray, algorithmIDArray, null);
    }

    public SignedData(byte[] byArray, AlgorithmID[] algorithmIDArray, SecurityProvider securityProvider) {
        this();
        this.securityProvider_ = securityProvider;
        this.a = byArray;
        this.mode_ = 2;
        this.vl.a(algorithmIDArray);
        this.a();
    }

    public void addDigestAlgorithm(AlgorithmID algorithmID) {
        if (!this.vl.g(algorithmID)) {
            if (this.a != null) {
                SecurityProvider securityProvider = this.securityProvider_;
                if (securityProvider == null) {
                    securityProvider = SecurityProvider.getSecurityProvider();
                }
                byte[] byArray = securityProvider.getHash(algorithmID, this.a);
                this.vl.a(algorithmID, byArray);
            } else {
                this.vl.a(algorithmID, false);
            }
        }
    }

    public void addSignerInfo(SignerInfo signerInfo) {
        AlgorithmID algorithmID;
        try {
            signerInfo.a(this.contentType_);
        }
        catch (CMSException cMSException) {
            throw new NoSuchAlgorithmException(cMSException.getMessage());
        }
        signerInfo.a(this);
        if (signerInfo.getSecurityProvider() == null) {
            signerInfo.setSecurityProvider(this.securityProvider_);
        }
        if (!this.vl.g(algorithmID = signerInfo.getDigestAlgorithm())) {
            if (this.a != null && signerInfo.getSignatureValue() == null) {
                SecurityProvider securityProvider = this.securityProvider_;
                if (securityProvider == null) {
                    securityProvider = SecurityProvider.getSecurityProvider();
                }
                byte[] byArray = securityProvider.getHash(algorithmID, this.a);
                this.vl.a(algorithmID, byArray);
            } else {
                this.vl.a(algorithmID, false);
            }
        }
        if (this.a != null) {
            try {
                signerInfo.b();
            }
            catch (CMSException cMSException) {
                throw new NoSuchAlgorithmException("Error computing signature value: " + cMSException.toString());
            }
        }
        this.signerInfos_.addElement(signerInfo);
        if (this.version_ < 3 && signerInfo.getVersion() == 3) {
            this.version_ = 3;
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void decode(ASN1Object aSN1Object) {
        try {
            this.decode(new ByteArrayInputStream(DerCoder.encode((ASN1Object)aSN1Object)));
        }
        catch (IOException iOException) {
            throw new CMSParsingException(iOException.getMessage());
        }
    }

    public void decode(InputStream inputStream) {
        DerInputStream derInputStream;
        int n2;
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        if ((n2 = (derInputStream = ((DerInputStream)inputStream).readSequence()).nextTag()) == 6) {
            ObjectID objectID = derInputStream.readObjectID();
            if (!objectID.equals((Object)ObjectID.cms_signedData)) {
                throw new CMSParsingException("Content type not SignedData!");
            }
            this.thisObject_ = derInputStream.readContextSpecific().readSequence();
        } else {
            this.thisObject_ = derInputStream;
        }
        this.version_ = this.thisObject_.readInteger().intValue();
        try {
            this.vl.a((AlgorithmID[])ASN.parseSequenceOf((ASN1Object)DerCoder.decode((InputStream)this.thisObject_), (Class)(sl != null ? sl : (sl = SignedData.class$("iaik.asn1.structures.AlgorithmID")))));
        }
        catch (CodingException codingException) {
            throw new IOException("Error parsing digest algorithms!");
        }
        this.vd = new EncapsulatedContentInfo((InputStream)this.thisObject_);
        this.contentType_ = this.vd.getContentType();
        if (!this.vd.hasContent()) {
            this.mode_ = 2;
            this.notifyEOF();
            return;
        }
        this.a = this.vd.getContent();
        try {
            this.a();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSParsingException(noSuchAlgorithmException.getMessage());
        }
        this.notifyEOF();
    }

    public byte[] getContent() {
        return this.a;
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CMSException(iOException.getMessage());
        }
    }

    public InputStream getInputStream() {
        if (this.a == null) {
            return null;
        }
        return new ByteArrayInputStream(this.a);
    }

    public void setContent(byte[] byArray) {
        this.a = byArray;
        try {
            this.vl.a(byArray, true);
        }
        catch (Exception exception) {}
    }

    public void setInputStream(InputStream inputStream) {
        super.setInputStream(inputStream);
        if (inputStream != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Utils.copyStream(this.inputStream_, byteArrayOutputStream, null);
                this.a = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                throw new InternalErrorException("Error reading from stream!", exception);
            }
        }
    }

    private void a() {
        this.vl.a(this.a, true);
    }

    protected ASN1Object toASN1Object(int n2) {
        if (n2 < 0) {
            n2 = this.blockSize_;
        }
        if (this.mode_ == 1 && this.a != null) {
            this.vd = new EncapsulatedContentInfo(this.a, this.contentType_);
            this.vd.setBlockSize(n2);
        } else {
            this.vd = new EncapsulatedContentInfo(this.contentType_);
        }
        SEQUENCE sEQUENCE = new SEQUENCE(n2 > 0);
        try {
            sEQUENCE.addComponent((ASN1Object)new INTEGER(this.version_));
            sEQUENCE.addComponent(ASN.createSetOf((ASN1Type[])this.vl.cA()));
            sEQUENCE.addComponent(this.vd.toASN1Object());
            if (this.certSet_ != null && !this.certSet_.isEmpty()) {
                sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, this.certSet_.toASN1Object(), true));
            }
            if (this.crls_ != null && !this.crls_.isEmpty()) {
                sEQUENCE.addComponent((ASN1Object)new CON_SPEC(1, this.crls_.toASN1Object(), true));
            }
            sEQUENCE.addComponent(ASN.createSetOf((Vector)this.signerInfos_));
        }
        catch (CodingException codingException) {
            throw new CMSException(codingException.toString());
        }
        return sEQUENCE;
    }

    public String toString(boolean bl) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.version_ + "\n");
        AlgorithmID[] algorithmIDArray = this.vl.cA();
        if (algorithmIDArray.length > 0) {
            stringBuffer.append("DigestAlgorithms: ");
            n2 = 0;
            while (n2 < algorithmIDArray.length) {
                stringBuffer.append(String.valueOf(algorithmIDArray[n2].getName()) + ",");
                ++n2;
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append("\n");
        }
        stringBuffer.append("EncapsulatedContentInfo: {\n");
        if (this.vd != null) {
            Utils.printIndented(this.vd.toString(bl), true, stringBuffer);
        }
        stringBuffer.append("\n}\n");
        if (this.certSet_ != null && !this.certSet_.isEmpty()) {
            stringBuffer.append(this.certSet_);
        }
        if (this.crls_ != null && !this.crls_.isEmpty()) {
            stringBuffer.append(this.crls_);
        }
        stringBuffer.append("SignerInfos: " + this.signerInfos_.size() + "\n");
        if (bl) {
            n2 = 1;
            Enumeration enumeration = this.signerInfos_.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append("SignerInfo " + n2 + ": {\n");
                Utils.printIndented(((SignerInfo)enumeration.nextElement()).toString(bl), true, stringBuffer);
                stringBuffer.append("\n}\n");
                ++n2;
            }
        }
        return stringBuffer.toString();
    }
}

