/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.SET;
import iaik.asn1.structures.Name;
import iaik.cms.CMSParsingException;
import iaik.cms.CMSRuntimeException;
import iaik.cms.DebugCMS;
import iaik.cms.OCSPRevocationInfo;
import iaik.cms.OtherRevocationInfo;
import iaik.cms.RevocationInfoChoice;
import iaik.x509.X509CRL;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CRL;
import java.util.Enumeration;
import java.util.Vector;

public class RevocationInfoChoices {
    private static boolean a = false;
    private Vector tR = new Vector();

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    public RevocationInfoChoices() {
    }

    public RevocationInfoChoices(InputStream inputStream) {
        this();
        this.decode(inputStream);
    }

    RevocationInfoChoices(InputStream inputStream, boolean bl) {
        this();
        this.b(inputStream, bl);
    }

    public void addRevocationInfo(CRL cRL) {
        RevocationInfoChoice revocationInfoChoice = new RevocationInfoChoice(cRL);
        this.tR.addElement(revocationInfoChoice);
    }

    public void addRevocationInfoChoice(RevocationInfoChoice revocationInfoChoice) {
        this.tR.addElement(revocationInfoChoice);
    }

    public void addRevocationInfoChoices(RevocationInfoChoice[] revocationInfoChoiceArray) {
        int n2 = 0;
        while (n2 < revocationInfoChoiceArray.length) {
            RevocationInfoChoice revocationInfoChoice = revocationInfoChoiceArray[n2];
            if (revocationInfoChoice != null) {
                this.addRevocationInfoChoice(revocationInfoChoice);
            }
            ++n2;
        }
    }

    public void addRevocationInfos(CRL[] cRLArray) {
        int n2 = 0;
        while (n2 < cRLArray.length) {
            CRL cRL = cRLArray[n2];
            if (cRL != null) {
                this.addRevocationInfo(cRLArray[n2]);
            }
            ++n2;
        }
    }

    public boolean containsOCSPRevocationInfos() {
        Enumeration enumeration = this.tR.elements();
        while (enumeration.hasMoreElements()) {
            RevocationInfoChoice revocationInfoChoice = (RevocationInfoChoice)enumeration.nextElement();
            if (revocationInfoChoice.getType() != 1 || !(revocationInfoChoice.getCRL() instanceof OCSPRevocationInfo)) continue;
            return true;
        }
        return false;
    }

    public boolean containsOtherRevocationInfos() {
        Enumeration enumeration = this.tR.elements();
        while (enumeration.hasMoreElements()) {
            if (((RevocationInfoChoice)enumeration.nextElement()).getType() != 1) continue;
            return true;
        }
        return false;
    }

    public boolean containsX509CRLs() {
        Enumeration enumeration = this.tR.elements();
        while (enumeration.hasMoreElements()) {
            if (((RevocationInfoChoice)enumeration.nextElement()).getType() != 0) continue;
            return true;
        }
        return false;
    }

    private int a() {
        int n2 = 0;
        Enumeration enumeration = this.tR.elements();
        while (enumeration.hasMoreElements()) {
            if (((RevocationInfoChoice)enumeration.nextElement()).getType() != 1) continue;
            ++n2;
        }
        return n2;
    }

    public void decode(InputStream inputStream) {
        this.b(inputStream, false);
    }

    void b(InputStream inputStream, boolean bl) {
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        DerInputStream derInputStream = (DerInputStream)inputStream;
        DerInputStream derInputStream2 = derInputStream.readSet();
        while (derInputStream2.nextTag() > -1) {
            RevocationInfoChoice revocationInfoChoice = new RevocationInfoChoice((InputStream)derInputStream2, bl);
            this.tR.addElement(revocationInfoChoice);
        }
    }

    public OCSPRevocationInfo[] getOCSPRevocationInfos() {
        Object object;
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = this.tR.elements();
        while (enumeration.hasMoreElements()) {
            object = ((RevocationInfoChoice)enumeration.nextElement()).getCRL();
            if (!(object instanceof OCSPRevocationInfo)) continue;
            vector.addElement((Object[])object);
        }
        object = new OCSPRevocationInfo[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public OtherRevocationInfo[] getOtherRevocationInfos() {
        Object object;
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = this.tR.elements();
        try {
            while (enumeration.hasMoreElements()) {
                object = ((RevocationInfoChoice)enumeration.nextElement()).getCRL();
                if (!(object instanceof OtherRevocationInfo)) continue;
                vector.addElement((Object[])object);
            }
        }
        catch (CMSParsingException cMSParsingException) {
            throw new CMSRuntimeException(cMSParsingException.toString());
        }
        object = new OtherRevocationInfo[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public RevocationInfoChoice[] getRevocationInfoChoices() {
        Object[] objectArray = new RevocationInfoChoice[this.tR.size()];
        this.tR.copyInto(objectArray);
        return objectArray;
    }

    public CRL[] getRevocationInfos() {
        int n2 = this.tR.size();
        CRL[] cRLArray = new CRL[n2];
        Enumeration enumeration = this.tR.elements();
        int n3 = 0;
        while (n3 < n2) {
            if (enumeration.hasMoreElements()) {
                try {
                    cRLArray[n3] = ((RevocationInfoChoice)enumeration.nextElement()).getCRL();
                }
                catch (CMSParsingException cMSParsingException) {
                    throw new CMSRuntimeException(cMSParsingException.toString());
                }
            }
            ++n3;
        }
        return cRLArray;
    }

    public X509CRL getX509CRL(Name name) {
        Enumeration enumeration = this.tR.elements();
        try {
            while (enumeration.hasMoreElements()) {
                X509CRL x509CRL;
                CRL cRL = ((RevocationInfoChoice)enumeration.nextElement()).getCRL();
                if (!(cRL instanceof X509CRL) || !(x509CRL = (X509CRL)cRL).getIssuerDN().equals(name)) continue;
                return x509CRL;
            }
        }
        catch (CMSParsingException cMSParsingException) {
            throw new CMSRuntimeException(cMSParsingException.toString());
        }
        return null;
    }

    public X509CRL[] getX509CRLs() {
        Object object;
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = this.tR.elements();
        try {
            while (enumeration.hasMoreElements()) {
                object = ((RevocationInfoChoice)enumeration.nextElement()).getCRL();
                if (!(object instanceof X509CRL)) continue;
                vector.addElement((Object[])object);
            }
        }
        catch (CMSParsingException cMSParsingException) {
            throw new CMSRuntimeException(cMSParsingException.toString());
        }
        object = new X509CRL[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public boolean isEmpty() {
        return this.tR.isEmpty();
    }

    public void removeAllRevocationInfos() {
        this.tR.removeAllElements();
    }

    public void setRevocationInfoChoices(RevocationInfoChoice[] revocationInfoChoiceArray) {
        this.tR.clear();
        this.addRevocationInfoChoices(revocationInfoChoiceArray);
    }

    public void setRevocationInfos(CRL[] cRLArray) {
        this.tR.removeAllElements();
        this.addRevocationInfos(cRLArray);
    }

    public int size() {
        return this.tR.size();
    }

    public ASN1Object toASN1Object() {
        SET sET = new SET();
        Enumeration enumeration = this.tR.elements();
        while (enumeration.hasMoreElements()) {
            RevocationInfoChoice revocationInfoChoice = (RevocationInfoChoice)enumeration.nextElement();
            sET.addComponent(revocationInfoChoice.toASN1Object());
        }
        return sET;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RevocationInfos: " + this.tR.size());
        stringBuffer.append(" -- " + this.a() + " other revocation info(s)\n");
        return stringBuffer.toString();
    }

    public void writeTo(OutputStream outputStream) {
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
        }
        catch (CodingException codingException) {
            throw new IOException(codingException.toString());
        }
    }
}

