/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.cms.CMSParsingException;
import iaik.cms.DebugCMS;
import iaik.cms.OCSPRevocationInfo;
import iaik.cms.OtherRevocationInfo;
import iaik.cms.Utils;
import iaik.utils.TracedInputStream;
import iaik.utils.Util;
import iaik.x509.X509CRL;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;

public class RevocationInfoChoice {
    private static boolean rH = false;
    public static final int TYPE_CERTIFICATE_LIST = 0;
    public static final int TYPE_OTHER_REVOCATION_INFO_FORMAT = 1;
    byte[] a;
    private CRL vb;
    private int d;

    static {
        rH = DebugCMS.getDebugMode() && rH;
    }

    public RevocationInfoChoice(InputStream inputStream) {
        this(inputStream, false);
    }

    public RevocationInfoChoice(InputStream inputStream, boolean bl) {
        this.b(inputStream, bl);
    }

    public RevocationInfoChoice(CRL cRL) {
        if (cRL instanceof X509CRL) {
            this.d = 0;
        } else if (cRL instanceof OtherRevocationInfo) {
            this.d = 1;
        } else {
            throw new IllegalArgumentException("Only iaik.x509.X509CRLs or iaik.cms.OtherRevocationInfos are allowed!");
        }
        this.vb = cRL;
    }

    public RevocationInfoChoice(byte[] byArray) {
        try {
            this.a(byArray);
        }
        catch (IOException iOException) {
            throw new CMSParsingException(iOException.toString());
        }
    }

    public void clearEncoded() {
        if (this.vb == null) {
            this.getCRL();
        }
        this.a = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void b(InputStream inputStream, boolean bl) {
        DerInputStream derInputStream = null;
        TracedInputStream tracedInputStream = null;
        if (bl) {
            tracedInputStream = new TracedInputStream(inputStream);
            derInputStream = new DerInputStream((InputStream)tracedInputStream);
        } else {
            DerInputStream derInputStream2 = derInputStream = inputStream instanceof DerInputStream ? (DerInputStream)inputStream : new DerInputStream(inputStream);
        }
        if (derInputStream.nextIsContextSpecific()) {
            this.d = 1;
            int n2 = derInputStream.readContextSpecific(16);
            if (n2 != 1) throw new CMSParsingException("Invalid implicit tag " + n2 + " for OtherRevocationInfoFormat! Must be 1");
            DerInputStream derInputStream3 = derInputStream.readSequence();
            ObjectID objectID = derInputStream3.readObjectID();
            try {
                this.vb = OCSPRevocationInfo.id_ri_ocsp_response.equals((Object)objectID) ? new OCSPRevocationInfo((InputStream)derInputStream3) : new OtherRevocationInfo(objectID, (InputStream)derInputStream3);
            }
            catch (CodingException codingException) {
                throw new CMSParsingException("Error parsing other revocation info: " + codingException.getMessage());
            }
            derInputStream3.readEOC();
        } else {
            this.d = 0;
            if (bl) {
                DerInputStream derInputStream4 = derInputStream.readSequence();
                byte[] byArray = tracedInputStream.getTracedData();
                int n3 = byArray[byArray.length - 1] & 0xFF;
                if (n3 == 128) {
                    try {
                        int n4 = 0;
                        while (n4 < 3) {
                            Utils.k((InputStream)derInputStream4);
                            ++n4;
                        }
                    }
                    catch (Exception exception) {
                        throw new CMSParsingException("Error parsing crl: " + exception.toString());
                    }
                    derInputStream4.readEOC();
                } else {
                    Util.readStream((InputStream)derInputStream4);
                }
            } else {
                try {
                    this.vb = new X509CRL((InputStream)derInputStream);
                }
                catch (CRLException cRLException) {
                    throw new CMSParsingException(cRLException.toString());
                }
            }
        }
        if (tracedInputStream == null) return;
        this.a = tracedInputStream.getTracedData();
    }

    void a(byte[] byArray) {
        boolean bl;
        if (byArray == null) {
            throw new NullPointerException("array must not be null!");
        }
        if (byArray.length == 0) {
            throw new IOException("array must not be empty!");
        }
        byte by = byArray[0];
        boolean bl2 = bl = (by & 0xC0) == 128;
        if (bl) {
            this.d = 1;
            this.b(new ByteArrayInputStream(byArray), false);
        } else {
            this.d = 0;
        }
        this.a = byArray;
    }

    public CRL getCRL() {
        if (this.vb == null) {
            if (this.d == 0) {
                try {
                    this.vb = new X509CRL(this.a);
                }
                catch (CRLException cRLException) {
                    throw new CMSParsingException(cRLException.toString());
                }
            }
            try {
                this.b(new ByteArrayInputStream(this.a), false);
            }
            catch (IOException iOException) {
                throw new CMSParsingException(iOException.toString());
            }
        }
        return this.vb;
    }

    public byte[] getEncoded() {
        byte[] byArray = this.a;
        if (byArray == null) {
            byArray = DerCoder.encode((ASN1Object)this.toASN1Object());
        }
        return byArray;
    }

    public int getType() {
        return this.d;
    }

    public ASN1Object toASN1Object() {
        ASN1Object aSN1Object = null;
        if (this.a != null) {
            aSN1Object = Utils.a(this.a, null);
        }
        if (aSN1Object == null) {
            if (this.vb instanceof X509CRL) {
                try {
                    aSN1Object = Utils.a(((X509CRL)this.vb).getEncoded(), null);
                }
                catch (Exception exception) {}
                if (aSN1Object == null) {
                    aSN1Object = ((X509CRL)this.vb).toASN1Object();
                }
            } else if (this.vb instanceof OtherRevocationInfo) {
                OtherRevocationInfo otherRevocationInfo = (OtherRevocationInfo)this.vb;
                SEQUENCE sEQUENCE = new SEQUENCE();
                sEQUENCE.addComponent((ASN1Object)otherRevocationInfo.getOtherRevInfoFormat());
                sEQUENCE.addComponent(otherRevocationInfo.toASN1Object());
                aSN1Object = new CON_SPEC(1, (ASN1Object)sEQUENCE, true);
            }
        }
        return aSN1Object;
    }

    public String toString() {
        return this.vb != null ? this.vb.toString() : (this.a != null ? String.valueOf(Util.toString((byte[])this.a, (int)0, (int)5)) + "..." : "");
    }

    public void writeTo(OutputStream outputStream) {
        if (this.a != null) {
            outputStream.write(this.a);
        } else {
            boolean bl = true;
            if (this.vb instanceof X509CRL) {
                try {
                    outputStream.write(((X509CRL)this.vb).getEncoded());
                    bl = false;
                }
                catch (Exception exception) {}
            }
            if (bl) {
                try {
                    DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
                }
                catch (CodingException codingException) {
                    throw new IOException(codingException.toString());
                }
            }
        }
    }
}

