/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.cms.CertificateIdentifier;
import iaik.cms.OtherKeyAttribute;
import iaik.cms.SubjectKeyID;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import java.util.Date;

public class RecipientKeyIdentifier
implements CertificateIdentifier {
    SubjectKeyID va;
    Date b;
    OtherKeyAttribute uG;

    public RecipientKeyIdentifier() {
    }

    public RecipientKeyIdentifier(ASN1Object aSN1Object) {
        this.decode(aSN1Object);
    }

    public RecipientKeyIdentifier(SubjectKeyID subjectKeyID) {
        if (subjectKeyID == null) {
            throw new IllegalArgumentException("Cannot create a RecipientKeyIdentifier with no SubjectKeyIdentifier");
        }
        this.va = subjectKeyID;
    }

    public RecipientKeyIdentifier(X509Certificate x509Certificate) {
        this.va = new SubjectKeyID(x509Certificate);
    }

    public void decode(ASN1Object aSN1Object) {
        int n2 = aSN1Object.countComponents();
        this.va = new SubjectKeyID(aSN1Object.getComponentAt(0));
        if (this.va == null) {
            throw new CodingException("Invalid RecipientKeyIdentifier. Missing SubjectKeyIdentifier!");
        }
        if (n2 > 3) {
            throw new CodingException("Cannot create RecipientKeyIdentifier. Invalid number of components: " + n2);
        }
        int n3 = 1;
        while (n3 < n2) {
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(n3);
            if (aSN1Object2.isA(ASN.GeneralizedTime)) {
                if (n3 != 1) {
                    throw new CodingException("Invalid RecipientKeyIdentifier. Date is not second component!");
                }
                ChoiceOfTime choiceOfTime = new ChoiceOfTime(aSN1Object.getComponentAt(n3));
                this.b = choiceOfTime.getDate();
            } else {
                this.uG = new OtherKeyAttribute(aSN1Object.getComponentAt(n3));
            }
            ++n3;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof RecipientKeyIdentifier) {
            RecipientKeyIdentifier recipientKeyIdentifier = (RecipientKeyIdentifier)object;
            if (!this.hasSubjectKeyIdentifier(recipientKeyIdentifier.getSubjectKeyIdentifier())) {
                return false;
            }
            if (!this.hasDate(recipientKeyIdentifier.getDate())) {
                return false;
            }
            return this.hasOtherKeyAttribute(recipientKeyIdentifier.getOtherKeyAttribute());
        }
        return false;
    }

    public Date getDate() {
        return this.b;
    }

    public int getKeyIdType() {
        return 2;
    }

    public String getKeyIdTypeName() {
        return "RecipientKeyIdentifier";
    }

    public OtherKeyAttribute getOtherKeyAttribute() {
        return this.uG;
    }

    public SubjectKeyID getSubjectKeyIdentifier() {
        return this.va;
    }

    public boolean hasDate(Date date) {
        if (this.b != null && date != null) {
            return this.b.equals(date);
        }
        return this.b == null && date == null;
    }

    public boolean hasOtherKeyAttribute(OtherKeyAttribute otherKeyAttribute) {
        if (this.uG != null && otherKeyAttribute != null) {
            return this.uG.equals(otherKeyAttribute);
        }
        return this.uG == null && otherKeyAttribute == null;
    }

    public boolean hasSubjectKeyIdentifier(SubjectKeyID subjectKeyID) {
        if (this.va != null && subjectKeyID != null) {
            return this.va.equals(subjectKeyID);
        }
        return this.va == null && subjectKeyID == null;
    }

    public int hashCode() {
        return this.va.hashCode();
    }

    public boolean identifiesCert(X509Certificate x509Certificate) {
        try {
            return this.va.equals(new SubjectKeyID(x509Certificate));
        }
        catch (X509ExtensionException x509ExtensionException) {
            return false;
        }
    }

    public void setDate(Date date) {
        this.b = date;
    }

    public void setOtherKeyAttribute(OtherKeyAttribute otherKeyAttribute) {
        this.uG = otherKeyAttribute;
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.va.toASN1Object());
        if (this.b != null) {
            ChoiceOfTime choiceOfTime = new ChoiceOfTime(this.b);
            choiceOfTime.setEncodingType(ASN.GeneralizedTime);
            sEQUENCE.addComponent(choiceOfTime.toASN1Object());
        }
        if (this.uG != null) {
            sEQUENCE.addComponent(this.uG.toASN1Object());
        }
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("subjectKeyIdentifier: " + this.va.toString());
        if (this.b != null) {
            stringBuffer.append("\ndate: " + this.b.toString());
        }
        if (this.uG != null) {
            stringBuffer.append("\nother: " + this.uG.toString());
        }
        return stringBuffer.toString();
    }
}

