/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.SET;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.DebugCMS;
import iaik.cms.KEKRecipientInfo;
import iaik.cms.KeyAgreeRecipientInfo;
import iaik.cms.KeyIdentifier;
import iaik.cms.KeyTransRecipientInfo;
import iaik.cms.OtherRecipientInfo;
import iaik.cms.PasswordRecipientInfo;
import iaik.cms.SecurityProvider;
import iaik.x509.X509Certificate;
import java.io.InputStream;
import java.security.Key;
import java.util.Enumeration;
import java.util.Vector;
import javax.crypto.SecretKey;

public abstract class RecipientInfo
implements ASN1Type {
    private static boolean a = false;
    public static final int KEY_TRANSPORT_RECIPIENT_INFO = 0;
    public static final int KEY_AGREE_RECIPIENT_INFO = 1;
    public static final int KEK_RECIPIENT_INFO = 2;
    public static final int PASSWORD_RECIPIENT_INFO = 3;
    public static final int OTHER_RECIPIENT_INFO = 4;
    protected int version_;
    protected AlgorithmID keyEncryptionAlgorithm_;
    protected SecurityProvider securityProvider_;

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    protected RecipientInfo() {
    }

    public static SET createRecipientInfos(Vector vector) {
        SET sET = new SET();
        Enumeration enumeration = vector.elements();
        try {
            while (enumeration.hasMoreElements()) {
                Object e2 = enumeration.nextElement();
                if (!(e2 instanceof RecipientInfo)) {
                    throw new CMSException("Only can add RecipientInfos to a SET OF RecipientInfos!");
                }
                RecipientInfo recipientInfo = (RecipientInfo)e2;
                int n2 = recipientInfo.getVersion();
                switch (n2) {
                    case -1: {
                        sET.addComponent((ASN1Object)new CON_SPEC(4, recipientInfo.toASN1Object(), true));
                        break;
                    }
                    case 0: {
                        if (recipientInfo instanceof KeyTransRecipientInfo) {
                            sET.addComponent(recipientInfo.toASN1Object());
                            break;
                        }
                        sET.addComponent((ASN1Object)new CON_SPEC(3, recipientInfo.toASN1Object(), true));
                        break;
                    }
                    case 2: {
                        sET.addComponent(recipientInfo.toASN1Object());
                        break;
                    }
                    case 3: {
                        sET.addComponent((ASN1Object)new CON_SPEC(1, recipientInfo.toASN1Object(), true));
                        break;
                    }
                    case 4: {
                        sET.addComponent((ASN1Object)new CON_SPEC(2, recipientInfo.toASN1Object(), true));
                        break;
                    }
                    default: {
                        throw new CMSException("Invalid RecipientInfo version: " + n2);
                    }
                }
            }
        }
        catch (CodingException codingException) {
            throw new CMSException("Error creating recipientInfo ASN1Object: " + codingException.getMessage());
        }
        return sET;
    }

    public abstract void decode(ASN1Object var1);

    public SecretKey decryptKey(Key key) {
        return this.decryptKey(key, null, "RAW");
    }

    public SecretKey decryptKey(Key key, KeyIdentifier keyIdentifier) {
        return this.decryptKey(key, keyIdentifier, "RAW");
    }

    public abstract SecretKey decryptKey(Key var1, KeyIdentifier var2, String var3);

    public SecretKey decryptKey(Key key, String string) {
        return this.decryptKey(key, null, string);
    }

    public abstract void encryptKey(SecretKey var1);

    public abstract byte[] getEncryptedKey(KeyIdentifier var1);

    public AlgorithmID getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm_;
    }

    public abstract KeyIdentifier[] getRecipientIdentifiers();

    public int getRecipientInfoType() {
        int n2 = this.version_;
        switch (this.version_) {
            case -1: {
                n2 = 4;
                break;
            }
            case 0: {
                if (this instanceof KeyTransRecipientInfo) {
                    n2 = 0;
                    break;
                }
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 0;
                break;
            }
            case 3: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        return n2;
    }

    public SecurityProvider getSecurityProvider() {
        return this.securityProvider_;
    }

    public int getVersion() {
        return this.version_;
    }

    public abstract boolean isRecipientInfoFor(KeyIdentifier var1);

    public abstract CertificateIdentifier isRecipientInfoFor(X509Certificate var1);

    public static RecipientInfo parseRecipientInfo(ASN1Object aSN1Object) {
        return RecipientInfo.parseRecipientInfo(aSN1Object, null);
    }

    public static RecipientInfo parseRecipientInfo(ASN1Object aSN1Object, SecurityProvider securityProvider) {
        RecipientInfo recipientInfo;
        block9: {
            recipientInfo = null;
            try {
                if (aSN1Object.isA(ASN.SEQUENCE)) {
                    recipientInfo = new KeyTransRecipientInfo(aSN1Object);
                    recipientInfo.setSecurityProvider(securityProvider);
                    break block9;
                }
                CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object;
                int n2 = cON_SPEC.getAsnType().getTag();
                cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                switch (n2) {
                    case 1: {
                        recipientInfo = new KeyAgreeRecipientInfo((ASN1Object)cON_SPEC.getValue(), securityProvider);
                        break;
                    }
                    case 2: {
                        recipientInfo = new KEKRecipientInfo((ASN1Object)cON_SPEC.getValue(), securityProvider);
                        break;
                    }
                    case 3: {
                        recipientInfo = new PasswordRecipientInfo((ASN1Object)cON_SPEC.getValue(), securityProvider);
                        break;
                    }
                    case 4: {
                        recipientInfo = new OtherRecipientInfo((ASN1Object)cON_SPEC.getValue());
                        break;
                    }
                    default: {
                        throw new CMSParsingException("Invalid RecipientInfo tag: " + n2);
                    }
                }
            }
            catch (Exception exception) {
                throw new CMSParsingException("Error parsing recipient info: " + exception.getMessage());
            }
        }
        return recipientInfo;
    }

    public static RecipientInfo parseRecipientInfo(InputStream inputStream) {
        return RecipientInfo.parseRecipientInfo(inputStream, null);
    }

    public static RecipientInfo parseRecipientInfo(InputStream inputStream, SecurityProvider securityProvider) {
        try {
            DerInputStream derInputStream = null;
            derInputStream = inputStream instanceof DerInputStream ? (DerInputStream)inputStream : new DerInputStream(inputStream);
            return RecipientInfo.parseRecipientInfo(DerCoder.decode((InputStream)derInputStream), securityProvider);
        }
        catch (CodingException codingException) {
            throw new CMSParsingException("Error parsing recipient infos: " + codingException.getMessage());
        }
    }

    public static RecipientInfo[] parseRecipientInfos(InputStream inputStream) {
        return RecipientInfo.parseRecipientInfos(inputStream, null);
    }

    public static RecipientInfo[] parseRecipientInfos(InputStream inputStream, SecurityProvider securityProvider) {
        DerInputStream derInputStream = null;
        derInputStream = inputStream instanceof DerInputStream ? (DerInputStream)inputStream : new DerInputStream(inputStream);
        DerInputStream derInputStream2 = derInputStream.readSet();
        Vector<RecipientInfo> vector = new Vector<RecipientInfo>();
        while (derInputStream2.nextTag() > -1) {
            vector.addElement(RecipientInfo.parseRecipientInfo((InputStream)derInputStream2, securityProvider));
        }
        Object[] objectArray = new RecipientInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider_ = securityProvider;
    }

    public abstract ASN1Object toASN1Object();

    public abstract String toString();
}

