/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.DebugCMS;
import iaik.cms.KeyIdentifier;
import iaik.cms.RecipientInfo;
import iaik.cms.SecurityProvider;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;

public class PasswordRecipientInfo
extends RecipientInfo {
    private static boolean rM = false;
    AlgorithmID sM;
    Key uZ;
    byte[] rE;
    AlgorithmParameters uJ;

    static {
        rM = DebugCMS.getDebugMode() && rM;
    }

    public PasswordRecipientInfo() {
        this.version_ = 0;
    }

    public PasswordRecipientInfo(ASN1Object aSN1Object) {
        this();
        this.decode(aSN1Object);
    }

    public PasswordRecipientInfo(ASN1Object aSN1Object, SecurityProvider securityProvider) {
        this();
        this.securityProvider_ = securityProvider;
        this.decode(aSN1Object);
    }

    public PasswordRecipientInfo(AlgorithmID algorithmID, AlgorithmID algorithmID2, byte[] byArray) {
        this();
        if (algorithmID != null) {
            this.sM = (AlgorithmID)algorithmID.clone();
        }
        this.keyEncryptionAlgorithm_ = (AlgorithmID)algorithmID2.clone();
        this.rE = byArray;
    }

    public PasswordRecipientInfo(AlgorithmID algorithmID, Key key) {
        this(algorithmID, key, null);
    }

    public PasswordRecipientInfo(AlgorithmID algorithmID, Key key, AlgorithmParameters algorithmParameters) {
        this();
        this.keyEncryptionAlgorithm_ = (AlgorithmID)algorithmID.clone();
        this.uZ = key;
        this.uJ = algorithmParameters;
    }

    public PasswordRecipientInfo(AlgorithmID algorithmID, byte[] byArray) {
        this();
        this.keyEncryptionAlgorithm_ = (AlgorithmID)algorithmID.clone();
        this.rE = byArray;
    }

    public PasswordRecipientInfo(char[] cArray, AlgorithmID algorithmID, AlgorithmParameterSpec algorithmParameterSpec, AlgorithmID algorithmID2, AlgorithmParameters algorithmParameters) {
        this(cArray, algorithmID, algorithmParameterSpec, algorithmID2, algorithmParameters, null);
    }

    public PasswordRecipientInfo(char[] cArray, AlgorithmID algorithmID, AlgorithmParameterSpec algorithmParameterSpec, AlgorithmID algorithmID2, AlgorithmParameters algorithmParameters, SecurityProvider securityProvider) {
        this();
        SecurityProvider securityProvider2 = this.securityProvider_ = securityProvider;
        if (securityProvider2 == null) {
            securityProvider2 = SecurityProvider.getSecurityProvider();
        }
        this.sM = (AlgorithmID)algorithmID.clone();
        this.keyEncryptionAlgorithm_ = (AlgorithmID)algorithmID2.clone();
        this.uJ = algorithmParameters;
        this.uZ = securityProvider2.deriveKey(cArray, this.sM, algorithmParameterSpec);
    }

    public void decode(ASN1Object aSN1Object) {
        block4: {
            SecurityProvider securityProvider = this.securityProvider_;
            if (securityProvider == null) {
                securityProvider = SecurityProvider.getSecurityProvider();
            }
            this.version_ = ((BigInteger)aSN1Object.getComponentAt(0).getValue()).intValue();
            int n2 = 1;
            if (aSN1Object.countComponents() == 4) {
                CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(n2++);
                cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                this.sM = new AlgorithmID((ASN1Object)cON_SPEC.getValue());
            }
            this.keyEncryptionAlgorithm_ = new AlgorithmID(aSN1Object.getComponentAt(n2++));
            this.rE = (byte[])aSN1Object.getComponentAt(n2).getValue();
            try {
                this.uJ = securityProvider.getAlgorithmParameters(this.keyEncryptionAlgorithm_);
            }
            catch (Exception exception) {
                if (!rM) break block4;
                System.out.println("Cannot create AlgorithmParameters for " + this.keyEncryptionAlgorithm_.getAlgorithm().getName());
            }
        }
    }

    public SecretKey decryptKey(Key key, KeyIdentifier keyIdentifier, String string) {
        SecurityProvider securityProvider = this.securityProvider_;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        try {
            String string2 = string;
            if (string2 == null || string2.equalsIgnoreCase("RAW")) {
                string2 = this.keyEncryptionAlgorithm_.getRawImplementationName();
                int n2 = string2.indexOf("Wrap") + 4;
                string2 = n2 != 3 && n2 < string2.length() ? string2.substring(n2) : string;
            }
            return securityProvider.unwrapKey(this.rE, this.keyEncryptionAlgorithm_, key, this.uJ, string2);
        }
        catch (Exception exception) {
            throw new CMSException("Unable to decrypt encrypted content-encryption key: " + exception.getMessage());
        }
    }

    public SecretKey decryptKey(char[] cArray) {
        return this.decryptKey(cArray, this.sM, null, null);
    }

    public SecretKey decryptKey(char[] cArray, AlgorithmID algorithmID, AlgorithmParameterSpec algorithmParameterSpec, String string) {
        SecurityProvider securityProvider = this.securityProvider_;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        this.uZ = securityProvider.deriveKey(cArray, algorithmID, algorithmParameterSpec);
        return this.decryptKey(this.uZ, null, string);
    }

    public SecretKey decryptKey(char[] cArray, String string) {
        return this.decryptKey(cArray, this.sM, null, string);
    }

    public void encryptKey(SecretKey secretKey) {
        SecurityProvider securityProvider = this.securityProvider_;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        if (this.keyEncryptionAlgorithm_ == null) {
            throw new NullPointerException("Unable to encrypt symmetric key. Content-encryption algorithm is not set!");
        }
        if (this.uZ == null) {
            throw new NullPointerException("Unable to encrypt symmetric key. Key encryption key is not set!");
        }
        if (secretKey == null) {
            throw new NullPointerException("Cannot encrypt a null key!");
        }
        try {
            this.rE = securityProvider.wrapKey(secretKey, this.keyEncryptionAlgorithm_, this.uZ, this.uJ);
        }
        catch (Exception exception) {
            throw new CMSException("Unable to encrypt the symmetric key: " + exception.getMessage());
        }
    }

    public byte[] getEncryptedKey() {
        return this.rE;
    }

    public byte[] getEncryptedKey(KeyIdentifier keyIdentifier) {
        return this.rE;
    }

    public AlgorithmID getKeyDerivationAlgorithm() {
        return this.sM;
    }

    public KeyIdentifier[] getRecipientIdentifiers() {
        return new KeyIdentifier[0];
    }

    public boolean isRecipientInfoFor(KeyIdentifier keyIdentifier) {
        return false;
    }

    public CertificateIdentifier isRecipientInfoFor(X509Certificate x509Certificate) {
        return null;
    }

    public ASN1Object toASN1Object() {
        if (this.keyEncryptionAlgorithm_ == null) {
            throw new NullPointerException("keyEncryptionAlgorithm field of this PasswordRecipientInfo not set!");
        }
        if (this.rE == null) {
            throw new NullPointerException("encryptedKey field of this PasswordRecipientInfo not set!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent((ASN1Object)new INTEGER(this.version_));
        if (this.sM != null) {
            sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, this.sM.toASN1Object(), true));
        }
        sEQUENCE.addComponent(this.keyEncryptionAlgorithm_.toASN1Object());
        sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(this.rE));
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("version: " + this.version_ + "\n");
        if (this.sM != null) {
            stringBuffer.append("keyDerivationAlgorithm: " + this.sM + "\n");
        }
        stringBuffer.append("keyEncryptionAlgorithm: " + this.keyEncryptionAlgorithm_ + "\n");
        stringBuffer.append("encryptedKey: " + (this.rE == null ? "not set" : Util.toString((byte[])this.rE, (int)0, (int)5)) + "...");
        return stringBuffer.toString();
    }
}

