/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.cms.CMSException;
import iaik.cms.KeyIdentifier;
import iaik.cms.SecurityProvider;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.security.PublicKey;
import javax.crypto.interfaces.DHPublicKey;

public class OriginatorPublicKey
implements KeyIdentifier {
    private PublicKey uT;
    private SecurityProvider uU;

    public OriginatorPublicKey() {
    }

    public OriginatorPublicKey(ASN1Object aSN1Object) {
        this.decode(aSN1Object);
    }

    public OriginatorPublicKey(ASN1Object aSN1Object, SecurityProvider securityProvider) {
        this.uU = securityProvider;
        this.decode(aSN1Object);
    }

    public OriginatorPublicKey(PublicKey publicKey) {
        if (publicKey == null) {
            throw new IllegalArgumentException("Cannot create a OriginatorPublicKey. Missing public key!");
        }
        this.uT = publicKey;
    }

    public void decode(ASN1Object aSN1Object) {
        SecurityProvider securityProvider = this.uU;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        try {
            this.uT = securityProvider.getOriginatorPublicKey(aSN1Object);
        }
        catch (CMSException cMSException) {
            throw new CodingException(cMSException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OriginatorPublicKey)) {
            return false;
        }
        OriginatorPublicKey originatorPublicKey = (OriginatorPublicKey)object;
        return CryptoUtils.equalsBlock((byte[])this.uT.getEncoded(), (byte[])originatorPublicKey.getPublicKey().getEncoded());
    }

    public int getKeyIdType() {
        return 4;
    }

    public String getKeyIdTypeName() {
        return "OriginatorPublicKey";
    }

    public PublicKey getPublicKey() {
        return this.uT;
    }

    public int hashCode() {
        if (this.uT.getAlgorithm().equalsIgnoreCase("ESDH")) {
            return ((DHPublicKey)this.uT).getY().hashCode();
        }
        return Util.calculateHashCode((byte[])this.uT.getEncoded());
    }

    public ASN1Object toASN1Object() {
        SecurityProvider securityProvider = this.uU;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        try {
            return securityProvider.getASN1OriginatorPublicKey(this.uT);
        }
        catch (CMSException cMSException) {
            throw new CodingException("Cannot get ASN.1 representation of public key: " + cMSException.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.uT.getAlgorithm()) + "key:\n");
        stringBuffer.append(this.uT);
        return stringBuffer.toString();
    }
}

