/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.SEQUENCE;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.CertificateSet;
import iaik.cms.DebugCMS;
import iaik.cms.OtherCertificate;
import iaik.cms.OtherRevocationInfo;
import iaik.cms.RevocationInfoChoices;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import iaik.x509.attr.AttributeCertificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CRL;
import java.security.cert.Certificate;

public class OriginatorInfo {
    private static boolean a = false;
    private CertificateSet uR = new CertificateSet();
    private RevocationInfoChoices uS = new RevocationInfoChoices();

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    public OriginatorInfo() {
    }

    public OriginatorInfo(ASN1Object aSN1Object) {
        this();
        this.decode(aSN1Object);
    }

    public OriginatorInfo(InputStream inputStream) {
        this();
        this.decode(inputStream);
    }

    public boolean containsCRLs() {
        return this.uS.isEmpty() ^ true;
    }

    public boolean containsCertificates() {
        return this.uR.isEmpty() ^ true;
    }

    public void decode(ASN1Object aSN1Object) {
        byte[] byArray = DerCoder.encode((ASN1Object)aSN1Object);
        if (byArray == null) {
            throw new CMSParsingException("Cannot decode OriginatorInfo!");
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.decode(byteArrayInputStream);
        }
        catch (Exception exception) {
            throw new CMSParsingException(exception.getMessage());
        }
    }

    public void decode(InputStream inputStream) {
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        DerInputStream derInputStream = ((DerInputStream)inputStream).readSequence();
        try {
            while (derInputStream.nextIsContextSpecific()) {
                int n2 = derInputStream.readContextSpecific(17);
                switch (n2) {
                    case 0: {
                        this.uR = new CertificateSet((InputStream)derInputStream);
                        break;
                    }
                    case 1: {
                        this.uS = new RevocationInfoChoices((InputStream)derInputStream);
                        break;
                    }
                    default: {
                        throw new CMSParsingException("Invalid implicit tag " + n2 + "!");
                    }
                }
            }
        }
        catch (CMSParsingException cMSParsingException) {
            throw new IOException("Error parsing Object! " + cMSParsingException.getMessage());
        }
    }

    public AttributeCertificate[] getAttributeCertificates() {
        return this.uR.getAttributeCertificates();
    }

    public X509CRL[] getCRLs() {
        return this.uS.getX509CRLs();
    }

    public X509Certificate getCertificate(CertificateIdentifier certificateIdentifier) {
        if (this.uR == null) {
            throw new CMSException("Certificate not found!");
        }
        X509Certificate x509Certificate = this.uR.getX509Certificate(certificateIdentifier);
        if (x509Certificate == null) {
            throw new CMSException("Certificate not found!");
        }
        return x509Certificate;
    }

    public CertificateSet getCertificateSet() {
        return this.uR;
    }

    public Certificate[] getCertificates() {
        return this.uR.getCertificates();
    }

    public OtherCertificate[] getOtherCertificates() {
        return this.uR.getOtherCertificates();
    }

    public OtherRevocationInfo[] getOtherRevocationInfos() {
        return this.uS.getOtherRevocationInfos();
    }

    public RevocationInfoChoices getRevocationInfoChoices() {
        return this.uS;
    }

    public X509Certificate[] getX509Certificates() {
        return this.uR.getX509Certificates();
    }

    public boolean isEmpty() {
        return this.uR.isEmpty() && this.uS.isEmpty();
    }

    public void setCRLs(X509CRL[] x509CRLArray) {
        if (x509CRLArray == null || x509CRLArray.length == 0) {
            this.uS.removeAllRevocationInfos();
        } else {
            this.uS.setRevocationInfos((CRL[])x509CRLArray);
        }
    }

    public void setCertificateSet(CertificateSet certificateSet) {
        this.uR = certificateSet;
    }

    public void setCertificates(Certificate[] certificateArray) {
        this.uR.setCertificates(certificateArray);
    }

    public void setRevocationInfoChoices(RevocationInfoChoices revocationInfoChoices) {
        if (revocationInfoChoices == null) {
            this.uS.removeAllRevocationInfos();
        } else {
            this.uS = revocationInfoChoices;
        }
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        try {
            if (this.uR != null && !this.uR.isEmpty()) {
                sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, this.uR.toASN1Object(), true));
            }
            if (this.uS != null && !this.uS.isEmpty()) {
                sEQUENCE.addComponent((ASN1Object)new CON_SPEC(1, this.uS.toASN1Object(), true));
            }
        }
        catch (CodingException codingException) {
            throw new CMSException(codingException.toString());
        }
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.uR != null) {
            stringBuffer.append(this.uR);
        }
        if (this.uS != null) {
            stringBuffer.append(this.uS);
        }
        return stringBuffer.toString();
    }

    public void writeTo(OutputStream outputStream) {
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.toString());
        }
    }
}

