/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.cms.OtherRevocationInfo;
import iaik.x509.ocsp.BasicOCSPResponse;
import iaik.x509.ocsp.OCSPResponse;
import java.io.InputStream;
import java.security.cert.Certificate;

public class OCSPRevocationInfo
extends OtherRevocationInfo {
    public static ObjectID id_ri_ocsp_response = new ObjectID("1.3.6.1.5.5.7.16.2", "id_ri_ocsp_response");
    private BasicOCSPResponse uQ;

    public OCSPRevocationInfo(ASN1Object aSN1Object) {
        super(id_ri_ocsp_response, aSN1Object);
    }

    public OCSPRevocationInfo(OCSPResponse oCSPResponse) {
        super(id_ri_ocsp_response, oCSPResponse.toASN1Object());
        this.a(oCSPResponse);
        this.uQ = (BasicOCSPResponse)oCSPResponse.getResponse();
    }

    OCSPRevocationInfo(InputStream inputStream) {
        super(id_ri_ocsp_response, inputStream);
    }

    public OCSPRevocationInfo(byte[] byArray) {
        super(id_ri_ocsp_response, byArray);
    }

    private void a(OCSPResponse oCSPResponse) {
        if (oCSPResponse.getResponseStatus() != 0) {
            throw new CodingException("Response status must be successful!");
        }
        if (!BasicOCSPResponse.responseType.equals((Object)oCSPResponse.getResponseType())) {
            throw new CodingException("Response type must be BasicOCSPResponse!");
        }
    }

    public void decode(ASN1Object aSN1Object) {
        super.decode(aSN1Object);
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("Invalid OCSPResponse! Must be ASN.1 SEQUENCE");
        }
        try {
            if (aSN1Object.countComponents() == 2) {
                OCSPResponse oCSPResponse = new OCSPResponse(aSN1Object);
                this.a(oCSPResponse);
                this.uQ = (BasicOCSPResponse)oCSPResponse.getResponse();
            } else {
                BasicOCSPResponse basicOCSPResponse = new BasicOCSPResponse();
                basicOCSPResponse.decode(aSN1Object);
                this.uQ = basicOCSPResponse;
            }
        }
        catch (Exception exception) {
            throw new CodingException(exception.toString());
        }
    }

    public BasicOCSPResponse getBasicResponse() {
        if (this.uQ == null) {
            this.decode(this.toASN1Object());
        }
        return this.uQ;
    }

    public boolean isRevoked(Certificate certificate) {
        throw new RuntimeException("Method not supported!");
    }

    public String toString() {
        String string = this.uQ != null ? this.uQ.toString() : super.toString();
        return string;
    }
}

